---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Formats.Nrbf 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **NrbfDecoderのセキュリティテスト**：悪意あるペイロードに対する防御テストの追加検討
  2. **境界値テストの網羅性**：Array.MaxLength等の境界値テストの充足確認
  3. **例外メッセージの国際化**：SR.csリソースとの整合性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/NrbfDecoder.cs`
- E-02: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/SerializationRecord.cs`
- E-03: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ClassRecord.cs`
- E-04: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ArrayRecord.cs`
- E-05: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/PrimitiveTypeRecord.cs`
- E-06: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/PrimitiveTypeRecordOfT.cs`
- E-07: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/SZArrayRecord.cs`
- E-08: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ArraySinglePrimitiveRecord.cs`
- E-09: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ArraySingleStringRecord.cs`
- E-10: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ArraySingleObjectRecord.cs`
- E-11: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/RectangularArrayRecord.cs`
- E-12: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/JaggedArrayRecord.cs`
- E-13: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/PayloadOptions.cs`
- E-14: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/SerializationRecordId.cs`
- E-15: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/RecordMap.cs`
- E-16: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/Utils/BinaryReaderExtensions.cs`
- E-17: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/Utils/TypeNameHelpers.cs`
- E-18: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/Utils/ThrowHelper.cs`
- E-19: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ClassWithMembersAndTypesRecord.cs`
- E-20: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/SystemClassWithMembersAndTypesRecord.cs`
- E-21: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/BinaryObjectStringRecord.cs`
- E-22: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/MemberReferenceRecord.cs`
- E-23: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ArrayInfo.cs`
- E-24: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/MemberTypeInfo.cs`
- E-25: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ClassInfo.cs`
- E-26: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/BinaryLibraryRecord.cs`
- E-27: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/SerializedStreamHeaderRecord.cs`
- E-28: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/ClassWithIdRecord.cs`
- E-29: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/NullsRecord.cs`
- E-30: `src/libraries/System.Formats.Nrbf/src/System/Formats/Nrbf/MemberPrimitiveTypedRecord.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### NrbfDecoder クラス（UT-NRBF-001 〜 UT-NRBF-018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StartsWithPayloadHeader(ReadOnlySpan<byte>)の正常系テスト | E-01 (L41-44) | ○ |
| C-02 | StartsWithPayloadHeader(ReadOnlySpan<byte>)の異常系テスト | E-01 (L43) | ○ |
| C-03 | StartsWithPayloadHeader(ReadOnlySpan<byte>)の境界値テスト（17バイト未満） | E-01 (L42) | ○ |
| C-04 | StartsWithPayloadHeader(ReadOnlySpan<byte>)の境界値テスト（空バッファ） | E-01 (L42) | ○ |
| C-05 | StartsWithPayloadHeader(Stream)の正常系テスト | E-01 (L56-87) | ○ |
| C-06 | StartsWithPayloadHeader(Stream)のnullチェック | E-01 (L58) | ○ |
| C-07 | StartsWithPayloadHeader(Stream)のシーク可能チェック | E-01 (L60-63) | ○ |
| C-08 | StartsWithPayloadHeader(Stream)の位置復元テスト | E-01 (L78, L85) | ○ |
| C-09 | Decode(Stream)の正常系テスト | E-01 (L114-116) | ○ |
| C-10 | Decode(Stream)のnullチェック | E-01 (L130) | ○ |
| C-11 | Decode(Stream)の不正データ検出 | E-01 (L137-140) | ○ |
| C-12 | Decode(Stream)のUTF8エラー | E-01 (L25, L132) | ○ |
| C-13 | Decode(Stream)の不完全データ検出 | E-01 (API仕様) | ○ |
| C-14 | leaveOpen=true時のストリーム管理 | E-01 (L132) | ○ |
| C-15 | leaveOpen=false時のストリーム管理 | E-01 (L132) | ○ |
| C-16 | recordMap出力テスト | E-01 (L128-141) | ○ |
| C-17 | DecodeClassRecordの正常系テスト | E-01 (L148-149) | ○ |
| C-18 | DecodeClassRecordの型不一致テスト | E-01 (L149) | ○ |

### SerializationRecord クラス（UT-NRBF-019 〜 UT-NRBF-024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | TypeNameMatches正常系（一致） | E-02 (L56-61) | ○ |
| C-20 | TypeNameMatches正常系（不一致） | E-02 (L63-143) | ○ |
| C-21 | TypeNameMatchesのnullチェック | E-02 (L58) | ○ |
| C-22 | TypeNameMatchesの配列型比較 | E-02 (L95-97, L112-114) | ○ |
| C-23 | TypeNameMatchesのジェネリック型比較 | E-02 (L116-140) | ○ |
| C-24 | TypeNameMatchesのポインタ型 | E-02 (L67-69) | ○ |

### ClassRecord クラス（UT-NRBF-025 〜 UT-NRBF-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | HasMember正常系（存在） | E-03 (L51) | ○ |
| C-26 | HasMember正常系（不在） | E-03 (L51) | ○ |
| C-27 | GetString正常系 | E-03 (L63, L126-141) | ○ |
| C-28 | GetString null値 | E-03 (L136-137) | ○ |
| C-29 | GetStringの不在メンバーエラー | E-03 (L128) | ○ |
| C-30 | GetStringの型不一致エラー | E-03 (L138-139) | ○ |
| C-31 | GetInt32正常系 | E-03 (L77) | ○ |
| C-32 | GetBoolean正常系 | E-03 (L65) | ○ |
| C-33 | GetDateTime正常系 | E-03 (L93) | ○ |
| C-34 | GetDecimal正常系 | E-03 (L89) | ○ |
| C-35 | GetClassRecord正常系 | E-03 (L60) | ○ |
| C-36 | GetArrayRecord正常系 | E-03 (L106) | ○ |
| C-37 | GetSerializationRecord正常系 | E-03 (L117-124) | ○ |
| C-38 | GetSerializationRecordのプリミティブ値エラー | E-03 (L123) | ○ |
| C-39 | GetRawValue正常系 | E-03 (L103) | ○ |
| C-40 | MemberNames正常系 | E-03 (L29) | ○ |

### ArrayRecord クラス（UT-NRBF-041 〜 UT-NRBF-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | GetArray正常系 | E-04 (L72-84) | ○ |
| C-42 | GetArrayのnullチェック | E-04 (L74) | ○ |
| C-43 | GetArrayの型不一致エラー | E-04 (L76-78) | ○ |
| C-44 | GetArrayのnull許可テスト | E-04 (L81-82) | ○ |
| C-45 | GetArrayのnull禁止テスト | E-04 (L83, L131-134) | ○ |
| C-46 | Lengths正常系 | E-04 (L31) | ○ |
| C-47 | Rank正常系 | E-04 (L37) | ○ |
| C-48 | SZArrayRecord.Length | E-07 (L24) | ○ |
| C-49 | SZArrayRecord.GetArray正常系 | E-07 (L42) | ○ |
| C-50 | SZArrayRecord.GetArrayのキャッシュ | E-07 (L45) | ○ |
| C-51 | ArraySinglePrimitiveRecord.GetArray | E-08 (L41-42) | ○ |
| C-52 | DecodePrimitiveTypes bool配列 | E-08 (L263-265) | ○ |
| C-53 | DecodePrimitiveTypes byte配列 | E-08 (L100-102) | ○ |
| C-54 | DecodePrimitiveTypes char配列 | E-08 (L104-106) | ○ |
| C-55 | DecodePrimitiveTypes DateTime配列 | E-08 (L108, L233-235) | ○ |
| C-56 | DecodePrimitiveTypes decimal配列 | E-08 (L56-58, L218-226) | ○ |
| C-57 | DecodePrimitiveTypes 空配列 | E-08 (L50-52) | ○ |
| C-58 | ArraySingleStringRecord.GetArray | E-09 (L44-45) | ○ |
| C-59 | ArraySingleStringRecord null含む配列 | E-09 (L77-84) | ○ |
| C-60 | ArraySingleStringRecord null禁止 | E-09 (L72-75) | ○ |
| C-61 | ArraySingleObjectRecord.GetArray | E-10 (L30-31) | ○ |
| C-62 | RectangularArrayRecord.GetArray | E-11 (L45-63) | ○ |
| C-63 | RectangularArrayRecord.Lengths | E-11 (L39) | ○ |
| C-64 | JaggedArrayRecord.GetArray | E-12 (L46-58) | ○ |

### PrimitiveTypeRecord クラス（UT-NRBF-065 〜 UT-NRBF-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | PrimitiveTypeRecord<T>.Value | E-06 (L34) | ○ |
| C-66 | PrimitiveTypeRecord<T>.TypeName | E-06 (L37) | ○ |
| C-67 | BinaryObjectStringRecord.Value | E-21 (L18-21) | ○ |

### SerializationRecordId 構造体（UT-NRBF-068 〜 UT-NRBF-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | Equals同一ID | E-14 (L55) | ○ |
| C-69 | Equals異なるID | E-14 (L55) | ○ |
| C-70 | GetHashCode | E-14 (L61) | ○ |
| C-71 | Decode ID=0エラー | E-14 (L46-49) | ○ |

### PayloadOptions クラス（UT-NRBF-072 〜 UT-NRBF-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | TypeNameParseOptions | E-13 (L21) | ○ |
| C-73 | UndoTruncatedTypeNames | E-13 (L41) | ○ |

### RecordMap クラス（UT-NRBF-074 〜 UT-NRBF-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | Add正常系 | E-15 (L32-61) | ○ |
| C-75 | Add重複IDエラー | E-15 (L47-59) | ○ |
| C-76 | GetRecord正常系 | E-15 (L66-69) | ○ |
| C-77 | GetRecord不在IDエラー | E-15 (L67-69) | ○ |

### BinaryReaderExtensions（UT-NRBF-078 〜 UT-NRBF-094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | ReadSerializationRecordType正常系 | E-16 (L19-29) | ○ |
| C-79 | ReadSerializationRecordType無効タイプ | E-16 (L22-27) | ○ |
| C-80 | ReadSerializationRecordType非許可タイプ | E-16 (L24) | ○ |
| C-81 | ReadArrayType正常系 | E-16 (L32-53) | ○ |
| C-82 | ReadArrayTypeカスタムオフセット | E-16 (L44-47) | ○ |
| C-83 | ReadPrimitiveType正常系 | E-16 (L66-75) | ○ |
| C-84 | ReadPrimitiveType無効タイプ | E-16 (L70-73) | ○ |
| C-85 | ReadPrimitiveValue正常系 | E-16 (L80-99) | ○ |
| C-86 | ParseDecimal正常系 | E-16 (L102-116) | ○ |
| C-87 | ParseDecimal無効文字列 | E-16 (L110-113) | ○ |
| C-88 | ParseChar正常系 | E-16 (L118-128) | ○ |
| C-89 | ParseCharサロゲート文字 | E-16 (L124-127) | ○ |
| C-90 | CreateDateTimeFromData正常系 | E-16 (L157-169) | ○ |
| C-91 | CreateDateTimeFromData Ambiguous DST | E-16 (L171-207) | ○ |
| C-92 | CreateDateTimeFromData無効ticks | E-16 (L166-169) | ○ |
| C-93 | IsDataAvailableシーク可能 | E-16 (L215-235) | ○ |
| C-94 | IsDataAvailableシーク不可 | E-16 (L218-221) | ○ |

### TypeNameHelpers（UT-NRBF-095 〜 UT-NRBF-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | GetPrimitiveTypeName | E-17 (L24-56) | ○ |
| C-96 | GetPrimitiveSZArrayTypeName | E-17 (L58-66) | ○ |
| C-97 | GetPrimitiveType<T> | E-17 (L68-108) | ○ |
| C-98 | ParseSystemRecordTypeName | E-17 (L153-155) | ○ |
| C-99 | ParseNonSystemClassRecordTypeName正常系 | E-17 (L110-151) | ○ |
| C-100 | ParseNonSystemClassRecordTypeName無効型名 | E-17 (L136-139) | ○ |

### ArrayInfo, MemberTypeInfo, ClassInfo（UT-NRBF-101 〜 UT-NRBF-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | ArrayInfo.Decode | E-23 (L47-48) | ○ |
| C-102 | ParseValidArrayLength正常系 | E-23 (L50-60) | ○ |
| C-103 | ParseValidArrayLength負の長さ | E-23 (L54-57) | ○ |
| C-104 | ParseValidArrayLength過大長さ | E-23 (L54-57) | ○ |
| C-105 | MemberTypeInfo.Decode | E-24 (L26-68) | ○ |
| C-106 | GetNextAllowedRecordType | E-24 (L70-111) | ○ |
| C-107 | GetArrayTypeName | E-24 (L113-138) | ○ |
| C-108 | ClassInfo.Decode正常系 | E-25 (L45-78) | ○ |
| C-109 | ClassInfo.Decode重複メンバー | E-25 (L74) | ○ |
| C-110 | LoadTypeName(BinaryLibraryRecord) | E-25 (L80-81) | ○ |
| C-111 | LoadTypeName(PayloadOptions) | E-25 (L83-84) | ○ |

### BinaryLibraryRecord, SerializedStreamHeaderRecord（UT-NRBF-112 〜 UT-NRBF-117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | BinaryLibraryRecord.Decode正常系 | E-26 (L42-57) | ○ |
| C-113 | BinaryLibraryRecord.Decode無効アセンブリ名 | E-26 (L51-54) | ○ |
| C-114 | BinaryLibraryRecord.Decode UndoTruncatedTypeNames | E-26 (L51, L56) | ○ |
| C-115 | SerializedStreamHeaderRecord.Decode正常系 | E-27 (L33-51) | ○ |
| C-116 | SerializedStreamHeaderRecord.Decode無効メジャーバージョン | E-27 (L41-44) | ○ |
| C-117 | SerializedStreamHeaderRecord.Decode無効マイナーバージョン | E-27 (L45-48) | ○ |

### ClassWithMembersAndTypesRecord, SystemClassWithMembersAndTypesRecord（UT-NRBF-118 〜 UT-NRBF-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | ClassWithMembersAndTypesRecord.Decode | E-19 (L24-34) | ○ |
| C-119 | SystemClassWithMembersAndTypesRecord.Decode | E-20 (L25-101) | ○ |
| C-120 | SystemClassWithMembersAndTypesRecordプリミティブマッピング | E-20 (L47-73) | ○ |
| C-121 | DecodeDateTime | E-20 (L106-112) | ○ |
| C-122 | DecodeDecimal | E-20 (L114-122) | ○ |

### ClassWithIdRecord, MemberReferenceRecord（UT-NRBF-123 〜 UT-NRBF-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | ClassWithIdRecord.Decode | E-28 (L31-82) | ○ |
| C-124 | ClassWithIdRecord.Decode無効参照 | E-28 (L75-78) | ○ |
| C-125 | MemberReferenceRecord.Decode | E-22 (L38-39) | ○ |
| C-126 | GetReferencedRecord正常系 | E-22 (L41) | ○ |
| C-127 | GetReferencedRecord無効参照 | E-22 (L41), E-15 (L67-69) | ○ |

### MemberPrimitiveTypedRecord, ThrowHelper（UT-NRBF-128 〜 UT-NRBF-132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | MemberPrimitiveTypedRecord.Value | E-30 (L12-13) | ○ |
| C-129 | MemberPrimitiveTypedRecord.Id | E-30 (L22) | ○ |
| C-130 | ThrowHelper.ThrowInvalidValue | E-18 (L16-17) | ○ |
| C-131 | ThrowHelper.ThrowForUnexpectedRecordType | E-18 (L40-62) | ○ |
| C-132 | ThrowHelper.ThrowEndOfStreamException | E-18 (L37-38) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースにソースコードからの根拠がある
- 追加検討事項:
  - 統合テスト観点の実装確認（既存のtests/配下のテストとの整合性）
  - パフォーマンステスト（大規模配列のデコード性能）
  - セキュリティテスト（DoS攻撃への耐性）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースに明確なソースコード根拠がある
- 注意点:
  - セキュリティ関連のテスト（悪意あるペイロード対応）は既存テスト（AttackTests.cs）との重複確認が必要
  - Array.MaxLength等の境界値はランタイム依存のため、実行環境による差異に注意

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースIDの一意性確認（UT-NRBF-001〜132の連番）
- [ ] 優先度「高」のテストケースが重要な機能をカバーしているか確認
- [ ] 各クラスの主要publicメソッドがテスト対象に含まれているか確認
- [ ] 異常系テストで適切な例外型が指定されているか確認
- [ ] 境界値テストの入力値が適切か確認
- [ ] 既存のtests/配下のテストコードとの整合性確認
