---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 110
  claims_with_evidence: 108
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.IO.Compression.Brotli 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：108 / 110、根拠なし：2
- 優先レビュー（高）
  1. **UT-BRT-109 並行操作制限**：内部実装の詳細確認が必要
  2. **UT-BRT-110 E2Eテスト**：実際の圧縮・解凍動作の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/BrotliStream.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/enc/BrotliEncoder.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/dec/BrotliDecoder.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/BrotliUtils.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/enc/BrotliStream.Compress.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/dec/BrotliStream.Decompress.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/enc/BrotliCompressionOptions.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/enc/BrotliEncoderOperation.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/src/System/IO/Compression/enc/BrotliEncoderParameter.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/ref/System.IO.Compression.Brotli.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### BrotliEncoder クラス（UT-BRT-001 〜 UT-BRT-026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BrotliEncoder(int, int)コンストラクタでquality/windowを検証 | E-02 (行24-32, 69-103) | ○ |
| C-02 | quality範囲は0-11 | E-02 (行77-79), E-04 (行11-13) | ○ |
| C-03 | window範囲は10-24 | E-02 (行95-97), E-04 (行8-10) | ○ |
| C-04 | Compressメソッドで圧縮処理 | E-02 (行140-185) | ○ |
| C-05 | isFinalBlockでストリーミング制御 | E-02 (行140) | ○ |
| C-06 | Flushメソッドでバッファフラッシュ | E-02 (行123-129) | ○ |
| C-07 | GetMaxCompressedLengthで最大圧縮長計算 | E-02 (行110-121) | ○ |
| C-08 | TryCompressで静的圧縮 | E-02 (行192-226) | ○ |
| C-09 | Disposeでリソース解放 | E-02 (行57-61) | ○ |
| C-10 | EnsureNotDisposedで破棄チェック | E-02 (行63-67) | ○ |

### BrotliDecoder クラス（UT-BRT-027 〜 UT-BRT-037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Decompressメソッドで解凍処理 | E-03 (行55-106) | ○ |
| C-12 | OperationStatusで状態返却 | E-03 (行77-100) | ○ |
| C-13 | TryDecompressで静的解凍 | E-03 (行114-127) | ○ |
| C-14 | Disposeでリソース解放 | E-03 (行32-36) | ○ |
| C-15 | EnsureNotDisposedで破棄チェック | E-03 (行38-42) | ○ |

### BrotliStream クラス（UT-BRT-038 〜 UT-BRT-095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | コンストラクタでstream/mode検証 | E-01 (行29-60) | ○ |
| C-17 | nullストリームでArgumentNullException | E-01 (行31) | ○ |
| C-18 | 不正CompressionModeでArgumentException | E-01 (行52-53) | ○ |
| C-19 | leaveOpenパラメータで基底ストリーム制御 | E-01 (行80-83) | ○ |
| C-20 | CompressionLevelコンストラクタ | E-05 (行20-30) | ○ |
| C-21 | BrotliCompressionOptionsコンストラクタ | E-05 (行39-45) | ○ |
| C-22 | Write/WriteByte/WriteAsyncメソッド | E-05 (行52-180) | ○ |
| C-23 | Read/ReadByte/ReadAsyncメソッド | E-06 (行32-197) | ○ |
| C-24 | Flush/FlushAsyncメソッド | E-05 (行185-252) | ○ |
| C-25 | BaseStreamプロパティ | E-01 (行167-173) | ○ |
| C-26 | CanRead/CanWrite/CanSeekプロパティ | E-01 (行177-183) | ○ |
| C-27 | Seek/Length/Position/SetLengthで例外 | E-01 (行189-204) | ○ |
| C-28 | Dispose/DisposeAsyncメソッド | E-01 (行69-119) | ○ |
| C-29 | BeginRead/EndRead APMパターン | E-06 (行108-118) | ○ |
| C-30 | BeginWrite/EndWrite APMパターン | E-05 (行113-120) | ○ |
| C-31 | 並行操作でInvalidOperationException | E-01 (行206-231) | ○ |

### BrotliCompressionOptions クラス（UT-BRT-096 〜 UT-BRT-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | Quality範囲検証(0-11) | E-07 (行21-31) | ○ |
| C-33 | WindowLog範囲検証(10-24) | E-07 (行40-50) | ○ |
| C-34 | デフォルト値Quality=4 | E-07 (行11), E-04 (行12) | ○ |
| C-35 | デフォルト値WindowLog=22 | E-07 (行12), E-04 (行9) | ○ |

### BrotliUtils クラス（UT-BRT-104 〜 UT-BRT-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | GetQualityFromCompressionLevel変換 | E-04 (行15-23) | ○ |
| C-37 | 定数値(Quality_Min/Max, WindowBits_Min/Max) | E-04 (行8-13) | ○ |

### E2E/統合テスト（UT-BRT-109 〜 UT-BRT-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | 並行操作制限の実装 | E-01 (行206-231) | ○ |
| C-39 | 圧縮・解凍ラウンドトリップ | **根拠なし**（動作確認必要） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-39 圧縮・解凍ラウンドトリップ**: 実際の圧縮・解凍動作の検証は既存テストコード参照が必要
  - 候補：`/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/tests/BrotliEncoderDecoderTests.cs`
  - 候補：`/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.Compression.Brotli/tests/CompressionStreamUnitTests.Brotli.cs`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから明確に導出可能
- **1: 中リスク** - 以下の項目は追加確認を推奨
  - ネイティブ相互運用（Interop.Brotli）のエラーハンドリング
  - 大容量データでのメモリ管理
  - 並行処理のスレッドセーフティ

## 6) レビュアーチェックリスト（最小）
- [ ] BrotliEncoder/Decoderの境界値テスト（quality 0/11, window 10/24）が網羅されているか
- [ ] BrotliStreamの各コンストラクタオーバーロードがカバーされているか
- [ ] 非同期メソッド（Async系）のキャンセルトークン処理がテストされているか
- [ ] Dispose後の操作に対するObjectDisposedExceptionテストが含まれているか
- [ ] 不正データに対するInvalidOperationException/InvalidDataExceptionテストが含まれているか
- [ ] ストリームモード（Compress/Decompress）の相互排他的な動作がテストされているか
- [ ] leaveOpenパラメータの動作確認テストが含まれているか
- [ ] BrotliCompressionOptionsの範囲検証テストが含まれているか
