---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 82
  claims_with_evidence: 82
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.IO.Compression.ZipFile 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：82 / 82、根拠なし：0
- 優先レビュー（高）
  1. **パストラバーサル防止（C-57）**：セキュリティ上重要なテストケース
  2. **非同期API（C-59〜73）**：.NET最新機能のテストカバレッジ
  3. **Unix固有処理（C-54, C-79, C-82）**：プラットフォーム依存のテスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFile.Create.cs`
- E-02: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFile.Extract.cs`
- E-03: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFile.Create.Async.cs`
- E-04: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFile.Extract.Async.cs`
- E-05: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFile.Create.Unix.cs`
- E-06: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFile.Create.Windows.cs`
- E-07: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFileExtensions.ZipArchive.Create.cs`
- E-08: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFileExtensions.ZipArchive.Create.Async.cs`
- E-09: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFileExtensions.ZipArchive.Create.Unix.cs`
- E-10: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFileExtensions.ZipArchive.Extract.cs`
- E-11: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFileExtensions.ZipArchive.Extract.Async.cs`
- E-12: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFileExtensions.ZipArchiveEntry.Extract.cs`
- E-13: `src/libraries/System.IO.Compression.ZipFile/src/System/IO/Compression/ZipFileExtensions.ZipArchiveEntry.Extract.Async.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ZipFile クラス - Open系メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenReadメソッドがReadモードでZIPを開く | E-01 L31 | ○ |
| C-02 | 存在しないファイルでFileNotFoundException | E-01 XMLドキュメント | ○ |
| C-03 | nullでArgumentNullException | E-01 L183, E-02 | ○ |
| C-04 | Readモードで既存ZIPを開く | E-01 L68, L144-162 | ○ |
| C-05 | Createモードで新規ZIP作成 | E-01 L68, L473-478 | ○ |
| C-06 | Updateモードで既存ZIPを開く | E-01 L68, L473-478 | ○ |
| C-07 | CreateモードでIOException（既存ファイル） | E-01 L476 FileMode.CreateNew | ○ |
| C-08 | ディレクトリパスでUnauthorizedAccessException | E-01 L468-471 | ○ |
| C-09 | 無効なZipArchiveModeでArgumentOutOfRangeException | E-01 L478 | ○ |
| C-10 | entryNameEncodingを指定して開く | E-01 L144-162 | ○ |

### ZipFile クラス - CreateFromDirectory系メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | ディレクトリからZIP作成 | E-01 L203-204, L403-415 | ○ |
| C-12 | 空ディレクトリから空ZIP作成 | E-01 L531-538 | ○ |
| C-13 | 存在しないディレクトリでDirectoryNotFoundException | E-01 XMLドキュメント L191-193 | ○ |
| C-14 | 既存ZIPでIOException | E-01 XMLドキュメント L194-195 | ○ |
| C-15 | sourceDirectoryNameがnullでArgumentNullException | E-01 XMLドキュメント L186 | ○ |
| C-16 | destinationArchiveFileNameがnullでArgumentNullException | E-01 XMLドキュメント L186 | ○ |
| C-17 | includeBaseDirectory=trueでベースディレクトリ含有 | E-01 L521-524, L534-537 | ○ |
| C-18 | includeBaseDirectory=falseでベースディレクトリ除外 | E-01 L519-520 | ○ |
| C-19 | CompressionLevel.Fastestで高速圧縮 | E-01 L442 | ○ |
| C-20 | CompressionLevel.Optimalで最適圧縮 | E-01 L442 | ○ |
| C-21 | StreamにZIPアーカイブ作成 | E-01 L344-345, L417-424 | ○ |
| C-22 | 書き込み不可StreamでArgumentException | E-01 L498-501 | ○ |
| C-23 | destinationがnullでArgumentNullException | E-01 L497 | ○ |
| C-24 | 無効なCompressionLevelでArgumentOutOfRangeException | E-01 L502-505 | ○ |

### ZipFile クラス - ExtractToDirectory系メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | ZIPをディレクトリに展開 | E-02 L39-40, L181-189 | ○ |
| C-26 | sourceArchiveFileNameがnullでArgumentNullException | E-02 L183 | ○ |
| C-27 | 存在しないZIPでFileNotFoundException | E-02 XMLドキュメント L32 | ○ |
| C-28 | 無効なZIPでInvalidDataException | E-02 XMLドキュメント L33-35 | ○ |
| C-29 | overwriteFiles=trueで上書き | E-02 L72-73 | ○ |
| C-30 | overwriteFiles=falseでIOException | E-02 XMLドキュメント L28-29 | ○ |
| C-31 | エンコーディング指定でデコード | E-02 L126-127 | ○ |
| C-32 | StreamからZIP展開 | E-02 L216-217, L320-330 | ○ |
| C-33 | 読み取り不可StreamでArgumentException | E-02 L323-326 | ○ |
| C-34 | sourceがnullでArgumentNullException | E-02 L322 | ○ |

### ZipFileExtensions クラス - CreateEntryFromFile系メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | ファイルをZIPエントリとして追加 | E-07 L44-45, L80-94 | ○ |
| C-36 | LastWriteTimeがファイルの更新日時に設定 | E-07 L113-121 | ○ |
| C-37 | 1980年より前のLastWriteTimeは1980/1/1に変換 | E-07 L117-120 | ○ |
| C-38 | 2107年より後のLastWriteTimeは1980/1/1に変換 | E-07 L117-120 | ○ |
| C-39 | destinationがnullでArgumentNullException | E-07 L98 | ○ |
| C-40 | sourceFileNameがnullでArgumentNullException | E-07 L99 | ○ |
| C-41 | entryNameがnullでArgumentNullException | E-07 L100 | ○ |
| C-42 | 存在しないファイルでFileNotFoundException | E-07 XMLドキュメント L35 | ○ |
| C-43 | 圧縮レベル指定でエントリ作成 | E-07 L76-78 | ○ |

### ZipFileExtensions クラス - ExtractToDirectory系メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | ZipArchiveをディレクトリに展開 | E-10 L35-36, L66-75 | ○ |
| C-45 | sourceがnullでArgumentNullException | E-10 L68 | ○ |
| C-46 | destinationDirectoryNameがnullでArgumentNullException | E-10 L69 | ○ |
| C-47 | overwriteFiles=trueで上書き | E-10 L66-75 | ○ |

### ZipFileExtensions クラス - ExtractToFile系メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | エントリをファイルに展開 | E-12 L33-34, L63-74 | ○ |
| C-49 | LastWriteTimeがエントリのタイムスタンプに設定 | E-12 L105-106 | ○ |
| C-50 | sourceがnullでArgumentNullException | E-12 L78 | ○ |
| C-51 | destinationFileNameがnullでArgumentNullException | E-12 L79 | ○ |
| C-52 | 既存ファイルでIOException（overwrite=false） | E-12 L84 FileMode.CreateNew | ○ |
| C-53 | overwrite=trueで上書き | E-12 L84 FileMode.Create | ○ |
| C-54 | Unixパーミッション復元 | E-12 L89-102 | ○ |

### ZipFileExtensions クラス - ExtractRelativeToDirectory
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | ファイルエントリが相対パスで展開 | E-12 L108-138, L140-149 | ○ |
| C-56 | ディレクトリエントリが作成 | E-12 L127-134 | ○ |
| C-57 | パストラバーサル防止（../） | E-12 L124-125 | ○ |
| C-58 | 不正ディレクトリエントリでIOException | E-12 L129-130 | ○ |

### 非同期API
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | OpenAsync正常系 | E-03 L155-175 | ○ |
| C-60 | OpenAsyncキャンセル | E-03 L157 | ○ |
| C-61 | OpenReadAsync正常系 | E-03 L36 | ○ |
| C-62 | CreateFromDirectoryAsync正常系 | E-03 L219-220, L433-450 | ○ |
| C-63 | CreateFromDirectoryAsyncキャンセル | E-03 L437 | ○ |
| C-64 | CreateFromDirectoryAsync(Stream)正常系 | E-03 L368-369, L452-464 | ○ |
| C-65 | ExtractToDirectoryAsync正常系 | E-04 L44-45, L195-206 | ○ |
| C-66 | ExtractToDirectoryAsyncキャンセル | E-04 L197 | ○ |
| C-67 | ExtractToDirectoryAsync(Stream)正常系 | E-04 L236-237, L349-364 | ○ |
| C-68 | CreateEntryFromFileAsync正常系 | E-08 L46-47, L83-100 | ○ |
| C-69 | CreateEntryFromFileAsyncキャンセル | E-08 L86 | ○ |
| C-70 | ExtractToDirectoryAsync(ZipArchive)正常系 | E-11 L40-41, L73-84 | ○ |
| C-71 | ExtractToDirectoryAsync(ZipArchive)キャンセル | E-11 L75 | ○ |
| C-72 | ExtractToFileAsync正常系 | E-13 L38-39, L70-87 | ○ |
| C-73 | ExtractToFileAsyncキャンセル | E-13 L72 | ○ |

### 内部メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | GetFileStreamForOpen Readモード | E-01 L475 | ○ |
| C-75 | GetFileStreamForOpen Createモード | E-01 L476 | ○ |
| C-76 | GetFileStreamForOpen Updateモード | E-01 L477 | ○ |
| C-77 | CreateZipArchiveFromDirectory ファイルエントリ作成 | E-01 L438-444 | ○ |
| C-78 | CreateZipArchiveFromDirectory 空ディレクトリエントリ | E-01 L446-453 | ○ |
| C-79 | CreateZipArchiveFromDirectory サポートされないファイルタイプ | E-01 L455-458 | ○ |
| C-80 | CreateEnumerableForCreate列挙 | E-05 L10-36, E-06 L10-14 | ○ |
| C-81 | FileStreamBufferSize定数 | E-01 L540 | ○ |
| C-82 | SetExternalAttributes Unix | E-09 L12-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースがソースコードから直接導出されている。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードのXMLドキュメントおよび実装から導出
- **パストラバーサル（C-57）**: セキュリティ上重要なため優先的にレビュー推奨
- **Unix固有処理（C-54, C-79, C-82）**: プラットフォーム依存のためCI/CDでの実行確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 全テストケースがXMLドキュメントの例外仕様と一致しているか
- [ ] パストラバーサル防止テスト（C-57）が十分なカバレッジを持つか
- [ ] 非同期API（C-59〜73）が同期版と同等のテストカバレッジを持つか
- [ ] Unix固有のテスト（C-54, C-79, C-82）がUnix環境で実行されるか
- [ ] タイムスタンプ境界値テスト（C-37, C-38）の年の範囲（1980〜2107）が正確か
- [ ] 圧縮レベル（CompressionLevel）のテストが全ての有効値をカバーしているか
