---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 190
  claims_with_evidence: 190
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.IO.Compression.Zstandard 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードからの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：クラス・メソッドのテストケースが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：190 / 190、根拠なし：0
- 優先レビュー（高）
  1. **圧縮・展開ラウンドトリップテスト（UT-ZST-188〜190）**：統合テストの網羅性確認
  2. **辞書関連テスト（UT-ZST-159〜173）**：Train メソッドの複雑なバリデーション確認
  3. **並行操作テスト（UT-ZST-056）**：スレッドセーフティの検証方法確認

## 2) 参照した情報（Evidence一覧）
> ソースコードファイルからの抽出

- E-01: `src/libraries/System.IO.Compression.Zstandard/src/System/IO/Compression/ZstandardStream.cs`
- E-02: `src/libraries/System.IO.Compression.Zstandard/src/System/IO/Compression/ZstandardStream.Compress.cs`
- E-03: `src/libraries/System.IO.Compression.Zstandard/src/System/IO/Compression/ZstandardStream.Decompress.cs`
- E-04: `src/libraries/System.IO.Compression.Zstandard/src/System/IO/Compression/ZstandardEncoder.cs`
- E-05: `src/libraries/System.IO.Compression.Zstandard/src/System/IO/Compression/ZstandardDecoder.cs`
- E-06: `src/libraries/System.IO.Compression.Zstandard/src/System/IO/Compression/ZstandardCompressionOptions.cs`
- E-07: `src/libraries/System.IO.Compression.Zstandard/src/System/IO/Compression/ZstandardDictionary.cs`
- E-08: `src/libraries/System.IO.Compression.Zstandard/src/System/IO/Compression/ZstandardUtils.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ZstandardStream コンストラクタ（UT-ZST-001〜017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタで stream=null の場合 ArgumentNullException | E-01 L29: `ArgumentNullException.ThrowIfNull(stream);` | ○ |
| C-02 | 圧縮モードで CanWrite=false の stream を渡すと ArgumentException | E-01 L34-37: `if (!stream.CanWrite) { throw new ArgumentException(...) }` | ○ |
| C-03 | 展開モードで CanRead=false の stream を渡すと ArgumentException | E-01 L40-44: `if (!stream.CanRead) { throw new ArgumentException(...) }` | ○ |
| C-04 | 無効な CompressionMode で ArgumentException | E-01 L47-48: `default: throw new ArgumentException(...)` | ○ |
| C-05 | dictionary=null で ArgumentNullException | E-01 L93: `ArgumentNullException.ThrowIfNull(dictionary);` | ○ |
| C-06 | encoder=null で ArgumentNullException | E-02 L62: `ArgumentNullException.ThrowIfNull(encoder);` | ○ |
| C-07 | decoder=null で ArgumentNullException | E-03 L25: `ArgumentNullException.ThrowIfNull(decoder);` | ○ |

### ZstandardStream プロパティ（UT-ZST-018〜029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | BaseStream で Dispose 後に ObjectDisposedException | E-01 L116: `EnsureNotDisposed();` -> L233: `ObjectDisposedException.ThrowIf(...)` | ○ |
| C-09 | CanRead は Decompress モードで true | E-01 L123: `CanRead => _mode == CompressionMode.Decompress && _stream?.CanRead == true` | ○ |
| C-10 | CanWrite は Compress モードで true | E-01 L127: `CanWrite => _mode == CompressionMode.Compress && _stream?.CanWrite == true` | ○ |
| C-11 | CanSeek は常に false | E-01 L131: `CanSeek => false` | ○ |
| C-12 | Length で NotSupportedException | E-01 L135: `Length => throw new NotSupportedException()` | ○ |
| C-13 | Position get/set で NotSupportedException | E-01 L139-143: `get => throw new NotSupportedException(); set => throw new NotSupportedException();` | ○ |
| C-14 | Seek で NotSupportedException | E-01 L150: `Seek(...) => throw new NotSupportedException()` | ○ |
| C-15 | SetLength で NotSupportedException | E-01 L155: `SetLength(...) => throw new NotSupportedException()` | ○ |

### ZstandardStream Write 操作（UT-ZST-030〜042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | 展開モードで Write すると InvalidOperationException | E-02 L94-97, L277-280: `if (_mode != CompressionMode.Compress) { throw new InvalidOperationException(...) }` | ○ |
| C-17 | Dispose 後の Write で ObjectDisposedException | E-02 L98: `EnsureNotDisposed();` -> E-01 L233 | ○ |
| C-18 | Write 時の InvalidData で InvalidDataException | E-02 L133-136: `if (lastResult == OperationStatus.InvalidData) { throw new InvalidDataException(...) }` | ○ |
| C-19 | キャンセル済みトークンで ValueTask.FromCanceled | E-02 L284-286: `return cancellationToken.IsCancellationRequested ? ValueTask.FromCanceled(cancellationToken) : ...` | ○ |

### ZstandardStream Read 操作（UT-ZST-043〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | 圧縮モードで Read すると InvalidOperationException | E-03 L106-109: `if (_mode != CompressionMode.Decompress) { throw new InvalidOperationException(...) }` | ○ |
| C-21 | Dispose 後の Read で ObjectDisposedException | E-03 L111: `EnsureNotDisposed();` -> E-01 L233 | ○ |
| C-22 | 不正データで InvalidDataException | E-03 L43-46: `if (lastResult == OperationStatus.InvalidData) { throw new InvalidDataException(...) }` | ○ |
| C-23 | 切り詰めデータで InvalidDataException | E-03 L123-124, L294-295: `ThrowTruncatedInvalidData()` -> `throw new InvalidDataException(...)` | ○ |
| C-24 | ReadByte で終端時に -1 返却 | E-03 L260-265: `return bytesRead > 0 ? singleByte[0] : -1;` | ○ |

### ZstandardStream Flush/Dispose（UT-ZST-054〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | 同時RW操作中の Flush で InvalidOperationException | E-02 L321: `EnsureNoActiveRWOperation();` -> E-01 L263-266 | ○ |
| C-26 | Dispose で最終ブロック書き込み | E-01 L165-168: `if (_mode == CompressionMode.Compress) { WriteCore(..., isFinalBlock: true, ...) }` | ○ |
| C-27 | leaveOpen=false で基底ストリーム Dispose | E-01 L170-173: `if (!_leaveOpen) { _stream.Dispose(); }` | ○ |
| C-28 | 所有エンコーダーの Dispose/Reset | E-01 L213-222: `if (_encoderOwned) { ...Dispose() } else { ...Reset() }` | ○ |

### ZstandardStream SetSourceLength（UT-ZST-058〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | 展開モードで InvalidOperationException | E-02 L82-85: `if (_mode != CompressionMode.Compress) { throw new InvalidOperationException(...) }` | ○ |
| C-30 | 負の値で ArgumentOutOfRangeException | E-04 L430: `ArgumentOutOfRangeException.ThrowIfNegative(length);` | ○ |

### ZstandardEncoder（UT-ZST-067〜102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | 品質範囲チェック | E-04 L461-462: `ArgumentOutOfRangeException.ThrowIfLessThan(...Quality_Min...) ... ThrowIfGreaterThan(...Quality_Max...)` | ○ |
| C-32 | ウィンドウ範囲チェック | E-04 L472-473: `ArgumentOutOfRangeException.ThrowIfLessThan(...WindowLog_Min...) ... ThrowIfGreaterThan(...WindowLog_Max...)` | ○ |
| C-33 | Compress で Dispose 後に ObjectDisposedException | E-04 L202: `EnsureNotDisposed();` -> L454: `ObjectDisposedException.ThrowIf(_disposed, ...)` | ○ |
| C-34 | ソース長不一致で InvalidData 返却 | E-04 L259-262: `if (error == Interop.Zstd.ZSTD_error.srcSize_wrong) { return OperationStatus.InvalidData; }` | ○ |
| C-35 | GetMaxCompressedLength で負の入力に ArgumentOutOfRangeException | E-04 L290: `ArgumentOutOfRangeException.ThrowIfNegative(inputLength);` | ○ |
| C-36 | Reset で Dispose 後に ObjectDisposedException | E-04 L392: `EnsureNotDisposed();` | ○ |
| C-37 | SetPrefix で完了後に InvalidOperationException | E-04 L406-409: `if (_finished) { throw new InvalidOperationException(...) }` | ○ |
| C-38 | SetSourceLength で完了後に InvalidOperationException | E-04 L434-437: `if (_finished) { throw new InvalidOperationException(...) }` | ○ |
| C-39 | TryCompress で dictionary=null に ArgumentNullException | E-04 L341: `ArgumentNullException.ThrowIfNull(dictionary);` | ○ |

### ZstandardDecoder（UT-ZST-103〜134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | maxWindowLog 範囲チェック | E-05 L363-364: `ArgumentOutOfRangeException.ThrowIfLessThan(...WindowLog_Min...) ... ThrowIfGreaterThan(...WindowLog_Max...)` | ○ |
| C-41 | dictionary=null で ArgumentNullException | E-05 L62, L87, L278: `ArgumentNullException.ThrowIfNull(dictionary);` | ○ |
| C-42 | Decompress で Dispose 後に ObjectDisposedException | E-05 L137: `EnsureNotDisposed();` -> L354: `ObjectDisposedException.ThrowIf(_disposed, this)` | ○ |
| C-43 | 不正データで InvalidData 返却 | E-05 L176-178: `default: return OperationStatus.InvalidData;` | ○ |
| C-44 | ウィンドウサイズ超過で IOException | E-05 L171-174: `case Interop.Zstd.ZSTD_error.frameParameter_windowTooLarge: ZstandardUtils.Throw(error);` -> E-08 L70 | ○ |
| C-45 | TryGetMaxDecompressedLength で空データに true, 0 | E-05 L207-211: `if (data.IsEmpty) { length = 0; return true; }` | ○ |
| C-46 | TryDecompress で空ソースに false | E-05 L243-246: `if (source.IsEmpty) { return false; }` | ○ |
| C-47 | SetPrefix で完了後に InvalidOperationException | E-05 L332-335: `if (_finished) { throw new InvalidOperationException(...) }` | ○ |

### ZstandardCompressionOptions（UT-ZST-135〜158）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Quality 範囲チェック | E-06 L47-51: `if (value != 0) { ArgumentOutOfRangeException.ThrowIfGreaterThan(...) ... ThrowIfLessThan(...) }` | ○ |
| C-49 | WindowLog 範囲チェック | E-06 L71-75: `if (value != 0) { ArgumentOutOfRangeException.ThrowIfLessThan(...) ... ThrowIfGreaterThan(...) }` | ○ |
| C-50 | TargetBlockSize 範囲チェック | E-06 L92-96: `if (value != 0) { ArgumentOutOfRangeException.ThrowIfLessThan(...Min...) ... ThrowIfGreaterThan(...Max...) }` | ○ |
| C-51 | 静的プロパティが ZstandardUtils 定数と一致 | E-06 L10-25: `DefaultQuality => ZstandardUtils.Quality_Default` 等 | ○ |

### ZstandardDictionary（UT-ZST-159〜173）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | Create で空バッファに ArgumentException | E-07 L41-44: `if (buffer.IsEmpty) { throw new ArgumentException(...) }` | ○ |
| C-53 | Train で空サンプルに ArgumentException | E-07 L89-92: `if (samples.IsEmpty) { throw new ArgumentException(...) }` | ○ |
| C-54 | Train で 5 未満のサンプルに ArgumentException | E-07 L95-98: `if (sampleLengths.Length < 5) { throw new ArgumentException(...) }` | ○ |
| C-55 | Train でサンプル長不一致に ArgumentException | E-07 L121-124: `if (totalLength != samples.Length) { throw new ArgumentException(...) }` | ○ |
| C-56 | Train で負のサンプル長に ArgumentException | E-07 L113-116: `if (length <= 0) { throw new ArgumentException(...) }` | ○ |
| C-57 | Train で maxDictionarySize < 256 に ArgumentOutOfRangeException | E-07 L126: `ArgumentOutOfRangeException.ThrowIfLessThan(maxDictionarySize, 256, ...)` | ○ |
| C-58 | Data プロパティで Dispose 後に ObjectDisposedException | E-07 L179: `ThrowIfDisposed();` -> L197: `ObjectDisposedException.ThrowIf(_disposed, this)` | ○ |

### ZstandardUtils（UT-ZST-174〜187）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | IsError でエラー判定 | E-08 L28: `return Interop.Zstd.ZSTD_isError(result) != 0` | ○ |
| C-60 | memory_allocation で OutOfMemoryException | E-08 L75-76: `case Interop.Zstd.ZSTD_error.memory_allocation: return new OutOfMemoryException();` | ○ |
| C-61 | frameParameter_windowTooLarge で IOException | E-08 L69-70: `case ...: return new IOException(SR.ZstandardDecoder_WindowTooLarge);` | ○ |
| C-62 | dictionary_wrong で InvalidDataException | E-08 L72-73: `case ...: return new InvalidDataException(SR.ZstandardDecoder_DictionaryWrong);` | ○ |
| C-63 | stage_wrong で InvalidOperationException | E-08 L78-79: `case ...: return new InvalidOperationException(SR.ZstandardEncoderDecoder_InvalidState);` | ○ |
| C-64 | GetQualityFromCompressionLevel の変換 | E-08 L86-97: switch式による各 CompressionLevel の変換 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースがソースコードに基づいています。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコードの実装に基づいており、高い信頼性があります。

## 6) レビュアーチェックリスト（最小）
- [ ] 統合テスト（UT-ZST-188〜190）の実装方針が適切か確認
- [ ] Train メソッドのテスト（UT-ZST-162〜167）で十分なサンプルデータを用意できるか確認
- [ ] 並行操作テスト（UT-ZST-056）の実装可能性を確認
- [ ] プラットフォーム依存のテスト（WindowLog_Max が 32bit/64bit で異なる）の対応確認
- [ ] ネイティブ Zstd ライブラリの依存関係がテスト環境で利用可能か確認
