---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 137
  claims_with_evidence: 135
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.IO.Compression 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：135 / 137、根拠なし：2
- 優先レビュー（高）
  1. **UT-IOC-085 IsGzipStream()**: windowBitsの範囲判定ロジックの正確性要確認
  2. **UT-IOC-097 AvailableOutput**: OutputWindowクラスの内部実装詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.Compression/src/System/IO/Compression/DeflateZLib/DeflateStream.cs`
- E-02: `src/libraries/System.IO.Compression/src/System/IO/Compression/GZipStream.cs`
- E-03: `src/libraries/System.IO.Compression/src/System/IO/Compression/ZLibStream.cs`
- E-04: `src/libraries/System.IO.Compression/src/System/IO/Compression/ZipArchive.cs`
- E-05: `src/libraries/System.IO.Compression/src/System/IO/Compression/ZipArchiveEntry.cs`
- E-06: `src/libraries/System.IO.Compression/src/System/IO/Compression/ZipHelper.cs`
- E-07: `src/libraries/System.IO.Compression/src/System/IO/Compression/ZLibCompressionOptions.cs`
- E-08: `src/libraries/System.IO.Compression/src/System/IO/Compression/DeflateZLib/Inflater.cs`
- E-09: `src/libraries/System.IO.Compression/src/System/IO/Compression/DeflateZLib/Deflater.cs`
- E-10: `src/libraries/System.IO.Compression/src/System/IO/Compression/ZipBlocks.cs`
- E-11: `src/libraries/System.IO.Compression/src/System/IO/Compression/ZipCustomStreams.cs`
- E-12: `src/libraries/System.IO.Compression/src/System/IO/Compression/DeflateManaged/InflaterManaged.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DeflateStream圧縮モード初期化 | E-01 | ○ |
| C-02 | DeflateStream展開モード初期化 | E-01 | ○ |
| C-03 | DeflateStream nullストリーム例外 | E-01 | ○ |
| C-04 | DeflateStream無効CompressionMode例外 | E-01 | ○ |
| C-05 | DeflateStream.Read正常系 | E-01 | ○ |
| C-06 | DeflateStream.Read圧縮モード例外 | E-01 | ○ |
| C-07 | DeflateStream.Read空バッファ | E-01 | ○ |
| C-08 | DeflateStream.Read Spanオーバーロード | E-01 | ○ |
| C-09 | DeflateStream.Write正常系 | E-01 | ○ |
| C-10 | DeflateStream.Write展開モード例外 | E-01 | ○ |
| C-11 | DeflateStream.Write Spanオーバーロード | E-01 | ○ |
| C-12 | DeflateStream.Flush | E-01 | ○ |
| C-13 | DeflateStream.FlushAsync | E-01 | ○ |
| C-14 | DeflateStream.Dispose | E-01 | ○ |
| C-15 | DeflateStream leaveOpenオプション | E-01 | ○ |
| C-16 | DeflateStream.CanRead | E-01 | ○ |
| C-17 | DeflateStream.CanWrite | E-01 | ○ |
| C-18 | DeflateStream.CanSeek | E-01 | ○ |
| C-19 | GZipStream圧縮モード初期化 | E-02 | ○ |
| C-20 | GZipStream展開モード初期化 | E-02 | ○ |
| C-21 | GZipStream nullストリーム例外 | E-02 | ○ |
| C-22 | GZipStream.Read正常系 | E-02 | ○ |
| C-23 | GZipStream.Write正常系 | E-02 | ○ |
| C-24 | GZipStream連結ストリーム読み取り | E-02, E-08 | ○ |
| C-25 | ZLibStream圧縮モード初期化 | E-03 | ○ |
| C-26 | ZLibStream展開モード初期化 | E-03 | ○ |
| C-27 | ZLibStreamカスタムオプション | E-03, E-07 | ○ |
| C-28 | ZLibCompressionOptions.CompressionLevel正常系 | E-07 | ○ |
| C-29 | ZLibCompressionOptions.CompressionLevelデフォルト | E-07 | ○ |
| C-30 | ZLibCompressionOptions.CompressionLevel下限超過 | E-07 | ○ |
| C-31 | ZLibCompressionOptions.CompressionLevel上限超過 | E-07 | ○ |
| C-32 | ZLibCompressionOptions.CompressionStrategy正常系 | E-07 | ○ |
| C-33 | ZLibCompressionOptions.CompressionStrategy不正値 | E-07 | ○ |
| C-34 | ZipArchive読み取りモード初期化 | E-04 | ○ |
| C-35 | ZipArchive作成モード初期化 | E-04 | ○ |
| C-36 | ZipArchive更新モード初期化 | E-04 | ○ |
| C-37 | ZipArchive nullストリーム例外 | E-04 | ○ |
| C-38 | ZipArchiveストリーム能力検証 | E-04 | ○ |
| C-39 | ZipArchive.Entries取得 | E-04 | ○ |
| C-40 | ZipArchive.Entries作成モード例外 | E-04 | ○ |
| C-41 | ZipArchive.GetEntry正常系 | E-04 | ○ |
| C-42 | ZipArchive.GetEntry未発見 | E-04 | ○ |
| C-43 | ZipArchive.GetEntry null例外 | E-04 | ○ |
| C-44 | ZipArchive.CreateEntry正常系 | E-04 | ○ |
| C-45 | ZipArchive.CreateEntry読み取りモード例外 | E-04 | ○ |
| C-46 | ZipArchive.CreateEntry圧縮レベル指定 | E-04 | ○ |
| C-47 | ZipArchive.Dispose | E-04 | ○ |
| C-48 | ZipArchive leaveOpenオプション | E-04 | ○ |
| C-49 | ZipArchive.Comment取得 | E-04 | ○ |
| C-50 | ZipArchive.Comment設定 | E-04 | ○ |
| C-51 | ZipArchiveEntry.FullName | E-05 | ○ |
| C-52 | ZipArchiveEntry.Name | E-05 | ○ |
| C-53 | ZipArchiveEntry.Length | E-05 | ○ |
| C-54 | ZipArchiveEntry.CompressedLength | E-05 | ○ |
| C-55 | ZipArchiveEntry.LastWriteTime取得 | E-05 | ○ |
| C-56 | ZipArchiveEntry.LastWriteTime設定 | E-05 | ○ |
| C-57 | ZipArchiveEntry.LastWriteTime下限補正 | E-05, E-06 | ○ |
| C-58 | ZipArchiveEntry.LastWriteTime上限補正 | E-05, E-06 | ○ |
| C-59 | ZipArchiveEntry.Open読み取り | E-05 | ○ |
| C-60 | ZipArchiveEntry.Open書き込み | E-05 | ○ |
| C-61 | ZipArchiveEntry.Open二重オープン例外 | E-05 | ○ |
| C-62 | ZipArchiveEntry.Delete正常系 | E-05 | ○ |
| C-63 | ZipArchiveEntry.Delete読み取りモード例外 | E-05 | ○ |
| C-64 | ZipArchiveEntry.ExternalAttributes取得 | E-05 | ○ |
| C-65 | ZipArchiveEntry.ExternalAttributes設定 | E-05 | ○ |
| C-66 | ZipHelper.DosTimeToDateTime正常系 | E-06 | ○ |
| C-67 | ZipHelper.DosTimeToDateTimeゼロ入力 | E-06 | ○ |
| C-68 | ZipHelper.DosTimeToDateTime不正日時 | E-06 | ○ |
| C-69 | ZipHelper.DateTimeToDosTime正常系 | E-06 | ○ |
| C-70 | ZipHelper.GetEncodingASCII | E-06 | ○ |
| C-71 | ZipHelper.GetEncodingUTF8 | E-06 | ○ |
| C-72 | ZipHelper.GetEncodedTruncatedBytesFromString正常系 | E-06 | ○ |
| C-73 | ZipHelper.GetEncodedTruncatedBytesFromString空入力 | E-06 | ○ |
| C-74 | ZipHelper.GetEncodedTruncatedBytesFromString切り詰め | E-06 | ○ |
| C-75 | ZipHelper.SeekBackwardsToSignature発見 | E-06 | ○ |
| C-76 | ZipHelper.SeekBackwardsToSignature未発見 | E-06 | ○ |
| C-77 | Inflater.CreateInflater | E-08 | ○ |
| C-78 | Inflater.Inflate正常系 | E-08 | ○ |
| C-79 | Inflater.Inflate空Span | E-08 | ○ |
| C-80 | Inflater.SetInput正常系 | E-08 | ○ |
| C-81 | Inflater.SetInput空入力 | E-08 | ○ |
| C-82 | Inflater.NeedsInput | E-08 | ○ |
| C-83 | Inflater.Finished | E-08 | ○ |
| C-84 | Inflater.Dispose | E-08 | ○ |
| C-85 | Inflater.IsGzipStream | E-08 | △ |
| C-86 | Deflater.CreateDeflater | E-09 | ○ |
| C-87 | Deflater.SetInput | E-09 | ○ |
| C-88 | Deflater.GetDeflateOutput | E-09 | ○ |
| C-89 | Deflater.Finish | E-09 | ○ |
| C-90 | Deflater.Flush | E-09 | ○ |
| C-91 | Deflater.NeedsInput | E-09 | ○ |
| C-92 | Deflater.Dispose | E-09 | ○ |
| C-93 | InflaterManaged初期化 | E-12 | ○ |
| C-94 | InflaterManaged.Inflate正常系 | E-12 | ○ |
| C-95 | InflaterManaged.SetInput | E-12 | ○ |
| C-96 | InflaterManaged.Finished | E-12 | ○ |
| C-97 | InflaterManaged.AvailableOutput | E-12 | △ |
| C-98 | WrappedStream.Read | E-11 | ○ |
| C-99 | WrappedStream.Write | E-11 | ○ |
| C-100 | WrappedStream.Dispose closeBaseStream=true | E-11 | ○ |
| C-101 | WrappedStream.Dispose closeBaseStream=false | E-11 | ○ |
| C-102 | SubReadStream初期化 | E-11 | ○ |
| C-103 | SubReadStream.Read正常系 | E-11 | ○ |
| C-104 | SubReadStream.Read範囲終端 | E-11 | ○ |
| C-105 | SubReadStream.Position取得 | E-11 | ○ |
| C-106 | SubReadStream.Position設定 | E-11 | ○ |
| C-107 | SubReadStream.Seek正常系 | E-11 | ○ |
| C-108 | SubReadStream.Seek範囲外例外 | E-11 | ○ |
| C-109 | SubReadStream.Length | E-11 | ○ |
| C-110 | SubReadStream.CanWrite | E-11 | ○ |
| C-111 | CheckSumAndSizeWriteStream.Write CRC計算 | E-11 | ○ |
| C-112 | CheckSumAndSizeWriteStream.Write空書き込み | E-11 | ○ |
| C-113 | CheckSumAndSizeWriteStream.Position | E-11 | ○ |
| C-114 | CheckSumAndSizeWriteStream.Dispose | E-11 | ○ |
| C-115 | CheckSumAndSizeWriteStream.CanRead | E-11 | ○ |
| C-116 | ZipGenericExtraField.TryReadBlock正常系 | E-10 | ○ |
| C-117 | ZipGenericExtraField.TryReadBlockサイズ不足 | E-10 | ○ |
| C-118 | ZipGenericExtraField.ParseExtraField | E-10 | ○ |
| C-119 | ZipGenericExtraField.WriteBlock | E-10 | ○ |
| C-120 | Zip64ExtraField.GetJustZip64Block正常系 | E-10 | ○ |
| C-121 | Zip64ExtraField.GetJustZip64Block未発見 | E-10 | ○ |
| C-122 | Zip64ExtraField.UncompressedSize | E-10 | ○ |
| C-123 | Zip64ExtraField.CompressedSize | E-10 | ○ |
| C-124 | Zip64ExtraField.WriteBlock | E-10 | ○ |
| C-125 | ZipLocalFileHeader.TrySkipBlock正常系 | E-10 | ○ |
| C-126 | ZipLocalFileHeader.TrySkipBlockシグネチャ不一致 | E-10 | ○ |
| C-127 | ZipLocalFileHeader.GetExtraFields | E-10 | ○ |
| C-128 | ZipCentralDirectoryFileHeader.TryReadBlock正常系 | E-10 | ○ |
| C-129 | ZipCentralDirectoryFileHeader.TryReadBlockシグネチャ不一致 | E-10 | ○ |
| C-130 | ZipEndOfCentralDirectoryBlock.ReadBlock正常系 | E-10 | ○ |
| C-131 | ZipEndOfCentralDirectoryBlock.ReadBlock無効EOCD | E-10 | ○ |
| C-132 | ZipEndOfCentralDirectoryBlock.WriteBlock | E-10 | ○ |
| C-133 | Zip64EndOfCentralDirectoryLocator.TryReadBlock | E-10 | ○ |
| C-134 | Zip64EndOfCentralDirectoryLocator.WriteBlock | E-10 | ○ |
| C-135 | Zip64EndOfCentralDirectoryRecord.TryReadBlock正常系 | E-10 | ○ |
| C-136 | Zip64EndOfCentralDirectoryRecord.TryReadBlock無効例外 | E-10 | ○ |
| C-137 | Zip64EndOfCentralDirectoryRecord.WriteBlock | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-85 (UT-IOC-085)**: IsGzipStream()メソッドのwindowBits範囲判定（24-31）はコードで確認できるが、ZLibのwindowBits仕様との完全な整合性検証が必要
  - 候補：ZLib公式ドキュメント / RFC 1952（GZip仕様）
- **C-97 (UT-IOC-097)**: AvailableOutputプロパティはOutputWindowクラスのAvailableBytesを参照するが、OutputWindow.csの詳細実装は未解析
  - 候補：OutputWindow.csソースコード / 既存テストコード

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 大部分のテストケースはソースコードの明示的なメソッドシグネチャ・実装に基づいている
- **リスク1（中）**: Zip64関連のテストケース（UT-IOC-120〜137）は4GB超ファイルでの実機検証が推奨される
- **リスク1（中）**: 非同期メソッド（FlushAsync, ReadAsync, WriteAsync）のキャンセレーショントークン動作は追加検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] DeflateStream/GZipStream/ZLibStreamの相互運用性テストケースの追加検討
- [ ] Zip64形式の大規模ファイル（4GB超）テストケースの実行環境確認
- [ ] マルチスレッド環境でのInflater/Deflater使用に関するテストケース追加検討
- [ ] 破損したZIPファイルに対する例外処理テストケースの網羅性確認
- [ ] プラットフォーム固有の動作（Windows/Linux/macOS）に関するテストケース追加検討
