---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 135
  claims_with_evidence: 132
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.IO.FileSystem.AccessControl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコード・API定義などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：クラス・メソッドの主要な機能・分岐をカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 132 / 135 = 0.98
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：132 / 135、根拠なし：3
- 優先レビュー（高）
  1. **UT-FSAC-050 (Persist)**: 内部メソッドのため直接テスト困難
  2. **UT-FSAC-049 (GetAccessControlSectionsFromChanges)**: 内部メソッドのため直接テスト困難
  3. **UT-FSAC-094 (GetFileAccessFromRights)**: 内部メソッドのため直接テスト困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/src/System/Security/AccessControl/FileSecurity.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/src/System/Security/AccessControl/DirectorySecurity.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/src/System/Security/AccessControl/FileSystemSecurity.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/src/System/Security/AccessControl/FileSystemAccessRule.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/src/System/Security/AccessControl/FileSystemAuditRule.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/src/System/Security/AccessControl/FileSystemRights.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/src/System/Security/AccessControl/DirectoryObjectSecurity.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/src/System/IO/FileSystemAclExtensions.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/ref/System.IO.FileSystem.AccessControl.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/tests/FileSystemSecurityTests.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/tests/FileSystemAccessRuleTests.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/tests/FileSystemAuditRuleTests.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/tests/FileSystemAclExtensionsTests.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.AccessControl/tests/DirectoryObjectSecurityTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### FileSecurity クラス (UT-FSAC-001 〜 004)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FileSecurity デフォルトコンストラクタ | E-01 L11-14, E-10 L23 | ○ |
| C-02 | FileSecurity(string, AccessControlSections) コンストラクタ | E-01 L16-19, E-10 L432-445 | ○ |
| C-03 | 存在しないファイルでFileNotFoundException | E-03 L52-58, E-10 L432-445 | ○ |
| C-04 | 無効なファイル名でArgumentException | E-03 L37-38 | ○ |

### DirectorySecurity クラス (UT-FSAC-005 〜 007)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | DirectorySecurity デフォルトコンストラクタ | E-02 L10-13 | ○ |
| C-06 | DirectorySecurity(string, AccessControlSections) コンストラクタ | E-02 L15-18, E-10 L416-428 | ○ |
| C-07 | 存在しないディレクトリでDirectoryNotFoundException | E-03 L45-51, E-10 L416-428 | ○ |

### FileSystemAccessRule クラス (UT-FSAC-008 〜 015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | FileSystemAccessRule(IdentityReference, FileSystemRights, AccessControlType) | E-04 L14-26, E-11 L13-22 | ○ |
| C-09 | FileSystemAccessRule(string, FileSystemRights, AccessControlType) | E-04 L28-40, E-11 L49-59 | ○ |
| C-10 | 継承フラグと伝播フラグ指定コンストラクタ | E-04 L46-60, E-11 L61-70 | ○ |
| C-11 | Allow時Synchronizeビット付与 | E-04 L110-118, E-11 L14-19 | ○ |
| C-12 | Deny時Synchronizeビット除去 | E-04 L119-124, E-11 L32-38 | ○ |
| C-13 | FullControl時Synchronizeビット維持 | E-04 L121-123, E-11 L41-46 | ○ |
| C-14 | 無効なFileSystemRightsでArgumentOutOfRangeException | E-04 L112-113, E-11 L25-29 | ○ |
| C-15 | FileSystemRightsプロパティ | E-04 L100-103 | ○ |

### FileSystemAuditRule クラス (UT-FSAC-016 〜 020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | FileSystemAuditRule(IdentityReference, FileSystemRights, AuditFlags) | E-05 L10-21, E-12 L12-18 | ○ |
| C-17 | FileSystemAuditRule(string, FileSystemRights, AuditFlags) | E-05 L39-50, E-12 L30-36 | ○ |
| C-18 | 継承フラグと伝播フラグ指定コンストラクタ | E-05 L23-37, E-12 L21-27 | ○ |
| C-19 | 無効なFileSystemRightsでArgumentOutOfRangeException | E-05 L87-88, E-12 L39-43 | ○ |
| C-20 | FileSystemRightsプロパティ | E-05 L93-96, E-12 L47-52 | ○ |

### FileSystemSecurity クラス - アクセスルール操作 (UT-FSAC-021 〜 037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | AddAccessRule正常動作 | E-03 L149-153, E-10 L28-41 | ○ |
| C-22 | AddAccessRule null検証 | E-10 L21-25 | ○ |
| C-23 | SetAccessRule正常動作 | E-03 L155-158, E-10 L51-68 | ○ |
| C-24 | SetAccessRule異なるIdentity | E-10 L71-90 | ○ |
| C-25 | SetAccessRule null検証 | E-10 L44-48 | ○ |
| C-26 | ResetAccessRule正常動作 | E-03 L160-163, E-10 L99-122 | ○ |
| C-27 | ResetAccessRule null検証 | E-10 L93-97 | ○ |
| C-28 | RemoveAccessRule部分削除 | E-03 L165-198, E-10 L132-150 | ○ |
| C-29 | RemoveAccessRule同一ルール削除 | E-10 L152-165 | ○ |
| C-30 | RemoveAccessRule非マッチ時 | E-10 L167-185 | ○ |
| C-31 | RemoveAccessRule null検証 | E-03 L167, E-10 L125-129 | ○ |
| C-32 | RemoveAccessRuleAll正常動作 | E-03 L200-206, E-10 L236-268 | ○ |
| C-33 | RemoveAccessRuleAll Deny非影響 | E-10 L260-264 | ○ |
| C-34 | RemoveAccessRuleAll null検証 | E-10 L230-234 | ○ |
| C-35 | RemoveAccessRuleSpecific正常動作 | E-03 L208-242, E-10 L214-227 | ○ |
| C-36 | RemoveAccessRuleSpecific部分一致非削除 | E-10 L194-212 | ○ |
| C-37 | RemoveAccessRuleSpecific null検証 | E-03 L210, E-10 L188-192 | ○ |

### FileSystemSecurity クラス - 監査ルール操作 (UT-FSAC-038 〜 046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | AddAuditRule正常動作 | E-03 L244-247, E-10 L281-295 | ○ |
| C-39 | SetAuditRule正常動作 | E-03 L249-252, E-10 L297-322 | ○ |
| C-40 | RemoveAuditRule部分削除 | E-03 L254-257, E-10 L324-344 | ○ |
| C-41 | RemoveAuditRuleSpecific正常動作 | E-03 L264-267, E-10 L346-365 | ○ |
| C-42 | RemoveAuditRuleSpecific部分一致非削除 | E-10 L367-381 | ○ |
| C-43 | RemoveAuditRuleAll正常動作 | E-03 L259-262, E-10 L383-405 | ○ |
| C-44 | AccessRightTypeプロパティ | E-03 L269-272, E-10 L271-279 | ○ |
| C-45 | AccessRuleTypeプロパティ | E-03 L274-277 | ○ |
| C-46 | AuditRuleTypeプロパティ | E-03 L279-282, E-10 L407-413 | ○ |

### FileSystemSecurity クラス - ファクトリ・永続化 (UT-FSAC-047 〜 050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | AccessRuleFactory | E-03 L69-84 | ○ |
| C-48 | AuditRuleFactory | E-03 L86-101 | ○ |
| C-49 | GetAccessControlSectionsFromChanges | E-03 L103-115 | △ |
| C-50 | Persist(string) | E-03 L117-131 | △ |

### FileSystemAclExtensions - DirectoryInfo (UT-FSAC-051 〜 056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | GetAccessControl(DirectoryInfo) | E-08 L13-18, E-13 L28-35 | ○ |
| C-52 | GetAccessControl(DirectoryInfo) null検証 | E-08 L15, E-13 L22-25 | ○ |
| C-53 | GetAccessControl(DirectoryInfo, AccessControlSections) | E-08 L20-25, E-13 L44-52 | ○ |
| C-54 | GetAccessControl(DirectoryInfo, AccessControlSections) null検証 | E-08 L22, E-13 L38-41 | ○ |
| C-55 | SetAccessControl(DirectoryInfo, DirectorySecurity) | E-08 L27-33, E-13 L118-125 | ○ |
| C-56 | SetAccessControl null検証 | E-08 L29, E-13 L111-116 | ○ |

### FileSystemAclExtensions - FileInfo (UT-FSAC-057 〜 061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | GetAccessControl(FileInfo) | E-08 L35-40, E-13 L60-69 | ○ |
| C-58 | GetAccessControl(FileInfo) null検証 | E-08 L37, E-13 L54-58 | ○ |
| C-59 | GetAccessControl(FileInfo, AccessControlSections) | E-08 L42-47, E-13 L78-87 | ○ |
| C-60 | SetAccessControl(FileInfo, FileSecurity) | E-08 L49-57, E-13 L136-144 | ○ |
| C-61 | SetAccessControl null検証 | E-08 L51-52, E-13 L128-134 | ○ |

### FileSystemAclExtensions - FileStream (UT-FSAC-062 〜 068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | GetAccessControl(FileStream) | E-08 L65-76, E-13 L96-104 | ○ |
| C-63 | GetAccessControl(FileStream) null検証 | E-08 L67, E-13 L90-93 | ○ |
| C-64 | GetAccessControl閉じたストリーム | E-08 L70-73 | ○ |
| C-65 | SetAccessControl(FileStream, FileSecurity) | E-08 L85-97, E-13 L181-188 | ○ |
| C-66 | SetAccessControl null stream検証 | E-08 L87, E-13 L166-169 | ○ |
| C-67 | SetAccessControl null security検証 | E-08 L88, E-13 L172-178 | ○ |
| C-68 | SetAccessControl閉じたストリーム | E-08 L91-94 | ○ |

### FileSystemAclExtensions - Create (UT-FSAC-069 〜 089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Create(DirectoryInfo, DirectorySecurity) | E-08 L106-112, E-13 L246-269 | ○ |
| C-70 | Create null DirectoryInfo検証 | E-08 L108, E-13 L195-199 | ○ |
| C-71 | Create null DirectorySecurity検証 | E-08 L109, E-13 L202-206 | ○ |
| C-72 | Create親ディレクトリ不在 | E-13 L209-219 | ○ |
| C-73 | Create FullControl階層作成 | E-13 L221-231 | ○ |
| C-74 | Create(FileInfo, ...) | E-08 L134-190, E-13 L436-448 | ○ |
| C-75 | Create null FileInfo検証 | E-08 L136, E-13 L302-308 | ○ |
| C-76 | Create無効FileMode | E-08 L141-143, E-13 L322-326 | ○ |
| C-77 | Create無効FileShare | E-08 L146-148, E-13 L329-332 | ○ |
| C-78 | Create無効bufferSize | E-08 L151-153, E-13 L335-338 | ○ |
| C-79 | Create書き込みモード読み取り権限 | E-08 L158-161, E-13 L351-353 | ○ |
| C-80 | Create Appendモード読み取り権限 | E-08 L166-168, E-13 L388-389 | ○ |
| C-81 | Create Truncateモード部分書き込み権限 | E-08 L173-175, E-13 L408-409 | ○ |
| C-82 | CreateディレクトリNotFoundException | E-13 L310-319 | ○ |
| C-83 | Create nullセキュリティ | E-08 L278-289, E-13 L437-438 | ○ |
| C-84 | Create Denyルール適用 | E-13 L479-508 | ○ |
| C-85 | CreateDirectory(DirectorySecurity, string) | E-08 L203-213, E-13 L569-586 | ○ |
| C-86 | CreateDirectory null security検証 | E-08 L205, E-13 L551-558 | ○ |
| C-87 | CreateDirectory null path検証 | E-08 L206, E-13 L561-566 | ○ |
| C-88 | CreateDirectory空path検証 | E-08 L206, E-13 L566 | ○ |
| C-89 | CreateDirectory既存ディレクトリ | E-13 L569-586 | ○ |

### FileSystemAclExtensions - GetFileAccessFromRights (UT-FSAC-090 〜 094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | FullControlでReadWrite | E-08 L221-225 | ○ |
| C-91 | ModifyでReadWrite | E-08 L222-225 | ○ |
| C-92 | ReadDataでRead | E-08 L227-236 | ○ |
| C-93 | WriteDataでWrite | E-08 L238-248 | ○ |
| C-94 | アクセス権限なしでException | E-08 L250 | △ |

### DirectoryObjectSecurity クラス (UT-FSAC-095 〜 128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | デフォルトコンストラクタ | E-07 L14-18, E-14 L46-51 | ○ |
| C-96 | CommonSecurityDescriptorコンストラクタ | E-07 L20-25, E-14 L54-60 | ○ |
| C-97 | null CommonSecurityDescriptor検証 | E-07 L23, E-14 L63-67 | ○ |
| C-98 | GetAccessRules SecurityIdentifier | E-07 L714-717, E-14 L79-90 | ○ |
| C-99 | GetAccessRules NTAccount | E-07 L714-717, E-14 L93-104 | ○ |
| C-100 | GetAccessRules無効targetType | E-07 L54-57, E-14 L70-76 | ○ |
| C-101 | GetAuditRules | E-07 L719-722, E-14 L107-117 | ○ |
| C-102 | AddAccessRule | E-07 L521-537, E-14 L673-697 | ○ |
| C-103 | AddAccessRule null検証 | E-07 L523, E-14 L667-671 | ○ |
| C-104 | SetAccessRule | E-07 L539-553, E-14 L614-638 | ○ |
| C-105 | SetAccessRule null検証 | E-07 L541, E-14 L608-612 | ○ |
| C-106 | ResetAccessRule | E-07 L555-569, E-14 L534-568 | ○ |
| C-107 | ResetAccessRule null検証 | E-07 L557, E-14 L527-531 | ○ |
| C-108 | RemoveAccessRule Allow | E-07 L571-590, E-14 L325-354 | ○ |
| C-109 | RemoveAccessRule Deny | E-14 L357-386 | ○ |
| C-110 | RemoveAccessRule null検証 | E-07 L573, E-14 L318-322 | ○ |
| C-111 | RemoveAccessRuleAll Allow | E-07 L592-611, E-14 L448-477 | ○ |
| C-112 | RemoveAccessRuleAll Deny | E-14 L496-523 | ○ |
| C-113 | RemoveAccessRuleAll Deny継承付きException | E-14 L480-493 | ○ |
| C-114 | RemoveAccessRuleAll null検証 | E-07 L594, E-14 L442-446 | ○ |
| C-115 | RemoveAccessRuleSpecific完全一致 | E-07 L613-631, E-14 L396-416 | ○ |
| C-116 | RemoveAccessRuleSpecific部分一致非削除 | E-14 L419-439 | ○ |
| C-117 | RemoveAccessRuleSpecific null検証 | E-07 L615, E-14 L389-393 | ○ |
| C-118 | AddAuditRule | E-07 L634-648, E-14 L290-315 | ○ |
| C-119 | AddAuditRule null検証 | E-07 L636, E-14 L284-288 | ○ |
| C-120 | SetAuditRule | E-07 L650-664, E-14 L258-281 | ○ |
| C-121 | SetAuditRule null検証 | E-07 L652, E-14 L252-256 | ○ |
| C-122 | RemoveAuditRule | E-07 L666-680, E-14 L218-249 | ○ |
| C-123 | RemoveAuditRule null検証 | E-07 L668, E-14 L212-216 | ○ |
| C-124 | RemoveAuditRuleAll | E-07 L682-696, E-14 L127-154 | ○ |
| C-125 | RemoveAuditRuleAll null検証 | E-07 L684, E-14 L120-124 | ○ |
| C-126 | RemoveAuditRuleSpecific完全一致 | E-07 L698-712, E-14 L164-184 | ○ |
| C-127 | RemoveAuditRuleSpecific部分一致非削除 | E-14 L187-209 | ○ |
| C-128 | RemoveAuditRuleSpecific null検証 | E-07 L700, E-14 L157-161 | ○ |

### FileSystemRights 列挙型 (UT-FSAC-129 〜 135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | ReadData = ListDirectory | E-06 L11-12 | ○ |
| C-130 | WriteData = CreateFiles | E-06 L13-14 | ○ |
| C-131 | AppendData = CreateDirectories | E-06 L15-16 | ○ |
| C-132 | ExecuteFile = Traverse | E-06 L19-20 | ○ |
| C-133 | Read複合フラグ | E-06 L40 | ○ |
| C-134 | Write複合フラグ | E-06 L42 | ○ |
| C-135 | FullControl複合フラグ | E-06 L34 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-FSAC-049, UT-FSAC-050**: `GetAccessControlSectionsFromChanges` および `Persist` メソッドは内部（internal）メソッドであり、直接の単体テストは困難。統合テストまたはリフレクションによるテストが必要
  - 候補：統合テスト / InternalsVisibleTo / リフレクション
- **UT-FSAC-094**: `GetFileAccessFromRights` はプライベートメソッドであり、直接テストは困難
  - 候補：Create拡張メソッド経由の間接テスト / リフレクション

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: FileSystemRights列挙型のフラグ値確認テスト（UT-FSAC-129〜135）
- **1（中リスク）**: 内部メソッドのテスト（UT-FSAC-049, 050, 094）- テスト方法の検討が必要
- **0（低リスク）**: その他のpublic API テスト - ソースコードおよび既存テストコードから十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] FileSecurity/DirectorySecurityのコンストラクタテストがエラーハンドリングを網羅しているか確認
- [ ] FileSystemAccessRule.AccessMaskFromRightsのSynchronizeビット処理ロジックが正しくテストされているか確認
- [ ] FileSystemAclExtensions.CreateメソッドのFileMode/FileSystemRights組み合わせテストが網羅的か確認
- [ ] DirectoryObjectSecurityの継承フラグ付きルール削除時のInvalidOperationExceptionテストを確認
- [ ] 内部メソッド（GetAccessControlSectionsFromChanges, Persist, GetFileAccessFromRights）のテスト方針を決定
