---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.IO.FileSystem.DriveInfo 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコード・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/src/System/IO/DriveInfo.cs`（共通実装：コンストラクタ、Name、IsReady、RootDirectory、ToString）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/src/System/IO/DriveInfo.Windows.cs`（Windows固有実装：DriveType、DriveFormat、AvailableFreeSpace、TotalFreeSpace、TotalSize、VolumeLabel、GetDrives）
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/src/System/IO/DriveInfo.Unix.cs`（Unix固有実装：DriveType、DriveFormat、AvailableFreeSpace、TotalFreeSpace、TotalSize、CheckStatfsResultAndThrowIfNecessary、ThrowForError）
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/src/System/IO/DriveInfo.UnixOrDefault.cs`（Unix/Default共通：GetDrives、NormalizeDriveName、VolumeLabel）
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/src/System/IO/DriveInfo.Default.cs`（Browser/Default実装：DriveType、DriveFormat、AvailableFreeSpace、TotalFreeSpace、TotalSize）
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/src/System/IO/DriveType.cs`（DriveType列挙型定義）
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/src/System/IO/DriveNotFoundException.cs`（DriveNotFoundException例外クラス）
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/src/System/IO/Error.cs`（Errorヘルパークラス：GetExceptionForLastWin32DriveError、GetExceptionForWin32DriveError）
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/ref/System.IO.FileSystem.DriveInfo.cs`（公開API定義）
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/tests/DriveInfo.Windows.Tests.cs`（Windows向け既存テスト）
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/tests/DriveInfo.Unix.Tests.cs`（Unix向け既存テスト）
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.FileSystem.DriveInfo/tests/VirtualDrives.Windows.Tests.cs`（仮想ドライブ向け既存テスト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DriveInfo(string)正常系（Windows） | E-01, E-02, E-10 | ○ |
| C-02 | DriveInfo(string)正常系（Unix） | E-01, E-04, E-11 | ○ |
| C-03 | DriveInfo(string)異常系：null | E-01, E-10, E-11 | ○ |
| C-04 | DriveInfo(string)異常系：空文字 | E-04, E-10, E-11 | ○ |
| C-05 | DriveInfo(string)異常系：NUL文字 | E-04, E-11 | ○ |
| C-06 | DriveInfo(string)異常系：無効形式（Windows） | E-10 | ○ |
| C-07 | Nameプロパティ | E-01 | ○ |
| C-08 | IsReady正常系：有効ドライブ | E-01, E-10, E-11 | ○ |
| C-09 | IsReady正常系：無効ドライブ | E-01, E-10, E-11 | ○ |
| C-10 | RootDirectory | E-01, E-10, E-11 | ○ |
| C-11 | ToString() | E-01, E-10, E-11 | ○ |
| C-12 | DriveType正常系：Fixed（Windows） | E-02, E-10 | ○ |
| C-13 | DriveType正常系：Fixed（Unix） | E-03, E-11 | ○ |
| C-14 | DriveType正常系：無効ドライブ | E-02, E-03, E-10, E-11 | ○ |
| C-15 | DriveType正常系：CDRom | E-02, E-06 | ○ |
| C-16 | DriveType正常系：Network | E-02, E-06 | ○ |
| C-17 | DriveFormat正常系（Windows） | E-02, E-10 | ○ |
| C-18 | DriveFormat正常系（Unix） | E-03, E-11 | ○ |
| C-19 | DriveFormat異常系：DriveNotFoundException | E-02, E-03, E-10, E-11 | ○ |
| C-20 | AvailableFreeSpace正常系 | E-02, E-03, E-10, E-11 | ○ |
| C-21 | AvailableFreeSpace異常系：DriveNotFoundException | E-02, E-03, E-10, E-11 | ○ |
| C-22 | AvailableFreeSpace異常系：AppContainer | E-02, E-10 | ○ |
| C-23 | TotalFreeSpace正常系 | E-02, E-03, E-10, E-11 | ○ |
| C-24 | TotalFreeSpace異常系：DriveNotFoundException | E-02, E-03, E-10, E-11 | ○ |
| C-25 | TotalSize正常系 | E-02, E-03, E-10, E-11 | ○ |
| C-26 | TotalSize異常系：DriveNotFoundException | E-02, E-03, E-10, E-11 | ○ |
| C-27 | TotalSize境界値：固定ドライブ | E-02, E-10 | ○ |
| C-28 | VolumeLabel(get)正常系（Windows） | E-02, E-10 | ○ |
| C-29 | VolumeLabel(get)正常系（Unix） | E-04, E-11 | ○ |
| C-30 | VolumeLabel(get)異常系：DriveNotFoundException（Windows） | E-02, E-10 | ○ |
| C-31 | VolumeLabel(set)正常系（Windows） | E-02, E-10 | ○ |
| C-32 | VolumeLabel(set)正常系：null（Windows） | E-02, E-09 | ○ |
| C-33 | VolumeLabel(set)異常系：PlatformNotSupportedException（Unix） | E-04, E-11 | ○ |
| C-34 | VolumeLabel(set)異常系：UnauthorizedAccessException | E-02, E-10 | ○ |
| C-35 | VolumeLabel(set)異常系：Network/CDRom | E-02, E-10 | ○ |
| C-36 | VolumeLabel(set)異常系：仮想ドライブ | E-12 | ○ |
| C-37 | GetDrives()正常系（Windows） | E-02, E-10 | ○ |
| C-38 | GetDrives()正常系（Unix） | E-04, E-11 | ○ |
| C-39 | GetDrives()配列要素検証 | E-02, E-04, E-10, E-11 | ○ |
| C-40 | ISerializable.GetObjectData | E-01 | ○ |
| C-41 | DriveNotFoundException() | E-07 | ○ |
| C-42 | DriveNotFoundException(string) | E-07 | ○ |
| C-43 | DriveNotFoundException(string)：null | E-07 | ○ |
| C-44 | DriveNotFoundException(string, Exception) | E-07 | ○ |
| C-45 | DriveNotFoundException.HResult | E-07 | ○ |
| C-46 | DriveType.Unknown | E-06, E-09 | ○ |
| C-47 | DriveType.NoRootDirectory | E-06, E-09 | ○ |
| C-48 | DriveType.Removable | E-06, E-09 | ○ |
| C-49 | DriveType.Fixed | E-06, E-09 | ○ |
| C-50 | DriveType.Network | E-06, E-09 | ○ |
| C-51 | DriveType.CDRom | E-06, E-09 | ○ |
| C-52 | DriveType.Ram | E-06, E-09 | ○ |
| C-53 | Error.GetExceptionForLastWin32DriveError：ERROR_PATH_NOT_FOUND | E-08 | ○ |
| C-54 | Error.GetExceptionForLastWin32DriveError：ERROR_INVALID_DRIVE | E-08 | ○ |
| C-55 | Error.GetExceptionForWin32DriveError：その他エラー | E-08 | ○ |
| C-56 | CheckStatfsResultAndThrowIfNecessary(Error)：SUCCESS | E-03 | ○ |
| C-57 | CheckStatfsResultAndThrowIfNecessary(Error)：ENOENT | E-03 | ○ |
| C-58 | CheckStatfsResultAndThrowIfNecessary(int)：非0 | E-03 | ○ |
| C-59 | NormalizeDriveName（Windows） | E-02, E-10 | ○ |
| C-60 | NormalizeDriveName（Unix） | E-04, E-11 | ○ |
| C-61 | DriveType境界値：ELOOP（Unix） | E-03 | ○ |
| C-62 | DriveType境界値：ENAMETOOLONG（Unix） | E-03 | ○ |
| C-63 | DriveType境界値：ENOTDIR（Unix） | E-03 | ○ |
| C-64 | DriveType境界値：その他エラー（Unix） | E-03 | ○ |
| C-65 | AvailableFreeSpace境界値：Browser | E-05, E-11 | ○ |
| C-66 | TotalFreeSpace境界値：Browser | E-05, E-11 | ○ |
| C-67 | TotalSize境界値：Browser | E-05, E-11 | ○ |
| C-68 | DriveFormat境界値：Browser | E-05 | ○ |
| C-69 | DriveType境界値：Browser | E-05, E-11 | ○ |
| C-70 | GetDrives()境界値：Browser | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべてのテストケースはソースコードまたは既存テストコードを根拠として生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースは実装コードを直接参照して生成されており、既存テストとの整合性も確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] 各プラットフォーム（Windows/Unix/Browser）固有の動作が正しく分離されているか確認
- [ ] 例外処理のテストケースが網羅的か確認（DriveNotFoundException、ArgumentException、PlatformNotSupportedException等）
- [ ] ディスク容量関連プロパティ（AvailableFreeSpace、TotalFreeSpace、TotalSize）の境界値テストが適切か確認
- [ ] VolumeLabel設定の権限関連テストが環境依存を考慮しているか確認
- [ ] DriveType列挙型の全値がテストされているか確認
- [ ] 内部クラス（Error）のテストケースが必要か判断（internalのためテスト不可の可能性あり）
