---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.IO.FileSystem.Watcher 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-FSW-098 Site(set)のDesignMode動作**：デザインモードの動作は環境依存で検証困難
  2. **UT-FSW-100 IsSuspendedのDesignMode判定**：デザインモード判定はComponent基底クラスに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` - メインクラス実装
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemEventArgs.cs` - イベント引数クラス
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/RenamedEventArgs.cs` - 名前変更イベント引数クラス
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/ErrorEventArgs.cs` - エラーイベント引数クラス
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/WaitForChangedResult.cs` - 待機結果構造体
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/InternalBufferOverflowException.cs` - 例外クラス
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/NotifyFilters.cs` - 通知フィルタ列挙型
- E-08: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/WatcherChangeTypes.cs` - 変更タイプ列挙型
- E-09: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Win32.cs` - Windows固有実装
- E-10: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` - Linux固有実装
- E-11: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.OSX.cs` - macOS固有実装
- E-12: `src/libraries/System.IO.FileSystem.Watcher/src/System/HResults.cs` - HResult定数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パラメータなしコンストラクタで_directoryが空文字列で初期化される | E-01 (line 76-79) | ○ |
| C-02 | コンストラクタ(path)でCheckPathValidityが呼ばれる | E-01 (line 85-89) | ○ |
| C-03 | CheckPathValidityでnullチェックが行われる | E-01 (line 361) | ○ |
| C-04 | CheckPathValidityで空文字列チェックが行われる | E-01 (line 364-365) | ○ |
| C-05 | CheckPathValidityで存在確認チェックが行われる | E-01 (line 367-368) | ○ |
| C-06 | コンストラクタ(path, filter)でfilterのnullチェックが行われる | E-01 (line 98) | ○ |
| C-07 | NotifyFilter setで無効値チェックが行われる | E-01 (line 115-116) | ○ |
| C-08 | NotifyFilter変更時にRestartが呼ばれる | E-01 (line 122) | ○ |
| C-09 | FilterプロパティgetでFilters.Count==0なら"*"を返す | E-01 (line 170) | ○ |
| C-10 | FilterプロパティsetでFiltersがクリアされる | E-01 (line 174-175) | ○ |
| C-11 | EnableRaisingEventsがtrueでStartRaisingEventsIfNotDisposedが呼ばれる | E-01 (line 153) | ○ |
| C-12 | EnableRaisingEventsがfalseでStopRaisingEventsが呼ばれる | E-01 (line 157) | ○ |
| C-13 | IncludeSubdirectories変更時にRestartが呼ばれる | E-01 (line 194) | ○ |
| C-14 | InternalBufferSizeのデフォルト値が8192 | E-01 (line 42) | ○ |
| C-15 | InternalBufferSizeが4096未満の場合4096に丸められる | E-01 (line 212-214) | ○ |
| C-16 | Pathプロパティsetでnullは空文字列として扱われる | E-01 (line 239) | ○ |
| C-17 | Pathプロパティsetで空文字列チェックが行われる | E-01 (line 242-243) | ○ |
| C-18 | Pathプロパティsetで存在確認チェックが行われる | E-01 (line 245-246) | ○ |
| C-19 | Path変更時にRestartが呼ばれる | E-01 (line 249) | ○ |
| C-20 | Disposeで各イベントハンドラがnullに設定される | E-01 (line 341-345) | ○ |
| C-21 | StartRaisingEventsIfNotDisposedでObjectDisposedException確認 | E-01 (line 638) | ○ |
| C-22 | WaitForChangedでTaskCompletionSourceを使用した待機 | E-01 (line 538) | ○ |
| C-23 | WaitForChangedでタイムアウト付き待機が可能 | E-01 (line 533-609) | ○ |
| C-24 | ToTimeoutMillisecondsで負値チェックが行われる | E-01 (line 617) | ○ |
| C-25 | ToTimeoutMillisecondsで最大値チェックが行われる | E-01 (line 618) | ○ |
| C-26 | BeginInitで_initializingがtrueに設定される | E-01 (line 666) | ○ |
| C-27 | EndInitで_initializingがfalseに設定される | E-01 (line 671) | ○ |
| C-28 | IsSuspendedで_initializingまたはDesignModeをチェック | E-01 (line 679) | ○ |
| C-29 | NormalizedFilterCollectionで空文字列が"*"に正規化される | E-01 (line 690) | ○ |
| C-30 | NormalizedFilterCollectionで"*.*"が"*"に正規化される | E-01 (line 690) | ○ |
| C-31 | MatchPatternでFiltersが空の場合trueを返す | E-01 (line 381-382) | ○ |
| C-32 | MatchPatternで空のファイル名はfalseを返す | E-01 (line 377-378) | ○ |
| C-33 | GetHandlerでCreatedに対応するハンドラを返す | E-01 (line 424-425) | ○ |
| C-34 | GetHandlerでDeletedに対応するハンドラを返す | E-01 (line 426-427) | ○ |
| C-35 | GetHandlerでChangedに対応するハンドラを返す | E-01 (line 428-429) | ○ |
| C-36 | FileSystemEventArgsコンストラクタでdirectoryのnullチェック | E-02 (line 20) | ○ |
| C-37 | FileSystemEventArgs.Combineでパス結合が行われる | E-02 (line 35-42) | ○ |
| C-38 | FileSystemEventArgs.Combineでセパレータ処理が行われる | E-02 (line 37-41) | ○ |
| C-39 | RenamedEventArgsがFileSystemEventArgsを継承 | E-03 (line 9) | ○ |
| C-40 | RenamedEventArgsでOldFullPathがCombineで生成される | E-03 (line 21) | ○ |
| C-41 | ErrorEventArgsコンストラクタでexceptionが設定される | E-04 (line 16-18) | ○ |
| C-42 | ErrorEventArgs.GetExceptionで例外が取得できる | E-04 (line 24-27) | ○ |
| C-43 | WaitForChangedResult構造体のプロパティが設定可能 | E-05 (line 19-22) | ○ |
| C-44 | WaitForChangedResult.TimedOutResultがタイムアウト状態を表す | E-05 (line 16-17) | ○ |
| C-45 | InternalBufferOverflowExceptionのHResultが0x80131905 | E-06 (line 21), E-12 (line 42) | ○ |
| C-46 | InternalBufferOverflowExceptionのメッセージコンストラクタ | E-06 (line 27-30) | ○ |
| C-47 | InternalBufferOverflowExceptionの内部例外コンストラクタ | E-06 (line 36-39) | ○ |
| C-48 | NotifyFilters.FileNameが0x00000001 | E-07 (line 15) | ○ |
| C-49 | NotifyFilters.DirectoryNameが0x00000002 | E-07 (line 19) | ○ |
| C-50 | NotifyFilters.Attributesが0x00000004 | E-07 (line 23) | ○ |
| C-51 | NotifyFilters.Sizeが0x00000008 | E-07 (line 27) | ○ |
| C-52 | NotifyFilters.LastWriteが0x00000010 | E-07 (line 31) | ○ |
| C-53 | NotifyFilters.LastAccessが0x00000020 | E-07 (line 35) | ○ |
| C-54 | NotifyFilters.CreationTimeが0x00000040 | E-07 (line 39) | ○ |
| C-55 | NotifyFilters.Securityが0x00000100 | E-07 (line 43) | ○ |
| C-56 | WatcherChangeTypes.Createdが1 | E-08 (line 15) | ○ |
| C-57 | WatcherChangeTypes.Deletedが2 | E-08 (line 19) | ○ |
| C-58 | WatcherChangeTypes.Changedが4 | E-08 (line 23) | ○ |
| C-59 | WatcherChangeTypes.Renamedが8 | E-08 (line 27) | ○ |
| C-60 | WatcherChangeTypes.Allが15 | E-08 (line 32) | ○ |
| C-61 | Win32実装でSafeFileHandleを使用 | E-09 (line 32-37) | ○ |
| C-62 | Win32実装でThreadPoolBoundHandleを使用 | E-09 (line 58) | ○ |
| C-63 | Linux実装でinotifyを使用 | E-10 (line 148) | ○ |
| C-64 | Linux実装でChannelを使用したイベントキュー | E-10 (line 994) | ○ |
| C-65 | OSX実装でFSEventStreamを使用 | E-11 (line 320-327) | ○ |
| C-66 | OSX実装でCFRunLoopを使用 | E-11 (line 257) | ○ |
| C-67 | デフォルトNotifyFiltersがLastWrite|FileName|DirectoryName | E-01 (line 29) | ○ |
| C-68 | NotifyFilters有効マスクが定義されている | E-01 (line 54-61) | ○ |
| C-69 | OnChangedでSynchronizingObjectが考慮される | E-01 (line 490-494) | ○ |
| C-70 | OnErrorでSynchronizingObjectが考慮される | E-01 (line 506-510) | ○ |
| C-71 | OnRenamedでSynchronizingObjectが考慮される | E-01 (line 522-526) | ○ |
| C-72 | WaitForChanged内でEnableRaisingEventsが自動設定される | E-01 (line 574-578) | ○ |
| C-73 | WaitForChanged終了後にEnableRaisingEventsが元に戻される | E-01 (line 585) | ○ |
| C-74 | NotifyRenameEventArgsでパターンマッチが行われる | E-01 (line 413-414) | ○ |
| C-75 | NotifyFileSystemEventArgsでパターンマッチが行われる | E-01 (line 443) | ○ |
| C-76 | NotifyInternalBufferOverflowEventでエラーイベントが発火 | E-01 (line 396-402) | ○ |
| C-77 | CreateBufferOverflowExceptionでメッセージが設定される | E-01 (line 404-405) | ○ |
| C-78 | Restartで停止と開始が行われる | E-01 (line 627-633) | ○ |
| C-79 | ImmutableStringListでスレッドセーフな操作 | E-01 (line 706-772) | ○ |
| C-80 | ImmutableStringList.Insertで配列が新規作成される | E-01 (line 746-754) | ○ |
| C-81 | ImmutableStringList.RemoveAtで配列が新規作成される | E-01 (line 762-769) | ○ |
| C-82 | ImmutableStringList.Clearで空配列が設定される | E-01 (line 736) | ○ |
| C-83 | Win32でReadDirectoryChangesWを使用 | E-09 (line 185-193) | ○ |
| C-84 | Win32でバッファオーバーフロー検出が行われる | E-09 (line 264-268) | ○ |
| C-85 | Win32でParseEventBufferAndNotifyForEachが呼ばれる | E-09 (line 273) | ○ |
| C-86 | Win32でリネームイベントのペアリング処理が行われる | E-09 (line 311-356) | ○ |
| C-87 | Linux実装でIN_MASK_ADDを使用 | E-10 (line 250) | ○ |
| C-88 | Linux実装でWatchedDirectoryツリーを管理 | E-10 (line 1304-1392) | ○ |
| C-89 | Linux実装でinotify_add_watchを呼び出す | E-10 (line 258) | ○ |
| C-90 | Linux実装でinotify_rm_watchを呼び出す | E-10 (line 406) | ○ |
| C-91 | OSX実装でFSEventStreamCreateを使用 | E-11 (line 320-327) | ○ |
| C-92 | OSX実装でFSEventStreamStartを使用 | E-11 (line 355) | ○ |
| C-93 | OSX実装でFSEventStreamStopを使用 | E-11 (line 277) | ○ |
| C-94 | OSX実装でリネームペアリング処理が行われる | E-11 (line 488-524) | ○ |
| C-95 | OSX実装でShouldRescanOccurチェックが行われる | E-11 (line 609-618) | ○ |
| C-96 | OSX実装でFilterEventsが変更タイプを判定 | E-11 (line 568-607) | ○ |
| C-97 | Linux実装でTranslateFiltersがNotifyFiltersを変換 | E-10 (line 1245-1301) | ○ |
| C-98 | Site.DesignModeでEnableRaisingEventsがtrueになる | E-01 (line 654-655) | △ |
| C-99 | IsSuspendedでDesignModeが考慮される | E-01 (line 679) | ○ |
| C-100 | DesignModeプロパティはComponent基底クラスに依存 | なし（基底クラス依存） | △ |

## 4) 不足情報（Unknown / Missing）
- **DesignModeの動作確認**: Component基底クラスのDesignModeプロパティの動作はランタイム環境に依存し、単体テストでの検証が困難
  - 候補：モックISiteの使用 / デザインツールでの手動検証 / 統合テストでの検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 列挙型の値検証（UT-FSW-077〜091）
- 0: 低リスク - 基本的なプロパティ取得/設定（UT-FSW-011〜015, 021〜023）
- 1: 中リスク - イベント発火のタイミング検証（UT-FSW-029〜033）- 非同期動作のため再現性に注意
- 1: 中リスク - WaitForChangedのタイムアウト動作（UT-FSW-040〜043）- タイミング依存
- 2: 高リスク - プラットフォーム固有動作（Win32/Linux/OSX）- 環境依存テスト

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-FSW-002〜007, 016〜017, 024〜032, 044〜045）が適切にコンストラクタ・プロパティ・イベントをカバーしているか
- [ ] 境界値テストケース（UT-FSW-023, 052）の条件が正しいか
- [ ] 異常系テストケース（UT-FSW-003〜005, 007, 009, 025〜027, 042〜043, 045, 054）の期待例外が正しいか
- [ ] イベント発火テスト（UT-FSW-029〜038）のテスト観点が十分か
- [ ] プラットフォーム固有の動作差異が考慮されているか
