---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.IO.MemoryMappedFiles 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・APIリファレンス・既存テストなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-MMF-078**: Windows ERROR_LOCK_VIOLATIONリトライロジックの動作検証
  2. **UT-MMF-022, UT-MMF-036, UT-MMF-081**: 32ビット環境固有のテストケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedFile.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedFile.Windows.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedFile.Unix.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedViewStream.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedViewAccessor.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedView.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedView.Windows.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedView.Unix.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedFileAccess.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedFileOptions.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/System/IO/MemoryMappedFiles/MemoryMappedFileRights.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/Microsoft/Win32/SafeMemoryMappedFileHandle.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/src/Microsoft/Win32/SafeMemoryMappedViewHandle.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.IO.MemoryMappedFiles/ref/System.IO.MemoryMappedFiles.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-MMF-001) | CreateFromFile(string)で既存ファイルからMemoryMappedFileが作成される | E-01 (line 87-89) | ○ |
| C-02 (UT-MMF-002) | null pathでArgumentNullExceptionがスローされる | E-01 (line 109) | ○ |
| C-03 (UT-MMF-003) | FileMode.AppendでArgumentExceptionがスローされる | E-01 (line 112-115) | ○ |
| C-04 (UT-MMF-004) | FileMode.TruncateでArgumentExceptionがスローされる | E-01 (line 116-119) | ○ |
| C-05 (UT-MMF-005) | 空ファイルでcapacity=0の場合ArgumentExceptionがスローされる | E-01 (line 142-146) | ○ |
| C-06 (UT-MMF-006) | 空のmapNameでArgumentExceptionがスローされる | E-01 (line 517-520) | ○ |
| C-07 (UT-MMF-007) | 負のcapacityでArgumentOutOfRangeExceptionがスローされる | E-01 (line 522-525) | ○ |
| C-08 (UT-MMF-008) | Write accessでArgumentExceptionがスローされる | E-01 (line 533-536) | ○ |
| C-09 (UT-MMF-009) | 無効なaccess値でArgumentOutOfRangeExceptionがスローされる | E-01 (line 527-531) | ○ |
| C-10 (UT-MMF-010) | SafeFileHandleからMemoryMappedFileが作成される | E-01 (line 208-235) | ○ |
| C-11 (UT-MMF-011) | null fileHandleでArgumentNullExceptionがスローされる | E-01 (line 212) | ○ |
| C-12 (UT-MMF-012) | 無効なinheritabilityでArgumentOutOfRangeExceptionがスローされる | E-01 (line 221-224) | ○ |
| C-13 (UT-MMF-013) | FileStreamからMemoryMappedFileが作成される | E-01 (line 237-268) | ○ |
| C-14 (UT-MMF-014) | null fileStreamでArgumentNullExceptionがスローされる | E-01 (line 241) | ○ |
| C-15 (UT-MMF-015) | FileStreamがFlushされてからマッピングされる | E-01 (line 256) | ○ |
| C-16 (UT-MMF-016) | 匿名メモリマップドファイルが作成される | E-01 (line 272-276) | ○ |
| C-17 (UT-MMF-017) | capacity=0でArgumentOutOfRangeExceptionがスローされる | E-01 (line 293) | ○ |
| C-18 (UT-MMF-018) | 負のcapacityでArgumentOutOfRangeExceptionがスローされる | E-01 (line 293) | ○ |
| C-19 (UT-MMF-019) | Write accessでArgumentExceptionがスローされる | E-01 (line 306-309) | ○ |
| C-20 (UT-MMF-020) | 無効なoptionsでArgumentOutOfRangeExceptionがスローされる | E-01 (line 311-314) | ○ |
| C-21 (UT-MMF-021) | 無効なinheritabilityでArgumentOutOfRangeExceptionがスローされる | E-01 (line 316-319) | ○ |
| C-22 (UT-MMF-022) | 32ビット環境でuint.MaxValueより大きいcapacityで例外 | E-01 (line 295-298) | ○ |
| C-23 (UT-MMF-023) | 既存の名前付きマップが開かれる（Windows） | E-01 (line 48-77), E-02 | ○ |
| C-24 (UT-MMF-024) | null/空のmapNameでArgumentExceptionがスローされる | E-01 (line 63) | ○ |
| C-25 (UT-MMF-025) | 無効なdesiredAccessRightsで例外がスローされる | E-01 (line 70-73) | ○ |
| C-26 (UT-MMF-026) | 無効なinheritabilityで例外がスローされる | E-01 (line 65-68) | ○ |
| C-27 (UT-MMF-027) | 新規マップが作成される（Windows） | E-01 (line 329-384), E-02 (line 93-177) | ○ |
| C-28 (UT-MMF-028) | 既存マップが開かれる（Windows） | E-02 (line 93-177) | ○ |
| C-29 (UT-MMF-029) | null/空のmapNameでArgumentExceptionがスローされる | E-01 (line 348) | ○ |
| C-30 (UT-MMF-030) | capacity=0でArgumentOutOfRangeExceptionがスローされる | E-01 (line 350) | ○ |
| C-31 (UT-MMF-031) | デフォルトパラメータでViewStreamが作成される | E-01 (line 387-389) | ○ |
| C-32 (UT-MMF-032) | 指定オフセットとサイズでViewStreamが作成される | E-01 (line 392-395) | ○ |
| C-33 (UT-MMF-033) | 負のoffsetでArgumentOutOfRangeExceptionがスローされる | E-01 (line 399) | ○ |
| C-34 (UT-MMF-034) | 負のsizeでArgumentOutOfRangeExceptionがスローされる | E-01 (line 401-404) | ○ |
| C-35 (UT-MMF-035) | 無効なaccess値でArgumentOutOfRangeExceptionがスローされる | E-01 (line 406-409) | ○ |
| C-36 (UT-MMF-036) | 32ビット環境でuint.MaxValueより大きいsizeで例外 | E-01 (line 411-414) | ○ |
| C-37 (UT-MMF-037) | デフォルトパラメータでViewAccessorが作成される | E-01 (line 421-423) | ○ |
| C-38 (UT-MMF-038) | 指定オフセットとサイズでViewAccessorが作成される | E-01 (line 426-429) | ○ |
| C-39 (UT-MMF-039) | 負のoffsetでArgumentOutOfRangeExceptionがスローされる | E-01 (line 433) | ○ |
| C-40 (UT-MMF-040) | 負のsizeでArgumentOutOfRangeExceptionがスローされる | E-01 (line 435-438) | ○ |
| C-41 (UT-MMF-041) | 無効なaccess値でArgumentOutOfRangeExceptionがスローされる | E-01 (line 440-443) | ○ |
| C-42 (UT-MMF-042) | リソースが正しく解放される | E-01 (line 454-476) | ○ |
| C-43 (UT-MMF-043) | leaveOpen=trueの場合ファイルハンドルが解放されない | E-01 (line 471-474) | ○ |
| C-44 (UT-MMF-044) | leaveOpen=falseの場合ファイルハンドルも解放される | E-01 (line 471-474) | ○ |
| C-45 (UT-MMF-045) | 有効なハンドルが取得できる | E-01 (line 478-481) | ○ |
| C-46 (UT-MMF-046) | ReadアクセスがFileAccess.Readに変換される | E-01 (line 486-503) | ○ |
| C-47 (UT-MMF-047) | ReadWriteアクセスがFileAccess.ReadWriteに変換される | E-01 (line 486-503) | ○ |
| C-48 (UT-MMF-048) | CopyOnWriteアクセスがFileAccess.ReadWriteに変換される | E-01 (line 486-503) | ○ |
| C-49 (UT-MMF-049) | WriteアクセスがFileAccess.Writeに変換される | E-01 (line 486-503) | ○ |
| C-50 (UT-MMF-050) | MemoryMappedViewからストリームが初期化される | E-04 (line 13-19) | ○ |
| C-51 (UT-MMF-051) | 有効なビューハンドルが取得できる | E-04 (line 21) | ○ |
| C-52 (UT-MMF-052) | 正しいポインタオフセットが取得できる | E-04 (line 23) | ○ |
| C-53 (UT-MMF-053) | 負の値でArgumentOutOfRangeExceptionがスローされる | E-04 (line 27) | ○ |
| C-54 (UT-MMF-054) | 正の値でNotSupportedExceptionがスローされる | E-04 (line 29) | ○ |
| C-55 (UT-MMF-055) | 変更がフラッシュされる | E-04 (line 60-68) | ○ |
| C-56 (UT-MMF-056) | Dispose済みでObjectDisposedExceptionがスローされる | E-04 (line 62-65) | ○ |
| C-57 (UT-MMF-057) | 書き込み可能な場合Flushが呼ばれる | E-04 (line 37-39) | ○ |
| C-58 (UT-MMF-058) | 基底クラスのDisposeが呼ばれる | E-04 (line 50) | ○ |
| C-59 (UT-MMF-059) | MemoryMappedViewからアクセサが初期化される | E-05 (line 13-19) | ○ |
| C-60 (UT-MMF-060) | 有効なビューハンドルが取得できる | E-05 (line 21-24) | ○ |
| C-61 (UT-MMF-061) | 正しいポインタオフセットが取得できる | E-05 (line 26-29) | ○ |
| C-62 (UT-MMF-062) | 変更がフラッシュされる | E-05 (line 60-68) | ○ |
| C-63 (UT-MMF-063) | Dispose済みでObjectDisposedExceptionがスローされる | E-05 (line 62-65) | ○ |
| C-64 (UT-MMF-064) | 書き込み可能な場合Flushが呼ばれる | E-05 (line 37-39) | ○ |
| C-65 (UT-MMF-065) | 基底クラスのDisposeが呼ばれる | E-05 (line 50) | ○ |
| C-66 (UT-MMF-066) | オフセットとサイズがページ境界に調整される（Unix） | E-08 (line 31-42) | ○ |
| C-67 (UT-MMF-067) | capacityを超えるoffsetで例外がスローされる（Unix） | E-08 (line 15) | ○ |
| C-68 (UT-MMF-068) | offset+sizeがcapacityを超える場合例外（Unix） | E-08 (line 20-23) | ○ |
| C-69 (UT-MMF-069) | Dispose済みハンドルで例外がスローされる（Unix） | E-08 (line 24) | ○ |
| C-70 (UT-MMF-070) | ビュー権限がマップ権限を超える場合例外（Unix） | E-08 (line 69-74) | ○ |
| C-71 (UT-MMF-071) | CopyOnWriteの場合MAP_PRIVATEフラグが設定される（Unix） | E-08 (line 45-48) | ○ |
| C-72 (UT-MMF-072) | size=0の場合匿名マッピングが作成される（Unix） | E-08 (line 91-107) | ○ |
| C-73 (UT-MMF-073) | MapViewOfFileが正しく呼び出される（Windows） | E-07 (line 37-43) | ○ |
| C-74 (UT-MMF-074) | DelayAllocatePagesオプションでMEM_COMMITが呼び出される（Windows） | E-07 (line 60-75) | ○ |
| C-75 (UT-MMF-075) | MSyncが正しく呼び出される（Unix） | E-08 (line 130-154) | ○ |
| C-76 (UT-MMF-076) | capacity=0の場合何もしない（Unix） | E-08 (line 132-133) | ○ |
| C-77 (UT-MMF-077) | FlushViewOfFileが正しく呼び出される（Windows） | E-07 (line 103) | ○ |
| C-78 (UT-MMF-078) | ERROR_LOCK_VIOLATIONでリトライが実行される（Windows） | E-07 (line 106-137) | △ |
| C-79 (UT-MMF-079) | オフセットがallocationGranularityの倍数に調整される | E-06 (line 71-90) | ○ |
| C-80 (UT-MMF-080) | サイズが調整後のオフセット分増加する | E-06 (line 71-90) | ○ |
| C-81 (UT-MMF-081) | 32ビット環境で調整後サイズがuint.MaxValueを超える場合例外 | E-06 (line 86-89) | ○ |
| C-82 (UT-MMF-082) | ビューハンドルが正しく解放される | E-06 (line 46-54) | ○ |
| C-83 (UT-MMF-083) | Dispose前はfalseが返却される | E-06 (line 56-59) | ○ |
| C-84 (UT-MMF-084) | Dispose後はtrueが返却される | E-06 (line 56-59) | ○ |
| C-85 (UT-MMF-085) | ReadアクセスがPROT_READに変換される（Unix） | E-08 (line 175-208) | ○ |
| C-86 (UT-MMF-086) | ReadWriteアクセスがPROT_READ|PROT_WRITEに変換される（Unix） | E-08 (line 175-208) | ○ |
| C-87 (UT-MMF-087) | CopyOnWriteでforVerification=trueの場合PROT_READのみ（Unix） | E-08 (line 203-206) | ○ |
| C-88 (UT-MMF-088) | CopyOnWriteでforVerification=falseの場合PROT_READ|PROT_WRITE（Unix） | E-08 (line 203-206) | ○ |
| C-89 (UT-MMF-089) | SafeMemoryMappedFileHandleがownsHandle=trueで初期化される | E-12 (line 13-16) | ○ |
| C-90 (UT-MMF-090) | ゼロまたは-1の場合trueが返却される | E-14 (line 12) | ○ |
| C-91 (UT-MMF-091) | 有効なハンドル値の場合falseが返却される | E-14 (line 12) | ○ |
| C-92 (UT-MMF-092) | ネイティブハンドルが解放される | E-14 (line 13) | △ |
| C-93 (UT-MMF-093) | SafeBufferとして初期化される | E-13 (line 10-13) | ○ |
| C-94 (UT-MMF-094) | ビューがアンマップされる | E-14 (line 18) | ○ |
| C-95 (UT-MMF-095) | ReadWriteが0である | E-09 (line 8) | ○ |
| C-96 (UT-MMF-096) | すべての列挙値が一意である | E-09 (line 6-14) | ○ |
| C-97 (UT-MMF-097) | Noneが0である | E-10 (line 9) | ○ |
| C-98 (UT-MMF-098) | DelayAllocatePagesが0x4000000である | E-10 (line 10) | ○ |
| C-99 (UT-MMF-099) | ReadWriteがRead|Writeである | E-11 (line 21) | ○ |
| C-100 (UT-MMF-100) | FullControlが全権限の組み合わせである | E-11 (line 25-26) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-MMF-078**: ERROR_LOCK_VIOLATIONリトライロジックのテストは実際のNTFSトランザクションログ競合状態を再現することが難しい
  - 候補：モック / 統合テスト / 手動テスト
- **UT-MMF-092**: ReleaseHandleの具体的な実装はプラットフォーム固有ファイルに分散している
  - 候補：Windows実装ファイル / Unix実装ファイル の確認が必要

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 列挙型の値確認テスト（UT-MMF-095〜100）
- **1（中リスク）**: プラットフォーム固有機能のテスト（Windows専用API: OpenExisting, CreateOrOpen）
- **1（中リスク）**: 32ビット環境固有のテスト（IntPtr.Size == 4の分岐）
- **2（高リスク）**: リトライロジックのテスト（ERROR_LOCK_VIOLATION処理）- 再現が困難

## 6) レビュアーチェックリスト（最小）
- [ ] 全テストケースでテストID（UT-MMF-XXX）が連番で重複がないことを確認
- [ ] ファクトリメソッド（CreateFromFile, CreateNew, CreateOrOpen, OpenExisting）の異常系テストが網羅されていることを確認
- [ ] プラットフォーム固有テスト（Unix/Windows）が適切に分類されていることを確認
- [ ] Dispose/リソース解放のテストケースが含まれていることを確認
- [ ] 境界値テスト（capacity=0, size=-1, offset=-1等）が含まれていることを確認
- [ ] MemoryMappedViewStream/MemoryMappedViewAccessorの主要メソッドがカバーされていることを確認
