---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 175
  claims_with_evidence: 168
  claims_without_evidence: 7
confidence_derived: 0.96
---

# 根拠レポート：libraries-System.IO.Packaging 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・クラス定義が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：168 / 175、根拠なし：7
- 優先レビュー（高）
  1. **UT-PKG-093〜097（ZipPackage内部メソッド）**：internal/protectedメソッドのため直接テスト可能性要確認
  2. **UT-PKG-126〜128（ZipStreamManager）**：internal クラスのためテストアプローチ要検討
  3. **UT-PKG-174〜175（スケーラビリティテスト）**：具体的な境界値の妥当性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/Package.cs` - Package抽象クラス定義（715行）
- E-02: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/PackagePart.cs` - PackagePart抽象クラス定義（303行）
- E-03: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/ZipPackage.cs` - ZipPackage実装クラス（456行）
- E-04: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/ZipPackagePart.cs` - ZipPackagePart実装クラス（131行）
- E-05: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/PackageRelationship.cs` - PackageRelationshipクラス定義（115行）
- E-06: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/PackUriHelper.cs` - PackUriHelperユーティリティ（600+行）
- E-07: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/PackageRelationshipCollection.cs` - リレーションシップコレクション（189行）
- E-08: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/PackageRelationshipSelector.cs` - リレーションシップセレクタ（171行）
- E-09: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/PackagePartCollection.cs` - パートコレクション（67行）
- E-10: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/PackageProperties.cs` - パッケージプロパティ抽象クラス（223行）
- E-11: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/ContentType.cs` - ContentType内部クラス（532行）
- E-12: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/InternalRelationshipCollection.cs` - 内部リレーションシップコレクション（650行）
- E-13: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/ZipStreamManager.cs` - Zipストリーム管理（89行）
- E-14: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/InterleavedZipPackagePartStream.cs` - インターリーブストリーム（573行）
- E-15: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/CompressionOption.cs` - 圧縮オプション列挙型（37行）
- E-16: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/TargetMode.cs` - ターゲットモード列挙型（34行）
- E-17: `src/libraries/System.IO.Packaging/src/System/IO/Packaging/FileFormatException.cs` - ファイルフォーマット例外（162行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Package クラス（UT-PKG-001〜035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜06 | Package.Open各オーバーロード | E-01: Package.cs 38-148行 | ○ |
| C-07〜09 | Open異常系テスト | E-01: ArgumentNullException.ThrowIfNull使用 | ○ |
| C-10〜14 | CreatePart正常系/異常系 | E-01: CreatePart 160-220行 | ○ |
| C-15〜21 | GetPart, PartExists, DeletePart, GetParts | E-01: 各メソッド定義確認 | ○ |
| C-22〜31 | リレーションシップ操作 | E-01: CreateRelationship等 260-350行 | ○ |
| C-32〜35 | PackageProperties, Flush, Close, FileOpenAccess | E-01: 対応プロパティ/メソッド確認 | ○ |

### PackagePart クラス（UT-PKG-036〜047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36〜39 | プロパティ（Uri, ContentType, Package, CompressionOption） | E-02: PackagePart.cs 35-80行 | ○ |
| C-40〜42 | GetStream各オーバーロード | E-02: GetStream 90-150行 | ○ |
| C-43〜47 | リレーションシップ操作 | E-02: 180-280行 | ○ |

### PackageRelationship クラス（UT-PKG-048〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48〜53 | 全プロパティ | E-05: PackageRelationship.cs 全体 | ○ |

### PackUriHelper クラス（UT-PKG-054〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54〜56 | Create各オーバーロード | E-06: PackUriHelper.cs 50-150行 | ○ |
| C-57〜58 | GetPackageUri, GetPartUri | E-06: 160-230行 | ○ |
| C-59〜62 | リレーションシップパートURI操作 | E-06: 240-320行 | ○ |
| C-63〜65 | ComparePartUri | E-06: 330-380行 | ○ |
| C-66〜69 | ResolvePartUri, GetRelativeUri, ValidatePartUri | E-06: 390-500行 | ○ |

### コレクションクラス（UT-PKG-070〜074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70〜72 | PackageRelationshipCollection | E-07: 全体 | ○ |
| C-73〜74 | PackagePartCollection | E-09: 全体 | ○ |

### PackageRelationshipSelector クラス（UT-PKG-075〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75〜84 | コンストラクタ、Select、プロパティ | E-08: 全体 | ○ |

### PackageProperties クラス（UT-PKG-085〜092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85〜92 | 各プロパティ、Dispose | E-10: 全体（抽象クラス） | ○ |

### ZipPackage/ZipPackagePart クラス（UT-PKG-093〜099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93〜97 | ZipPackage内部メソッド | E-03: ZipPackage.cs（internal/protected） | △ |
| C-98〜99 | ZipPackagePart.GetStreamCore | E-04: ZipPackagePart.cs | ○ |

### ContentType クラス（UT-PKG-100〜111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100〜111 | コンストラクタ、プロパティ、メソッド | E-11: ContentType.cs 全体（internal） | ○ |

### InternalRelationshipCollection クラス（UT-PKG-112〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112〜125 | Add, GetRelationship, Delete, Clear, Flush等 | E-12: 全体（internal） | ○ |

### ZipStreamManager クラス（UT-PKG-126〜128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126〜128 | Open メソッド | E-13: ZipStreamManager.cs（internal） | △ |

### InterleavedZipPackagePartStream クラス（UT-PKG-129〜154）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129〜154 | Read, Write, Seek, SetLength, Position, Length等 | E-14: 全体（internal） | ○ |

### FileFormatException クラス（UT-PKG-155〜162）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155〜162 | 各コンストラクタ、SourceUriプロパティ | E-17: 全体 | ○ |

### 列挙型（UT-PKG-163〜169）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-163〜167 | CompressionOption各値 | E-15: CompressionOption.cs | ○ |
| C-168〜169 | TargetMode各値 | E-16: TargetMode.cs | ○ |

### 統合テスト（UT-PKG-170〜175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-170〜173 | Close/Dispose、読み書き、永続化 | E-01, E-02: 複合動作 | ○ |
| C-174〜175 | スケーラビリティ（1000件） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

1. **internalクラスのテスト可能性**
   - ContentType, InternalRelationshipCollection, ZipStreamManager, InterleavedZipPackagePartStreamはinternalクラス
   - InternalsVisibleToまたはリフレクション経由でのテストが必要
   - 候補：テストプロジェクトへのInternalsVisibleTo追加 / 公開APIを通じた間接テスト

2. **スケーラビリティテストの境界値**
   - 「1000件」という数値の根拠が不明
   - 候補：パフォーマンス要件定義書 / 既存テストコードの調査

3. **ZipPackageの派生クラス固有動作**
   - CreatePartCore, GetPartCore等はprotectedメソッド
   - 直接テストには継承クラスの作成が必要

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1: 中 | UT-PKG-093〜097 | internal/protectedメソッドのテスト方法要検討 |
| 1: 中 | UT-PKG-126〜128 | internalクラスZipStreamManagerのテスト方法 |
| 0: 低 | UT-PKG-174〜175 | 境界値1000の妥当性確認が必要 |
| 0: 低 | UT-PKG-100〜111 | internalクラスContentTypeは公開API経由でテスト可能 |

## 6) レビュアーチェックリスト（最小）

- [ ] Package.Open/CreatePart/DeletePartの正常系・異常系テストケースが網羅されているか
- [ ] PackageRelationshipの作成・取得・削除テストケースが適切か
- [ ] PackUriHelperの各メソッドのテストケースがRFC準拠か確認
- [ ] internalクラスのテスト戦略（InternalsVisibleTo等）が決定されているか
- [ ] InterleavedZipPackagePartStreamの複数ピース処理テストが十分か
- [ ] FileFormatExceptionのシリアライゼーションテストは.NETバージョン依存のため要確認
- [ ] スケーラビリティテストの境界値（1000件）の妥当性を確認
