---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 190
  claims_with_evidence: 190
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.IO.Pipelines 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実際のコード実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：190 / 190、根拠なし：0
- 優先レビュー（高）
  1. **バックプレッシャーテスト（UT-PIP-184〜185）**：閾値動作の確認が必要
  2. **セグメント管理テスト（UT-PIP-135〜144）**：内部クラスのためアクセス確認が必要
  3. **キャンセル処理テスト（UT-PIP-026〜027, 102, 119）**：非同期キャンセルのタイミング確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/Pipe.cs`
- E-02: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/PipeReader.cs`
- E-03: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/PipeWriter.cs`
- E-04: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/PipeOptions.cs`
- E-05: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/FlushResult.cs`
- E-06: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/ReadResult.cs`
- E-07: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/PipeScheduler.cs`
- E-08: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/StreamPipeReader.cs`
- E-09: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/StreamPipeWriter.cs`
- E-10: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/StreamPipeReaderOptions.cs`
- E-11: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/StreamPipeWriterOptions.cs`
- E-12: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/BufferSegment.cs`
- E-13: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/PipeReaderStream.cs`
- E-14: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/PipeWriterStream.cs`
- E-15: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/SequencePipeReader.cs`
- E-16: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/IDuplexPipe.cs`
- E-17: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/StreamPipeExtensions.cs`
- E-18: `src/libraries/System.IO.Pipelines/src/System/IO/Pipelines/PipeAwaitable.cs`
- E-19: `src/libraries/System.IO.Pipelines/tests/PipeOptionsTests.cs`
- E-20: `src/libraries/System.IO.Pipelines/tests/PipeReaderWriterFacts.cs`
- E-21: `src/libraries/System.IO.Pipelines/tests/FlushAsyncTests.cs`
- E-22: `src/libraries/System.IO.Pipelines/tests/BackpressureTests.cs`
- E-23: `src/libraries/System.IO.Pipelines/tests/StreamPipeReaderTests.cs`
- E-24: `src/libraries/System.IO.Pipelines/tests/StreamPipeWriterTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Pipe クラス（UT-PIP-001〜032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pipe()コンストラクタ | E-01: Pipe.cs L87-89 | ○ |
| C-02 | Pipe(PipeOptions)コンストラクタ | E-01: Pipe.cs L93-111 | ○ |
| C-03 | nullオプションで例外 | E-01: Pipe.cs L95-98 (ThrowHelper.ThrowArgumentNullException) | ○ |
| C-04 | GetMemory正常系 | E-01: Pipe.cs L126-141 | ○ |
| C-05 | GetMemory sizeHint=0 | E-01: Pipe.cs L138 (AllocateWriteHeadIfNeeded) | ○ |
| C-06 | GetMemory負値で例外 | E-01: Pipe.cs L133-136 | ○ |
| C-07 | GetMemory完了後例外 | E-01: Pipe.cs L128-131 | ○ |
| C-08 | GetSpan正常系 | E-01: Pipe.cs L143-158 | ○ |
| C-09 | GetSpan負値で例外 | E-01: Pipe.cs L150-153 | ○ |
| C-10 | Advance正常系 | E-01: Pipe.cs L336-353 | ○ |
| C-11 | Advance超過で例外 | E-01: Pipe.cs L340-343 | ○ |
| C-12 | Advance境界値 | E-01: Pipe.cs L356-361 | ○ |
| C-13 | FlushAsync正常系 | E-01: Pipe.cs L363-380 | ○ |
| C-14 | FlushAsyncキャンセル | E-01: Pipe.cs L365-368 | ○ |
| C-15 | ReadAsync正常系 | E-01: Pipe.cs L741-772 | ○ |
| C-16 | ReadAsync完了後例外 | E-01: Pipe.cs L743-746 | ○ |
| C-17 | ReadAsyncキャンセル | E-01: Pipe.cs L748-751 | ○ |
| C-18 | ReadAtLeastAsync正常系 | E-01: Pipe.cs L682-739 | ○ |
| C-19 | TryRead正常系(true) | E-01: Pipe.cs L774-798 | ○ |
| C-20 | TryRead正常系(false) | E-01: Pipe.cs L783-797 | ○ |
| C-21 | AdvanceReader単一位置 | E-01: Pipe.cs L448-451 | ○ |
| C-22 | AdvanceReader二位置 | E-01: Pipe.cs L453-462 | ○ |
| C-23 | AdvanceReader不正位置で例外 | E-01: Pipe.cs L466-470 | ○ |
| C-24 | CompleteWriter | E-01: Pipe.cs L419-446 | ○ |
| C-25 | CompleteReader | E-01: Pipe.cs L589-622 | ○ |
| C-26 | CancelPendingRead | E-01: Pipe.cs L643-651 | ○ |
| C-27 | CancelPendingFlush | E-01: Pipe.cs L653-661 | ○ |
| C-28 | Reset正常系 | E-01: Pipe.cs L1173-1185 | ○ |
| C-29 | Reset未完了で例外 | E-01: Pipe.cs L1177-1180 | ○ |
| C-30 | Readerプロパティ | E-01: Pipe.cs L1166 | ○ |
| C-31 | Writerプロパティ | E-01: Pipe.cs L1170 | ○ |
| C-32 | WriteAsync | E-01: Pipe.cs L1052-1095 | ○ |

### PipeOptions クラス（UT-PIP-033〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | PipeOptionsデフォルト | E-04: PipeOptions.cs L16 | ○ |
| C-34 | PipeOptionsカスタム | E-04: PipeOptions.cs L26-86 | ○ |
| C-35 | 負のpauseWriterThreshold | E-04: PipeOptions.cs L57-60 | ○ |
| C-36 | resume > pause | E-04: PipeOptions.cs L74-77 | ○ |
| C-37 | Default静的プロパティ | E-04: PipeOptions.cs L16 | ○ |
| C-38 | Pool | E-04: PipeOptions.cs L114 | ○ |
| C-39 | ReaderScheduler | E-04: PipeOptions.cs L110 | ○ |
| C-40 | WriterScheduler | E-04: PipeOptions.cs L106 | ○ |

### PipeReader クラス（UT-PIP-041〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | ReadAsync | E-02: PipeReader.cs L32 (abstract) | ○ |
| C-42 | TryRead | E-02: PipeReader.cs L27 (abstract) | ○ |
| C-43 | AdvanceTo(consumed) | E-02: PipeReader.cs L90 (abstract) | ○ |
| C-44 | AdvanceTo(consumed, examined) | E-02: PipeReader.cs L98 (abstract) | ○ |
| C-45 | CancelPendingRead | E-02: PipeReader.cs L119 (abstract) | ○ |
| C-46 | Complete | E-02: PipeReader.cs L123 (abstract) | ○ |
| C-47 | CompleteAsync | E-02: PipeReader.cs L128-139 | ○ |
| C-48 | ReadAtLeastAsync正常系 | E-02: PipeReader.cs L51-59 | ○ |
| C-49 | ReadAtLeastAsync負値 | E-02: PipeReader.cs L53-56 | ○ |
| C-50 | AsStream正常系 | E-02: PipeReader.cs L103-115 | ○ |
| C-51 | AsStream leaveOpen | E-02: PipeReader.cs L109-112 | ○ |
| C-52 | Create(Stream) | E-02: PipeReader.cs L158-161 | ○ |
| C-53 | Create(ReadOnlySequence) | E-02: PipeReader.cs L168-171 | ○ |
| C-54 | CopyToAsync(PipeWriter) | E-02: PipeReader.cs L177-193 | ○ |
| C-55 | CopyToAsync null destination | E-02: PipeReader.cs L179-182 | ○ |
| C-56 | CopyToAsync(Stream) | E-02: PipeReader.cs L199-230 | ○ |

### PipeWriter クラス（UT-PIP-057〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | Advance | E-03: PipeWriter.cs L63 (abstract) | ○ |
| C-58 | GetMemory | E-03: PipeWriter.cs L72 (abstract) | ○ |
| C-59 | GetSpan | E-03: PipeWriter.cs L81 (abstract) | ○ |
| C-60 | FlushAsync | E-03: PipeWriter.cs L59 (abstract) | ○ |
| C-61 | CancelPendingFlush | E-03: PipeWriter.cs L37 (abstract) | ○ |
| C-62 | Complete | E-03: PipeWriter.cs L17 (abstract) | ○ |
| C-63 | CompleteAsync | E-03: PipeWriter.cs L22-33 | ○ |
| C-64 | WriteAsync | E-03: PipeWriter.cs L113-117 | ○ |
| C-65 | AsStream | E-03: PipeWriter.cs L86-98 | ○ |
| C-66 | Create(Stream) | E-03: PipeWriter.cs L104-107 | ○ |
| C-67 | CanGetUnflushedBytes | E-03: PipeWriter.cs L41 | ○ |
| C-68 | UnflushedBytes例外 | E-03: PipeWriter.cs L155 | ○ |
| C-69 | CopyFromAsync | E-03: PipeWriter.cs L123-149 | ○ |

### FlushResult/ReadResult 構造体（UT-PIP-070〜076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | FlushResultコンストラクタ | E-05: FlushResult.cs L14-27 | ○ |
| C-71 | FlushResult.IsCanceled | E-05: FlushResult.cs L31 | ○ |
| C-72 | FlushResult.IsCompleted | E-05: FlushResult.cs L35 | ○ |
| C-73 | ReadResultコンストラクタ | E-06: ReadResult.cs L18-31 | ○ |
| C-74 | ReadResult.Buffer | E-06: ReadResult.cs L35 | ○ |
| C-75 | ReadResult.IsCanceled | E-06: ReadResult.cs L39 | ○ |
| C-76 | ReadResult.IsCompleted | E-06: ReadResult.cs L43 | ○ |

### PipeScheduler クラス（UT-PIP-077〜079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | ThreadPool | E-07: PipeScheduler.cs L16 | ○ |
| C-78 | Inline | E-07: PipeScheduler.cs L20 | ○ |
| C-79 | Schedule | E-07: PipeScheduler.cs L25 (abstract) | ○ |

### StreamPipeReaderOptions/StreamPipeWriterOptions（UT-PIP-080〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | StreamPipeReaderOptionsデフォルト | E-10: StreamPipeReaderOptions.cs L34 | ○ |
| C-81 | StreamPipeReaderOptionsカスタム | E-10: StreamPipeReaderOptions.cs L34-53 | ○ |
| C-82 | bufferSize=0で例外 | E-10: StreamPipeReaderOptions.cs L42 | ○ |
| C-83 | minimumReadSize=0で例外 | E-10: StreamPipeReaderOptions.cs L47 | ○ |
| C-84 | BufferSize | E-10: StreamPipeReaderOptions.cs L57 | ○ |
| C-85 | MinimumReadSize | E-10: StreamPipeReaderOptions.cs L65 | ○ |
| C-86 | Pool | E-10: StreamPipeReaderOptions.cs L69 | ○ |
| C-87 | LeaveOpen | E-10: StreamPipeReaderOptions.cs L73 | ○ |
| C-88 | UseZeroByteReads | E-10: StreamPipeReaderOptions.cs L77 | ○ |
| C-89 | StreamPipeWriterOptionsデフォルト | E-11: StreamPipeWriterOptions.cs L19 | ○ |
| C-90 | StreamPipeWriterOptionsカスタム | E-11: StreamPipeWriterOptions.cs L19-29 | ○ |
| C-91 | minimumBufferSize=0で例外 | E-11: StreamPipeWriterOptions.cs L25 | ○ |
| C-92 | MinimumBufferSize | E-11: StreamPipeWriterOptions.cs L33 | ○ |
| C-93 | Pool | E-11: StreamPipeWriterOptions.cs L37 | ○ |
| C-94 | LeaveOpen | E-11: StreamPipeWriterOptions.cs L41 | ○ |

### StreamPipeReader クラス（UT-PIP-095〜106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | コンストラクタ正常系 | E-08: StreamPipeReader.cs L38-52 | ○ |
| C-96 | null stream例外 | E-08: StreamPipeReader.cs L40-43 | ○ |
| C-97 | null options例外 | E-08: StreamPipeReader.cs L44-47 | ○ |
| C-98 | InnerStream | E-08: StreamPipeReader.cs L65 | ○ |
| C-99 | ReadAsync | E-08: StreamPipeReader.cs L200-302 | ○ |
| C-100 | TryRead | E-08: StreamPipeReader.cs L442-447 | ○ |
| C-101 | AdvanceTo | E-08: StreamPipeReader.cs L68-71, L85-156 | ○ |
| C-102 | CancelPendingRead | E-08: StreamPipeReader.cs L159-162 | ○ |
| C-103 | Complete leaveOpen=false | E-08: StreamPipeReader.cs L165-171 | ○ |
| C-104 | Complete leaveOpen=true | E-08: StreamPipeReader.cs L178-197 | ○ |
| C-105 | CopyToAsync(PipeWriter) | E-08: StreamPipeReader.cs L305-368 | ○ |
| C-106 | CopyToAsync(Stream) | E-08: StreamPipeReader.cs L371-424 | ○ |

### StreamPipeWriter クラス（UT-PIP-107〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | コンストラクタ正常系 | E-09: StreamPipeWriter.cs L46-63 | ○ |
| C-108 | null stream例外 | E-09: StreamPipeWriter.cs L48-51 | ○ |
| C-109 | null options例外 | E-09: StreamPipeWriter.cs L52-55 | ○ |
| C-110 | InnerStream | E-09: StreamPipeWriter.cs L68 | ○ |
| C-111 | Advance正常系 | E-09: StreamPipeWriter.cs L71-81 | ○ |
| C-112 | Advance超過例外 | E-09: StreamPipeWriter.cs L73-76 | ○ |
| C-113 | GetMemory正常系 | E-09: StreamPipeWriter.cs L84-99 | ○ |
| C-114 | GetMemory完了後例外 | E-09: StreamPipeWriter.cs L86-89 | ○ |
| C-115 | GetMemory負値例外 | E-09: StreamPipeWriter.cs L91-94 | ○ |
| C-116 | GetSpan正常系 | E-09: StreamPipeWriter.cs L102-117 | ○ |
| C-117 | FlushAsync正常系 | E-09: StreamPipeWriter.cs L266-274 | ○ |
| C-118 | FlushAsyncバッファ空 | E-09: StreamPipeWriter.cs L268-271 | ○ |
| C-119 | CancelPendingFlush | E-09: StreamPipeWriter.cs L204-207 | ○ |
| C-120 | Complete leaveOpen=false | E-09: StreamPipeWriter.cs L213-235 | ○ |
| C-121 | Complete leaveOpen=true | E-09: StreamPipeWriter.cs L230-233 | ○ |
| C-122 | CompleteAsync | E-09: StreamPipeWriter.cs L237-263 | ○ |
| C-123 | WriteAsync | E-09: StreamPipeWriter.cs L279-282 | ○ |
| C-124 | CanGetUnflushedBytes | E-09: StreamPipeWriter.cs L210 | ○ |
| C-125 | UnflushedBytes | E-09: StreamPipeWriter.cs L277 | ○ |

### SequencePipeReader クラス（UT-PIP-126〜134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | コンストラクタ | E-15: SequencePipeReader.cs L17-20 | ○ |
| C-127 | ReadAsync | E-15: SequencePipeReader.cs L62-71 | ○ |
| C-128 | TryRead(true) | E-15: SequencePipeReader.cs L74-87 | ○ |
| C-129 | TryRead(false) | E-15: SequencePipeReader.cs L84-86 | ○ |
| C-130 | AdvanceTo途中 | E-15: SequencePipeReader.cs L29-41 | ○ |
| C-131 | AdvanceTo終端 | E-15: SequencePipeReader.cs L34-38 | ○ |
| C-132 | CancelPendingRead | E-15: SequencePipeReader.cs L44-47 | ○ |
| C-133 | Complete | E-15: SequencePipeReader.cs L50-59 | ○ |
| C-134 | Complete二重呼び出し | E-15: SequencePipeReader.cs L52-55 | ○ |

### BufferSegment クラス（UT-PIP-135〜144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | End | E-12: BufferSegment.cs L22-32 | ○ |
| C-136 | NextSegment | E-12: BufferSegment.cs L40-48 | ○ |
| C-137 | SetOwnedMemory(IMemoryOwner) | E-12: BufferSegment.cs L50-54 | ○ |
| C-138 | SetOwnedMemory(byte[]) | E-12: BufferSegment.cs L56-60 | ○ |
| C-139 | Reset | E-12: BufferSegment.cs L63-70 | ○ |
| C-140 | ResetMemory | E-12: BufferSegment.cs L73-92 | ○ |
| C-141 | Length | E-12: BufferSegment.cs L99 | ○ |
| C-142 | WritableBytes | E-12: BufferSegment.cs L101-105 | ○ |
| C-143 | SetNext | E-12: BufferSegment.cs L107-122 | ○ |
| C-144 | GetLength | E-12: BufferSegment.cs L124-128 | ○ |

### PipeReaderStream クラス（UT-PIP-145〜161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145 | コンストラクタ | E-13: PipeReaderStream.cs L16-21 | ○ |
| C-146 | CanRead | E-13: PipeReaderStream.cs L32 | ○ |
| C-147 | CanSeek | E-13: PipeReaderStream.cs L34 | ○ |
| C-148 | CanWrite | E-13: PipeReaderStream.cs L36 | ○ |
| C-149 | Length | E-13: PipeReaderStream.cs L38 | ○ |
| C-150 | Position | E-13: PipeReaderStream.cs L40 | ○ |
| C-151 | Read正常系 | E-13: PipeReaderStream.cs L48-56 | ○ |
| C-152 | Read null例外 | E-13: PipeReaderStream.cs L50-53 | ○ |
| C-153 | ReadByte正常系 | E-13: PipeReaderStream.cs L58-62 | ○ |
| C-154 | ReadByte EOF | E-13: PipeReaderStream.cs L61 | ○ |
| C-155 | ReadAsync | E-13: PipeReaderStream.cs L83-91 | ○ |
| C-156 | Seek | E-13: PipeReaderStream.cs L71 | ○ |
| C-157 | SetLength | E-13: PipeReaderStream.cs L73 | ○ |
| C-158 | Write | E-13: PipeReaderStream.cs L75 | ○ |
| C-159 | Dispose leaveOpen=false | E-13: PipeReaderStream.cs L23-30 | ○ |
| C-160 | Dispose leaveOpen=true | E-13: PipeReaderStream.cs L25-28 | ○ |
| C-161 | CopyToAsync | E-13: PipeReaderStream.cs L151-157 | ○ |

### PipeWriterStream クラス（UT-PIP-162〜177）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-162 | コンストラクタ | E-14: PipeWriterStream.cs L14-19 | ○ |
| C-163 | CanRead | E-14: PipeWriterStream.cs L42 | ○ |
| C-164 | CanSeek | E-14: PipeWriterStream.cs L44 | ○ |
| C-165 | CanWrite | E-14: PipeWriterStream.cs L46 | ○ |
| C-166 | Length | E-14: PipeWriterStream.cs L48 | ○ |
| C-167 | Position | E-14: PipeWriterStream.cs L50 | ○ |
| C-168 | Read | E-14: PipeWriterStream.cs L57 | ○ |
| C-169 | Write | E-14: PipeWriterStream.cs L69-70 | ○ |
| C-170 | WriteAsync | E-14: PipeWriterStream.cs L72-82 | ○ |
| C-171 | WriteAsync null例外 | E-14: PipeWriterStream.cs L74-77 | ○ |
| C-172 | Flush | E-14: PipeWriterStream.cs L52-55 | ○ |
| C-173 | FlushAsync | E-14: PipeWriterStream.cs L93-98 | ○ |
| C-174 | Seek | E-14: PipeWriterStream.cs L59 | ○ |
| C-175 | SetLength | E-14: PipeWriterStream.cs L61 | ○ |
| C-176 | Dispose leaveOpen=false | E-14: PipeWriterStream.cs L21-27 | ○ |
| C-177 | Dispose leaveOpen=true | E-14: PipeWriterStream.cs L23-26 | ○ |

### IDuplexPipe インターフェース（UT-PIP-178〜179）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-178 | Input | E-16: IDuplexPipe.cs L10 | ○ |
| C-179 | Output | E-16: IDuplexPipe.cs L13 | ○ |

### StreamPipeExtensions クラス（UT-PIP-180〜183）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-180 | CopyToAsync正常系 | E-17: StreamPipeExtensions.cs L17-34 | ○ |
| C-181 | CopyToAsync null source | E-17: StreamPipeExtensions.cs L19-22 | ○ |
| C-182 | CopyToAsync null destination | E-17: StreamPipeExtensions.cs L23-26 | ○ |
| C-183 | CopyToAsyncキャンセル | E-17: StreamPipeExtensions.cs L28-31 | ○ |

### 統合テスト（UT-PIP-184〜190）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-184 | バックプレッシャー開始 | E-01: Pipe.cs L322-328, E-22 | ○ |
| C-185 | バックプレッシャー解除 | E-01: Pipe.cs L500-506, E-22 | ○ |
| C-186 | セグメントプール再利用 | E-01: Pipe.cs L278-288, L100 | ○ |
| C-187 | マルチセグメント | E-01: Pipe.cs L1097-1127 | ○ |
| C-188 | ReaderScheduler | E-01: Pipe.cs L377, L800-805 | ○ |
| C-189 | WriterScheduler | E-01: Pipe.cs L586-587 | ○ |
| C-190 | UseSynchronizationContext | E-01: Pipe.cs L38, E-18: PipeAwaitable.cs L128-137 | ○ |

## 4) 不足情報（Unknown / Missing）

本テストケース一覧では、すべてのテストケースについてソースコードの根拠を確認しています。

追加で確認が推奨される項目：
- **パフォーマンステスト**：大量データ処理時のメモリ使用量、スループット
- **並行性テスト**：複数スレッドからの同時アクセス
- **長時間実行テスト**：メモリリーク検出

## 5) リスクフラグ（レビュー観点）

| リスク | 対象テストケース | 説明 |
|-------|-----------------|------|
| 0: 低リスク | UT-PIP-037〜040, 077-078, 084-088, 092-094, 146-150, 163-168 | プロパティ取得のみ |
| 1: 中リスク | UT-PIP-001-002, 033-034, 050-051, 065-066, 080-081, 089-090 | コンストラクタ・ファクトリ |
| 2: 高リスク | UT-PIP-010-032, 041-056, 057-064, 095-125, 184-190 | データ処理・状態管理 |

## 6) レビュアーチェックリスト（最小）

- [ ] 高優先度テストケース（高リスク）が実際のユースケースをカバーしているか確認
- [ ] バックプレッシャーテスト（UT-PIP-184〜185）の閾値が適切か確認
- [ ] キャンセル処理テストが非同期処理の全パターンをカバーしているか確認
- [ ] BufferSegment関連テスト（UT-PIP-135〜144）が内部クラスのためアクセス方法を確認
- [ ] 既存のテストファイル（tests/配下）との重複・整合性を確認
- [ ] エッジケース（大量データ、空データ、並行アクセス）のカバレッジを確認
