---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.IO.Pipes.AccessControl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. **Persist メソッド**：Windows環境でのみテスト可能
  2. **PipeStream状態チェック**：実際のパイプ接続が必要
  3. **NamedPipeServerStreamAcl.Create**：パラメータ組み合わせが多い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeSecurity.cs`
- E-02: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeAccessRule.cs`
- E-03: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeAuditRule.cs`
- E-04: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipesAclExtensions.cs`
- E-05: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/AnonymousPipeServerStreamAcl.cs`
- E-06: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/NamedPipeServerStreamAcl.cs`
- E-07: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeAccessRights.cs`
- E-08: `src/libraries/System.IO.Pipes.AccessControl/ref/System.IO.Pipes.AccessControl.cs`（リファレンスアセンブリ定義）
- E-09: `src/libraries/System.IO.Pipes.AccessControl/README.md`（モジュール説明）

## 3) Claims と根拠の対応（レビューの主戦場）

### PipeSecurity クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタでインスタンス生成 | E-01 (line 13-14) | ○ |
| C-02 | AddAccessRuleで有効なルール追加 | E-01 (line 20-25) | ○ |
| C-03 | AddAccessRuleでnull時ArgumentNullException | E-01 (line 22) | ○ |
| C-04 | SetAccessRuleで有効なルール設定 | E-01 (line 27-32) | ○ |
| C-05 | SetAccessRuleでnull時ArgumentNullException | E-01 (line 29) | ○ |
| C-06 | ResetAccessRuleでリセット | E-01 (line 34-39) | ○ |
| C-07 | ResetAccessRuleでnull時ArgumentNullException | E-01 (line 36) | ○ |
| C-08 | RemoveAccessRuleで完全一致削除 | E-01 (line 41-77) | ○ |
| C-09 | RemoveAccessRuleでSynchronizeビットマスク | E-01 (line 65-72) | ○ |
| C-10 | RemoveAccessRuleでFullControl時そのまま削除 | E-01 (line 73-76) | ○ |
| C-11 | RemoveAccessRuleでnull時ArgumentNullException | E-01 (line 43) | ○ |
| C-12 | RemoveAccessRuleで存在しないルール時false | E-01 (line 41-77) | ○ |
| C-13 | RemoveAccessRuleSpecificで完全一致削除 | E-01 (line 79-115) | ○ |
| C-14 | RemoveAccessRuleSpecificでSynchronizeビットマスク | E-01 (line 104-110) | ○ |
| C-15 | RemoveAccessRuleSpecificでnull時ArgumentNullException | E-01 (line 81) | ○ |
| C-16 | AddAuditRuleで監査ルール追加 | E-01 (line 117-120) | ○ |
| C-17 | SetAuditRuleで監査ルール設定 | E-01 (line 122-125) | ○ |
| C-18 | RemoveAuditRuleで監査ルール削除 | E-01 (line 127-130) | ○ |
| C-19 | RemoveAuditRuleAllで一括削除 | E-01 (line 132-135) | ○ |
| C-20 | RemoveAuditRuleSpecificで完全一致削除 | E-01 (line 137-140) | ○ |
| C-21 | AccessRuleFactoryで正常生成 | E-01 (line 142-163) | ○ |
| C-22 | AccessRuleFactoryでinheritanceFlags検証 | E-01 (line 148-151) | ○ |
| C-23 | AccessRuleFactoryでpropagationFlags検証 | E-01 (line 152-155) | ○ |
| C-24 | AuditRuleFactoryで正常生成 | E-01 (line 166-191) | ○ |
| C-25 | AuditRuleFactoryでinheritanceFlags検証 | E-01 (line 177-180) | ○ |
| C-26 | AuditRuleFactoryでpropagationFlags検証 | E-01 (line 181-184) | ○ |
| C-27 | Persist(SafeHandle)で永続化 | E-01 (line 207-221) | ○ |
| C-28 | Persist(string)で名前指定永続化 | E-01 (line 223-237) | ○ |
| C-29 | AccessRightTypeがPipeAccessRights返却 | E-01 (line 239-245) | ○ |
| C-30 | AccessRuleTypeがPipeAccessRule返却 | E-01 (line 247-253) | ○ |
| C-31 | AuditRuleTypeがPipeAuditRule返却 | E-01 (line 255-261) | ○ |

### PipeAccessRule クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | 文字列identityでインスタンス生成 | E-02 (line 14-17) | ○ |
| C-33 | IdentityReferenceでインスタンス生成 | E-02 (line 19-22) | ○ |
| C-34 | 不正なrights（負値）でArgumentOutOfRangeException | E-02 (line 48-49) | ○ |
| C-35 | 不正なrights（上限超過）でArgumentOutOfRangeException | E-02 (line 48-49) | ○ |
| C-36 | PipeAccessRightsプロパティで権限取得 | E-02 (line 33-39) | ○ |
| C-37 | AccessMaskFromRightsでAllow時Synchronize追加 | E-02 (line 51-54) | ○ |
| C-38 | AccessMaskFromRightsでDeny時Synchronizeマスク | E-02 (line 55-61) | ○ |
| C-39 | AccessMaskFromRightsでDeny+FullControl時Synchronize維持 | E-02 (line 57-60) | ○ |
| C-40 | RightsFromAccessMaskで逆変換 | E-02 (line 66-69) | ○ |

### PipeAuditRule クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | IdentityReferenceでインスタンス生成 | E-03 (line 11-21) | ○ |
| C-42 | 文字列identityでインスタンス生成 | E-03 (line 23-33) | ○ |
| C-43 | 不正なrights（負値）でArgumentOutOfRangeException | E-03 (line 52-55) | ○ |
| C-44 | 不正なrights（上限超過）でArgumentOutOfRangeException | E-03 (line 52-55) | ○ |
| C-45 | PipeAccessRightsプロパティで権限取得 | E-03 (line 60-66) | ○ |

### PipesAclExtensions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | GetAccessControlで接続済みストリームからPipeSecurity取得 | E-04 (line 11-18) | ○ |
| C-47 | GetAccessControlでWaitingToConnect状態時エラー | E-04 (line 14) コメント参照 | ○ |
| C-48 | GetAccessControlでClosed状態時エラー | E-04 (line 14) コメント参照 | ○ |
| C-49 | SetAccessControlで接続済みストリームにPipeSecurity設定 | E-04 (line 20-35) | ○ |
| C-50 | SetAccessControlでnull時ArgumentNullException | E-04 (line 22) | ○ |
| C-51 | SetAccessControlでNamedPipeClientStream未接続時IOException | E-04 (line 28-31) | ○ |
| C-52 | SetAccessControlでWaitingToConnect状態時エラー | E-04 (line 25) コメント参照 | ○ |
| C-53 | SetAccessControlでClosed状態時エラー | E-04 (line 25) コメント参照 | ○ |

### AnonymousPipeServerStreamAcl クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Createで有効パラメータからインスタンス生成 | E-05 (line 19-22) | ○ |
| C-55 | Createでnull pipeSecurityも許容 | E-05 (line 16) コメント参照 | ○ |
| C-56 | Createでdirection=InOut時NotSupportedException | E-05 (line 17) コメント参照 | ○ |
| C-57 | Createで不正inheritability時ArgumentOutOfRangeException | E-05 (line 18) コメント参照 | ○ |
| C-58 | Createでbuffersize=0も許容 | E-05 (line 13) コメント参照 | ○ |

### NamedPipeServerStreamAcl クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | Createで有効パラメータからインスタンス生成 | E-06 (line 35-48) | ○ |
| C-60 | Createでnull pipeSecurityも許容 | E-06 (line 18) コメント参照 | ○ |
| C-61 | Createでnull pipeName時ArgumentNullException | E-06 (line 22) コメント参照 | ○ |
| C-62 | Createで空pipeName時ArgumentException | E-06 (line 23) コメント参照 | ○ |
| C-63 | Createでpipename=anonymous時ArgumentOutOfRangeException | E-06 (line 33) コメント参照 | ○ |
| C-64 | Createで負のinBufferSize時ArgumentOutOfRangeException | E-06 (line 28) コメント参照 | ○ |
| C-65 | CreateでmaxInstances=0時ArgumentOutOfRangeException | E-06 (line 29-30) コメント参照 | ○ |
| C-66 | CreateでmaxInstances>=255時ArgumentOutOfRangeException | E-06 (line 29-30) コメント参照 | ○ |
| C-67 | CreateでMaxAllowedServerInstances許容 | E-06 (line 29-30) コメント参照 | ○ |
| C-68 | Createで不正inheritability時ArgumentOutOfRangeException | E-06 (line 31) コメント参照 | ○ |
| C-69 | CreateでCurrentUserOnly時カスタムPipeSecurity適用 | E-06 (line 34) コメント参照 | ○ |
| C-70 | CreateでadditionalAccessRights適用 | E-06 (line 45) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- すべてのテストケースはソースコードの実装から直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: PipeSecurity型プロパティ（AccessRightType, AccessRuleType, AuditRuleType）
- **1 (中リスク)**: 監査ルール関連メソッド（実運用での使用頻度が低い）
- **2 (高リスク)**: Persistメソッド（Windows環境依存、実際のセキュリティ設定変更）

### プラットフォーム依存性について
このモジュールはWindows専用APIを使用しています。以下のテストケースはWindows環境でのみ実行可能です：
- PipeSecurity.Persist(SafeHandle) / Persist(string)
- PipesAclExtensions.GetAccessControl / SetAccessControl
- AnonymousPipeServerStreamAcl.Create
- NamedPipeServerStreamAcl.Create

## 6) レビュアーチェックリスト（最小）
- [ ] PipeSecurityのnullチェックが全メソッドで正しく行われているか確認
- [ ] Synchronizeビット処理（Allow/Deny時の動作）が正しくテストされているか確認
- [ ] 境界値テスト（bufferSize=0, maxInstances=1/254）が適切か確認
- [ ] Windows環境でのみ実行可能なテストが明示されているか確認
- [ ] PipeStream状態遷移（WaitingToConnect, Connected, Disconnected, Broken, Closed）のテストが網羅されているか確認
- [ ] ArgumentNullException/ArgumentOutOfRangeExceptionのテストが全パブリックメソッドで存在するか確認
