---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 205
  claims_with_evidence: 205
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.IO.Pipes 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：205 / 205、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり
  2. **プラットフォーム固有機能**：Windows専用/Unix専用のテストケースは実行環境の考慮が必要
  3. **非同期処理**：非同期メソッドのテストはタイミング依存性に注意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeStream.cs`
- E-02: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeStream.Windows.cs`
- E-03: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeStream.Unix.cs`
- E-04: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/NamedPipeServerStream.cs`
- E-05: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/NamedPipeServerStream.Windows.cs`
- E-06: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/NamedPipeClientStream.cs`
- E-07: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/NamedPipeClientStream.Windows.cs`
- E-08: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/AnonymousPipeServerStream.cs`
- E-09: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/AnonymousPipeClientStream.cs`
- E-10: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeSecurity.cs`
- E-11: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeAccessRule.cs`
- E-12: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeAuditRule.cs`
- E-13: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipesAclExtensions.cs`
- E-14: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeDirection.cs`
- E-15: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeOptions.cs`
- E-16: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeState.cs`
- E-17: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeTransmissionMode.cs`
- E-18: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeAccessRights.cs`
- E-19: `src/libraries/System.IO.Pipes/src/Microsoft/Win32/SafeHandles/SafePipeHandle.cs`
- E-20: `src/libraries/System.IO.Pipes/src/System/IO/Error.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### PipeStream 基底クラス (UT-PIP-001 - UT-PIP-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PipeStreamコンストラクタでdirection, bufferSizeが検証される | E-01: L31-40 | ○ |
| C-02 | 不正なPipeDirectionでArgumentOutOfRangeExceptionがスローされる | E-01: L33-36 | ○ |
| C-03 | 負のbufferSizeでArgumentOutOfRangeExceptionがスローされる | E-01: L37 | ○ |
| C-04 | PipeTransmissionModeの検証が行われる | E-01: L48-51 | ○ |
| C-05 | IsConnectedはStateがConnectedの場合にtrueを返す | E-01: L174-184 | ○ |
| C-06 | IsMessageCompleteは状態検証を行う | E-01: L193-224 | ○ |
| C-07 | SafePipeHandleはハンドル未設定時に例外をスローする | E-01: L233-249 | ○ |
| C-08 | CanRead/CanWriteはPipeDirectionに依存する | E-01: L69-76, L267-281 | ○ |
| C-09 | CanSeekは常にfalseを返す | E-01: L283-289 | ○ |
| C-10 | Length/Positionはシーク不可のため例外をスローする | E-01: L291-319 | ○ |
| C-11 | CheckReadOperationsは状態検証を行う | E-01: L339-360 | ○ |
| C-12 | CheckWriteOperationsは状態検証を行う | E-01: L363-390 | ○ |
| C-13 | Read/WriteメソッドはCanRead/CanWriteを検証する | E-02: L21-36, L125-141 | ○ |
| C-14 | 非同期Read/Writeはキャンセルトークンに対応する | E-02: L54-103, L160-199 | ○ |
| C-15 | WaitForPipeDrainはWindowsでのみサポートされる | E-02: L446-460, E-03: L341-356 | ○ |
| C-16 | TransmissionMode/ReadModeプロパティが正しく動作する | E-02: L464-582, E-03: L360-423 | ○ |
| C-17 | InBufferSize/OutBufferSizeはCanRead/CanWriteを検証する | E-02: L495-543, E-03: L369-399 | ○ |

### NamedPipeServerStream (UT-PIP-068 - UT-PIP-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | コンストラクタで全パラメータが検証される | E-04: L85-130 | ○ |
| C-19 | pipeNameがnull/空の場合に例外がスローされる | E-04: L95 | ○ |
| C-20 | maxNumberOfServerInstancesの範囲が検証される | E-04: L110-116 | ○ |
| C-21 | SafePipeHandleコンストラクタでハンドルが検証される | E-04: L133-150 | ○ |
| C-22 | WaitForConnectionは状態を検証する | E-04: L169-187, E-05: L169-202 | ○ |
| C-23 | WaitForConnectionAsyncはキャンセルに対応する | E-05: L204-207, L317-363 | ○ |
| C-24 | Disconnectは状態を検証してDisconnected状態に遷移する | E-05: L209-220, E-04: L189-208 | ○ |
| C-25 | GetImpersonationUserNameはWindowsでクライアント名を取得する | E-05: L225-238 | ○ |
| C-26 | RunAsClientはクライアントとして偽装して実行する | E-05: L243-266 | ○ |
| C-27 | MaxAllowedServerInstances定数は-1である | E-04: L16 | ○ |

### NamedPipeClientStream (UT-PIP-095 - UT-PIP-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | コンストラクタで全パラメータが検証される | E-06: L57-90 | ○ |
| C-29 | serverName/pipeNameがnull/空の場合に例外がスローされる | E-06: L61-66 | ○ |
| C-30 | PipeOptionsの検証が行われる | E-06: L67-70 | ○ |
| C-31 | TokenImpersonationLevelの検証が行われる | E-06: L71-74 | ○ |
| C-32 | HandleInheritabilityの検証が行われる | E-06: L75-78 | ○ |
| C-33 | SafePipeHandleコンストラクタでハンドルが検証される | E-06: L99-112 | ○ |
| C-34 | Connect()は無限タイムアウトで接続する | E-06: L119-121 | ○ |
| C-35 | Connect(int)はタイムアウト値を検証する | E-06: L124-131 | ○ |
| C-36 | 既に接続済みの場合InvalidOperationExceptionがスローされる | E-06: L234-243 | ○ |
| C-37 | ConnectAsyncはキャンセルトークンに対応する | E-06: L185-203 | ○ |
| C-38 | CheckPipePropertyOperationsはWaitingToConnect/Broken状態を検証する | E-06: L218-230 | ○ |
| C-39 | NumberOfServerInstancesはWindowsでインスタンス数を取得する | E-07: L181-200 | ○ |
| C-40 | TryConnectはWin32 APIを使用して接続を試みる | E-07: L99-178 | ○ |

### AnonymousPipeServerStream (UT-PIP-125 - UT-PIP-143)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | デフォルトコンストラクタはOut方向で初期化する | E-08: L17-19 | ○ |
| C-42 | PipeDirection.InOutはNotSupportedExceptionをスローする | E-08: L36-39, L66-69 | ○ |
| C-43 | HandleInheritabilityの検証が行われる | E-08: L70-73 | ○ |
| C-44 | SafePipeHandleコンストラクタで両ハンドルが検証される | E-08: L33-59 | ○ |
| C-45 | GetClientHandleAsStringはハンドルの文字列表現を返す | E-08: L87-91 | ○ |
| C-46 | ClientSafePipeHandleはクライアントハンドルを返す | E-08: L93-100 | ○ |
| C-47 | DisposeLocalCopyOfClientHandleはクライアントハンドルをクローズする | E-08: L113-119 | ○ |
| C-48 | TransmissionModeは常にByteを返す | E-08: L139-142 | ○ |
| C-49 | ReadMode setでMessageモードはNotSupportedExceptionをスローする | E-08: L144-158 | ○ |

### AnonymousPipeClientStream (UT-PIP-144 - UT-PIP-154)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | ハンドル文字列コンストラクタでパースと検証が行われる | E-09: L20-45 | ○ |
| C-51 | nullのpipeHandleAsStringでArgumentNullExceptionがスローされる | E-09: L27 | ○ |
| C-52 | パースできない文字列でArgumentExceptionがスローされる | E-09: L30-34 | ○ |
| C-53 | PipeDirection.InOutはNotSupportedExceptionをスローする | E-09: L23-26, L50-53 | ○ |
| C-54 | SafePipeHandleコンストラクタでハンドルが検証される | E-09: L47-61 | ○ |
| C-55 | TransmissionModeは常にByteを返す | E-09: L80-83 | ○ |
| C-56 | ReadMode setでMessageモードはNotSupportedExceptionをスローする | E-09: L85-99 | ○ |

### PipeSecurity/PipeAccessRule/PipeAuditRule (UT-PIP-155 - UT-PIP-185)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | PipeSecurityはNativeObjectSecurityを継承する | E-10: L11 | ○ |
| C-58 | AddAccessRuleはnullルールで例外をスローする | E-10: L20-25 | ○ |
| C-59 | RemoveAccessRuleはマッチングロジックを持つ | E-10: L41-77 | ○ |
| C-60 | AccessRuleFactoryはinheritanceFlags!=Noneで例外をスローする | E-10: L148-151 | ○ |
| C-61 | Persistはセキュリティ設定を永続化する | E-10: L207-221 | ○ |
| C-62 | PipeAccessRuleはアクセスマスクを変換する | E-11: L46-64 | ○ |
| C-63 | Allow時にSynchronizeビットが追加される | E-11: L51-54 | ○ |
| C-64 | Deny時(非FullControl)でSynchronizeビットが除外される | E-11: L55-61 | ○ |
| C-65 | PipeAuditRuleはアクセス権を検証する | E-12: L50-58 | ○ |

### PipesAclExtensions (UT-PIP-186 - UT-PIP-189)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | GetAccessControlはPipeSecurityを返す | E-13: L11-18 | ○ |
| C-67 | SetAccessControlはnullで例外をスローする | E-13: L22 | ○ |
| C-68 | SetAccessControlはNamedPipeClientStreamでBroken状態を検証する | E-13: L28-31 | ○ |

### SafePipeHandle (UT-PIP-190 - UT-PIP-193)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | デフォルトコンストラクタは無効なハンドルを作成する | E-19: L15-18 | ○ |
| C-70 | IntPtrコンストラクタでハンドル値を設定する | E-19: L25-29 | ○ |

### Error ヘルパークラス (UT-PIP-194 - UT-PIP-199)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | GetEndOfFileはEndOfStreamExceptionを返す | E-20: L9-12 | ○ |
| C-72 | GetPipeNotOpenはObjectDisposedExceptionを返す | E-20: L14-17 | ○ |
| C-73 | GetReadNotSupportedはNotSupportedExceptionを返す | E-20: L19-22 | ○ |
| C-74 | GetSeekNotSupportedはNotSupportedExceptionを返す | E-20: L24-27 | ○ |
| C-75 | GetWriteNotSupportedはNotSupportedExceptionを返す | E-20: L29-32 | ○ |
| C-76 | GetOperationAbortedはIOExceptionを返す | E-20: L34-37 | ○ |

### GetPipePath (UT-PIP-200 - UT-PIP-205)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Windows版GetPipePathはパスを正規化する | E-02: L221-229 | ○ |
| C-78 | Windows版GetPipePathはanonymousを予約名として検証する | E-02: L224-227 | ○ |
| C-79 | Unix版GetPipePathはリモートサーバーを拒否する | E-03: L187-191 | ○ |
| C-80 | Unix版GetPipePathは無効な文字を検証する | E-03: L203-215 | ○ |
| C-81 | Unix版GetPipePathは絶対パスをそのまま返す | E-03: L203-210 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースにソースコードによる根拠あり
- 既存テストファイル（tests/配下）は参照していないが、本レポートはソースコード実装からテストケースを導出しているため問題なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースにソースコード根拠あり
- 1: 中リスク - プラットフォーム固有機能（Windows/Unix）のテストは実行環境による制約に注意
- 1: 中リスク - 非同期処理テストはタイミング依存性に注意

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースIDが連番で重複がないか確認
- [ ] 対象クラス・メソッドがソースコードに存在するか確認
- [ ] テスト観点（正常系/異常系/境界値）が適切に分類されているか確認
- [ ] 優先度（高/中/低）が妥当か確認
- [ ] プラットフォーム固有テストケース（Windows/Unix）が明示されているか確認
- [ ] 例外テストケースで期待される例外型が正しいか確認
- [ ] 入力値・期待結果が具体的かつ検証可能か確認
