---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Linq.AsyncEnumerable 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で主要なテストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/AsyncEnumerable.cs`
- E-02: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/AsyncIterator.cs`
- E-03: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ThrowHelper.cs`
- E-04: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Where.cs`
- E-05: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Select.cs`
- E-06: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/FirstAsync.cs`
- E-07: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/LastAsync.cs`
- E-08: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/SingleAsync.cs`
- E-09: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/CountAsync.cs`
- E-10: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/AnyAsync.cs`
- E-11: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/AllAsync.cs`
- E-12: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/AggregateAsync.cs`
- E-13: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ToArrayAsync.cs`
- E-14: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ToListAsync.cs`
- E-15: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ToDictionaryAsync.cs`
- E-16: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ElementAtAsync.cs`
- E-17: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Take.cs`
- E-18: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Skip.cs`
- E-19: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Empty.cs`
- E-20: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Concat.cs`
- E-21: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Distinct.cs`
- E-22: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/OrderBy.cs`
- E-23: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/GroupBy.cs`
- E-24: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ContainsAsync.cs`
- E-25: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/SequenceEqualAsync.cs`
- E-26: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/SelectMany.cs`
- E-27: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Zip.cs`
- E-28: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Reverse.cs`
- E-29: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Append.cs`
- E-30: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Prepend.cs`
- E-31: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/DefaultIfEmpty.cs`
- E-32: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Cast.cs`
- E-33: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/OfType.cs`
- E-34: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/TakeWhile.cs`
- E-35: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/SkipWhile.cs`
- E-36: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/TakeLast.cs`
- E-37: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/SkipLast.cs`
- E-38: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Range.cs`
- E-39: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Repeat.cs`
- E-40: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Except.cs`
- E-41: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Intersect.cs`
- E-42: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Union.cs`
- E-43: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Join.cs`
- E-44: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/GroupJoin.cs`
- E-45: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/MinAsync.cs`
- E-46: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/MaxAsync.cs`
- E-47: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/SumAsync.cs`
- E-48: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/AverageAsync.cs`
- E-49: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Index.cs`
- E-50: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/Chunk.cs`
- E-51: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/DistinctBy.cs`
- E-52: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ExceptBy.cs`
- E-53: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/IntersectBy.cs`
- E-54: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/UnionBy.cs`
- E-55: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/MinByAsync.cs`
- E-56: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/MaxByAsync.cs`
- E-57: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/AggregateBy.cs`
- E-58: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/CountBy.cs`
- E-59: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ToHashSetAsync.cs`
- E-60: `src/libraries/System.Linq.AsyncEnumerable/src/System/Linq/ToLookupAsync.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Where メソッドは条件に一致する要素をフィルタリングする | E-04 | ○ |
| C-02 | Where に null source を渡すと ArgumentNullException | E-04 (L24) | ○ |
| C-03 | Where に null predicate を渡すと ArgumentNullException | E-04 (L25) | ○ |
| C-04 | Where は空シーケンスに対して空を返す | E-04 (L28) | ○ |
| C-05 | Where はインデックス付き predicate をサポート | E-04 (L92-L117) | ○ |
| C-06 | Where は非同期 predicate をサポート | E-04 (L53-L77) | ○ |
| C-07 | Select は全要素に変換関数を適用 | E-05 | ○ |
| C-08 | Select に null source を渡すと ArgumentNullException | E-05 (L28) | ○ |
| C-09 | Select に null selector を渡すと ArgumentNullException | E-05 (L29) | ○ |
| C-10 | Select はインデックス付き selector をサポート | E-05 (L95-L117) | ○ |
| C-11 | FirstAsync は最初の要素を返す | E-06 (L20-L41) | ○ |
| C-12 | FirstAsync は空シーケンスで InvalidOperationException | E-06 (L34-L37) | ○ |
| C-13 | FirstAsync に null source を渡すと ArgumentNullException | E-06 (L24) | ○ |
| C-14 | FirstAsync は predicate 付きで条件一致要素を返す | E-06 (L55-L80) | ○ |
| C-15 | FirstAsync は predicate 一致なしで InvalidOperationException | E-06 (L77) | ○ |
| C-16 | FirstOrDefaultAsync は最初の要素を返す | E-06 (L128-L131) | ○ |
| C-17 | FirstOrDefaultAsync は空シーケンスで default を返す | E-06 (L156) | ○ |
| C-18 | FirstOrDefaultAsync はカスタム default 値をサポート | E-06 (L140-L158) | ○ |
| C-19 | LastAsync は最後の要素を返す | E-07 (L19-L47) | ○ |
| C-20 | LastAsync は空シーケンスで InvalidOperationException | E-07 (L33-L36) | ○ |
| C-21 | LastAsync は predicate 付きで条件一致最後の要素を返す | E-07 (L61-L101) | ○ |
| C-22 | LastAsync は predicate 一致なしで InvalidOperationException | E-07 (L98) | ○ |
| C-23 | LastOrDefaultAsync は最後の要素を返す | E-07 (L166-L169) | ○ |
| C-24 | LastOrDefaultAsync は空シーケンスで default を返す | E-07 (L192) | ○ |
| C-25 | SingleAsync は 1 要素シーケンスで要素を返す | E-08 (L23-L49) | ○ |
| C-26 | SingleAsync は空シーケンスで InvalidOperationException | E-08 (L36-L39) | ○ |
| C-27 | SingleAsync は複数要素で InvalidOperationException | E-08 (L42-L45) | ○ |
| C-28 | SingleAsync は predicate 付きで条件一致要素を返す | E-08 (L65-L102) | ○ |
| C-29 | SingleAsync は predicate 複数一致で InvalidOperationException | E-08 (L91) | ○ |
| C-30 | SingleOrDefaultAsync は 1 要素シーケンスで要素を返す | E-08 (L183-L212) | ○ |
| C-31 | SingleOrDefaultAsync は空シーケンスで default を返す | E-08 (L199-L201) | ○ |
| C-32 | SingleOrDefaultAsync は複数要素で InvalidOperationException | E-08 (L205-L208) | ○ |
| C-33 | CountAsync は要素数を返す | E-09 (L20-L42) | ○ |
| C-34 | CountAsync は空シーケンスで 0 を返す | E-09 (L34-L40) | ○ |
| C-35 | CountAsync に null source を渡すと ArgumentNullException | E-09 (L24) | ○ |
| C-36 | CountAsync は predicate 付きで条件一致カウント | E-09 (L52-L77) | ○ |
| C-37 | LongCountAsync は long 型でカウント | E-09 (L121-L143) | ○ |
| C-38 | AnyAsync は要素存在で true | E-10 (L19-L35) | ○ |
| C-39 | AnyAsync は空シーケンスで false | E-10 (L33) | ○ |
| C-40 | AnyAsync は predicate 一致で true | E-10 (L48-L72) | ○ |
| C-41 | AnyAsync は predicate 不一致で false | E-10 (L70) | ○ |
| C-42 | AllAsync は全一致で true | E-11 (L24-L48) | ○ |
| C-43 | AllAsync は一部不一致で false | E-11 (L40-L43) | ○ |
| C-44 | AllAsync は空シーケンスで true | E-11 (L46) | ○ |
| C-45 | AggregateAsync は累積関数を適用 | E-12 (L22-L52) | ○ |
| C-46 | AggregateAsync は空シーケンスで InvalidOperationException | E-12 (L39-L42) | ○ |
| C-47 | AggregateAsync はシード付きで累積 | E-12 (L105-L130) | ○ |
| C-48 | AggregateAsync は空シーケンスでシード値を返す | E-12 (L121-L128) | ○ |
| C-49 | AggregateAsync は結果セレクタを適用 | E-12 (L185-L213) | ○ |
| C-50 | ToArrayAsync は配列に変換 | E-13 (L19-L46) | ○ |
| C-51 | ToArrayAsync は空シーケンスで空配列 | E-13 (L44) | ○ |
| C-52 | ToArrayAsync に null source を渡すと ArgumentNullException | E-13 (L23) | ○ |
| C-53 | ToListAsync はリストに変換 | E-14 (L19-L38) | ○ |
| C-54 | ToListAsync は空シーケンスで空リスト | E-14 (L30-L36) | ○ |
| C-55 | ToDictionaryAsync は KVP シーケンスを Dictionary に変換 | E-15 (L24-L45) | ○ |
| C-56 | ToDictionaryAsync はキーセレクタで Dictionary を作成 | E-15 (L76-L99) | ○ |
| C-57 | ToDictionaryAsync は重複キーで ArgumentException | E-15 (L40, L95) | ○ |
| C-58 | ToDictionaryAsync はキー・値セレクタをサポート | E-15 (L158-L185) | ○ |
| C-59 | ElementAtAsync は指定インデックスの要素を返す | E-16 (L20-L28) | ○ |
| C-60 | ElementAtAsync は範囲外で ArgumentOutOfRangeException | E-16 (L127-L130) | ○ |
| C-61 | ElementAtAsync は負インデックスで例外 | E-16 (L112) | ○ |
| C-62 | ElementAtAsync は Index 構造体をサポート | E-16 (L64-L77) | ○ |
| C-63 | ElementAtOrDefaultAsync は指定インデックスの要素を返す | E-16 (L40-L48) | ○ |
| C-64 | ElementAtOrDefaultAsync は範囲外で default を返す | E-16 (L132) | ○ |
| C-65 | Take は先頭から指定数を取得 | E-17 (L23-L48) | ○ |
| C-66 | Take は count=0 で空シーケンス | E-17 (L30) | ○ |
| C-67 | Take は count 超過で全要素 | E-17 (L38-L46) | ○ |
| C-68 | Take は count 負で空シーケンス | E-17 (L30) | ○ |
| C-69 | Take は Range をサポート | E-17 (L60-L119) | ○ |
| C-70 | Skip は先頭から指定数をスキップ | E-18 (L18-L49) | ○ |
| C-71 | Skip は count=0 で全要素 | E-18 (L26) | ○ |
| C-72 | Skip は count 超過で空 | E-18 (L41-L46) | ○ |
| C-73 | Skip は count 負で全要素 | E-18 (L26) | ○ |
| C-74 | Empty は空シーケンスを返す | E-19 (L17) | ○ |
| C-75 | Empty は同一インスタンスを返す | E-19 (L26) | ○ |
| C-76 | Concat は 2 シーケンスを連結 | E-20 (L19-L38) | ○ |
| C-77 | Concat に null first を渡すと ArgumentNullException | E-20 (L22) | ○ |
| C-78 | Concat は first 空で second を返す | E-20 (L25-L28) | ○ |
| C-79 | Concat は second 空で first を返す | E-20 (L30-L33) | ○ |
| C-80 | Distinct は重複を除去 | E-21 (L18-L49) | ○ |
| C-81 | Distinct はカスタム comparer をサポート | E-21 (L20, L30) | ○ |
| C-82 | Distinct は重複なしで全要素 | E-21 (L37-L46) | ○ |
| C-83 | OrderBy はキーで昇順ソート | E-22 (L33-L44) | ○ |
| C-84 | OrderBy に null source を渡すと ArgumentNullException | E-22 (L38) | ○ |
| C-85 | OrderByDescending はキーで降順ソート | E-22 (L88-L99) | ○ |
| C-86 | ThenBy は二次ソートを適用 | E-22 (L132-L140) | ○ |
| C-87 | Order は要素自体でソート | E-22 (L19-L22) | ○ |
| C-88 | OrderDescending は要素自体で降順ソート | E-22 (L74-L77) | ○ |
| C-89 | GroupBy はキーでグループ化 | E-23 (L27-L50) | ○ |
| C-90 | GroupBy に null source を渡すと ArgumentNullException | E-23 (L32) | ○ |
| C-91 | GroupBy は空シーケンスで空 | E-23 (L36) | ○ |
| C-92 | GroupBy は elementSelector をサポート | E-23 (L108-L134) | ○ |
| C-93 | AsyncIterator.GetAsyncEnumerator は初回で自身を返す | E-02 (L75-L81) | ○ |
| C-94 | AsyncIterator.GetAsyncEnumerator は 2 回目で Clone を返す | E-02 (L77) | ○ |
| C-95 | AsyncIterator.DisposeAsync は状態を -1 に設定 | E-02 (L60-L65) | ○ |
| C-96 | ThrowHelper.ThrowIfNegative は正の値で例外なし | E-03 (L11-L17) | ○ |
| C-97 | ThrowHelper.ThrowIfNegative は負の値で例外 | E-03 (L13-L16) | ○ |
| C-98 | ThrowHelper.ThrowIfNegativeOrZero は正の値で例外なし | E-03 (L19-L25) | ○ |
| C-99 | ThrowHelper.ThrowIfNegativeOrZero は 0 で例外 | E-03 (L21-L24) | ○ |
| C-100 | ThrowHelper.ThrowNoElementsException は InvalidOperationException | E-03 (L40) | ○ |
| C-101 | ThrowHelper.ThrowMoreThanOneElementException は InvalidOperationException | E-03 (L34) | ○ |
| C-102 | ContainsAsync は存在する要素で true | E-24 | ○ |
| C-103 | ContainsAsync は存在しない要素で false | E-24 | ○ |
| C-104 | SequenceEqualAsync は同一シーケンスで true | E-25 | ○ |
| C-105 | SequenceEqualAsync は異なるシーケンスで false | E-25 | ○ |
| C-106 | SequenceEqualAsync は長さ不一致で false | E-25 | ○ |
| C-107 | EmptyAsyncEnumerable.MoveNextAsync は false | E-19 (L30) | ○ |
| C-108 | EmptyAsyncEnumerable.Current は default | E-19 (L32) | ○ |
| C-109 | Concat2AsyncIterator は 2 シーケンスを順番に列挙 | E-20 (L44-L88) | ○ |
| C-110 | ConcatNAsyncIterator は 3 以上のシーケンスを列挙 | E-20 (L102-L177) | ○ |
| C-111 | ToHashSetAsync は HashSet に変換 | E-59 | ○ |
| C-112 | ToLookupAsync は Lookup を作成 | E-60 | ○ |
| C-113 | Grouping.Add は要素を追加 | E-23 (L405-L414) | ○ |
| C-114 | Grouping.Trim は配列サイズを調整 | E-23 (L416-L422) | ○ |
| C-115 | SelectMany は入れ子をフラット化 | E-26 | ○ |
| C-116 | Zip は 2 シーケンスを結合 | E-27 | ○ |
| C-117 | Zip は長さ不一致で短い方に合わせる | E-27 | ○ |
| C-118 | Reverse はシーケンスを逆順 | E-28 | ○ |
| C-119 | Append は末尾に要素追加 | E-29 | ○ |
| C-120 | Prepend は先頭に要素追加 | E-30 | ○ |
| C-121 | DefaultIfEmpty は空シーケンスで default を返す | E-31 | ○ |
| C-122 | DefaultIfEmpty は非空シーケンスでそのまま | E-31 | ○ |
| C-123 | Cast は全要素をキャスト | E-32 | ○ |
| C-124 | Cast はキャスト不可で InvalidCastException | E-32 | ○ |
| C-125 | OfType は指定型のみフィルタ | E-33 | ○ |
| C-126 | TakeWhile は条件満たす間を取得 | E-34 | ○ |
| C-127 | SkipWhile は条件満たす間をスキップ | E-35 | ○ |
| C-128 | TakeLast は末尾から指定数を取得 | E-36 | ○ |
| C-129 | SkipLast は末尾から指定数をスキップ | E-37 | ○ |
| C-130 | Range は指定範囲の整数シーケンス | E-38 | ○ |
| C-131 | Repeat は指定要素を繰り返す | E-39 | ○ |
| C-132 | Except は差集合を返す | E-40 | ○ |
| C-133 | Intersect は積集合を返す | E-41 | ○ |
| C-134 | Union は和集合を返す | E-42 | ○ |
| C-135 | Join は内部結合を行う | E-43 | ○ |
| C-136 | GroupJoin はグループ結合を行う | E-44 | ○ |
| C-137 | MinAsync は最小値を返す | E-45 | ○ |
| C-138 | MaxAsync は最大値を返す | E-46 | ○ |
| C-139 | SumAsync は合計値を返す | E-47 | ○ |
| C-140 | AverageAsync は平均値を返す | E-48 | ○ |
| C-141 | Index はインデックス付きタプルを返す | E-49 | ○ |
| C-142 | Chunk は指定サイズで分割 | E-50 | ○ |
| C-143 | DistinctBy はキーで重複除去 | E-51 | ○ |
| C-144 | ExceptBy はキーで差集合 | E-52 | ○ |
| C-145 | IntersectBy はキーで積集合 | E-53 | ○ |
| C-146 | UnionBy はキーで和集合 | E-54 | ○ |
| C-147 | MinByAsync はキー最小の要素 | E-55 | ○ |
| C-148 | MaxByAsync はキー最大の要素 | E-56 | ○ |
| C-149 | AggregateBy はキーごとに累積 | E-57 | ○ |
| C-150 | CountBy はキーごとのカウント | E-58 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースがソースコードの実装に基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに明確な根拠を持つ
- 注意点：
  - 非同期メソッド（async/await）のテストでは、CancellationToken の動作確認が重要
  - 大規模シーケンスでのメモリ使用量・パフォーマンステストは別途必要

## 6) レビュアーチェックリスト（最小）
- [ ] Where, Select, First, Last, Single のテストケースが正常系/異常系/境界値を網羅しているか
- [ ] null 入力に対する ArgumentNullException テストが含まれているか
- [ ] 空シーケンスに対する挙動テストが含まれているか
- [ ] CancellationToken 対応のテストケースが考慮されているか
- [ ] 非同期 predicate/selector 対応のテストケースが含まれているか
- [ ] OrderBy, GroupBy などの複雑な操作のテストが適切か
- [ ] Index 構造体、Range 構造体を使用するオーバーロードがテストされているか
