---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Linq.Parallel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **C-147**: ExceptionAggregator.WrapEnumerable - 内部実装の詳細が未確認
  2. **C-150**: ListChunk<T>.Add - 内部ユーティリティの詳細仕様が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Linq.Parallel/src/System/Linq/ParallelEnumerable.cs` - ParallelEnumerableクラスの実装
- E-02: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/QueryOperators/QueryOperator.cs` - QueryOperator基底クラス
- E-03: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/QueryOperators/QuerySettings.cs` - クエリ設定構造体
- E-04: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/Scheduling/Scheduling.cs` - スケジューリング定数・ヘルパー
- E-05: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/QueryOperators/Unary/WhereQueryOperator.cs` - Whereオペレータ実装
- E-06: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/QueryOperators/Unary/SelectQueryOperator.cs` - Selectオペレータ実装
- E-07: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/QueryOperators/Unary/SortQueryOperator.cs` - Sortオペレータ実装
- E-08: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/QueryOperators/Binary/JoinQueryOperator.cs` - Joinオペレータ実装
- E-09: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/QueryOperators/AssociativeAggregationOperator.cs` - 集約オペレータ実装
- E-10: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/Merging/MergeExecutor.cs` - マージ実行器
- E-11: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/Partitioning/PartitionedDataSource.cs` - パーティション化データソース
- E-12: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/Scheduling/CancellationState.cs` - キャンセル状態管理
- E-13: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/Utils/GrowingArray.cs` - 可変長配列
- E-14: `src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/Utils/HashLookup.cs` - ハッシュルックアップ

## 3) Claims と根拠の対応（レビューの主戦場）

### ParallelEnumerable クラス（C-01 ~ C-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AsParallel<TSource>でIEnumerableから並列クエリが生成される | E-01 (行103-108) | ○ |
| C-02 | AsParallel<TSource>でnullソースはArgumentNullException | E-01 (行105: ArgumentNullException.ThrowIfNull) | ○ |
| C-03 | AsParallel(Partitioner)でPartitionerから並列クエリが生成される | E-01 (行125-130) | ○ |
| C-04 | AsParallel(Partitioner)でnullはArgumentNullException | E-01 (行127) | ○ |
| C-05 | AsOrdered<TSource>で順序付きクエリが生成される | E-01 (行152-172) | ○ |
| C-06 | AsOrdered<TSource>で無効ソースはInvalidOperationException | E-01 (行156-168) | ○ |
| C-07 | AsOrdered<TSource>でnullソースはArgumentNullException | E-01 (行154) | ○ |
| C-08 | AsUnordered<TSource>で順序なしクエリが生成される | E-01 (行218-223) | ○ |
| C-09 | AsSequential<TSource>で並列クエリがシーケンシャルに変換される | E-01 (行264-277) | ○ |
| C-10 | WithDegreeOfParallelismで並列度が設定される | E-01 (行296-308) | ○ |
| C-11 | WithDegreeOfParallelismで並列度0はArgumentOutOfRangeException | E-01 (行300) | ○ |
| C-12 | WithDegreeOfParallelismで並列度513はArgumentOutOfRangeException | E-01 (行301, E-04 行49: MAX_SUPPORTED_DOP=512) | ○ |
| C-13 | WithDegreeOfParallelismで並列度1が設定可能 | E-01 (行300: ThrowIfNegativeOrZero) | ○ |
| C-14 | WithDegreeOfParallelismで並列度512が設定可能 | E-01, E-04 | ○ |
| C-15 | WithCancellationでキャンセルトークンが設定される | E-01 (行324-333) | ○ |
| C-16 | キャンセル時にOperationCanceledExceptionがスローされる | E-12 (行71-78), E-02 (行144-148) | ○ |
| C-17 | WithExecutionModeで実行モードが設定される | E-01 (行352-366) | ○ |
| C-18 | WithExecutionModeで無効値はArgumentException | E-01 (行356-359) | ○ |
| C-19 | WithMergeOptionsでマージオプションが設定される | E-01 (行385-402) | ○ |
| C-20 | WithMergeOptionsで無効値はArgumentException | E-01 (行389-395) | ○ |
| C-21 | Rangeで指定範囲の整数シーケンスが生成される | E-01 (行420-424) | ○ |
| C-22 | Rangeで負のカウントはArgumentOutOfRangeException | E-01 (行422) | ○ |
| C-23 | Rangeでオーバーフローは ArgumentOutOfRangeException | E-01 (行422) | ○ |
| C-24 | Rangeでカウント0は空シーケンス | E-01 | ○ |
| C-25 | Repeatで指定回数繰り返された要素が生成される | E-01 (行440-445) | ○ |
| C-26 | Repeatで負のカウントはArgumentOutOfRangeException | E-01 (行442) | ○ |
| C-27 | Repeatでカウント0は空シーケンス | E-01 | ○ |
| C-28 | Empty<TResult>で空の並列シーケンスが返される | E-01 (行457-460) | ○ |
| C-29 | ForAll<TSource>で全要素にアクションが実行される | E-01 (行498-506) | ○ |
| C-30 | ForAll<TSource>でnullソースはArgumentNullException | E-01 (行500) | ○ |
| C-31 | ForAll<TSource>でnullアクションはArgumentNullException | E-01 (行501) | ○ |
| C-32 | Where<TSource>で条件に合致する要素がフィルタリングされる | E-01 (行530-536), E-05 | ○ |
| C-33 | Where<TSource>でインデックス付きフィルタが動作する | E-01 (行548-554) | ○ |
| C-34 | Whereで全要素除外時は空シーケンス | E-05 (行147) | ○ |
| C-35 | Select<TSource,TResult>で要素が変換される | E-01 (行573-580), E-06 | ○ |
| C-36 | Select<TSource,TResult>でインデックス付き変換が動作する | E-01 (行594-601) | ○ |
| C-37 | SelectMany<TSource,TResult>でネストコレクションが平坦化される | E-01 (行944-951) | ○ |
| C-38 | Joinで内部結合が実行される | E-01 (行685-692), E-08 | ○ |
| C-39 | Joinでマッチなしは空シーケンス | E-08 | ○ |
| C-40 | GroupJoinでグループ結合が実行される | E-01 (行817-824) | ○ |
| C-41 | Zipで2つのシーケンスが結合される | E-01 (行624-632) | ○ |
| C-42 | Zipで長さ不一致時は短い方に合わせる | E-01 | ○ |
| C-43 | OrderByで要素が昇順ソートされる | E-07 | ○ |
| C-44 | OrderByDescendingで要素が降順ソートされる | E-07 (行42-45: ReverseComparer使用) | ○ |
| C-45 | ThenByで二次ソートが実行される | E-07 (行54-69) | ○ |
| C-46 | GroupByで要素がグループ化される | E-01 | ○ |
| C-47 | Aggregateで累積計算が実行される | E-09 | ○ |
| C-48 | Aggregateでシード値付き累積計算が実行される | E-09 (行72-93) | ○ |
| C-49 | Aggregateで空シーケンスはInvalidOperationException | E-09 (行144-149) | ○ |
| C-50 | Countで要素数がカウントされる | E-01 | ○ |
| C-51 | Countで条件付きカウントが実行される | E-01 | ○ |
| C-52 | LongCountで長整数カウントが実行される | E-01 | ○ |
| C-53 | Sumで整数の合計が計算される | E-01 | ○ |
| C-54 | Sumでnull許容型の合計が計算される | E-01 | ○ |
| C-55 | Minで最小値が取得される | E-01 | ○ |
| C-56 | Minで空シーケンスはInvalidOperationException | E-01 | ○ |
| C-57 | Maxで最大値が取得される | E-01 | ○ |
| C-58 | Averageで平均値が計算される | E-01 | ○ |
| C-59 | Averageで空シーケンスはInvalidOperationException | E-01 | ○ |
| C-60 | Anyで条件を満たす要素の存在が検出される | E-01 | ○ |
| C-61 | Anyで要素の存在が検出される | E-01 | ○ |
| C-62 | Anyで空シーケンスはfalse | E-01 | ○ |
| C-63 | Allで全要素が条件を満たすことが検出される | E-01 | ○ |
| C-64 | Allで条件を満たさない要素があるとfalse | E-01 | ○ |
| C-65 | Containsで指定要素が含まれることが検出される | E-01 | ○ |
| C-66 | Containsで指定要素が含まれないとfalse | E-01 | ○ |
| C-67 | Firstで最初の要素が取得される | E-01 | ○ |
| C-68 | Firstで空シーケンスはInvalidOperationException | E-01 | ○ |
| C-69 | FirstOrDefaultで空シーケンスはデフォルト値 | E-01 | ○ |
| C-70 | Lastで最後の要素が取得される | E-01 | ○ |
| C-71 | Lastで空シーケンスはInvalidOperationException | E-01 | ○ |
| C-72 | Singleで単一要素が取得される | E-01 | ○ |
| C-73 | Singleで複数要素はInvalidOperationException | E-01 | ○ |
| C-74 | Singleで空シーケンスはInvalidOperationException | E-01 | ○ |
| C-75 | ElementAtで指定インデックスの要素が取得される | E-01 | ○ |
| C-76 | ElementAtで範囲外インデックスはArgumentOutOfRangeException | E-01 | ○ |
| C-77 | DefaultIfEmptyで空シーケンスはデフォルト値 | E-01 | ○ |
| C-78 | DefaultIfEmptyで非空シーケンスはそのまま | E-01 | ○ |
| C-79 | Reverseでシーケンスが逆順になる | E-01 | ○ |
| C-80 | Distinctで重複が除去される | E-01 | ○ |
| C-81 | Unionで2つのシーケンスの和集合が取得される | E-01 | ○ |
| C-82 | Intersectで2つのシーケンスの積集合が取得される | E-01 | ○ |
| C-83 | Exceptで差集合が取得される | E-01 | ○ |
| C-84 | Concatで2つのシーケンスが連結される | E-01 | ○ |
| C-85 | Takeで指定数の要素が取得される | E-01 | ○ |
| C-86 | Takeで要素数より多い数を指定すると全要素 | E-01 | ○ |
| C-87 | TakeWhileで条件を満たす間の要素が取得される | E-01 | ○ |
| C-88 | Skipで指定数の要素がスキップされる | E-01 | ○ |
| C-89 | Skipで要素数より多い数を指定すると空シーケンス | E-01 | ○ |
| C-90 | SkipWhileで条件を満たす間の要素がスキップされる | E-01 | ○ |
| C-91 | ToArrayで並列クエリが配列に変換される | E-01 | ○ |
| C-92 | ToListで並列クエリがリストに変換される | E-01 | ○ |
| C-93 | ToDictionaryで並列クエリが辞書に変換される | E-01 | ○ |
| C-94 | ToDictionaryで重複キーはAggregateException | E-01 | ○ |
| C-95 | ToLookupで並列クエリがルックアップに変換される | E-01 | ○ |
| C-96 | SequenceEqualで同一シーケンスはtrue | E-01 | ○ |
| C-97 | SequenceEqualで異なるシーケンスはfalse | E-01 | ○ |
| C-98 | Cast<TResult>で要素がキャストされる | E-01 | ○ |
| C-99 | Cast<TResult>でキャスト不可はAggregateException | E-01 | ○ |
| C-100 | OfType<TResult>で指定型の要素がフィルタリングされる | E-01 | ○ |

### QueryOperator クラス（C-101 ~ C-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | GetEnumeratorでクエリ結果のEnumeratorが取得される | E-02 (行89-93) | ○ |
| C-102 | Openでクエリが正しくオープンされる | E-02 (行63) | ○ |
| C-103 | ExecuteAndGetResultsAsArrayでクエリ結果が配列として取得される | E-02 (行190-249) | ○ |
| C-104 | AsSequentialQueryでシーケンシャルクエリに変換される | E-02 (行259) | ○ |
| C-105 | AsQueryOperatorでIEnumerableがQueryOperatorに変換される | E-02 (行308-338) | ○ |

### QuerySettings 構造体（C-106 ~ C-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | Mergeで2つの設定がマージされる | E-03 (行99-133) | ○ |
| C-107 | Mergeで重複TaskSchedulerはInvalidOperationException | E-03 (行101-104) | ○ |
| C-108 | Mergeで重複DOPはInvalidOperationException | E-03 (行106-109) | ○ |
| C-109 | WithDefaultsで未設定項目にデフォルト値が設定される | E-03 (行172-194) | ○ |
| C-110 | WithPerExecutionSettingsで実行毎の設定が追加される | E-03 (行135-167) | ○ |
| C-111 | CleanStateAtQueryEndでリソースが解放される | E-03 (行205-209) | ○ |

### Scheduling クラス（C-112 ~ C-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | GetDefaultDegreeOfParallelismでデフォルト並列度が取得される | E-04 (行56-59) | ○ |
| C-113 | GetDefaultChunkSize<T>で値型のチャンクサイズは128 | E-04 (行72-85) | ○ |
| C-114 | GetDefaultChunkSize<T>で参照型のチャンクサイズが計算される | E-04 (行87-90) | ○ |

### WhereQueryOperator クラス（C-115 ~ C-117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | OpenでWhereオペレータが正しくオープンされる | E-05 (行69-76) | ○ |
| C-116 | MoveNextで条件を満たす次の要素に移動する | E-05 (行128-148) | ○ |
| C-117 | MoveNextで全要素不一致時はfalse | E-05 (行147) | ○ |

### SelectQueryOperator クラス（C-118 ~ C-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | OpenでSelectオペレータが正しくオープンされる | E-06 (行68-72) | ○ |
| C-119 | MoveNextで変換された次の要素に移動する | E-06 (行114-126) | ○ |

### SortQueryOperator クラス（C-120 ~ C-121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | OpenでSortオペレータが正しくオープンされる | E-07 (行76-80) | ○ |
| C-121 | CreateOrderedEnumerableで二次ソートが正しく作成される | E-07 (行54-69) | ○ |

### JoinQueryOperator クラス（C-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | OpenでJoinオペレータが正しくオープンされる | E-08 (行156-162) | ○ |

### AssociativeAggregationOperator クラス（C-123 ~ C-124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | Aggregateで集約が正しく実行される | E-09 (行103-167) | ○ |
| C-124 | Aggregateで空シーケンスはInvalidOperationException | E-09 (行144-149) | ○ |

### MergeExecutor クラス（C-125 ~ C-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | Executeでマージが正しく実行される | E-10 (行49-94) | ○ |
| C-126 | GetEnumeratorでマージ結果のEnumeratorが取得される | E-10 (行116-120) | ○ |
| C-127 | GetResultsAsArrayでマージ結果が配列として取得される | E-10 (行126-130) | ○ |

### PartitionedDataSource クラス（C-128 ~ C-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | InitializePartitionsで配列ソースが正しくパーティション化される | E-11 (行86-136) | ○ |
| C-129 | InitializePartitionsでIList<T>ソースが正しくパーティション化される | E-11 (行85-136) | ○ |
| C-130 | InitializePartitionsでIEnumerable<T>ソースが遅延パーティション化される | E-11 (行141-146) | ○ |
| C-131 | ArrayIndexRangeEnumerator.MoveNextで配列の次の要素に移動する | E-11 (行258-272) | ○ |
| C-132 | ArrayIndexRangeEnumerator.MoveNextで配列末尾はfalse | E-11 (行271, 285-288) | ○ |
| C-133 | ContiguousChunkLazyEnumerator.MoveNextでチャンク内の次の要素に移動する | E-11 (行610-632) | ○ |
| C-134 | ContiguousChunkLazyEnumerator.MoveNextで新しいチャンクが取得される | E-11 (行639-698) | ○ |

### CancellationState クラス（C-135 ~ C-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | ThrowWithStandardMessageIfCanceledでキャンセル要求時にOperationCanceledExceptionがスローされる | E-12 (行71-78) | ○ |
| C-136 | MergedCancellationTokenでマージされたトークンが取得される | E-12 (行32-41) | ○ |
| C-137 | MergedCancellationTokenでMergedSourceがnullの場合非キャンセル可能トークンが返される | E-12 (行36-40) | ○ |

### GrowingArray クラス（C-138 ~ C-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | Addで要素が追加される | E-13 (行45-52) | ○ |
| C-139 | Addで配列が自動拡張される | E-13 (行47-50, 54-61) | ○ |
| C-140 | CopyFromで他の配列からコピーされる | E-13 (行63-74) | ○ |

### HashLookup クラス（C-141 ~ C-146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | Addでキーと値が追加される | E-14 (行41-44) | ○ |
| C-142 | Addで既存キーはfalse | E-14 (行43) | ○ |
| C-143 | TryGetValueで存在するキーの値が取得される | E-14 (行47-50) | ○ |
| C-144 | TryGetValueで存在しないキーはfalse | E-14 (行49) | ○ |
| C-145 | Indexer setでインデクサで値が設定される | E-14 (行52-59) | ○ |
| C-146 | Resizeで容量超過時にリサイズされる | E-14 (行114-128) | ○ |

### その他ユーティリティ（C-147 ~ C-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | ExceptionAggregator.WrapEnumerableで例外がAggregateExceptionにラップされる | **根拠なし** | △ |
| C-148 | ReverseComparer<T>.Compareで逆順比較が行われる | E-07 (行44: ReverseComparer使用) | ○ |
| C-149 | Util.GetDefaultComparer<TKey>でデフォルトComparerが取得される | E-07 (行41) | ○ |
| C-150 | ListChunk<TInputOutput>.Addでチャンクに要素が追加される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-147**: ExceptionAggregator.WrapEnumerableの詳細実装
  - 候補：`src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/Utils/ExceptionAggregator.cs`
- **C-150**: ListChunk<T>の詳細実装
  - 候補：`src/libraries/System.Linq.Parallel/src/System/Linq/Parallel/Utils/ListChunk.cs`

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: ほとんどのテストケースはソースコードから直接確認可能
- **1 (中リスク)**:
  - 並列実行時の競合状態のテスト（C-16, C-135など）
  - 大規模データセットでの性能特性
- **0 (低リスク)**: 内部ユーティリティクラスの一部（C-147, C-150）は実装詳細が未確認だが、主要機能には影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] ParallelEnumerableの主要メソッド（AsParallel, AsOrdered, WithDegreeOfParallelism等）のテストケースが網羅されているか
- [ ] null引数チェックのテストケースが全ての公開メソッドに対して存在するか
- [ ] 境界値テスト（空シーケンス、単一要素、最大値等）が適切に設計されているか
- [ ] キャンセル機能のテストケースが適切に設計されているか
- [ ] 例外発生時のAggregateExceptionラッピングのテストが含まれているか
- [ ] 順序保持（AsOrdered）と順序無視（AsUnordered）の動作確認テストが含まれているか
