---
generated_at: 2026-01-30 17:25:00
metrics:
  claims_total: 148
  claims_with_evidence: 145
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Linq.Queryable 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：145 / 148、根拠なし：3
- 優先レビュー（高）
  1. **UT-LQY-081（Shuffle）**：ランダム化の検証方法が明確でない
  2. **UT-LQY-125（オーバーロード解決）**：DisambiguateMatchesの内部動作の検証
  3. **UT-LQY-148（Average空シーケンス）**：Sum/Average系の空シーケンス動作の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Linq.Queryable/src/System/Linq/Queryable.cs` - メイン実装（2500+行）
- E-02: `src/libraries/System.Linq.Queryable/src/System/Linq/EnumerableQuery.cs` - EnumerableQuery実装
- E-03: `src/libraries/System.Linq.Queryable/src/System/Linq/EnumerableExecutor.cs` - EnumerableExecutor実装
- E-04: `src/libraries/System.Linq.Queryable/src/System/Linq/EnumerableRewriter.cs` - Expression変換ロジック
- E-05: `src/libraries/System.Linq.Queryable/src/System/Linq/TypeHelper.cs` - 型ヘルパー
- E-06: `src/libraries/System.Linq.Queryable/src/System/Linq/Error.cs` - エラー生成
- E-07: `src/libraries/System.Linq.Queryable/src/System/Linq/Strings.cs` - 文字列リソース

## 3) Claims と根拠の対応（レビューの主戦場）

### Queryable クラス（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-LQY-001) | AsQueryable<TElement>がIEnumerableをIQueryableに変換 | E-01: 行18-25 | ○ |
| C-02 (UT-LQY-002) | 既にIQueryableの場合はそのまま返却 | E-01: 行24 `source as IQueryable<TElement>` | ○ |
| C-03 (UT-LQY-003) | nullでArgumentNullException | E-01: 行22 `ArgumentNullException.ThrowIfNull` | ○ |
| C-04 (UT-LQY-004) | 非ジェネリックAsQueryable | E-01: 行27-45 | ○ |
| C-05 (UT-LQY-005) | 非IEnumerable<T>でArgumentException | E-01: 行38-42 | ○ |
| C-06 (UT-LQY-006) | Where基本動作 | E-01: 行47-58 | ○ |
| C-07 (UT-LQY-007) | Whereインデックス付き | E-01: 行60-71 | ○ |
| C-08 (UT-LQY-008) | Where source null | E-01: 行50 | ○ |
| C-09 (UT-LQY-009) | Where predicate null | E-01: 行51 | ○ |
| C-10 (UT-LQY-010) | Where空シーケンス | E-01: Enumerableへの委譲により保証 | ○ |
| C-11 (UT-LQY-011) | Select基本動作 | E-01: 行97-108 | ○ |
| C-12 (UT-LQY-012) | Selectインデックス付き | E-01: 行110-121 | ○ |
| C-13 (UT-LQY-013) | Select selector null | E-01: 行101 | ○ |
| C-14 (UT-LQY-014) | SelectMany基本動作 | E-01: 行123-134 | ○ |
| C-15 (UT-LQY-015) | SelectMany resultSelector | E-01: 行149-161, 163-175 | ○ |
| C-16 (UT-LQY-016) | Join基本動作 | E-01: 行280-294 | ○ |
| C-17 (UT-LQY-017) | Join with comparer | E-01: 行395-409 | ○ |
| C-18 (UT-LQY-018) | Join null引数 | E-01: 行283-287 | ○ |
| C-19 (UT-LQY-019) | GroupJoin | E-01: 行411-425 | ○ |
| C-20 (UT-LQY-020) | LeftJoin | E-01: 行541-555 | ○ |
| C-21 (UT-LQY-021) | RightJoin | E-01: 行967-981 | ○ |
| C-22 (UT-LQY-022) | OrderBy | E-01: 行745-756 | ○ |
| C-23 (UT-LQY-023) | OrderBy with comparer | E-01: 行758-769 | ○ |
| C-24 (UT-LQY-024) | OrderByDescending | E-01: 行844-855 | ○ |
| C-25 (UT-LQY-025) | Order | E-01: 行696-706 | ○ |
| C-26 (UT-LQY-026) | OrderDescending | E-01: 行795-805 | ○ |
| C-27 (UT-LQY-027) | ThenBy | E-01: 行1097-1108 | ○ |
| C-28 (UT-LQY-028) | ThenByDescending | E-01: 行1123-1134 | ○ |
| C-29 (UT-LQY-029) | Take int | E-01: 行1149-1159 | ○ |
| C-30 (UT-LQY-030) | Take Range | E-01: 行1167-1177 | ○ |
| C-31 (UT-LQY-031) | Take count=0 | E-01: Enumerableへの委譲 | ○ |
| C-32 (UT-LQY-032) | Take count超過 | E-01: Enumerableへの委譲 | ○ |
| C-33 (UT-LQY-033) | TakeWhile | E-01: 行1179-1203 | ○ |
| C-34 (UT-LQY-034) | Skip | E-01: 行1205-1215 | ○ |
| C-35 (UT-LQY-035) | Skip count超過 | E-01: Enumerableへの委譲 | ○ |
| C-36 (UT-LQY-036) | SkipWhile | E-01: 行1217-1241 | ○ |
| C-37 (UT-LQY-037) | GroupBy基本 | E-01: 行1243-1254 | ○ |
| C-38 (UT-LQY-038) | GroupBy elementSelector | E-01: 行1256-1268 | ○ |
| C-39 (UT-LQY-039) | GroupBy resultSelector | E-01: 行1297-1310 | ○ |
| C-40 (UT-LQY-040) | Distinct | E-01: 行1355-1365 | ○ |
| C-41 (UT-LQY-041) | Distinct comparer | E-01: 行1367-1377 | ○ |
| C-42 (UT-LQY-042) | DistinctBy | E-01: 行1386-1397 | ○ |
| C-43 (UT-LQY-043) | Chunk | E-01: 行1431-1441 | ○ |
| C-44 (UT-LQY-044) | Chunk size<=0 | E-01: Enumerableでの検証 | ○ |
| C-45 (UT-LQY-045) | Concat | E-01: 行1443-1454 | ○ |
| C-46 (UT-LQY-046) | Zip 2シーケンス | E-01: 行1456-1467 | ○ |
| C-47 (UT-LQY-047) | Zip resultSelector | E-01: 行1469-1481 | ○ |
| C-48 (UT-LQY-048) | Zip 3シーケンス | E-01: 行1493-1505 | ○ |
| C-49 (UT-LQY-049) | Union | E-01: 行1507-1518 | ○ |
| C-50 (UT-LQY-050) | UnionBy | E-01: 行1543-1555 | ○ |
| C-51 (UT-LQY-051) | Intersect | E-01: 行1600-1611 | ○ |
| C-52 (UT-LQY-052) | IntersectBy | E-01: 行1636-1650 | ○ |
| C-53 (UT-LQY-053) | Except | E-01: 行1678-1689 | ○ |
| C-54 (UT-LQY-054) | ExceptBy | E-01: 行1715-1729 | ○ |
| C-55 (UT-LQY-055) | Index | E-01: 行1588-1598 | ○ |
| C-56 (UT-LQY-056) | First | E-01: 行1758-1768 | ○ |
| C-57 (UT-LQY-057) | First predicate | E-01: 行1770-1781 | ○ |
| C-58 (UT-LQY-058) | First空シーケンス | E-01: Enumerable.First例外 | ○ |
| C-59 (UT-LQY-059) | FirstOrDefault | E-01: 行1783-1793 | ○ |
| C-60 (UT-LQY-060) | FirstOrDefault defaultValue | E-01: 行1801-1811 | ○ |
| C-61 (UT-LQY-061) | Last | E-01: 行1846-1856 | ○ |
| C-62 (UT-LQY-062) | Last空シーケンス | E-01: Enumerable.Last例外 | ○ |
| C-63 (UT-LQY-063) | LastOrDefault | E-01: 行1871-1881 | ○ |
| C-64 (UT-LQY-064) | Single | E-01: 行1935-1945 | ○ |
| C-65 (UT-LQY-065) | Single複数要素 | E-01: Enumerable.Single例外 | ○ |
| C-66 (UT-LQY-066) | Single空シーケンス | E-01: Enumerable.Single例外 | ○ |
| C-67 (UT-LQY-067) | SingleOrDefault | E-01: 行1960-1970 | ○ |
| C-68 (UT-LQY-068) | SingleOrDefault複数要素 | E-01: Enumerable.SingleOrDefault例外 | ○ |
| C-69 (UT-LQY-069) | ElementAt | E-01: 行2025-2038 | ○ |
| C-70 (UT-LQY-070) | ElementAt Index | E-01: 行2047-2060 | ○ |
| C-71 (UT-LQY-071) | ElementAt負インデックス | E-01: 行2030-2031 | ○ |
| C-72 (UT-LQY-072) | ElementAt ^0 | E-01: 行2052-2053 | ○ |
| C-73 (UT-LQY-073) | ElementAtOrDefault | E-01: 行2062-2072 | ○ |
| C-74 (UT-LQY-074) | DefaultIfEmpty | E-01: 行2092-2102 | ○ |
| C-75 (UT-LQY-075) | DefaultIfEmpty defaultValue | E-01: 行2104-2114 | ○ |
| C-76 (UT-LQY-076) | Contains true | E-01: 行2116-2126 | ○ |
| C-77 (UT-LQY-077) | Contains false | E-01: 同上 | ○ |
| C-78 (UT-LQY-078) | Reverse | E-01: 行2140-2150 | ○ |
| C-79 (UT-LQY-079) | SequenceEqual true | E-01: 行2152-2163 | ○ |
| C-80 (UT-LQY-080) | SequenceEqual false | E-01: 同上 | ○ |
| C-81 (UT-LQY-081) | Shuffle | E-01: 行2186-2196 | △ |
| C-82 (UT-LQY-082) | Any true | E-01: 行2198-2208 | ○ |
| C-83 (UT-LQY-083) | Any false | E-01: 同上 | ○ |
| C-84 (UT-LQY-084) | Any predicate | E-01: 行2210-2221 | ○ |
| C-85 (UT-LQY-085) | All true | E-01: 行2223-2234 | ○ |
| C-86 (UT-LQY-086) | All false | E-01: 同上 | ○ |
| C-87 (UT-LQY-087) | Count | E-01: 行2236-2246 | ○ |
| C-88 (UT-LQY-088) | Count predicate | E-01: 行2248-2259 | ○ |
| C-89 (UT-LQY-089) | CountBy | E-01: 行2269-2280 | ○ |
| C-90 (UT-LQY-090) | LongCount | E-01: 行2282-2305 | ○ |
| C-91 (UT-LQY-091) | Min | E-01: 行2307-2317 | ○ |
| C-92 (UT-LQY-092) | Min空シーケンス | E-01: Enumerable.Min例外 | ○ |
| C-93 (UT-LQY-093) | Min selector | E-01: 行2339-2350 | ○ |
| C-94 (UT-LQY-094) | MinBy | E-01: 行2360-2372 | ○ |
| C-95 (UT-LQY-095) | Max | E-01: 行2425-2435 | ○ |
| C-96 (UT-LQY-096) | Max selector | E-01: 行2456-2467 | ○ |
| C-97 (UT-LQY-097) | MaxBy | E-01: 行2477-2489 | ○ |
| C-98 (UT-LQY-098) | OfType | E-01: 行73-83 | ○ |
| C-99 (UT-LQY-099) | Cast | E-01: 行85-95 | ○ |
| C-100 (UT-LQY-100) | Cast失敗 | E-01: Enumerable.Cast例外 | ○ |

### EnumerableQuery クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 (UT-LQY-101) | コンストラクタ IEnumerable | E-02: 行44-48 | ○ |
| C-102 (UT-LQY-102) | コンストラクタ Expression | E-02: 行50-53 | ○ |
| C-103 (UT-LQY-103) | CreateQuery | E-02: 行63-71 | ○ |
| C-104 (UT-LQY-104) | CreateQuery null | E-02: 行65 | ○ |
| C-105 (UT-LQY-105) | CreateQuery invalid expression | E-02: 行68-69 | ○ |
| C-106 (UT-LQY-106) | CreateQuery<TElement> | E-02: 行73-82 | ○ |
| C-107 (UT-LQY-107) | Execute | E-02: 行84-89 | ○ |
| C-108 (UT-LQY-108) | Execute<TElement> | E-02: 行91-98 | ○ |
| C-109 (UT-LQY-109) | GetEnumerator | E-02: 行104-117 | ○ |
| C-110 (UT-LQY-110) | GetEnumerator自己参照 | E-02: 行112-113 | ○ |
| C-111 (UT-LQY-111) | ToString Expression | E-02: 行119-128 | ○ |
| C-112 (UT-LQY-112) | ToString Enumerable | E-02: 行123-124 | ○ |

### EnumerableExecutor クラス（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 (UT-LQY-113) | コンストラクタ | E-03: 行30-33 | ○ |
| C-114 (UT-LQY-114) | Execute | E-03: 行41-48 | ○ |
| C-115 (UT-LQY-115) | ExecuteBoxed | E-03: 行37 | ○ |

### EnumerableRewriter クラス（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 (UT-LQY-116) | VisitMethodCall Queryable変換 | E-04: 行28-61 | ○ |
| C-117 (UT-LQY-117) | VisitMethodCall無変更 | E-04: 行34-35 | ○ |
| C-118 (UT-LQY-118) | VisitConstant | E-04: 行201-215 | ○ |
| C-119 (UT-LQY-119) | VisitLambda | E-04: 行120 | ○ |
| C-120 (UT-LQY-120) | VisitConditional | E-04: 行378-393 | ○ |
| C-121 (UT-LQY-121) | VisitBlock | E-04: 行395-405 | ○ |
| C-122 (UT-LQY-122) | VisitGoto | E-04: 行407-415 | ○ |
| C-123 (UT-LQY-123) | VisitLabelTarget | E-04: 行417-436 | ○ |
| C-124 (UT-LQY-124) | FindEnumerableMethodForQueryable | E-04: 行218-234 | ○ |
| C-125 (UT-LQY-125) | DisambiguateMatches | E-04: 行245-292 | △ |

### TypeHelper クラス（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 (UT-LQY-126) | FindGenericType基本 | E-05: 行16-37 | ○ |
| C-127 (UT-LQY-127) | FindGenericTypeインターフェース | E-05: 行27-32 | ○ |
| C-128 (UT-LQY-128) | FindGenericType null | E-05: 行36 | ○ |

### Error クラス（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 (UT-LQY-129) | ArgumentNotIEnumerableGeneric | E-06: 行8-9 | ○ |
| C-130 (UT-LQY-130) | ArgumentNotValid | E-06: 行11-12 | ○ |
| C-131 (UT-LQY-131) | NoMethodOnType | E-06: 行17-18 | ○ |
| C-132 (UT-LQY-132) | NoMethodOnTypeMatchingArguments | E-06: 行20-21 | ○ |
| C-133 (UT-LQY-133) | EnumeratingNullEnumerableExpression | E-06: 行23-24 | ○ |

### その他メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-134 (UT-LQY-134) | Append | E-01: Appendメソッド | ○ |
| C-135 (UT-LQY-135) | Prepend | E-01: Prependメソッド | ○ |
| C-136 (UT-LQY-136) | TakeLast | E-01: TakeLastメソッド | ○ |
| C-137 (UT-LQY-137) | SkipLast | E-01: SkipLastメソッド | ○ |
| C-138 (UT-LQY-138) | Aggregate | E-01: Aggregateメソッド | ○ |
| C-139 (UT-LQY-139) | Aggregate seed | E-01: Aggregateメソッド | ○ |
| C-140 (UT-LQY-140) | Aggregate resultSelector | E-01: Aggregateメソッド | ○ |
| C-141 (UT-LQY-141) | AggregateBy | E-01: AggregateByメソッド | ○ |
| C-142 (UT-LQY-142) | Sum int | E-01: Sumメソッド群 | ○ |
| C-143 (UT-LQY-143) | Sum long | E-01: Sumメソッド群 | ○ |
| C-144 (UT-LQY-144) | Sum double | E-01: Sumメソッド群 | ○ |
| C-145 (UT-LQY-145) | Sum decimal | E-01: Sumメソッド群 | ○ |
| C-146 (UT-LQY-146) | Average int | E-01: Averageメソッド群 | ○ |
| C-147 (UT-LQY-147) | Average double | E-01: Averageメソッド群 | ○ |
| C-148 (UT-LQY-148) | Average空シーケンス | E-01: Enumerable.Average例外 | △ |

## 4) 不足情報（Unknown / Missing）
- **Shuffle（UT-LQY-081）**: ランダム化の検証方法について、実装はEnumerableに委譲されているが、テストでどのように「ランダム化されたこと」を検証するかは要検討
  - 候補: 順序が変わることの確率的検証 / 複数回実行での分布確認 / モック使用
- **DisambiguateMatches（UT-LQY-125）**: 内部ロジックの複雑さに対してテストケースが単純
  - 候補: 具体的なオーバーロード解決シナリオの追加
- **Average空シーケンス（UT-LQY-148）**: 値型と参照型での動作差異の検証
  - 候補: nullable型での動作確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: Error, Strings クラス - 単純な文字列生成のため
- **0: 低リスク**: TypeHelper - 小規模で明確なロジック
- **1: 中リスク**: EnumerableRewriter - Expression変換の複雑なロジック
- **1: 中リスク**: EnumerableQuery - IQueryProvider実装の複雑さ
- **0: 低リスク**: Queryable静的メソッド - パターンが統一されており、Enumerableへの委譲が明確

## 6) レビュアーチェックリスト（最小）
- [ ] null引数に対するArgumentNullExceptionのテストケースが全メソッドで網羅されているか
- [ ] 空シーケンスに対する動作（例外 or デフォルト値）が正しく分類されているか
- [ ] 境界値（0件、1件、大量件数）のテストケースが適切に含まれているか
- [ ] IEqualityComparer/IComparer を受け取るオーバーロードのテストケースが含まれているか
- [ ] Expression変換（EnumerableRewriter）のテストケースが重要なパターンを網羅しているか
- [ ] Join系メソッド（Join, LeftJoin, RightJoin, GroupJoin）の動作差異が明確に区別されているか
- [ ] 新規追加されたメソッド（Index, Chunk, CountBy, AggregateBy等）のテストケースが含まれているか
