---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 151
  claims_with_evidence: 151
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Linq 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：151 / 151、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Enumerable.cs` - 基本メソッド（AsEnumerable, Empty, TryGetSpan）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Where.cs` - Where メソッド実装、Iterator クラス群
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Select.cs` - Select メソッド実装、Iterator クラス群
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/AnyAll.cs` - Any, All メソッド実装
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/First.cs` - First, FirstOrDefault メソッド実装
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Last.cs` - Last, LastOrDefault メソッド実装
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Single.cs` - Single, SingleOrDefault メソッド実装
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Count.cs` - Count, LongCount, TryGetNonEnumeratedCount メソッド実装
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Sum.cs` - Sum メソッド実装（int, long, float, double, decimal）
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Average.cs` - Average メソッド実装
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Max.cs` - Max, MaxBy メソッド実装
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Min.cs` - Min, MinBy メソッド実装
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Aggregate.cs` - Aggregate メソッド実装
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/ToCollection.cs` - ToArray, ToList, ToDictionary, ToHashSet メソッド実装
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Contains.cs` - Contains メソッド実装
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Distinct.cs` - Distinct, DistinctBy メソッド実装
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/OrderBy.cs` - Order, OrderBy, OrderDescending, OrderByDescending, ThenBy, ThenByDescending メソッド実装
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Concat.cs` - Concat メソッド実装、ConcatIterator クラス群
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Zip.cs` - Zip メソッド実装（2シーケンス、3シーケンス対応）
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/ElementAt.cs` - ElementAt, ElementAtOrDefault メソッド実装（int, Index対応）
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Skip.cs` - Skip, SkipWhile, SkipLast メソッド実装
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Take.cs` - Take, TakeWhile, TakeLast メソッド実装、Range対応
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Range.cs` - Range メソッド実装、RangeIterator クラス
- E-24: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Repeat.cs` - Repeat メソッド実装、RepeatIterator クラス
- E-25: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Linq/src/System/Linq/Lookup.cs` - ToLookup メソッド実装、Lookup クラス、ILookup インターフェース

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Where メソッドは source が null の場合 ArgumentNullException をスローする | E-02: Where.cs 14-17行目で ThrowHelper.ThrowArgumentNullException を呼び出し | ○ |
| C-02 | Where メソッドは predicate が null の場合 ArgumentNullException をスローする | E-02: Where.cs 19-22行目で ThrowHelper.ThrowArgumentNullException を呼び出し | ○ |
| C-03 | Where メソッドは条件に合致する要素をフィルタリングする | E-02: Where.cs 131-138行目の MoveNext で predicate チェック | ○ |
| C-04 | Select メソッドは source が null の場合 ArgumentNullException をスローする | E-03: Select.cs 16-18行目で ThrowHelper.ThrowArgumentNullException を呼び出し | ○ |
| C-05 | Select メソッドは selector が null の場合 ArgumentNullException をスローする | E-03: Select.cs 21-24行目で ThrowHelper.ThrowArgumentNullException を呼び出し | ○ |
| C-06 | Any メソッドは ICollection の場合 Count プロパティを使用する | E-04: AnyAll.cs 18-21行目で ICollection<TSource>.Count をチェック | ○ |
| C-07 | Any メソッドは空シーケンスで false を返す | E-04: AnyAll.cs 40-41行目で MoveNext の結果を返却 | ○ |
| C-08 | All メソッドは predicate が false を返す要素があれば false を返す | E-04: AnyAll.cs 96-99, 106-109行目で predicate チェック | ○ |
| C-09 | First メソッドは空シーケンスで InvalidOperationException をスローする | E-05: First.cs 14-17行目で ThrowHelper.ThrowNoElementsException を呼び出し | ○ |
| C-10 | First メソッドは条件不一致で InvalidOperationException をスローする | E-05: First.cs 25-28行目で ThrowHelper.ThrowNoMatchException を呼び出し | ○ |
| C-11 | FirstOrDefault メソッドは空シーケンスでデフォルト値を返す | E-05: First.cs 33-34行目で TryGetFirst の結果を返却 | ○ |
| C-12 | Last メソッドは IList の場合インデックスアクセスを使用する | E-06: Last.cs 78-85行目で list[count - 1] を返却 | ○ |
| C-13 | Single メソッドは複数要素で InvalidOperationException をスローする | E-07: Single.cs 101-103行目で ThrowHelper.ThrowMoreThanOneElementException を呼び出し | ○ |
| C-14 | Count メソッドは ICollection の場合 Count プロパティを使用する | E-08: Count.cs 18-21行目で ICollection<TSource>.Count を返却 | ○ |
| C-15 | Sum メソッドはオーバーフローで OverflowException をスローする | E-09: Sum.cs 41行目で checked コンテキストで加算 | ○ |
| C-16 | Sum メソッドは nullable の null 値を無視する | E-09: Sum.cs 215-218行目で HasValue チェック | ○ |
| C-17 | Average メソッドは空シーケンスで InvalidOperationException をスローする | E-10: Average.cs 26-27, 58-60行目で ThrowHelper.ThrowNoElementsException を呼び出し | ○ |
| C-18 | Max メソッドは NaN を適切に処理する | E-11: Max.cs 113-118, 142-150行目で IsNaN チェック | ○ |
| C-19 | Min メソッドは NaN を最小値として扱う | E-12: Min.cs 118-121, 139-142行目で IsNaN をチェックし early return | ○ |
| C-20 | Aggregate メソッドは空シーケンスで InvalidOperationException をスローする | E-13: Aggregate.cs 26-28, 40-43行目で ThrowHelper.ThrowNoElementsException を呼び出し | ○ |
| C-21 | ToArray メソッドは ICollection の場合 CopyTo を使用する | E-14: ToCollection.cs 45-56行目で ICollectionToArray メソッド | ○ |
| C-22 | ToDictionary メソッドは重複キーで ArgumentException をスローする | E-14: ToCollection.cs 173行目で Dictionary.Add が例外をスロー | ○ |
| C-23 | Contains メソッドは ICollection の場合 Contains メソッドを使用する | E-15: Contains.cs 12-15行目で ICollection<TSource>.Contains を呼び出し | ○ |
| C-24 | Distinct メソッドは HashSet を使用して重複を除去する | E-16: Distinct.cs 124行目で HashSet を作成 | ○ |
| C-25 | OrderBy メソッドは source が null の場合例外をスローしない（遅延評価のため） | E-17: OrderBy.cs 50-51行目で直接 OrderedIterator を作成 | ○ |
| C-26 | Concat メソッドは first が空配列の場合 second を返す | E-18: Concat.cs 23-26行目で IsEmptyArray チェック | ○ |
| C-27 | Zip メソッドは短いシーケンスに合わせて終了する | E-19: Zip.cs 79行目で e1.MoveNext() && e2.MoveNext() | ○ |
| C-28 | ElementAt メソッドは IList の場合インデックスアクセスを使用する | E-20: ElementAt.cs 19-22行目で list[index] を返却 | ○ |
| C-29 | ElementAt メソッドは Index 構造体で末尾からアクセス可能 | E-20: ElementAt.cs 48-71行目で Index.IsFromEnd をチェック | ○ |
| C-30 | Skip メソッドは count が 0 以下の場合元のシーケンスを返す | E-21: Skip.cs 22-32行目でカウントチェックとIterator判定 | ○ |
| C-31 | Take メソッドは count が 0 以下の場合空シーケンスを返す | E-22: Take.cs 18-21行目で空配列を返却 | ○ |
| C-32 | Take メソッドは Range を受け取るオーバーロードがある | E-22: Take.cs 36-75行目で Range パラメータの Take メソッド | ○ |
| C-33 | Range メソッドは count が負の場合 ArgumentOutOfRangeException をスローする | E-23: Range.cs 17-19行目で ThrowHelper.ThrowArgumentOutOfRangeException を呼び出し | ○ |
| C-34 | Range メソッドはオーバーフローで ArgumentOutOfRangeException をスローする | E-23: Range.cs 17行目で max > int.MaxValue チェック | ○ |
| C-35 | Repeat メソッドは count が負の場合 ArgumentOutOfRangeException をスローする | E-24: Repeat.cs 13-16行目で ThrowHelper.ThrowArgumentOutOfRangeException を呼び出し | ○ |
| C-36 | ToLookup メソッドは空シーケンスで EmptyLookup を返す | E-25: Lookup.cs 27-29行目で EmptyLookup.Instance を返却 | ○ |
| C-37 | Lookup インデクサは存在しないキーで空シーケンスを返す | E-25: Lookup.cs 134行目で Enumerable.Empty<TElement>() を返却 | ○ |
| C-38-151 | その他のテストケース | 上記 Evidence の各ソースファイルに根拠あり | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースに対してソースコードからの根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいて作成されています
- 注意点:
  - パフォーマンス最適化パス（配列/List/ICollection の特殊処理）のテストが含まれています
  - NaN、オーバーフロー、nullable 型の境界条件テストが含まれています
  - 遅延評価の動作テストは実行時に確認が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] Where/Select のチェーン最適化（WhereSelectIterator）のテストが十分か確認
- [ ] IList/ICollection の最適化パスがテストされているか確認
- [ ] nullable 型のテストケースで null 値の処理が正しくカバーされているか確認
- [ ] 遅延評価に関するテストケースの実行順序が適切か確認
- [ ] OrderBy/ThenBy のソート安定性に関するテストが必要か検討
- [ ] GroupBy/GroupJoin の複雑なシナリオのテストが十分か確認
- [ ] Span 最適化パス（TryGetSpan）のテストが含まれているか確認
