---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 80
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Memory.Data 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：80 / 80、根拠なし：0
- 優先レビュー（高）
  1. **ファイル/ストリーム関連テスト（UT-SMD-038〜044）**：実際のファイルI/O動作の検証が必要
  2. **JSONシリアライズ関連テスト（UT-SMD-005〜007, 045〜047）**：シリアライズオプションの網羅性確認
  3. **BOM処理テスト（UT-SMD-061）**：BOMトリム処理の仕様確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Memory.Data/src/System/BinaryData.cs`（BinaryDataクラス本体：508行）
- E-02: `src/libraries/System.Memory.Data/src/System/BinaryDataConverter.cs`（BinaryDataJsonConverterクラス：30行）
- E-03: `src/libraries/System.Memory.Data/ref/System.Memory.Data.cs`（APIリファレンス定義）
- E-04: `src/libraries/System.Memory.Data/tests/BinaryDataTests.cs`（既存テストケース参照）
- E-05: `src/libraries/System.Memory.Data/tests/BinaryDataFromFileTests.cs`（ファイル関連テスト参照）

## 3) Claims と根拠の対応（レビューの主戦場）

### BinaryData コンストラクタ関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BinaryData(byte[])コンストラクタが存在しnullチェックを行う | E-01 (L60-63) | ○ |
| C-02 | BinaryData(byte[], string?)コンストラクタでMediaTypeが設定される | E-01 (L72-75) | ○ |
| C-03 | BinaryData(object?, JsonSerializerOptions?, Type?)でJSONシリアライズされる | E-01 (L90-94) | ○ |
| C-04 | BinaryData(object?, JsonSerializerContext, Type?)でAOT対応シリアライズ | E-01 (L107-111) | ○ |
| C-05 | BinaryData(ReadOnlyMemory<byte>)コンストラクタが存在する | E-01 (L118-121) | ○ |
| C-06 | BinaryData(ReadOnlyMemory<byte>, string?)でMediaTypeが設定される | E-01 (L130-133) | ○ |
| C-07 | BinaryData(string)でUTF-8エンコードされnullチェックを行う | E-01 (L140-145) | ○ |
| C-08 | BinaryData(string, string?)でMediaTypeが設定される | E-01 (L155-158) | ○ |

### プロパティ関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | Emptyプロパティが静的に定義されている | E-01 (L35) | ○ |
| C-10 | Lengthプロパティがバイト数を返す | E-01 (L41) | ○ |
| C-11 | IsEmptyプロパティが空かどうかを返す | E-01 (L47) | ○ |
| C-12 | MediaTypeプロパティがMIMEタイプを返す | E-01 (L53) | ○ |

### FromBytes関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | FromBytes(ReadOnlyMemory<byte>)が存在する | E-01 (L166) | ○ |
| C-14 | FromBytes(ReadOnlyMemory<byte>, string?)が存在する | E-01 (L177-178) | ○ |
| C-15 | FromBytes(byte[])が存在する | E-01 (L186) | ○ |
| C-16 | FromBytes(byte[], string?)が存在する | E-01 (L196-197) | ○ |

### FromString関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | FromString(string)が存在する | E-01 (L205) | ○ |
| C-18 | FromString(string, string?)が存在する | E-01 (L216-217) | ○ |

### FromStream関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | FromStream(Stream)がnullチェックを行う | E-01 (L238) | ○ |
| C-20 | FromStream(Stream, string?)でMediaType付き生成 | E-01 (L236-241) | ○ |
| C-21 | FromStreamAsync(Stream, CancellationToken)が存在する | E-01 (L250-251) | ○ |
| C-22 | FromStreamAsync(Stream, string?, CancellationToken)が存在する | E-01 (L263-269) | ○ |
| C-23 | ストリーム長がint.MaxValueを超える場合ArgumentOutOfRangeException | E-01 (L281-284) | ○ |

### FromFile関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | FromFile(string)がnullチェックを行う | E-01 (L326) | ○ |
| C-25 | FromFile(string, string?)でMediaType付き生成 | E-01 (L324-328) | ○ |
| C-26 | FromFileAsync(string, CancellationToken)がnullチェックを行う | E-01 (L352) | ○ |
| C-27 | FromFileAsync(string, string?, CancellationToken)が存在する | E-01 (L349-367) | ○ |

### FromObjectAsJson関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | FromObjectAsJson<T>(T, JsonSerializerOptions?)が存在する | E-01 (L381-382) | ○ |
| C-29 | FromObjectAsJson<T>(T, JsonTypeInfo<T>)が存在する | E-01 (L394-395) | ○ |

### インスタンスメソッド関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | WithMediaType(string?)で新しいインスタンスが生成される | E-01 (L403-404) | ○ |
| C-31 | ToString()でUTF-8デコードされる | E-01 (L419) | ○ |
| C-32 | ToStream()でReadOnlyMemoryStreamが返される | E-01 (L425) | ○ |
| C-33 | ToMemory()でReadOnlyMemory<byte>が返される | E-01 (L431) | ○ |
| C-34 | ToArray()でbyte配列が返される | E-01 (L437) | ○ |
| C-35 | ToObjectFromJson<T>(JsonSerializerOptions?)でBOMがトリムされる | E-01 (L450, L463-472) | ○ |
| C-36 | ToObjectFromJson<T>(JsonTypeInfo<T>)が存在する | E-01 (L460-461) | ○ |

### 演算子関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | implicit operator ReadOnlyMemory<byte>が定義されている | E-01 (L478) | ○ |
| C-38 | implicit operator ReadOnlySpan<byte>が定義されている | E-01 (L484-491) | ○ |
| C-39 | nullのBinaryDataがdefaultに変換される | E-01 (L478, L486-490) | ○ |

### Equals/GetHashCode関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | Equals(object?)が参照等価性を返す | E-01 (L501) | ○ |
| C-41 | GetHashCode()がbase.GetHashCode()を返す | E-01 (L505) | ○ |

### BinaryDataJsonConverter関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | BinaryDataJsonConverterクラスが存在する | E-02 (L9) | ○ |
| C-43 | Read()でBase64からBinaryDataを生成する | E-02 (L18-21) | ○ |
| C-44 | Write()でBase64文字列を出力する | E-02 (L24-27) | ○ |
| C-45 | BinaryDataにJsonConverter属性が付与されている | E-01 (L20) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードから直接確認可能な公開API・メソッドに基づいています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースはソースコードに明確な根拠があります
- 以下の点について実装確認を推奨：
  - ファイルI/O関連テスト（UT-SMD-038〜044）：実際のファイルシステム依存の動作確認
  - キャンセルトークン処理（UT-SMD-036）：非同期キャンセルの正確な動作仕様
  - エラーケース（UT-SMD-062, 075）：例外型の正確性

## 6) レビュアーチェックリスト（最小）
- [ ] テストケース番号（No）が1から連番になっているか
- [ ] テストIDが「UT-SMD-XXX」形式で連番になっているか
- [ ] 全ての公開コンストラクタ・メソッド・プロパティがカバーされているか
- [ ] 正常系・異常系・境界値の観点が網羅されているか
- [ ] 優先度の設定が適切か（金額計算やデータ整合性に関わるものが「高」になっているか）
- [ ] BinaryDataJsonConverterの読み取り・書き込みテストが含まれているか
- [ ] 暗黙変換演算子のテストが含まれているか
