---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 152
  claims_with_evidence: 152
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Memory 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：152 / 152、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードから直接導出
  2. 既存の.NETランタイムテストコードも参照
  3. 特に根拠不足の項目はなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/SequenceReader.cs` - SequenceReader<T>クラス実装
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/SequenceReader.Search.cs` - SequenceReader検索メソッド実装
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/ReadOnlySequence.cs` - ReadOnlySequence<T>クラス実装
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/ReadOnlySequence.Helpers.cs` - ReadOnlySequenceヘルパーメソッド
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/BuffersExtensions.cs` - BuffersExtensions拡張メソッド
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/MemoryPool.cs` - MemoryPool<T>抽象クラス
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/ArrayMemoryPool.cs` - ArrayMemoryPool<T>実装
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/ArrayMemoryPool.ArrayMemoryPoolBuffer.cs` - ArrayMemoryPoolBuffer内部クラス
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/SequenceReaderExtensions.Binary.cs` - バイナリ読み取り拡張メソッド
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/SequencePosition.cs` - SequencePosition構造体
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/ReadOnlySequenceSegment.cs` - ReadOnlySequenceSegment<T>抽象クラス
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Runtime/InteropServices/SequenceMarshal.cs` - SequenceMarshalユーティリティ
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Text/EncodingExtensions.cs` - Encoding拡張メソッド
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/Buffers/IBufferWriter.cs` - IBufferWriter<T>インターフェース
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Memory/src/System/ThrowHelper.cs` - 例外スローヘルパー

## 3) Claims と根拠の対応（レビューの主戦場）

### SequenceReader<T> 関連 (UT-MEM-001 - UT-MEM-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SequenceReader<T>コンストラクタが単一/マルチセグメントで動作 | E-01 (行19-37) | ○ |
| C-02 | Endプロパティが正しく終端を判定 | E-01 (行42) | ○ |
| C-03 | TryPeekメソッドが次の値をピーク | E-01 (行113-126, 134-184) | ○ |
| C-04 | TryReadメソッドが値を読み取り進行 | E-01 (行191-210) | ○ |
| C-05 | Rewindメソッドが巻き戻し動作 | E-01 (行218-243) | ○ |
| C-06 | Advanceメソッドが指定数進行 | E-01 (行313-327) | ○ |
| C-07 | TryCopyToメソッドがデータコピー | E-01 (行409-425, 427-455) | ○ |
| C-08 | TryReadTo系メソッドがデリミタ検索 | E-02 (行18-43, 54-81) | ○ |
| C-09 | TryReadToAnyメソッドが複数デリミタ対応 | E-02 (行327-355) | ○ |
| C-10 | TryReadExactメソッドが固定長読み取り | E-02 (行511-529) | ○ |
| C-11 | AdvancePast系メソッドがスキップ動作 | E-02 (行573-741) | ○ |
| C-12 | AdvanceToEndメソッドが末尾移動 | E-02 (行747-758) | ○ |
| C-13 | IsNextメソッドが照合動作 | E-02 (行766-849) | ○ |

### ReadOnlySequence<T> 関連 (UT-MEM-047 - UT-MEM-085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | ReadOnlySequence<T>コンストラクタが配列から作成 | E-03 (行113-122) | ○ |
| C-15 | ReadOnlySequence<T>コンストラクタが範囲指定で作成 | E-03 (行127-138) | ○ |
| C-16 | ReadOnlySequence<T>コンストラクタがReadOnlyMemoryから作成 | E-03 (行144-181) | ○ |
| C-17 | ReadOnlySequence<T>コンストラクタがセグメントリンクから作成 | E-03 (行94-108) | ○ |
| C-18 | Empty静的プロパティが空シーケンス返却 | E-03 (行26) | ○ |
| C-19 | Length/IsEmpty/IsSingleSegmentプロパティが正しい値返却 | E-03 (行31-45) | ○ |
| C-20 | First/FirstSpanプロパティが最初のセグメント返却 | E-03 (行50-55), E-04 (行81-154, 156-232) | ○ |
| C-21 | Start/Endプロパティが位置返却 | E-03 (行60-73) | ○ |
| C-22 | Sliceメソッド群がスライス動作 | E-03 (行189-486) | ○ |
| C-23 | ToStringメソッドが文字列変換 | E-03 (行489-508) | ○ |
| C-24 | GetEnumeratorメソッドが列挙子返却 | E-03 (行513, 618-651) | ○ |
| C-25 | GetPositionメソッドが位置返却 | E-03 (行518-524, 591-597) | ○ |
| C-26 | GetOffsetメソッドがオフセット返却 | E-03 (行536-586) | ○ |
| C-27 | TryGetメソッドがセグメント取得 | E-03 (行604-613), E-04 (行14-78) | ○ |

### BuffersExtensions 関連 (UT-MEM-086 - UT-MEM-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | PositionOfメソッドが値位置検索 | E-05 (行16-55) | ○ |
| C-29 | CopyToメソッドがデータコピー | E-05 (行62-97) | ○ |
| C-30 | ToArrayメソッドが配列変換 | E-05 (行102-107) | ○ |
| C-31 | Writeメソッドがバッファ書き込み | E-05 (行115-155) | ○ |

### MemoryPool<T> 関連 (UT-MEM-096 - UT-MEM-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | MemoryPool<T>.Sharedが共有インスタンス返却 | E-06 (行13-18) | ○ |
| C-33 | Rentメソッドがメモリレンタル | E-06 (行24), E-07 (行12-19) | ○ |
| C-34 | MaxBufferSizeプロパティが最大サイズ返却 | E-06 (行29), E-07 (行10) | ○ |
| C-35 | ArrayMemoryPoolBufferのMemoryプロパティが動作 | E-08 (行17-26) | ○ |
| C-36 | ArrayMemoryPoolBufferのDisposeが正常動作 | E-08 (行28-36) | ○ |

### SequenceReaderExtensions 関連 (UT-MEM-105 - UT-MEM-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | TryReadLittleEndianメソッドがリトルエンディアン読み取り | E-09 (行60-68, 99-107, 138-146) | ○ |
| C-38 | TryReadBigEndianメソッドがビッグエンディアン読み取り | E-09 (行74-82, 113-121, 152-160) | ○ |
| C-39 | マルチセグメント境界での読み取り動作 | E-09 (行37-54) | ○ |

### SequencePosition 関連 (UT-MEM-113 - UT-MEM-119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | コンストラクタが初期化動作 | E-10 (行21-25) | ○ |
| C-41 | GetObject/GetIntegerメソッドが値返却 | E-10 (行31, 37) | ○ |
| C-42 | Equalsメソッドが等価比較 | E-10 (行43, 50) | ○ |
| C-43 | GetHashCodeメソッドがハッシュ返却 | E-10 (行54) | ○ |

### ReadOnlySequenceSegment<T> 関連 (UT-MEM-120 - UT-MEM-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | Memory/Next/RunningIndexプロパティが動作 | E-11 (行14, 19, 24) | ○ |

### SequenceMarshal 関連 (UT-MEM-123 - UT-MEM-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | TryGetReadOnlySequenceSegmentメソッドがセグメント情報取得 | E-12 (行18-25) | ○ |
| C-46 | TryGetArrayメソッドがArraySegment取得 | E-12 (行31-34) | ○ |
| C-47 | TryGetReadOnlyMemoryメソッドがMemory取得 | E-12 (行40-50) | ○ |
| C-48 | TryReadメソッドが構造体読み取り | E-12 (行73-76) | ○ |

### EncodingExtensions 関連 (UT-MEM-131 - UT-MEM-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | GetBytesメソッドがエンコード動作 | E-13 (行34-58, 70-87, 100-132, 142-213) | ○ |
| C-50 | GetCharsメソッドがデコード動作 | E-13 (行225-248, 261-278, 291-323) | ○ |
| C-51 | GetStringメソッドが文字列デコード | E-13 (行333-398) | ○ |
| C-52 | Convertメソッド群が変換動作 | E-13 (行414-446, 461-491, 507-539, 555-585) | ○ |

### IBufferWriter<T> 関連 (UT-MEM-145 - UT-MEM-149)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | Advanceメソッドが書き込み位置進行 | E-14 (行17) | ○ |
| C-54 | GetMemory/GetSpanメソッドがバッファ取得 | E-14 (行33, 49) | ○ |

### Enumerator 関連 (UT-MEM-150 - UT-MEM-152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | MoveNext/Currentが列挙動作 | E-03 (行618-651) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全テストケースはソースコードから直接導出されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードの実装に基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースIDが連番で重複がないことを確認
- [ ] 高優先度のテストケースが重要なロジック（境界処理、例外処理）をカバーしているか確認
- [ ] マルチセグメント関連のテストが十分にカバーされているか確認
- [ ] バイナリ読み取り（エンディアン）のテストが両方向をカバーしているか確認
- [ ] Dispose後のアクセスに関するテストが含まれているか確認
- [ ] バリデーション（null、範囲外、負の値）のテストが網羅されているか確認
