---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Net.Http.Json 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-NHJ-024（タイムアウト処理）**：タイムアウト時の例外チェーン構造は実装コードから推測
  2. **UT-NHJ-026（バッファ制限）**：MaxResponseContentBufferSizeの具体的な挙動は実行時動作に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/JsonContent.cs` - JsonContentクラスの実装
- E-02: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/JsonContent.netcoreapp.cs` - JsonContentの.NET Core固有実装
- E-03: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpClientJsonExtensions.cs` - HttpClient拡張メソッドのコア実装
- E-04: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpClientJsonExtensions.Get.cs` - GetFromJsonAsync拡張メソッド
- E-05: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpClientJsonExtensions.Post.cs` - PostAsJsonAsync拡張メソッド
- E-06: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpClientJsonExtensions.Put.cs` - PutAsJsonAsync拡張メソッド
- E-07: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpClientJsonExtensions.Delete.cs` - DeleteFromJsonAsync拡張メソッド
- E-08: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpClientJsonExtensions.Patch.cs` - PatchAsJsonAsync拡張メソッド
- E-09: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpClientJsonExtensions.Get.AsyncEnumerable.cs` - GetFromJsonAsAsyncEnumerable拡張メソッド
- E-10: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpContentJsonExtensions.cs` - HttpContent拡張メソッドのコア実装
- E-11: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpContentJsonExtensions.netcoreapp.cs` - HttpContent拡張の.NET Core固有実装
- E-12: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/HttpContentJsonExtensions.AsyncEnumerable.cs` - ReadFromJsonAsAsyncEnumerable拡張メソッド
- E-13: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/JsonHelpers.cs` - JSONヘルパーユーティリティ
- E-14: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/TranscodingReadStream.cs` - 読み込み用トランスコーディングストリーム
- E-15: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/TranscodingWriteStream.cs` - 書き込み用トランスコーディングストリーム
- E-16: `src/libraries/System.Net.Http.Json/src/System/Net/Http/Json/LengthLimitReadStream.cs` - 長さ制限付き読み込みストリーム
- E-17: `src/libraries/System.Net.Http.Json/src/System/ArraySegmentExtensions.netstandard.cs` - ArraySegment拡張メソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-NHJ-001) | JsonContent.Create<T>でジェネリック型のJsonContentが作成される | E-01 L53-54 | ○ |
| C-02 (UT-NHJ-002) | カスタムMediaTypeがContent-Typeヘッダーに設定される | E-01 L33-40 | ○ |
| C-03 (UT-NHJ-003) | JsonSerializerOptionsが正しく適用される | E-01 L53-54, E-13 L17-26 | ○ |
| C-04 (UT-NHJ-004) | null値でJsonContentが作成可能 | E-01 L27-28 | ○ |
| C-05 (UT-NHJ-005) | Type指定でJsonContentが作成される | E-01 L66-72 | ○ |
| C-06 (UT-NHJ-006) | inputTypeがnullの場合ArgumentNullException | E-01 L68 | ○ |
| C-07 (UT-NHJ-007) | 型互換性がない場合ArgumentException | E-01 L165-170 | ○ |
| C-08 (UT-NHJ-008) | JsonTypeInfo指定でJsonContentが作成される | E-01 L82-87 | ○ |
| C-09 (UT-NHJ-009) | jsonTypeInfoがnullの場合ArgumentNullException | E-01 L84 | ○ |
| C-10 (UT-NHJ-010) | 非ジェネリックJsonTypeInfoでJsonContentが作成される | E-01 L96-102 | ○ |
| C-11 (UT-NHJ-011) | jsonTypeInfoがnullの場合ArgumentNullException | E-01 L98 | ○ |
| C-12 (UT-NHJ-012) | ObjectTypeプロパティが正しい型を返す | E-01 L19 | ○ |
| C-13 (UT-NHJ-013) | Valueプロパティが正しい値を返す | E-01 L20 | ○ |
| C-14 (UT-NHJ-014) | UTF-8でストリームにシリアライズされる | E-01 L117-119 | ○ |
| C-15 (UT-NHJ-015) | 非UTF-8でトランスコーディングされる | E-01 L117-118, L122-163 | ○ |
| C-16 (UT-NHJ-016) | TryComputeLengthは常にfalseを返す | E-01 L107-111 | ○ |
| C-17 (UT-NHJ-017) | GetFromJsonAsync<T>で文字列URIからデシリアライズ | E-04 L23-24 | ○ |
| C-18 (UT-NHJ-018) | GetFromJsonAsync<T>でUri型からデシリアライズ | E-04 L28-29 | ○ |
| C-19 (UT-NHJ-019) | JsonSerializerOptions指定でデシリアライズ | E-04 L33-39 | ○ |
| C-20 (UT-NHJ-020) | JsonTypeInfo指定でデシリアライズ | E-04 L47-51 | ○ |
| C-21 (UT-NHJ-021) | JsonSerializerContext指定でデシリアライズ | E-04 L41-45 | ○ |
| C-22 (UT-NHJ-022) | clientがnullの場合ArgumentNullException | E-03 L41 | ○ |
| C-23 (UT-NHJ-023) | HTTPエラーステータスでHttpRequestException | E-03 L84 | ○ |
| C-24 (UT-NHJ-024) | タイムアウト時の例外処理 | E-03 L93-101 | △ |
| C-25 (UT-NHJ-025) | キャンセル時のOperationCanceledException | E-03 L93-102 | ○ |
| C-26 (UT-NHJ-026) | バッファサイズ超過時のHttpRequestException | E-03 L121-126, E-16 L31-33 | △ |
| C-27 (UT-NHJ-027) | Type指定でデシリアライズ | E-04 L55-61 | ○ |
| C-28 (UT-NHJ-028) | PostAsJsonAsync<T>で文字列URIにPOST | E-05 L16-22 | ○ |
| C-29 (UT-NHJ-029) | PostAsJsonAsync<T>でUri型にPOST | E-05 L26-32 | ○ |
| C-30 (UT-NHJ-030) | JsonSerializerOptions指定でPOST | E-05 L16-22 | ○ |
| C-31 (UT-NHJ-031) | JsonTypeInfo指定でPOST | E-05 L44-50 | ○ |
| C-32 (UT-NHJ-032) | clientがnullの場合ArgumentNullException | E-05 L18 | ○ |
| C-33 (UT-NHJ-033) | PutAsJsonAsync<T>で文字列URIにPUT | E-06 L16-22 | ○ |
| C-34 (UT-NHJ-034) | PutAsJsonAsync<T>でUri型にPUT | E-06 L26-32 | ○ |
| C-35 (UT-NHJ-035) | JsonTypeInfo指定でPUT | E-06 L44-50 | ○ |
| C-36 (UT-NHJ-036) | clientがnullの場合ArgumentNullException | E-06 L18 | ○ |
| C-37 (UT-NHJ-037) | PatchAsJsonAsync<T>で文字列URIにPATCH | E-08 L27-33 | ○ |
| C-38 (UT-NHJ-038) | PatchAsJsonAsync<T>でUri型にPATCH | E-08 L48-54 | ○ |
| C-39 (UT-NHJ-039) | JsonTypeInfo指定でPATCH | E-08 L97-103 | ○ |
| C-40 (UT-NHJ-040) | clientがnullの場合ArgumentNullException | E-08 L29 | ○ |
| C-41 (UT-NHJ-041) | DeleteFromJsonAsync<T>で文字列URIからDELETE | E-07 L33-34 | ○ |
| C-42 (UT-NHJ-042) | DeleteFromJsonAsync<T>でUri型からDELETE | E-07 L48-49 | ○ |
| C-43 (UT-NHJ-043) | JsonTypeInfo指定でDELETE | E-07 L117-131 | ○ |
| C-44 (UT-NHJ-044) | clientがnullの場合ArgumentNullException | E-03 L41 | ○ |
| C-45 (UT-NHJ-045) | GetFromJsonAsAsyncEnumerable<T>で文字列URIから | E-09 L31-36 | ○ |
| C-46 (UT-NHJ-046) | GetFromJsonAsAsyncEnumerable<T>でUri型から | E-09 L51-56 | ○ |
| C-47 (UT-NHJ-047) | JsonTypeInfo指定でストリーミング | E-09 L69-92 | ○ |
| C-48 (UT-NHJ-048) | clientがnullの場合ArgumentNullException | E-09 L149 | ○ |
| C-49 (UT-NHJ-049) | ReadFromJsonAsync<T>でHttpContentからデシリアライズ | E-10 L61-66 | ○ |
| C-50 (UT-NHJ-050) | JsonSerializerOptions指定でデシリアライズ | E-10 L61-66 | ○ |
| C-51 (UT-NHJ-051) | JsonTypeInfo指定でデシリアライズ | E-10 L109-114 | ○ |
| C-52 (UT-NHJ-052) | contentがnullの場合ArgumentNullException | E-10 L63, L111 | ○ |
| C-53 (UT-NHJ-053) | 非UTF-8でトランスコーディング | E-10 L132-147 | ○ |
| C-54 (UT-NHJ-054) | Type指定でデシリアライズ | E-10 L30-35 | ○ |
| C-55 (UT-NHJ-055) | JsonSerializerContext指定でデシリアライズ | E-10 L102-107 | ○ |
| C-56 (UT-NHJ-056) | ReadFromJsonAsAsyncEnumerable<T>でストリーミング | E-12 L30-33 | ○ |
| C-57 (UT-NHJ-057) | JsonSerializerOptions指定でストリーミング | E-12 L50-58 | ○ |
| C-58 (UT-NHJ-058) | JsonTypeInfo指定でストリーミング | E-12 L72-80 | ○ |
| C-59 (UT-NHJ-059) | contentがnullの場合ArgumentNullException | E-12 L55, L77 | ○ |
| C-60 (UT-NHJ-060) | GetJsonTypeInfoで指定された型のJsonTypeInfo取得 | E-13 L17-26 | ○ |
| C-61 (UT-NHJ-061) | JsonSerializerOptions指定でJsonTypeInfo取得 | E-13 L17-26 | ○ |
| C-62 (UT-NHJ-062) | Content-Typeのcharsetからエンコーディング取得 | E-13 L30-57 | ○ |
| C-63 (UT-NHJ-063) | 引用符付きcharsetの解析 | E-13 L39-41 | ○ |
| C-64 (UT-NHJ-064) | charsetなしの場合null返却 | E-13 L31-56 | ○ |
| C-65 (UT-NHJ-065) | 無効なcharsetでInvalidOperationException | E-13 L48-51 | ○ |
| C-66 (UT-NHJ-066) | TranscodingReadStreamの初期化 | E-14 L32-49 | ○ |
| C-67 (UT-NHJ-067) | 非UTF-8からUTF-8への変換読み込み | E-14 L96-161 | ○ |
| C-68 (UT-NHJ-068) | 空バッファで0返却 | E-14 L98-101 | ○ |
| C-69 (UT-NHJ-069) | bufferがnullでArgumentNullException | E-14 L72-74 | ○ |
| C-70 (UT-NHJ-070) | offsetが負でArgumentOutOfRangeException | E-14 L76-79 | ○ |
| C-71 (UT-NHJ-071) | countが負でArgumentOutOfRangeException | E-14 L81-84 | ○ |
| C-72 (UT-NHJ-072) | buffer.Length - offset < countでArgumentException | E-14 L86-89 | ○ |
| C-73 (UT-NHJ-073) | オーバーフローバッファ処理 | E-14 L141-160 | ○ |
| C-74 (UT-NHJ-074) | CanReadはtrue | E-14 L52 | ○ |
| C-75 (UT-NHJ-075) | CanSeekはfalse | E-14 L53 | ○ |
| C-76 (UT-NHJ-076) | CanWriteはfalse | E-14 L54 | ○ |
| C-77 (UT-NHJ-077) | LengthでNotSupportedException | E-14 L55 | ○ |
| C-78 (UT-NHJ-078) | Position getでNotSupportedException | E-14 L59 | ○ |
| C-79 (UT-NHJ-079) | Position setでNotSupportedException | E-14 L60 | ○ |
| C-80 (UT-NHJ-080) | ReadでNotSupportedException | E-14 L67-68 | ○ |
| C-81 (UT-NHJ-081) | FlushでNotSupportedException | E-14 L193-194 | ○ |
| C-82 (UT-NHJ-082) | SeekでNotSupportedException | E-14 L196-197 | ○ |
| C-83 (UT-NHJ-083) | SetLengthでNotSupportedException | E-14 L199-200 | ○ |
| C-84 (UT-NHJ-084) | WriteでNotSupportedException | E-14 L202-203 | ○ |
| C-85 (UT-NHJ-085) | Disposeでリソース解放 | E-14 L205-228 | ○ |
| C-86 (UT-NHJ-086) | TranscodingWriteStreamの初期化 | E-15 L30-43 | ○ |
| C-87 (UT-NHJ-087) | UTF-8から非UTF-8への変換書き込み | E-15 L95-108 | ○ |
| C-88 (UT-NHJ-088) | bufferがnullでArgumentNullException | E-15 L71-73 | ○ |
| C-89 (UT-NHJ-089) | offsetが負でArgumentOutOfRangeException | E-15 L75-78 | ○ |
| C-90 (UT-NHJ-090) | countが負でArgumentOutOfRangeException | E-15 L80-83 | ○ |
| C-91 (UT-NHJ-091) | buffer.Length - offset < countでArgumentException | E-15 L85-88 | ○ |
| C-92 (UT-NHJ-092) | FinalWriteAsyncでエンコーダーフラッシュ | E-15 L142-157 | ○ |
| C-93 (UT-NHJ-093) | FlushAsyncで内部ストリームフラッシュ | E-15 L54-55 | ○ |
| C-94 (UT-NHJ-094) | CanReadはfalse | E-15 L45 | ○ |
| C-95 (UT-NHJ-095) | CanSeekはfalse | E-15 L46 | ○ |
| C-96 (UT-NHJ-096) | CanWriteはtrue | E-15 L47 | ○ |
| C-97 (UT-NHJ-097) | FlushでNotSupportedException | E-15 L51-52 | ○ |
| C-98 (UT-NHJ-098) | ReadでNotSupportedException | E-15 L57-58 | ○ |
| C-99 (UT-NHJ-099) | SeekでNotSupportedException | E-15 L60-61 | ○ |
| C-100 (UT-NHJ-100) | SetLengthでNotSupportedException | E-15 L63-64 | ○ |
| C-101 (UT-NHJ-101) | WriteでNotSupportedException | E-15 L66-67 | ○ |
| C-102 (UT-NHJ-102) | Disposeでリソース解放 | E-15 L131-140 | ○ |
| C-103 (UT-NHJ-103) | LengthLimitReadStreamの初期化 | E-16 L16-19 | ○ |
| C-104 (UT-NHJ-104) | 制限内で正常に読み込み | E-16 L44-68 | ○ |
| C-105 (UT-NHJ-105) | 制限超過でHttpRequestException | E-16 L22-28, L31-33 | ○ |
| C-106 (UT-NHJ-106) | 同期読み込みが動作 | E-16 L78-83 | ○ |
| C-107 (UT-NHJ-107) | 同期読み込みで制限超過時HttpRequestException | E-16 L78-83, L22-28 | ○ |
| C-108 (UT-NHJ-108) | ThrowExceededBufferLimitでHttpRequestException | E-16 L31-33 | ○ |
| C-109 (UT-NHJ-109) | CanReadは内部ストリーム委譲 | E-16 L36 | ○ |
| C-110 (UT-NHJ-110) | CanSeekは内部ストリーム委譲 | E-16 L37 | ○ |
| C-111 (UT-NHJ-111) | CanWriteはfalse | E-16 L38 | ○ |
| C-112 (UT-NHJ-112) | WriteでNotSupportedException | E-16 L92 | ○ |
| C-113 (UT-NHJ-113) | Flushは内部ストリーム委譲 | E-16 L85 | ○ |
| C-114 (UT-NHJ-114) | Seekは内部ストリーム委譲 | E-16 L87 | ○ |
| C-115 (UT-NHJ-115) | SetLengthは内部ストリーム委譲 | E-16 L88 | ○ |
| C-116 (UT-NHJ-116) | Lengthは内部ストリーム委譲 | E-16 L89 | ○ |
| C-117 (UT-NHJ-117) | Positionは内部ストリーム委譲 | E-16 L90 | ○ |
| C-118 (UT-NHJ-118) | ArraySegment.Slice(int)でスライス | E-17 L8-11 | ○ |
| C-119 (UT-NHJ-119) | ArraySegment.Slice(int, int)でスライス | E-17 L13-16 | ○ |
| C-120 (UT-NHJ-120) | ArraySegment.CopyToでコピー | E-17 L18-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-NHJ-024（タイムアウト処理）**: コードからタイムアウト時にTaskCanceledExceptionがスローされることは確認できるが、TimeoutExceptionが内包されるかはプラットフォーム依存（.NET vs .NET Framework）で異なる可能性がある
  - 候補：実際のテスト実行による動作確認 / .NET Runtimeのドキュメント
- **UT-NHJ-026（バッファ制限）**: MaxResponseContentBufferSizeの超過判定はContent-Lengthヘッダーとストリーム読み込み時の両方で行われるが、Content-Lengthがない場合の挙動は実行時テストが必要
  - 候補：HttpClientの仕様ドキュメント / 実際のテスト実行

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接導出可能
- 1: 中リスク - タイムアウト処理とバッファ制限のテストケースは実行環境依存の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-NHJ-xxx）が一貫しているか
- [ ] 正常系/異常系/境界値の観点が適切に網羅されているか
- [ ] 引数検証（ArgumentNullException等）のテストケースが全publicメソッドに対して存在するか
- [ ] ソースジェネレーター対応（JsonTypeInfo）のテストケースが主要メソッドに存在するか
- [ ] TranscodingReadStream/TranscodingWriteStreamの内部クラスに対するテストが十分か
- [ ] タイムアウト処理（UT-NHJ-024）の期待結果が.NETバージョンに依存しないか確認
