---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 143
  claims_with_evidence: 143
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Net.Http.WinHttpHandler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：143 / 143、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpHandler.cs`
- E-02: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpRequestStream.cs`
- E-03: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpResponseStream.cs`
- E-04: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpException.cs`
- E-05: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpResponseParser.cs`
- E-06: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpRequestState.cs`
- E-07: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpResponseHeaderReader.cs`
- E-08: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpAuthHelper.cs`
- E-09: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpCookieContainerAdapter.cs`
- E-10: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpTransportContext.cs`
- E-11: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpChannelBinding.cs`
- E-12: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpTrailersHelper.cs`
- E-13: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/NoWriteNoSeekStreamContent.cs`
- E-14: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/CachedCertificateValue.cs`
- E-15: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpChunkMode.cs`
- E-16: `src/libraries/System.Net.Http.WinHttpHandler/src/System/Net/Http/WinHttpTraceHelper.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### WinHttpHandler クラス（UT-WHH-001〜UT-WHH-043）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AutomaticRedirection setterでCheckDisposedOrStartedが呼ばれる | E-01 (L148) | ○ |
| C-02 | 操作開始後のプロパティ設定でInvalidOperationExceptionがスローされる | E-01 (L1596-1601) | ○ |
| C-03 | MaxAutomaticRedirectionsは正の整数のみ許可される | E-01 (L162-168) | ○ |
| C-04 | MaxAutomaticRedirections=0でArgumentOutOfRangeExceptionがスローされる | E-01 (L164-167) | ○ |
| C-05 | MaxAutomaticRedirections=1は有効な最小値 | E-01 (L162) | ○ |
| C-06 | CookieUsePolicyは定義された列挙値のみ許可される | E-01 (L198-203) | ○ |
| C-07 | 不正なCookieUsePolicy値でArgumentOutOfRangeExceptionがスローされる | E-01 (L202) | ○ |
| C-08 | ClientCertificateOptionは定義された列挙値のみ許可される | E-01 (L282-286) | ○ |
| C-09 | 不正なClientCertificateOption値でArgumentOutOfRangeExceptionがスローされる | E-01 (L285) | ○ |
| C-10 | ClientCertificatesはClientCertificateOption=Manualの場合のみアクセス可能 | E-01 (L297-299) | ○ |
| C-11 | WindowsProxyUsePolicyは定義された列挙値のみ許可される | E-01 (L341-347) | ○ |
| C-12 | 不正なWindowsProxyUsePolicy値でArgumentOutOfRangeExceptionがスローされる | E-01 (L346) | ○ |
| C-13 | MaxConnectionsPerServerは正の整数のみ許可される | E-01 (L391-399) | ○ |
| C-14 | MaxConnectionsPerServer=0でArgumentOutOfRangeExceptionがスローされる | E-01 (L395-398) | ○ |
| C-15 | SendTimeoutはCheckTimeSpanPropertyValueでバリデーションされる | E-01 (L415) | ○ |
| C-16 | TimeSpan.ZeroでArgumentOutOfRangeExceptionがスローされる | E-01 (L1604-1609) | ○ |
| C-17 | Timeout.InfiniteTimeSpanは許可される | E-01 (L1606) | ○ |
| C-18 | ReceiveHeadersTimeoutはCheckTimeSpanPropertyValueでバリデーションされる | E-01 (L430) | ○ |
| C-19 | ReceiveDataTimeoutはCheckTimeSpanPropertyValueでバリデーションされる | E-01 (L445) | ○ |
| C-20 | TcpKeepAliveEnabledはCheckDisposedOrStartedを呼ぶ | E-01 (L468) | ○ |
| C-21 | TcpKeepAliveTimeはCheckTimeSpanPropertyValueでバリデーションされる | E-01 (L489) | ○ |
| C-22 | TcpKeepAliveIntervalはCheckTimeSpanPropertyValueでバリデーションされる | E-01 (L510) | ○ |
| C-23 | MaxResponseHeadersLengthは正の整数のみ許可される | E-01 (L526-532) | ○ |
| C-24 | MaxResponseHeadersLength=0でArgumentOutOfRangeExceptionがスローされる | E-01 (L528-531) | ○ |
| C-25 | MaxResponseDrainSizeは正の整数のみ許可される | E-01 (L547-554) | ○ |
| C-26 | MaxResponseDrainSize=0でArgumentOutOfRangeExceptionがスローされる | E-01 (L549-553) | ○ |
| C-27 | DisposeでsessionHandleとcertificateCleanupTimerがDisposeされる | E-01 (L577-588) | ○ |
| C-28 | Disposeは冪等である（Interlocked.CompareExchange使用） | E-01 (L579) | ○ |
| C-29 | SendAsyncでnullリクエストでArgumentNullExceptionがスローされる | E-01 (L595) | ○ |
| C-30 | SendAsyncで相対URIでInvalidOperationExceptionがスローされる | E-01 (L598-601) | ○ |
| C-31 | SendAsyncでHTTP/HTTPS以外のスキームでNotSupportedExceptionがスローされる | E-01 (L603-606) | ○ |
| C-32 | UseCustomProxyでProxy=nullでInvalidOperationExceptionがスローされる | E-01 (L614-617) | ○ |
| C-33 | UseSpecifiedCookieContainerでCookieContainer=nullでInvalidOperationExceptionがスローされる | E-01 (L619-623) | ○ |
| C-34 | Dispose後のSendAsyncでObjectDisposedExceptionがスローされる | E-01 (L625, L1587-1592) | ○ |
| C-35 | GetChunkedModeForSendでTransferEncodingChunked=trueでManualモードが返される | E-01 (L662-665) | ○ |
| C-36 | GetChunkedModeForSendでContentLength設定時はNoneモードが維持される | E-01 (L671-672) | ○ |
| C-37 | GetChunkedModeForSendでHTTP/2でContentLength未設定時はAutomaticモードが返される | E-01 (L688-691) | ○ |
| C-38 | GetChunkedModeForSendでContent=null, TransferEncodingChunked=trueでInvalidOperationExceptionがスローされる | E-01 (L705-708) | ○ |
| C-39 | GetCertificateFromCacheでキャッシュヒット時にtrueと証明書データが返される | E-01 (L1708-1718) | ○ |
| C-40 | GetCertificateFromCacheでキャッシュミス時にfalseが返される | E-01 (L1717-1718) | ○ |
| C-41 | AddCertificateToCacheで証明書がキャッシュに追加される | E-01 (L1721-1727) | ○ |
| C-42 | TryRemoveCertificateFromCacheで証明書が削除される | E-01 (L1729-1737) | ○ |
| C-43 | TryRemoveCertificateFromCacheで存在しないキーでfalseが返される | E-01 (L1731) | ○ |

### WinHttpRequestStream クラス（UT-WHH-044〜UT-WHH-062）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | CanReadは常にfalseを返す | E-02 (L38-43) | ○ |
| C-45 | CanSeekは常にfalseを返す | E-02 (L46-51) | ○ |
| C-46 | CanWriteはDispose前はtrueを返す | E-02 (L54-58) | ○ |
| C-47 | CanWriteはDispose後はfalseを返す | E-02 (L58) | ○ |
| C-48 | LengthでNotSupportedExceptionがスローされる | E-02 (L62-68) | ○ |
| C-49 | Position getでNotSupportedExceptionがスローされる | E-02 (L71-76) | ○ |
| C-50 | Position setでNotSupportedExceptionがスローされる | E-02 (L79-83) | ○ |
| C-51 | WriteAsyncでnullバッファでArgumentNullExceptionがスローされる | E-02 (L100) | ○ |
| C-52 | WriteAsyncで負のオフセットでArgumentOutOfRangeExceptionがスローされる | E-02 (L102-105) | ○ |
| C-53 | WriteAsyncで負のカウントでArgumentOutOfRangeExceptionがスローされる | E-02 (L107-110) | ○ |
| C-54 | WriteAsyncでバッファ超過でArgumentExceptionがスローされる | E-02 (L112-115) | ○ |
| C-55 | WriteAsyncでDispose後にObjectDisposedExceptionがスローされる | E-02 (L124, L184-189) | ○ |
| C-56 | WriteAsyncでキャンセル済みトークンでキャンセルされたTaskが返される | E-02 (L117-122) | ○ |
| C-57 | WriteAsyncで同時書き込みでInvalidOperationExceptionがスローされる | E-02 (L126-130) | ○ |
| C-58 | SeekでNotSupportedExceptionがスローされる | E-02 (L146-150) | ○ |
| C-59 | SetLengthでNotSupportedExceptionがスローされる | E-02 (L152-156) | ○ |
| C-60 | ReadでNotSupportedExceptionがスローされる | E-02 (L158-162) | ○ |
| C-61 | FlushAsyncでキャンセル済みトークンでキャンセルされたTaskが返される | E-02 (L93) | ○ |
| C-62 | FlushAsyncで正常時にCompletedTaskが返される | E-02 (L95) | ○ |

### WinHttpResponseStream クラス（UT-WHH-063〜UT-WHH-084）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | CanReadはDispose前はtrueを返す | E-03 (L32-37) | ○ |
| C-64 | CanReadはDispose後はfalseを返す | E-03 (L36) | ○ |
| C-65 | CanSeekは常にfalseを返す | E-03 (L40-45) | ○ |
| C-66 | CanWriteは常にfalseを返す | E-03 (L48-53) | ○ |
| C-67 | LengthでNotSupportedExceptionがスローされる | E-03 (L56-62) | ○ |
| C-68 | Position getでNotSupportedExceptionがスローされる | E-03 (L65-70) | ○ |
| C-69 | Position setでNotSupportedExceptionがスローされる | E-03 (L73-77) | ○ |
| C-70 | ReadAsyncでnullバッファでArgumentNullExceptionがスローされる | E-03 (L174) | ○ |
| C-71 | ReadAsyncで負のオフセットでArgumentOutOfRangeExceptionがスローされる | E-03 (L176-179) | ○ |
| C-72 | ReadAsyncで負のカウントでArgumentOutOfRangeExceptionがスローされる | E-03 (L181-184) | ○ |
| C-73 | ReadAsyncでバッファ超過でArgumentExceptionがスローされる | E-03 (L186-189) | ○ |
| C-74 | ReadAsyncでDispose後にObjectDisposedExceptionがスローされる | E-03 (L196, L332-337) | ○ |
| C-75 | ReadAsyncでcount=0の場合0が返される | E-03 (L209-212) | ○ |
| C-76 | ReadAsyncでキャンセル済みトークンでキャンセルされたTaskが返される | E-03 (L191-194) | ○ |
| C-77 | ReadAsyncで同時読み取りでInvalidOperationExceptionがスローされる | E-03 (L214-217) | ○ |
| C-78 | CopyToAsyncでキャンセル済みトークンでキャンセルされたTaskが返される | E-03 (L98-101) | ○ |
| C-79 | CopyToAsyncで同時読み取りでInvalidOperationExceptionがスローされる | E-03 (L110-113) | ○ |
| C-80 | SeekでNotSupportedExceptionがスローされる | E-03 (L295-299) | ○ |
| C-81 | SetLengthでNotSupportedExceptionがスローされる | E-03 (L301-305) | ○ |
| C-82 | WriteでNotSupportedExceptionがスローされる | E-03 (L307-311) | ○ |
| C-83 | Disposeで_requestHandleがDisposeされる | E-03 (L313-329) | ○ |
| C-84 | Disposeは冪等である | E-03 (L315-317) | ○ |

### WinHttpException クラス（UT-WHH-085〜UT-WHH-089）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | コンストラクタでHResultが設定される | E-04 (L15-18) | ○ |
| C-86 | CONNECTION_ERRORがCONNECTION_RESETに変換される | E-04 (L33-46) | ○ |
| C-87 | その他のエラーがHRESULT_FROM_WIN32で変換される | E-04 (L45) | ○ |
| C-88 | CreateExceptionUsingErrorで例外が作成される | E-04 (L59-64) | ○ |
| C-89 | GetErrorMessageでフォーマットされたメッセージが返される | E-04 (L73-82) | ○ |

### WinHttpResponseParser クラス（UT-WHH-090〜UT-WHH-093）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | CreateResponseMessageでHttpResponseMessageが作成される | E-05 (L18-80) | ○ |
| C-91 | GetResponseHeaderNumberInfoで数値ヘッダー情報が取得できる | E-05 (L85-102) | ○ |
| C-92 | GetResponseHeaderCharBufferLengthでバッファ長が取得できる | E-05 (L206-232) | ○ |
| C-93 | GetResponseHeaderCharBufferLengthでトレーリングヘッダーのバッファ長が取得できる | E-05 (L213-216) | ○ |

### WinHttpResponseHeaderReader 構造体（UT-WHH-094〜UT-WHH-098）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | ReadHeaderでヘッダーが解析される | E-07 (L32-71) | ○ |
| C-95 | 空行がスキップされる | E-07 (L37-40) | ○ |
| C-96 | コロンのない行がスキップされる | E-07 (L44-48) | ○ |
| C-97 | ReadLineで行が読み取られる | E-07 (L88-114) | ○ |
| C-98 | 最後の行が正しく読み取られる | E-07 (L103-108) | ○ |

### WinHttpRequestState クラス（UT-WHH-099〜UT-WHH-107）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | PinでGCHandleが割り当てられる | E-06 (L42-51) | ○ |
| C-100 | 二重ピン留めで再割り当てされない | E-06 (L44) | ○ |
| C-101 | FromIntPtrで状態オブジェクトが取得できる | E-06 (L53-57) | ○ |
| C-102 | ClearSendRequestStateで状態がクリアされる | E-06 (L71-94) | ○ |
| C-103 | PinReceiveBufferでバッファがピン留めされる | E-06 (L162-173) | ○ |
| C-104 | 同じバッファで再ピン留めされない | E-06 (L164) | ○ |
| C-105 | PinSendBufferでバッファがピン留めされる | E-06 (L175-186) | ○ |
| C-106 | Disposeでリソースが解放される | E-06 (L189-228) | ○ |
| C-107 | Disposeは冪等である | E-06 (L199-202) | ○ |

### WinHttpAuthHelper クラス（UT-WHH-108〜UT-WHH-116）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | 401レスポンスで認証リトライフラグが設定される | E-08 (L71-115) | ○ |
| C-109 | 407レスポンスでプロキシ認証リトライフラグが設定される | E-08 (L117-162) | ○ |
| C-110 | 認証情報なしの401でRetryRequest=falseのまま | E-08 (L72-78) | ○ |
| C-111 | PreAuthenticateRequestでキャッシュされた認証情報が適用される | E-08 (L174-236) | ○ |
| C-112 | GetServerCredentialsFromCacheでキャッシュから認証情報が取得できる | E-08 (L238-264) | ○ |
| C-113 | GetServerCredentialsFromCacheでキャッシュにない場合falseが返される | E-08 (L263) | ○ |
| C-114 | SaveServerCredentialsToCache で認証情報がキャッシュに保存される | E-08 (L266-286) | ○ |
| C-115 | 重複追加で例外がスローされない（ArgumentException catch） | E-08 (L280-283) | ○ |
| C-116 | ChangeDefaultCredentialsPolicyでポリシーが変更される | E-08 (L288-309) | ○ |

### WinHttpCookieContainerAdapter クラス（UT-WHH-117〜UT-WHH-120）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | GetCookieHeaderでCookieヘッダーが生成される | E-09 (L88-101) | ○ |
| C-118 | GetCookieHeaderでCookieがない場合nullが返される | E-09 (L95-98) | ○ |
| C-119 | AddResponseCookiesToContainerでSet-CookieがCookieContainerに追加される | E-09 (L16-47) | ○ |
| C-120 | マルフォームドCookieが無視される（CookieException catch） | E-09 (L41-45) | ○ |

### WinHttpTransportContext クラス（UT-WHH-121〜UT-WHH-123）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | GetChannelBindingでEndpoint種別の場合ChannelBindingが返される | E-10 (L19-28) | ○ |
| C-122 | GetChannelBindingでEndpoint以外の場合nullが返される | E-10 (L27) | ○ |
| C-123 | SetChannelBindingでChannelBindingが設定される | E-10 (L30-42) | ○ |

### WinHttpChannelBinding クラス（UT-WHH-124〜UT-WHH-129）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | IsInvalidでサイズ0の場合trueが返される | E-11 (L40-46) | ○ |
| C-125 | IsInvalidでサイズが0より大きい場合falseが返される | E-11 (L44) | ○ |
| C-126 | Sizeで正しいサイズが返される | E-11 (L48-54) | ○ |
| C-127 | ToStringでバイト配列の16進文字列が返される | E-11 (L56-66) | ○ |
| C-128 | ToStringでIsInvalid時にnullが返される | E-11 (L58) | ○ |
| C-129 | ReleaseHandleでハンドルが解放される | E-11 (L68-74) | ○ |

### NoWriteNoSeekStreamContent クラス（UT-WHH-130〜UT-WHH-134）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | SerializeToStreamAsyncでストリームがコピーされる | E-13 (L37-62) | ○ |
| C-131 | 2回目の呼び出しでInvalidOperationExceptionがスローされる | E-13 (L41-44) | ○ |
| C-132 | TryComputeLengthで常にfalseが返される | E-13 (L65-69) | ○ |
| C-133 | DisposeでコンテンツストリームがDisposeされる | E-13 (L71-78) | ○ |
| C-134 | CreateContentReadStreamAsyncでコンテンツストリームが返される | E-13 (L80) | ○ |

### CachedCertificateValue/Key クラス（UT-WHH-135〜UT-WHH-139）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | RawCertificateDataで証明書データが取得できる | E-14 (L15) | ○ |
| C-136 | LastUsedTimeで最終使用時刻が取得・設定できる | E-14 (L16-20) | ○ |
| C-137 | Equalsで同じアドレスとホストでtrueが返される | E-14 (L34-36) | ○ |
| C-138 | Equalsで異なるアドレスでfalseが返される | E-14 (L34) | ○ |
| C-139 | GetHashCodeで同じキーで同じハッシュコードが返される | E-14 (L43) | ○ |

### WinHttpTrailersHelper クラス（UT-WHH-140〜UT-WHH-141）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | OsSupportsTrailersでOS機能検出が正しく動作する | E-12 (L22-62) | ○ |
| C-141 | GetResponseTrailersでレスポンストレーラーが取得できる | E-12 (L25-34) | ○ |

### WinHttpTraceHelper クラス（UT-WHH-142〜UT-WHH-143）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | TraceCallbackStatusでコールバックステータスがトレースされる | E-16 (L12-20) | ○ |
| C-143 | TraceAsyncErrorで非同期エラーがトレースされる | E-16 (L22-33) | ○ |

## 4) 不足情報（Unknown / Missing）
- **なし**: 全テストケースにソースコード根拠あり

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 全テストケースがソースコードに基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] WinHttpHandler のプロパティバリデーションテストケース（UT-WHH-001〜UT-WHH-026）が網羅的か確認
- [ ] ストリームクラスの非サポート操作テスト（NotSupportedException）が適切か確認
- [ ] 認証処理（WinHttpAuthHelper）のテストケースがセキュリティ要件を満たしているか確認
- [ ] 並行処理制御（InvalidOperationException for concurrent I/O）のテストが十分か確認
- [ ] リソース管理（Dispose）のテストが冪等性を含めて網羅的か確認
- [ ] 既存の単体テスト（tests/UnitTests配下）との整合性を確認
