---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.975
---

# 根拠レポート：libraries-System.Net.Http 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の実装・バリデーションロジック・例外処理などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：主要なクラス・メソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 195 / 200 = 0.975
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.975**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **UT-HTTP-016～018**: GetStringAsyncの実際のネットワーク動作は統合テスト依存
  2. **UT-HTTP-197～198**: SocketsHttpHandlerのHTTP/2サポートは実行環境依存
  3. **UT-HTTP-091**: LoadIntoBufferAsyncのバッファサイズ超過動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Http/src/System/Net/Http/HttpClient.cs` - HttpClientクラスの実装
- E-02: `src/libraries/System.Net.Http/src/System/Net/Http/HttpRequestMessage.cs` - HttpRequestMessageクラスの実装
- E-03: `src/libraries/System.Net.Http/src/System/Net/Http/HttpResponseMessage.cs` - HttpResponseMessageクラスの実装
- E-04: `src/libraries/System.Net.Http/src/System/Net/Http/HttpContent.cs` - HttpContentクラスの実装
- E-05: `src/libraries/System.Net.Http/src/System/Net/Http/HttpMethod.cs` - HttpMethodクラスの実装
- E-06: `src/libraries/System.Net.Http/src/System/Net/Http/ByteArrayContent.cs` - ByteArrayContentクラスの実装
- E-07: `src/libraries/System.Net.Http/src/System/Net/Http/StringContent.cs` - StringContentクラスの実装
- E-08: `src/libraries/System.Net.Http/src/System/Net/Http/StreamContent.cs` - StreamContentクラスの実装
- E-09: `src/libraries/System.Net.Http/src/System/Net/Http/FormUrlEncodedContent.cs` - FormUrlEncodedContentクラスの実装
- E-10: `src/libraries/System.Net.Http/src/System/Net/Http/MultipartContent.cs` - MultipartContentクラスの実装
- E-11: `src/libraries/System.Net.Http/src/System/Net/Http/MultipartFormDataContent.cs` - MultipartFormDataContentクラスの実装
- E-12: `src/libraries/System.Net.Http/src/System/Net/Http/ReadOnlyMemoryContent.cs` - ReadOnlyMemoryContentクラスの実装
- E-13: `src/libraries/System.Net.Http/src/System/Net/Http/HttpMessageHandler.cs` - HttpMessageHandlerクラスの実装
- E-14: `src/libraries/System.Net.Http/src/System/Net/Http/HttpMessageInvoker.cs` - HttpMessageInvokerクラスの実装
- E-15: `src/libraries/System.Net.Http/src/System/Net/Http/SocketsHttpHandler/SocketsHttpHandler.cs` - SocketsHttpHandlerクラスの実装

## 3) Claims と根拠の対応（レビューの主戦場）

### HttpClient（UT-HTTP-001～038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-001 | デフォルトコンストラクタでHttpClientHandlerを内部生成 | E-01 (L138-140) | ○ |
| UT-HTTP-002 | カスタムハンドラ指定でインスタンス生成 | E-01 (L142-144) | ○ |
| UT-HTTP-003 | nullハンドラでArgumentNullException | E-01 (L146), 基底クラスでチェック | ○ |
| UT-HTTP-004 | BaseAddressに絶対URI設定可 | E-01 (L81-97) | ○ |
| UT-HTTP-005 | BaseAddressに相対URIでArgumentException | E-01 (L87-89) | ○ |
| UT-HTTP-006 | 操作開始後のBaseAddress設定でInvalidOperationException | E-01 (L92, L736-743) | ○ |
| UT-HTTP-007 | Timeoutに正の値設定可 | E-01 (L100-113) | ○ |
| UT-HTTP-008 | TimeoutにInfiniteTimeSpan設定可 | E-01 (L105) | ○ |
| UT-HTTP-009 | Timeoutに0以下でArgumentOutOfRangeException | E-01 (L107) | ○ |
| UT-HTTP-010 | Timeoutに最大値超過でArgumentOutOfRangeException | E-01 (L108) | ○ |
| UT-HTTP-011 | MaxResponseContentBufferSizeに正の値設定可 | E-01 (L115-131) | ○ |
| UT-HTTP-012 | MaxResponseContentBufferSizeに0以下でArgumentOutOfRangeException | E-01 (L120) | ○ |
| UT-HTTP-013 | MaxResponseContentBufferSizeに上限超過でArgumentOutOfRangeException | E-01 (L121-125) | ○ |
| UT-HTTP-014 | DefaultRequestVersionにHTTPバージョン設定可 | E-01 (L52-60) | ○ |
| UT-HTTP-015 | DefaultRequestVersionにnullでArgumentNullException | E-01 (L58) | ○ |
| UT-HTTP-016 | GetStringAsyncで文字列取得 | E-01 (L168-229) | ○ |
| UT-HTTP-017 | GetStringAsyncで失敗時HttpRequestException | E-01 (L190) EnsureSuccessStatusCode | ○ |
| UT-HTTP-018 | GetStringAsyncでタイムアウト時TaskCanceledException | E-01 (L617-618) | ○ |
| UT-HTTP-019 | GetByteArrayAsyncでバイト配列取得 | E-01 (L240-304) | ○ |
| UT-HTTP-020 | GetByteArrayAsyncで空レスポンス時空配列 | E-01 (L293) | ○ |
| UT-HTTP-021 | GetStreamAsyncでストリーム取得 | E-01 (L315-350) | ○ |
| UT-HTTP-022 | GetAsyncでHttpResponseMessage取得 | E-01 (L377-378) | ○ |
| UT-HTTP-023 | GetAsyncでCancellationTokenキャンセル | E-01 (L596-627) | ○ |
| UT-HTTP-024 | PostAsyncでPOSTリクエスト送信 | E-01 (L389-394) | ○ |
| UT-HTTP-025 | PostAsyncでnullコンテンツ許可 | E-01 (L389-394) | ○ |
| UT-HTTP-026 | PutAsyncでPUTリクエスト送信 | E-01 (L405-410) | ○ |
| UT-HTTP-027 | PatchAsyncでPATCHリクエスト送信 | E-01 (L421-426) | ○ |
| UT-HTTP-028 | DeleteAsyncでDELETEリクエスト送信 | E-01 (L437-438) | ○ |
| UT-HTTP-029 | SendAsyncでカスタムリクエスト送信 | E-01 (L517-562) | ○ |
| UT-HTTP-030 | 送信済みリクエスト再送信でInvalidOperationException | E-01 (L745-750), E-02 (L173) | ○ |
| UT-HTTP-031 | SendAsyncでnullリクエストArgumentNullException | E-01 (L566) | ○ |
| UT-HTTP-032 | Dispose後SendAsyncでObjectDisposedException | E-01 (L568) | ○ |
| UT-HTTP-033 | CancelPendingRequestsで保留リクエストキャンセル | E-01 (L688-697) | ○ |
| UT-HTTP-034 | Dispose後CancelPendingRequestsでObjectDisposedException | E-01 (L690) | ○ |
| UT-HTTP-035 | Disposeでリソース解放 | E-01 (L705-719) | ○ |
| UT-HTTP-036 | DefaultRequestHeaders取得 | E-01 (L49-50) | ○ |
| UT-HTTP-037 | DefaultProxy設定 | E-01 (L39-46) | ○ |
| UT-HTTP-038 | DefaultProxyにnullでArgumentNullException | E-01 (L44) | ○ |

### HttpRequestMessage（UT-HTTP-039～056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-039 | デフォルトコンストラクタでMethod=GET | E-02 (L120-122) | ○ |
| UT-HTTP-040 | HttpMethodとUri指定でインスタンス生成 | E-02 (L125-136) | ○ |
| UT-HTTP-041 | HttpMethodと文字列URI指定でインスタンス生成 | E-02 (L138-141) | ○ |
| UT-HTTP-042 | nullメソッドでArgumentNullException | E-02 (L127) | ○ |
| UT-HTTP-043 | Method設定可 | E-02 (L86-95) | ○ |
| UT-HTTP-044 | MethodにnullでArgumentNullException | E-02 (L91) | ○ |
| UT-HTTP-045 | Dispose後Method設定でObjectDisposedException | E-02 (L92) CheckDisposed | ○ |
| UT-HTTP-046 | RequestUriに絶対URI設定可 | E-02 (L98-106) | ○ |
| UT-HTTP-047 | RequestUriに相対URI設定可 | E-02 (L98-106) | ○ |
| UT-HTTP-048 | RequestUriにnull設定可 | E-02 (L98-106) | ○ |
| UT-HTTP-049 | Content設定可 | E-02 (L62-83) | ○ |
| UT-HTTP-050 | Contentにnull設定可 | E-02 (L81-82) | ○ |
| UT-HTTP-051 | Version設定可 | E-02 (L36-45) | ○ |
| UT-HTTP-052 | VersionにnullでArgumentNullException | E-02 (L41) | ○ |
| UT-HTTP-053 | Headers取得 | E-02 (L108) | ○ |
| UT-HTTP-054 | Options取得 | E-02 (L118) | ○ |
| UT-HTTP-055 | ToString | E-02 (L143-171) | ○ |
| UT-HTTP-056 | Disposeでリソース解放 | E-02 (L199-214) | ○ |

### HttpResponseMessage（UT-HTTP-057～078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-057 | デフォルトコンストラクタでStatusCode=200 | E-03 (L147-149, L13) | ○ |
| UT-HTTP-058 | StatusCode指定でインスタンス生成 | E-03 (L152-159) | ○ |
| UT-HTTP-059 | 負のStatusCodeでArgumentOutOfRangeException | E-03 (L154) | ○ |
| UT-HTTP-060 | 1000以上のStatusCodeでArgumentOutOfRangeException | E-03 (L155) | ○ |
| UT-HTTP-061 | StatusCode設定可 | E-03 (L65-75) | ○ |
| UT-HTTP-062 | StatusCode=0設定可 | E-03 (L70) 0以上チェック | ○ |
| UT-HTTP-063 | StatusCode=999設定可 | E-03 (L71) 999以下チェック | ○ |
| UT-HTTP-064 | ReasonPhrase設定可 | E-03 (L80-100) | ○ |
| UT-HTTP-065 | ReasonPhrase nullでデフォルト値 | E-03 (L84-89) | ○ |
| UT-HTTP-066 | ReasonPhraseに改行でFormatException | E-03 (L93-95) | ○ |
| UT-HTTP-067 | IsSuccessStatusCode 200-299でtrue | E-03 (L142-144) | ○ |
| UT-HTTP-068 | IsSuccessStatusCode 200未満でfalse | E-03 (L143) | ○ |
| UT-HTTP-069 | IsSuccessStatusCode 300以上でfalse | E-03 (L143) | ○ |
| UT-HTTP-070 | EnsureSuccessStatusCode成功時自身返却 | E-03 (L161-176) | ○ |
| UT-HTTP-071 | EnsureSuccessStatusCode失敗時HttpRequestException | E-03 (L163-173) | ○ |
| UT-HTTP-072 | Content設定可 | E-03 (L41-62) | ○ |
| UT-HTTP-073 | Content null時EmptyContent返却 | E-03 (L44) | ○ |
| UT-HTTP-074 | Headers取得 | E-03 (L105) | ○ |
| UT-HTTP-075 | TrailingHeaders取得 | E-03 (L107) | ○ |
| UT-HTTP-076 | RequestMessage設定・取得 | E-03 (L130-139) | ○ |
| UT-HTTP-077 | ToString | E-03 (L178-206) | ○ |
| UT-HTTP-078 | Disposeでリソース解放 | E-03 (L210-225) | ○ |

### HttpContent（UT-HTTP-079～093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-079 | ReadAsStringAsyncで文字列読み取り | E-04 (L97-104) | ○ |
| UT-HTTP-080 | UTF-8 BOM処理 | E-04 (L737-742) | ○ |
| UT-HTTP-081 | Content-Typeのcharset尊重 | E-04 (L131-158) | ○ |
| UT-HTTP-082 | Dispose後ReadAsStringAsyncでObjectDisposedException | E-04 (L102) CheckDisposed | ○ |
| UT-HTTP-083 | ReadAsByteArrayAsyncでバイト配列読み取り | E-04 (L193-199) | ○ |
| UT-HTTP-084 | 空コンテンツで空配列 | E-04 (L115-118) | ○ |
| UT-HTTP-085 | ReadAsStreamAsyncでストリーム読み取り | E-04 (L239-269) | ○ |
| UT-HTTP-086 | ReadAsStreamで同期読み取り | E-04 (L209-237) | ○ |
| UT-HTTP-087 | ReadAsStreamAsync呼び出し後ReadAsStreamでHttpRequestException | E-04 (L234-236) | ○ |
| UT-HTTP-088 | CopyToAsyncでストリームコピー | E-04 (L341-374) | ○ |
| UT-HTTP-089 | CopyToAsyncでnullストリームArgumentNullException | E-04 (L353) | ○ |
| UT-HTTP-090 | LoadIntoBufferAsyncでバッファ読み込み | E-04 (L476-512) | ○ |
| UT-HTTP-091 | LoadIntoBufferAsyncでmaxBufferSize超過HttpRequestException | E-04 (L602-608, L778-780) | ○ |
| UT-HTTP-092 | Headers取得 | E-04 (L68) | ○ |
| UT-HTTP-093 | Disposeでリソース解放 | E-04 (L640-665) | ○ |

### ByteArrayContent（UT-HTTP-094～101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-094 | バイト配列からインスタンス生成 | E-06 (L17-22) | ○ |
| UT-HTTP-095 | オフセット・カウント指定でインスタンス生成 | E-06 (L25-38) | ○ |
| UT-HTTP-096 | nullコンテンツでArgumentNullException | E-06 (L19, L28) | ○ |
| UT-HTTP-097 | 負のオフセットでArgumentOutOfRangeException | E-06 (L29) | ○ |
| UT-HTTP-098 | 範囲外オフセットでArgumentOutOfRangeException | E-06 (L30) | ○ |
| UT-HTTP-099 | 負のカウントでArgumentOutOfRangeException | E-06 (L32) | ○ |
| UT-HTTP-100 | 範囲外カウントでArgumentOutOfRangeException | E-06 (L33) | ○ |
| UT-HTTP-101 | TryComputeLengthで長さ計算 | E-06 (L55-59) | ○ |

### StringContent（UT-HTTP-102～106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-102 | 文字列からインスタンス生成 | E-07 (L22-25) | ○ |
| UT-HTTP-103 | エンコーディング指定でインスタンス生成 | E-07 (L39-42) | ○ |
| UT-HTTP-104 | メディアタイプ指定でContent-Type設定 | E-07 (L48-74) | ○ |
| UT-HTTP-105 | nullコンテンツでArgumentNullException | E-07 (L92) | ○ |
| UT-HTTP-106 | 空文字列でインスタンス生成 | E-07 (L92) nullのみ拒否 | ○ |

### StreamContent（UT-HTTP-107～115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-107 | ストリームからインスタンス生成 | E-08 (L20-26) | ○ |
| UT-HTTP-108 | バッファサイズ指定でインスタンス生成 | E-08 (L28-34) | ○ |
| UT-HTTP-109 | nullストリームでArgumentNullException | E-08 (L22, L30) | ○ |
| UT-HTTP-110 | 0以下バッファサイズでArgumentOutOfRangeException | E-08 (L31) | ○ |
| UT-HTTP-111 | シーク可能ストリームで長さ計算可 | E-08 (L77-89) | ○ |
| UT-HTTP-112 | シーク不可ストリームでTryComputeLength false | E-08 (L77-89) | ○ |
| UT-HTTP-113 | SerializeToStreamAsyncでコンテンツコピー | E-08 (L65-75) | ○ |
| UT-HTTP-114 | シーク不可ストリーム2回読み取りでInvalidOperationException | E-08 (L119-137) | ○ |
| UT-HTTP-115 | Disposeで内部ストリームDispose | E-08 (L91-98) | ○ |

### FormUrlEncodedContent（UT-HTTP-116～120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-116 | キーバリューペアからインスタンス生成 | E-09 (L15-24) | ○ |
| UT-HTTP-117 | 特殊文字エンコード（スペース->+） | E-09 (L64-80) | ○ |
| UT-HTTP-118 | 複数ペアを&で連結 | E-09 (L35-38) | ○ |
| UT-HTTP-119 | nullコレクションでArgumentNullException | E-09 (L28) | ○ |
| UT-HTTP-120 | 空コレクションでインスタンス生成 | E-09 (L33-49) | ○ |

### MultipartContent（UT-HTTP-121～134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-121 | デフォルトコンストラクタでsubtype=mixed | E-10 (L36-37) | ○ |
| UT-HTTP-122 | サブタイプ指定でインスタンス生成 | E-10 (L40-41) | ○ |
| UT-HTTP-123 | 境界文字列指定でインスタンス生成 | E-10 (L44-62) | ○ |
| UT-HTTP-124 | nullサブタイプでArgumentException | E-10 (L46) | ○ |
| UT-HTTP-125 | 空白サブタイプでArgumentException | E-10 (L46) | ○ |
| UT-HTTP-126 | 71文字以上境界でArgumentOutOfRangeException | E-10 (L74-77) | ○ |
| UT-HTTP-127 | 境界が空白終端でArgumentException | E-10 (L79-82) | ○ |
| UT-HTTP-128 | 無効文字含む境界でArgumentException | E-10 (L85-88) | ○ |
| UT-HTTP-129 | Add可 | E-10 (L96-101) | ○ |
| UT-HTTP-130 | AddでnullでArgumentNullException | E-10 (L98) | ○ |
| UT-HTTP-131 | GetEnumeratorで列挙 | E-10 (L124-127) | ○ |
| UT-HTTP-132 | TryComputeLengthで長さ計算可 | E-10 (L358-409) | ○ |
| UT-HTTP-133 | 長さ計算不可コンテンツ含むとfalse | E-10 (L396-399) | ○ |
| UT-HTTP-134 | Disposeで全コンテンツDispose | E-10 (L107-118) | ○ |

### MultipartFormDataContent（UT-HTTP-135～140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-135 | デフォルトコンストラクタでsubtype=form-data | E-11 (L16-18) | ○ |
| UT-HTTP-136 | Add時Content-Disposition自動設定 | E-11 (L27-33) | ○ |
| UT-HTTP-137 | 名前付きAdd | E-11 (L35-41) | ○ |
| UT-HTTP-138 | 空白名前でArgumentException | E-11 (L38) | ○ |
| UT-HTTP-139 | ファイル名付きAdd | E-11 (L43-49) | ○ |
| UT-HTTP-140 | 空白ファイル名でArgumentException | E-11 (L47) | ○ |

### ReadOnlyMemoryContent（UT-HTTP-141～143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-141 | ReadOnlyMemoryからインスタンス生成 | E-12 (L13-14) | ○ |
| UT-HTTP-142 | TryComputeLengthでメモリ長 | E-12 (L28-32) | ○ |
| UT-HTTP-143 | SerializeToStreamAsyncでメモリ書き込み | E-12 (L22-26) | ○ |

### HttpMethod（UT-HTTP-144～167）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-144 | カスタムメソッド名でインスタンス生成 | E-05 (L33-43) | ○ |
| UT-HTTP-145 | nullメソッド名でArgumentException | E-05 (L35) | ○ |
| UT-HTTP-146 | 空白メソッド名でArgumentException | E-05 (L35) | ○ |
| UT-HTTP-147 | 無効文字メソッド名でFormatException | E-05 (L36-38) | ○ |
| UT-HTTP-148 | Get静的インスタンス | E-05 (L14) | ○ |
| UT-HTTP-149 | Post静的インスタンス | E-05 (L16) | ○ |
| UT-HTTP-150 | Put静的インスタンス | E-05 (L15) | ○ |
| UT-HTTP-151 | Delete静的インスタンス | E-05 (L17) | ○ |
| UT-HTTP-152 | Head静的インスタンス | E-05 (L18) | ○ |
| UT-HTTP-153 | Options静的インスタンス | E-05 (L19) | ○ |
| UT-HTTP-154 | Trace静的インスタンス | E-05 (L20) | ○ |
| UT-HTTP-155 | Patch静的インスタンス | E-05 (L21) | ○ |
| UT-HTTP-156 | Connect静的インスタンス | E-05 (L29) | ○ |
| UT-HTTP-157 | Query静的インスタンス | E-05 (L25) | ○ |
| UT-HTTP-158 | Equalsで同一メソッドtrue | E-05 (L55-57) | ○ |
| UT-HTTP-159 | Equalsで大文字小文字無視 | E-05 (L57) OrdinalIgnoreCase | ○ |
| UT-HTTP-160 | Equalsで異なるメソッドfalse | E-05 (L55-57) | ○ |
| UT-HTTP-161 | GetHashCodeで同一ハッシュ | E-05 (L63-70) | ○ |
| UT-HTTP-162 | Parseで既知メソッドシングルトン返却 | E-05 (L92-94) | ○ |
| UT-HTTP-163 | Parseで未知メソッド新インスタンス | E-05 (L93-94) | ○ |
| UT-HTTP-164 | operator ==で同一true | E-05 (L75-78) | ○ |
| UT-HTTP-165 | operator ==で両方nullでtrue | E-05 (L76) | ○ |
| UT-HTTP-166 | operator !=で異なるtrue | E-05 (L80-81) | ○ |
| UT-HTTP-167 | ToStringでメソッド名 | E-05 (L73) | ○ |

### HttpMessageHandler（UT-HTTP-168～169）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-168 | Send未オーバーライドでNotSupportedException | E-13 (L22-24) | ○ |
| UT-HTTP-169 | Disposeで基底は何もしない | E-13 (L31-33) | ○ |

### HttpMessageInvoker（UT-HTTP-170～178）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-170 | ハンドラ指定でインスタンス生成 | E-14 (L16-18) | ○ |
| UT-HTTP-171 | disposeHandler=falseでDispose時ハンドラ未Dispose | E-14 (L123-132) | ○ |
| UT-HTTP-172 | nullハンドラでArgumentNullException | E-14 (L23) | ○ |
| UT-HTTP-173 | SendAsyncでハンドラ呼び出し | E-14 (L67-100) | ○ |
| UT-HTTP-174 | SendAsyncでnullリクエストArgumentNullException | E-14 (L69) | ○ |
| UT-HTTP-175 | Dispose後SendAsyncでObjectDisposedException | E-14 (L71) | ○ |
| UT-HTTP-176 | Sendで同期ハンドラ呼び出し | E-14 (L35-65) | ○ |
| UT-HTTP-177 | disposeHandler=trueでハンドラDispose | E-14 (L127-129) | ○ |
| UT-HTTP-178 | disposeHandler=falseでハンドラ未Dispose | E-14 (L127-129) | ○ |

### SocketsHttpHandler（UT-HTTP-179～200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-HTTP-179 | デフォルトコンストラクタでインスタンス生成 | E-15 (L22) | ○ |
| UT-HTTP-180 | UseCookies設定可 | E-15 (L46-53) | ○ |
| UT-HTTP-181 | 操作開始後UseCookies設定でInvalidOperationException | E-15 (L51, L31-38) | ○ |
| UT-HTTP-182 | CookieContainer設定可 | E-15 (L56-64) | ○ |
| UT-HTTP-183 | AutomaticDecompression設定可 | E-15 (L67-75) | ○ |
| UT-HTTP-184 | UseProxy設定可 | E-15 (L78-85) | ○ |
| UT-HTTP-185 | Proxy設定可 | E-15 (L88-95) | ○ |
| UT-HTTP-186 | AllowAutoRedirect設定可 | E-15 (L128-135) | ○ |
| UT-HTTP-187 | MaxAutomaticRedirections設定可 | E-15 (L138-148) | ○ |
| UT-HTTP-188 | MaxAutomaticRedirections 0以下でArgumentOutOfRangeException | E-15 (L143) | ○ |
| UT-HTTP-189 | MaxConnectionsPerServer設定可 | E-15 (L151-159) | ○ |
| UT-HTTP-190 | MaxConnectionsPerServer 0以下でArgumentOutOfRangeException | E-15 (L155) | ○ |
| UT-HTTP-191 | ConnectTimeout設定可 | E-15 (L243-256) | ○ |
| UT-HTTP-192 | ConnectTimeoutにInfiniteTimeSpan設定可 | E-15 (L248) | ○ |
| UT-HTTP-193 | ConnectTimeout 0以下でArgumentOutOfRangeException | E-15 (L248-251) | ○ |
| UT-HTTP-194 | PooledConnectionLifetime設定可 | E-15 (L213-225) | ○ |
| UT-HTTP-195 | PooledConnectionIdleTimeout設定可 | E-15 (L228-240) | ○ |
| UT-HTTP-196 | SslOptions設定可 | E-15 (L203-210) | ○ |
| UT-HTTP-197 | SendAsyncでHTTP/1.1リクエスト送信 | E-15 (L605-635) | △ |
| UT-HTTP-198 | SendAsyncでHTTP/2リクエスト送信 | E-15 (L605-635) | △ |
| UT-HTTP-199 | SendでHTTP/1.1同期リクエスト送信 | E-15 (L574-603) | △ |
| UT-HTTP-200 | Send HTTP/2以上でNotSupportedException | E-15 (L579-581) | ○ |

## 4) 不足情報（Unknown / Missing）
- UT-HTTP-197, UT-HTTP-198, UT-HTTP-199: 実際のネットワーク通信動作は統合テストで検証が必要
  - 根拠：ソースコードでメソッドの存在と基本的なバリデーションは確認できるが、実際のHTTPプロトコル処理はモックまたは実サーバーとの統合テストで検証すべき
  - 候補：FunctionalTests / IntegrationTests / ネットワークモックフレームワーク

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なプロパティ・コンストラクタ・静的メソッドのテスト（140件）
- **1（中リスク）**: 非同期メソッド・ストリーム処理のテスト（50件）
- **2（高リスク）**: 実際のネットワーク通信を伴うテスト（UT-HTTP-016～018, UT-HTTP-197～199）- 統合テストとして実装推奨

## 6) レビュアーチェックリスト（最小）
- [ ] HttpClientの各プロパティのバリデーションロジックがテストケースでカバーされているか
- [ ] HttpRequestMessage/HttpResponseMessageのDispose動作が適切にテストされているか
- [ ] 各HttpContentサブクラス（ByteArrayContent, StringContent, StreamContent等）のシリアライズ動作が網羅されているか
- [ ] HttpMethodの等価性比較（大文字小文字無視）が正しくテストされているか
- [ ] SocketsHttpHandlerの操作開始後プロパティ変更禁止のテストが含まれているか
- [ ] タイムアウト・キャンセル関連のテストケースが十分か
- [ ] 境界値テスト（空配列、最大値、0など）が含まれているか
