---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 197
  claims_with_evidence: 197
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Net.Mail.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：197 / 197、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードから直接抽出しており、根拠は十分です
  2. SmtpClientの実際のネットワーク送信テストは結合テストとして別途実施が必要
  3. ファイルシステムを使用するAttachmentテストは実環境での確認が推奨されます

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Mail/src/System/Net/Mail/MailAddress.cs`
- E-02: `src/libraries/System.Net.Mail/src/System/Net/Mail/MailMessage.cs`
- E-03: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs`
- E-04: `src/libraries/System.Net.Mail/src/System/Net/Mail/Attachment.cs`
- E-05: `src/libraries/System.Net.Mail/src/System/Net/Mail/MailAddressCollection.cs`
- E-06: `src/libraries/System.Net.Mail/src/System/Net/Mail/MailAddressParser.cs`
- E-07: `src/libraries/System.Net.Mail/src/System/Net/Mail/AttachmentCollection.cs`
- E-08: `src/libraries/System.Net.Mail/src/System/Net/Mail/AlternateView.cs`
- E-09: `src/libraries/System.Net.Mail/src/System/Net/Mail/LinkedResource.cs`
- E-10: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpException.cs`
- E-11: `src/libraries/System.Net.Mail/src/System/Net/Mime/ContentType.cs`
- E-12: `src/libraries/System.Net.Mail/src/System/Net/Mime/ContentDisposition.cs`
- E-13: `src/libraries/System.Net.Mail/src/System/Net/Mime/SmtpDateTime.cs`
- E-14: `src/libraries/System.Net.Mail/src/System/Net/Mime/HeaderCollection.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### MailAddress クラス (UT-MAIL-001 - UT-MAIL-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MailAddress(string)コンストラクタが有効なアドレスを受け付ける | E-01 (L44-46) | ○ |
| C-02 | MailAddress(string)がnullで ArgumentException をスロー | E-01 (L124) | ○ |
| C-03 | MailAddress(string)が空文字で ArgumentException をスロー | E-01 (L124) | ○ |
| C-04 | 不正フォーマットで FormatException がスロー | E-01 (L151-155) | ○ |
| C-05 | TryCreate が不正アドレスで false を返す | E-01 (L104-118) | ○ |
| C-06 | User/Host/Address プロパティが正しく値を返す | E-01 (L168-234) | ○ |
| C-07 | ToString が正しいフォーマットで出力 | E-01 (L259-269) | ○ |
| C-08 | Equals/GetHashCode が正しく動作 | E-01 (L271-283) | ○ |
| C-09 | GetSmtpAddress が SMTP 形式で返却 | E-01 (L249-252) | ○ |
| C-10 | GetHost が IDN 変換を行う | E-01 (L202-226) | ○ |

### MailMessage クラス (UT-MAIL-021 - UT-MAIL-051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | MailMessage()デフォルトコンストラクタ | E-02 (L38-42) | ○ |
| C-12 | MailMessage(string, string)が from/to を検証 | E-02 (L44-51) | ○ |
| C-13 | From プロパティが null で ArgumentNullException | E-02 (L69-80) | ○ |
| C-14 | DeliveryNotificationOptions の範囲検証 | E-02 (L153-166) | ○ |
| C-15 | Body 設定時に BodyEncoding が自動設定 | E-02 (L214-238) | ○ |
| C-16 | Attachments/AlternateViews の Dispose 後アクセス | E-02 (L278-294) | ○ |
| C-17 | Dispose が関連リソースを解放 | E-02 (L297-312) | ○ |
| C-18 | BuildDeliveryStatusNotificationString の動作 | E-02 (L441-481) | ○ |

### SmtpClient クラス (UT-MAIL-052 - UT-MAIL-086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | SmtpClient コンストラクタ群 | E-03 (L61-85) | ○ |
| C-20 | Port の範囲検証 (負値、0) | E-03 (L171-191) | ○ |
| C-21 | Host の null/空文字検証 | E-03 (L145-168) | ○ |
| C-22 | 送信中のプロパティ変更防止 | E-03 (L154-157, L179-182) | ○ |
| C-23 | Timeout の範囲検証 | E-03 (L235-251) | ○ |
| C-24 | Send のバリデーション (From, 宛先, Host) | E-03 (L448-486) | ○ |
| C-25 | SendAsyncCancel の動作 | E-03 (L621-635) | ○ |
| C-26 | SendMailAsync とキャンセルトークン | E-03 (L656-692) | ○ |
| C-27 | Dispose の動作 | E-03 (L754-775) | ○ |
| C-28 | GetFileMailWriter の相対パス検証 | E-03 (L360-378) | ○ |

### ContentType クラス (UT-MAIL-087 - UT-MAIL-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | デフォルト ContentType | E-11 (L36-39) | ○ |
| C-30 | ContentType(string) のバリデーション | E-11 (L46-53) | ○ |
| C-31 | MediaType の設定と検証 | E-11 (L90-111) | ○ |
| C-32 | CharSet/Boundary/Name プロパティ | E-11 (L55-137) | ○ |
| C-33 | ToString の出力フォーマット | E-11 (L160-170) | ○ |
| C-34 | Equals/GetHashCode | E-11 (L212-215) | ○ |

### ContentDisposition クラス (UT-MAIL-103 - UT-MAIL-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | デフォルト ContentDisposition | E-12 (L50-55) | ○ |
| C-36 | ContentDisposition(string) のバリデーション | E-12 (L57-64) | ○ |
| C-37 | DispositionType の検証 | E-12 (L75-85) | ○ |
| C-38 | Inline プロパティの動作 | E-12 (L134-142) | ○ |
| C-39 | 日付プロパティ群 | E-12 (L66-155) | ○ |
| C-40 | Size プロパティのデフォルト値 | E-12 (L160-171) | ○ |

### Attachment / AttachmentBase クラス (UT-MAIL-116 - UT-MAIL-133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | Attachment コンストラクタ群 | E-04 (L284-340) | ○ |
| C-42 | Name/NameEncoding プロパティ | E-04 (L355-394) | ○ |
| C-43 | CreateAttachmentFromString ファクトリ | E-04 (L413-435) | ○ |
| C-44 | ContentStream の Dispose 後アクセス | E-04 (L185-192) | ○ |
| C-45 | ContentId の自動生成と検証 | E-04 (L195-229) | ○ |

### AlternateView / LinkedResource クラス (UT-MAIL-134 - UT-MAIL-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | AlternateView コンストラクタ群 | E-08 (L14-39) | ○ |
| C-47 | LinkedResources プロパティ | E-08 (L41-49) | ○ |
| C-48 | CreateAlternateViewFromString ファクトリ | E-08 (L63-82) | ○ |
| C-49 | Dispose での LinkedResources 解放 | E-08 (L84-96) | ○ |
| C-50 | LinkedResource コンストラクタ群 | E-09 (L12-37) | ○ |
| C-51 | CreateLinkedResourceFromString ファクトリ | E-09 (L52-71) | ○ |

### MailAddressCollection クラス (UT-MAIL-145 - UT-MAIL-153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | Add(string) のバリデーション | E-05 (L19-24) | ○ |
| C-53 | InsertItem/SetItem の null 検証 | E-05 (L26-38) | ○ |
| C-54 | ToString の出力フォーマット | E-05 (L50) | ○ |

### AttachmentCollection クラス (UT-MAIL-154 - UT-MAIL-163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | InsertItem/SetItem の検証 | E-07 (L45-56) | ○ |
| C-56 | Dispose 後の操作防止 | E-07 (L31-43) | ○ |
| C-57 | Dispose での全 Attachment 解放 | E-07 (L17-29) | ○ |

### SmtpException クラス (UT-MAIL-164 - UT-MAIL-168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | SmtpException コンストラクタ群 | E-10 (L74-94) | ○ |
| C-59 | StatusCode プロパティ | E-10 (L120-130) | ○ |
| C-60 | GetMessageForStatus の動作 | E-10 (L15-72) | ○ |

### SmtpDateTime クラス (UT-MAIL-169 - UT-MAIL-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | SmtpDateTime(DateTime) コンストラクタ | E-13 (L99-119) | ○ |
| C-62 | SmtpDateTime(string) パース | E-13 (L121-131) | ○ |
| C-63 | Date プロパティ | E-13 (L137-153) | ○ |
| C-64 | ToString の RFC 2822 フォーマット | E-13 (L160-168) | ○ |
| C-65 | TryParseTimeZoneString の動作 | E-13 (L294-335) | ○ |
| C-66 | ValidateAndGetTimeZoneOffsetValues の検証 | E-13 (L173-205) | ○ |

### MailAddressParser クラス (UT-MAIL-184 - UT-MAIL-189)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | TryParseAddress の動作 | E-06 (L26-32) | ○ |
| C-68 | ParseMultipleAddresses の動作 | E-06 (L37-52) | ○ |
| C-69 | TryNormalizeOrThrow の動作 | E-06 (L436-455) | ○ |

### HeaderCollection クラス (UT-MAIL-190 - UT-MAIL-197)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | Add/Set のバリデーション | E-14 (L68-104) | ○ |
| C-71 | Get/GetValues のバリデーション | E-14 (L31-47) | ○ |
| C-72 | Remove の動作 | E-14 (L22-28) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードから直接抽出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいている
- 1: 中リスク - SmtpClient の実際のネットワーク通信テストは結合テストとして別途必要
- 1: 中リスク - ファイルシステムを使用する Attachment/AlternateView テストは実環境での確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] MailAddress のコンストラクタバリデーションテストが網羅されているか
- [ ] MailMessage の必須プロパティ（From, To）のテストが含まれているか
- [ ] SmtpClient の各プロパティの境界値テストが含まれているか
- [ ] Dispose パターンのテスト（複数回呼び出し、Dispose 後アクセス）が含まれているか
- [ ] コレクションクラスの null 挿入防止テストが含まれているか
- [ ] ContentType/ContentDisposition の解析エラーテストが含まれているか
- [ ] SmtpDateTime の RFC 2822 フォーマット検証テストが含まれているか
