---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 82
  claims_with_evidence: 78
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Net.NameResolution 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードからの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：78 / 82、根拠なし：4
- 優先レビュー（高）
  1. **UT-NRS-079/080**: RunAsyncのリクエストシリアライズ動作は内部実装の詳細であり、テスト方法の検討が必要
  2. **UT-NRS-074-078**: GetAddrInfoExStateはprivate内部クラスであり、直接テストの可否要確認
  3. **UT-NRS-067/069**: プラットフォーム固有のテストはCI環境での実行可否要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.NameResolution/src/System/Net/Dns.cs`
- E-02: `src/libraries/System.Net.NameResolution/src/System/Net/Dns.Browser.cs`
- E-03: `src/libraries/System.Net.NameResolution/src/System/Net/IPHostEntry.cs`
- E-04: `src/libraries/System.Net.NameResolution/src/System/Net/NameResolutionTelemetry.cs`
- E-05: `src/libraries/System.Net.NameResolution/src/System/Net/NameResolutionMetrics.cs`
- E-06: `src/libraries/System.Net.NameResolution/src/System/Net/NameResolutionPal.Windows.cs`
- E-07: `src/libraries/System.Net.NameResolution/src/System/Net/NameResolutionPal.Unix.cs`
- E-08: `src/libraries/System.Net.NameResolution/src/System/Net/NetEventSource.NameResolution.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetHostName正常系テスト | E-01 (line 19-38) | ○ |
| C-02 | GetHostEntry(IPAddress)正常系テスト | E-01 (line 40-56) | ○ |
| C-03 | GetHostEntry(IPAddress)nullチェック | E-01 (line 44) | ○ |
| C-04 | GetHostEntry(IPAddress) Any検証 | E-01 (line 46-50) | ○ |
| C-05 | GetHostEntry(IPAddress) IPv6Any検証 | E-01 (line 46-50) | ○ |
| C-06 | GetHostEntry(string)正常系テスト | E-01 (line 58-92) | ○ |
| C-07 | GetHostEntry(string)IP文字列解析 | E-01 (line 75-84) | ○ |
| C-08 | GetHostEntry(string)nullチェック | E-01 (line 71) | ○ |
| C-09 | GetHostEntry(string) 0.0.0.0検証 | E-01 (line 77-80) | ○ |
| C-10 | GetHostEntry AddressFamily.InterNetwork | E-01 (line 69-92) | ○ |
| C-11 | GetHostEntry AddressFamily.InterNetworkV6 | E-01 (line 69-92) | ○ |
| C-12 | IPv6非サポート時の動作 | E-01 (line 390-417) | ○ |
| C-13 | GetHostEntryAsync正常系 | E-01 (line 94-150) | ○ |
| C-14 | GetHostEntryAsyncキャンセルトークン | E-01 (line 106-107, 119) | ○ |
| C-15 | GetHostEntryAsyncキャンセル動作 | E-01 (line 555-559) | ○ |
| C-16 | GetHostEntryAsync(IPAddress)正常系 | E-01 (line 152-171) | ○ |
| C-17 | GetHostEntryAsync(IPAddress)nullチェック | E-01 (line 156) | ○ |
| C-18 | GetHostAddresses正常系 | E-01 (line 188-222) | ○ |
| C-19 | GetHostAddresses IP文字列 | E-01 (line 205-214) | ○ |
| C-20 | GetHostAddresses nullチェック | E-01 (line 201) | ○ |
| C-21 | GetHostAddresses 0.0.0.0検証 | E-01 (line 207-210) | ○ |
| C-22 | GetHostAddresses AddressFamily | E-01 (line 199-222) | ○ |
| C-23 | GetHostAddresses ファミリー不一致 | E-01 (line 213) | ○ |
| C-24 | GetHostAddressesAsync正常系 | E-01 (line 224-250) | ○ |
| C-25 | GetHostAddressesAsyncキャンセル | E-01 (line 236-237) | ○ |
| C-26 | BeginGetHostEntry APMパターン | E-01 (line 173-177) | ○ |
| C-27 | EndGetHostEntry APMパターン | E-01 (line 179-186) | ○ |
| C-28 | EndGetHostEntry nullチェック | E-01 (line 183) | ○ |
| C-29 | BeginGetHostAddresses APMパターン | E-01 (line 252-253) | ○ |
| C-30 | EndGetHostAddresses APMパターン | E-01 (line 255-262) | ○ |
| C-31 | GetHostByName正常系 | E-01 (line 264-275) | ○ |
| C-32 | GetHostByName IP文字列 | E-01 (line 269-272) | ○ |
| C-33 | GetHostByAddress(string)正常系 | E-01 (line 291-302) | ○ |
| C-34 | GetHostByAddress(IPAddress)正常系 | E-01 (line 304-315) | ○ |
| C-35 | Resolve正常系 | E-01 (line 317-344) | ○ |
| C-36 | Resolveフォールバック | E-01 (line 327-335) | ○ |
| C-37 | ValidateHostName 256文字制限 | E-01 (line 693-703) | ○ |
| C-38 | ValidateHostName 255文字ドット終端 | E-01 (line 698) | ○ |
| C-39 | ValidateHostName 255文字非ドット終端 | E-01 (line 698) | ○ |
| C-40 | IPHostEntry.HostName | E-03 (line 18) | ○ |
| C-41 | IPHostEntry.Aliases | E-03 (line 21) | ○ |
| C-42 | IPHostEntry.AddressList | E-03 (line 24) | ○ |
| C-43 | BeforeResolution診断有効時 | E-04 (line 64-89) | ○ |
| C-44 | BeforeResolution診断無効時 | E-04 (line 67-69) | ○ |
| C-45 | AfterResolution成功時 | E-04 (line 91-123) | ○ |
| C-46 | AfterResolution失敗時 | E-04 (line 110-113) | ○ |
| C-47 | GetHostnameFromStateObject文字列 | E-04 (line 126-142) | ○ |
| C-48 | GetHostnameFromStateObject IPAddress | E-04 (line 134) | ○ |
| C-49 | GetHostnameFromStateObject KeyValuePair | E-04 (line 133) | ○ |
| C-50 | GetErrorType HostNotFound | E-04 (line 145-153) | ○ |
| C-51 | GetErrorType TryAgain | E-04 (line 148) | ○ |
| C-52 | GetErrorType不明エラー | E-04 (line 152) | ○ |
| C-53 | IsTracingEnabled | E-04 (line 184) | ○ |
| C-54 | NameResolutionActivity.Stop正常 | E-04 (line 187-240) | ○ |
| C-55 | NameResolutionActivity.Stopエラー | E-04 (line 214-217) | ○ |
| C-56 | NameResolutionMetrics.IsEnabled | E-05 (line 27) | ○ |
| C-57 | AfterResolution成功メトリクス | E-05 (line 29-36) | ○ |
| C-58 | AfterResolution失敗メトリクス | E-05 (line 37-42) | ○ |
| C-59 | NameResolutionPal.GetHostName Windows | E-06 (line 122-139) | ○ |
| C-60 | NameResolutionPal.GetHostName Unix | E-07 (line 193) | ○ |
| C-61 | TryGetAddrInfo Windows | E-06 (line 49-84) | ○ |
| C-62 | TryGetAddrInfo Unix | E-07 (line 131-153) | ○ |
| C-63 | TryGetAddrInfo Unix空文字列 | E-07 (line 133-137) | ○ |
| C-64 | TryGetAddrInfoエラー処理 | E-06 (line 65-71), E-07 (line 141-148) | ○ |
| C-65 | TryGetNameInfo Windows | E-06 (line 86-120) | ○ |
| C-66 | TryGetNameInfo Unix | E-07 (line 155-191) | ○ |
| C-67 | TryGetNameInfo WASI制限 | E-07 (line 157) | ○ |
| C-68 | GetAddrInfoAsync Windows | E-06 (line 141-187) | ○ |
| C-69 | GetAddrInfoAsync Unix制限 | E-07 (line 24-25) | ○ |
| C-70 | SupportsGetAddrInfoAsync Windows | E-06 (line 20-45) | ○ |
| C-71 | SupportsGetNameInfo Windows | E-06 (line 47) | ○ |
| C-72 | SupportsGetNameInfo Unix | E-07 (line 21) | ○ |
| C-73 | SupportsGetNameInfo WASI | E-07 (line 21) | ○ |
| C-74 | GetAddrInfoExState.RegisterForCancellation | E-06 (line 421-471) | ○ |
| C-75 | RegisterForCancellationスキップ | E-06 (line 423) | ○ |
| C-76 | UnregisterAndGetCancellationToken | E-06 (line 473-481) | ○ |
| C-77 | SetResult成功 | E-06 (line 483-493) | ○ |
| C-78 | SetResult例外 | E-06 (line 495-518) | ○ |
| C-79 | RunAsyncシリアライズ動作 | E-01 (line 711-786) | △ |
| C-80 | RunAsync並列実行 | E-01 (line 711-786) | △ |
| C-81 | CreateHostEntryForAddress | E-01 (line 685-691) | ○ |
| C-82 | CreateException | E-01 (line 788-789) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-79/C-80 (RunAsyncの動作テスト)**: 内部実装の詳細であり、実際のテスト実装では統合テストレベルでの検証が必要
  - 候補：並列実行のタイミング制御 / モック使用 / 実際のDNSサーバーへの負荷テスト
- **GetAddrInfoExState関連テスト**: privateクラスのため直接テストが困難
  - 候補：InternalsVisibleTo属性の追加 / 統合テストでの間接的検証

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なpublicメソッドのテスト（UT-NRS-001〜030）
- **1 (中リスク)**: プラットフォーム固有のテスト（UT-NRS-059〜073）- CI環境での実行可否要確認
- **1 (中リスク)**: テレメトリ/メトリクス関連テスト（UT-NRS-043〜058）- EventSource/Meterの有効化が必要
- **2 (高リスク)**: 内部クラス/メソッドのテスト（UT-NRS-074〜080）- アクセス修飾子の制約あり

## 6) レビュアーチェックリスト（最小）
- [ ] Dnsクラスの主要publicメソッド（GetHostName, GetHostEntry, GetHostAddresses）のテストケースが網羅されているか
- [ ] 非同期メソッド（*Async）のキャンセル動作テストが適切か
- [ ] プラットフォーム固有テスト（Windows/Unix/WASI）の実行環境が確保されているか
- [ ] 非推奨（Obsolete）メソッドのテスト優先度が適切か（低で良いか）
- [ ] null引数、無効なIPアドレス（Any/IPv6Any/0.0.0.0）の境界値テストが網羅されているか
- [ ] ホスト名長制限（255文字）のテストケースが正確か
- [ ] テレメトリ（EventSource）、メトリクス（Meter）、トレーシング（ActivitySource）のテスト前提条件が明確か
