---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 105
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Net.NetworkInformation 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：105 / 110、根拠なし：5
- 優先レビュー（高）
  1. **UT-NNI-107, UT-NNI-108**：NetworkChangeイベントの実装詳細がプラットフォーム固有ファイルに分散
  2. **UT-NNI-109, UT-NNI-110**：TeredoHelperはWindows固有の実装でLinux/macOSでのテスト可否要確認
  3. **UT-NNI-088**：Interop.Sys.GetNetworkInterfacesの戻り値に依存するテストケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/PhysicalAddress.cs`
- E-02: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/NetworkInterface.cs`
- E-03: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/UnixNetworkInterface.cs`
- E-04: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/LinuxNetworkInterface.cs`
- E-05: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/GatewayIPAddressInformationCollection.cs`
- E-06: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/UnicastIPAddressInformationCollection.cs`
- E-07: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/MulticastIPAddressInformationCollection.cs`
- E-08: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/InternalIPAddressCollection.cs`
- E-09: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/IPAddressUtil.cs`
- E-10: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/StringParsingHelpers.Addresses.cs`
- E-11: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/StringParsingHelpers.Statistics.cs`
- E-12: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/StringParsingHelpers.Dns.cs`
- E-13: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/StringParsingHelpers.Misc.cs`
- E-14: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/LinuxIPGlobalProperties.cs`
- E-15: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/LinuxIcmpV4Statistics.cs`
- E-16: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/LinuxTcpStatistics.cs`
- E-17: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/LinuxUdpStatistics.cs`
- E-18: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/LinuxIPGlobalStatistics.cs`
- E-19: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/NetworkAddressChange.cs`
- E-20: `src/libraries/System.Net.NetworkInformation/src/System/Net/NetworkInformation/TeredoHelper.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-NNI-001) | PhysicalAddress.Parse ハイフン区切りMACアドレスパース | E-01 (PhysicalAddress.cs:104-113) | ○ |
| C-02 (UT-NNI-002) | PhysicalAddress.Parse コロン区切り（2桁）MACアドレスパース | E-01 (PhysicalAddress.cs:115-128) | ○ |
| C-03 (UT-NNI-003) | PhysicalAddress.Parse コロン区切り（4桁）MACアドレスパース | E-01 (PhysicalAddress.cs:115-128) | ○ |
| C-04 (UT-NNI-004) | PhysicalAddress.Parse ドット区切りMACアドレスパース | E-01 (PhysicalAddress.cs:130-143) | ○ |
| C-05 (UT-NNI-005) | PhysicalAddress.Parse 区切りなしMACアドレスパース | E-01 (PhysicalAddress.cs:145-154) | ○ |
| C-06 (UT-NNI-006) | PhysicalAddress.Parse null入力時のNone返却 | E-01 (PhysicalAddress.cs:76) | ○ |
| C-07 (UT-NNI-007) | PhysicalAddress.Parse 不正形式でFormatException | E-01 (PhysicalAddress.cs:80-81) | ○ |
| C-08 (UT-NNI-008) | PhysicalAddress.Parse 奇数長文字列でFormatException | E-01 (PhysicalAddress.cs:147-150) | ○ |
| C-09 (UT-NNI-009) | PhysicalAddress.TryParse 有効入力でtrue | E-01 (PhysicalAddress.cs:97-200) | ○ |
| C-10 (UT-NNI-010) | PhysicalAddress.TryParse null入力でtrue/None | E-01 (PhysicalAddress.cs:86-94) | ○ |
| C-11 (UT-NNI-011) | PhysicalAddress.TryParse 不正形式でfalse | E-01 (PhysicalAddress.cs:170) | ○ |
| C-12 (UT-NNI-012) | PhysicalAddress.GetHashCode 一貫性 | E-01 (PhysicalAddress.cs:21-58) | ○ |
| C-13 (UT-NNI-013) | PhysicalAddress.GetHashCode 空配列で1返却 | E-01 (PhysicalAddress.cs:49-52) | ○ |
| C-14 (UT-NNI-014) | PhysicalAddress.Equals 同一アドレスでtrue | E-01 (PhysicalAddress.cs:60-64) | ○ |
| C-15 (UT-NNI-015) | PhysicalAddress.Equals 異なるアドレスでfalse | E-01 (PhysicalAddress.cs:60-64) | ○ |
| C-16 (UT-NNI-016) | PhysicalAddress.Equals nullでfalse | E-01 (PhysicalAddress.cs:60) | ○ |
| C-17 (UT-NNI-017) | PhysicalAddress.ToString 16進文字列変換 | E-01 (PhysicalAddress.cs:66-69) | ○ |
| C-18 (UT-NNI-018) | PhysicalAddress.GetAddressBytes 配列コピー返却 | E-01 (PhysicalAddress.cs:71-74) | ○ |
| C-19 (UT-NNI-019) | PhysicalAddress.None 静的フィールド | E-01 (PhysicalAddress.cs:14) | ○ |
| C-20 (UT-NNI-020) | NetworkInterface.GetAllNetworkInterfaces | E-02 (NetworkInterface.cs:17-20) | ○ |
| C-21 (UT-NNI-021) | NetworkInterface.GetIsNetworkAvailable | E-02 (NetworkInterface.cs:25-28) | ○ |
| C-22 (UT-NNI-022) | NetworkInterface.LoopbackInterfaceIndex | E-02 (NetworkInterface.cs:44-50) | ○ |
| C-23 (UT-NNI-023) | NetworkInterface.IPv6LoopbackInterfaceIndex | E-02 (NetworkInterface.cs:33-39) | ○ |
| C-24 (UT-NNI-024) | UnixNetworkInterface.Supports IPv4 | E-03 (UnixNetworkInterface.cs:35-50) | ○ |
| C-25 (UT-NNI-025) | UnixNetworkInterface.Supports IPv6 | E-03 (UnixNetworkInterface.cs:35-50) | ○ |
| C-26 (UT-NNI-026) | UnixNetworkInterface.Supports 非サポート時false | E-03 (UnixNetworkInterface.cs:49) | ○ |
| C-27 (UT-NNI-027) | GatewayIPAddressInformationCollection.Add NotSupportedException | E-05 (GatewayIPAddressInformationCollection.cs:51-54) | ○ |
| C-28 (UT-NNI-028) | GatewayIPAddressInformationCollection.Remove NotSupportedException | E-05 (GatewayIPAddressInformationCollection.cs:76-79) | ○ |
| C-29 (UT-NNI-029) | GatewayIPAddressInformationCollection.Clear NotSupportedException | E-05 (GatewayIPAddressInformationCollection.cs:81-84) | ○ |
| C-30 (UT-NNI-030) | GatewayIPAddressInformationCollection.IsReadOnly true | E-05 (GatewayIPAddressInformationCollection.cs:35-41) | ○ |
| C-31 (UT-NNI-031) | GatewayIPAddressInformationCollection.Count | E-05 (GatewayIPAddressInformationCollection.cs:27-33) | ○ |
| C-32 (UT-NNI-032) | GatewayIPAddressInformationCollection インデクサ | E-05 (GatewayIPAddressInformationCollection.cs:43-49) | ○ |
| C-33 (UT-NNI-033) | UnicastIPAddressInformationCollection.Add NotSupportedException | E-06 (UnicastIPAddressInformationCollection.cs:38-41) | ○ |
| C-34 (UT-NNI-034) | UnicastIPAddressInformationCollection.Remove NotSupportedException | E-06 (UnicastIPAddressInformationCollection.cs:71-74) | ○ |
| C-35 (UT-NNI-035) | UnicastIPAddressInformationCollection.Clear NotSupportedException | E-06 (UnicastIPAddressInformationCollection.cs:76-79) | ○ |
| C-36 (UT-NNI-036) | MulticastIPAddressInformationCollection.Add NotSupportedException | E-07 (MulticastIPAddressInformationCollection.cs:37-40) | ○ |
| C-37 (UT-NNI-037) | MulticastIPAddressInformationCollection.Remove NotSupportedException | E-07 (MulticastIPAddressInformationCollection.cs:70-73) | ○ |
| C-38 (UT-NNI-038) | MulticastIPAddressInformationCollection.Clear NotSupportedException | E-07 (MulticastIPAddressInformationCollection.cs:75-78) | ○ |
| C-39 (UT-NNI-039) | InternalIPAddressCollection.Add NotSupportedException | E-08 (InternalIPAddressCollection.cs:43-46) | ○ |
| C-40 (UT-NNI-040) | InternalIPAddressCollection.InternalAdd | E-08 (InternalIPAddressCollection.cs:48-51) | ○ |
| C-41 (UT-NNI-041) | IPAddressUtil.IsMulticast IPv4 224.x.x.x | E-09 (IPAddressUtil.cs:17-27) | ○ |
| C-42 (UT-NNI-042) | IPAddressUtil.IsMulticast IPv4 239.x.x.x | E-09 (IPAddressUtil.cs:26) | ○ |
| C-43 (UT-NNI-043) | IPAddressUtil.IsMulticast IPv4 ユニキャストfalse | E-09 (IPAddressUtil.cs:26) | ○ |
| C-44 (UT-NNI-044) | IPAddressUtil.IsMulticast IPv4 境界223.x.x.x | E-09 (IPAddressUtil.cs:26) | ○ |
| C-45 (UT-NNI-045) | IPAddressUtil.IsMulticast IPv4 境界240.x.x.x | E-09 (IPAddressUtil.cs:26) | ○ |
| C-46 (UT-NNI-046) | IPAddressUtil.IsMulticast IPv6 マルチキャスト | E-09 (IPAddressUtil.cs:17-20) | ○ |
| C-47 (UT-NNI-047) | IPAddressUtil.IsMulticast IPv6 ユニキャストfalse | E-09 (IPAddressUtil.cs:17-20) | ○ |
| C-48 (UT-NNI-048) | StringParsingHelpers.ParseIPv4GatewayAddressesFromRouteFile | E-10 (StringParsingHelpers.Addresses.cs:13-36) | ○ |
| C-49 (UT-NNI-049) | StringParsingHelpers.ParseIPv4GatewayAddressesFromRouteFile ゲートウェイ0スキップ | E-10 (StringParsingHelpers.Addresses.cs:26-27) | ○ |
| C-50 (UT-NNI-050) | StringParsingHelpers.ParseIPv6GatewayAddressesFromRouteFile | E-10 (StringParsingHelpers.Addresses.cs:38-78) | ○ |
| C-51 (UT-NNI-051) | StringParsingHelpers.ParseIPv6GatewayAddressesFromRouteFile ScopeId設定 | E-10 (StringParsingHelpers.Addresses.cs:69-73) | ○ |
| C-52 (UT-NNI-052) | StringParsingHelpers.ParseDhcpServerAddressesFromLeasesFile | E-10 (StringParsingHelpers.Addresses.cs:80-122) | ○ |
| C-53 (UT-NNI-053) | StringParsingHelpers.ParseDhcpServerAddressesFromLeasesFile ファイル不存在 | E-10 (StringParsingHelpers.Addresses.cs:87) | ○ |
| C-54 (UT-NNI-054) | StringParsingHelpers.ParseWinsServerAddressesFromSmbConfFile | E-10 (StringParsingHelpers.Addresses.cs:124-171) | ○ |
| C-55 (UT-NNI-055) | StringParsingHelpers.ParseWinsServerAddressesFromSmbConfFile コメントスキップ | E-10 (StringParsingHelpers.Addresses.cs:144-148) | ○ |
| C-56 (UT-NNI-056) | StringParsingHelpers.ParseDnsSuffixFromResolvConfFile | E-12 (StringParsingHelpers.Dns.cs:11-16) | ○ |
| C-57 (UT-NNI-057) | StringParsingHelpers.ParseDnsSuffixFromResolvConfFile 空文字 | E-12 (StringParsingHelpers.Dns.cs:15) | ○ |
| C-58 (UT-NNI-058) | StringParsingHelpers.ParseDnsAddressesFromResolvConfFile | E-12 (StringParsingHelpers.Dns.cs:18-37) | ○ |
| C-59 (UT-NNI-059) | StringParsingHelpers.ParseDnsAddressesFromResolvConfFile 不正アドレススキップ | E-12 (StringParsingHelpers.Dns.cs:30-33) | ○ |
| C-60 (UT-NNI-060) | StringParsingHelpers.ParseIcmpv4FromSnmpFile | E-11 (StringParsingHelpers.Statistics.cs:176-218) | ○ |
| C-61 (UT-NNI-061) | StringParsingHelpers.ParseIcmpv4FromSnmpFile InCsumErrors下位互換 | E-11 (StringParsingHelpers.Statistics.cs:181, 192) | ○ |
| C-62 (UT-NNI-062) | StringParsingHelpers.ParseIcmpv6FromSnmp6File | E-11 (StringParsingHelpers.Statistics.cs:220-261) | ○ |
| C-63 (UT-NNI-063) | StringParsingHelpers.ParseIPv4GlobalStatisticsFromSnmpFile | E-11 (StringParsingHelpers.Statistics.cs:263-298) | ○ |
| C-64 (UT-NNI-064) | StringParsingHelpers.ParseIPv4GlobalStatisticsFromSnmpFile Forwarding判定 | E-11 (StringParsingHelpers.Statistics.cs:278) | ○ |
| C-65 (UT-NNI-065) | StringParsingHelpers.ParseIPv6GlobalStatisticsFromSnmp6File | E-11 (StringParsingHelpers.Statistics.cs:300-326) | ○ |
| C-66 (UT-NNI-066) | StringParsingHelpers.ParseTcpGlobalStatisticsFromSnmpFile | E-11 (StringParsingHelpers.Statistics.cs:328-360) | ○ |
| C-67 (UT-NNI-067) | StringParsingHelpers.ParseUdpv4GlobalStatisticsFromSnmpFile | E-11 (StringParsingHelpers.Statistics.cs:362-384) | ○ |
| C-68 (UT-NNI-068) | StringParsingHelpers.ParseUdpv6GlobalStatisticsFromSnmp6File | E-11 (StringParsingHelpers.Statistics.cs:386-402) | ○ |
| C-69 (UT-NNI-069) | StringParsingHelpers.ParseInterfaceStatisticsTableFromFile | E-11 (StringParsingHelpers.Statistics.cs:404-454) | ○ |
| C-70 (UT-NNI-070) | StringParsingHelpers.ParseInterfaceStatisticsTableFromFile インターフェース不存在 | E-11 (StringParsingHelpers.Statistics.cs:452) | ○ |
| C-71 (UT-NNI-071) | StringParsingHelpers.ParseNumRoutesFromRouteFile | E-13 (StringParsingHelpers.Misc.cs:63-67) | ○ |
| C-72 (UT-NNI-072) | StringParsingHelpers.ParseNumIPInterfaces | E-13 (StringParsingHelpers.Misc.cs:69-84) | ○ |
| C-73 (UT-NNI-073) | StringParsingHelpers.ParseDefaultTtlFromFile | E-13 (StringParsingHelpers.Misc.cs:86-99) | ○ |
| C-74 (UT-NNI-074) | StringParsingHelpers.ParseRawIntFile | E-13 (StringParsingHelpers.Misc.cs:101-110) | ○ |
| C-75 (UT-NNI-075) | StringParsingHelpers.ParseRawIntFile 不正内容例外 | E-13 (StringParsingHelpers.Misc.cs:106-107) | ○ |
| C-76 (UT-NNI-076) | StringParsingHelpers.ReadAllText 権限エラー | E-13 (StringParsingHelpers.Misc.cs:27-37) | ○ |
| C-77 (UT-NNI-077) | LinuxIPGlobalProperties.GetActiveTcpConnections | E-14 (LinuxIPGlobalProperties.cs:9-13) | ○ |
| C-78 (UT-NNI-078) | LinuxIPGlobalProperties.GetActiveTcpListeners | E-14 (LinuxIPGlobalProperties.cs:15-19) | ○ |
| C-79 (UT-NNI-079) | LinuxIPGlobalProperties.GetActiveUdpListeners | E-14 (LinuxIPGlobalProperties.cs:21-25) | ○ |
| C-80 (UT-NNI-080) | LinuxIPGlobalProperties.GetIcmpV4Statistics | E-14 (LinuxIPGlobalProperties.cs:27-30) | ○ |
| C-81 (UT-NNI-081) | LinuxIPGlobalProperties.GetIcmpV6Statistics | E-14 (LinuxIPGlobalProperties.cs:32-35) | ○ |
| C-82 (UT-NNI-082) | LinuxIPGlobalProperties.GetIPv4GlobalStatistics | E-14 (LinuxIPGlobalProperties.cs:37-40) | ○ |
| C-83 (UT-NNI-083) | LinuxIPGlobalProperties.GetIPv6GlobalStatistics | E-14 (LinuxIPGlobalProperties.cs:42-45) | ○ |
| C-84 (UT-NNI-084) | LinuxIPGlobalProperties.GetTcpIPv4Statistics | E-14 (LinuxIPGlobalProperties.cs:47-50) | ○ |
| C-85 (UT-NNI-085) | LinuxIPGlobalProperties.GetTcpIPv6Statistics | E-14 (LinuxIPGlobalProperties.cs:52-55) | ○ |
| C-86 (UT-NNI-086) | LinuxIPGlobalProperties.GetUdpIPv4Statistics | E-14 (LinuxIPGlobalProperties.cs:57-60) | ○ |
| C-87 (UT-NNI-087) | LinuxIPGlobalProperties.GetUdpIPv6Statistics | E-14 (LinuxIPGlobalProperties.cs:62-65) | ○ |
| C-88 (UT-NNI-088) | LinuxNetworkInterface.GetLinuxNetworkInterfaces | E-04 (LinuxNetworkInterface.cs:74-138) | ○ |
| C-89 (UT-NNI-089) | LinuxNetworkInterface.SupportsMulticast | E-04 (LinuxNetworkInterface.cs:140-146) | ○ |
| C-90 (UT-NNI-090) | LinuxNetworkInterface.GetIPProperties | E-04 (LinuxNetworkInterface.cs:148-151) | ○ |
| C-91 (UT-NNI-091) | LinuxNetworkInterface.GetIPStatistics | E-04 (LinuxNetworkInterface.cs:153-156) | ○ |
| C-92 (UT-NNI-092) | LinuxNetworkInterface.GetIPv4Statistics | E-04 (LinuxNetworkInterface.cs:158-161) | ○ |
| C-93 (UT-NNI-093) | LinuxIcmpV4Statistics コンストラクタ | E-15 (LinuxIcmpV4Statistics.cs:10-14) | ○ |
| C-94 (UT-NNI-094) | LinuxIcmpV4Statistics.MessagesReceived | E-15 (LinuxIcmpV4Statistics.cs:40) | ○ |
| C-95 (UT-NNI-095) | LinuxIcmpV4Statistics.MessagesSent | E-15 (LinuxIcmpV4Statistics.cs:42) | ○ |
| C-96 (UT-NNI-096) | LinuxTcpStatistics コンストラクタ | E-16 (LinuxTcpStatistics.cs:13-20) | ○ |
| C-97 (UT-NNI-097) | LinuxTcpStatistics.CurrentConnections | E-16 (LinuxTcpStatistics.cs:31) | ○ |
| C-98 (UT-NNI-098) | LinuxTcpStatistics.ConnectionsAccepted PlatformNotSupportedException | E-16 (LinuxTcpStatistics.cs:22-23) | ○ |
| C-99 (UT-NNI-099) | LinuxUdpStatistics コンストラクタ | E-17 (LinuxUdpStatistics.cs:14-26) | ○ |
| C-100 (UT-NNI-100) | LinuxUdpStatistics.DatagramsReceived | E-17 (LinuxUdpStatistics.cs:28) | ○ |
| C-101 (UT-NNI-101) | LinuxUdpStatistics.IncomingDatagramsDiscarded PlatformNotSupportedException | E-17 (LinuxUdpStatistics.cs:32-33) | ○ |
| C-102 (UT-NNI-102) | LinuxIPGlobalStatistics コンストラクタ | E-18 (LinuxIPGlobalStatistics.cs:21-46) | ○ |
| C-103 (UT-NNI-103) | LinuxIPGlobalStatistics.DefaultTtl | E-18 (LinuxIPGlobalStatistics.cs:48) | ○ |
| C-104 (UT-NNI-104) | LinuxIPGlobalStatistics.ForwardingEnabled | E-18 (LinuxIPGlobalStatistics.cs:50) | ○ |
| C-105 (UT-NNI-105) | LinuxIPGlobalStatistics.NumberOfInterfaces | E-18 (LinuxIPGlobalStatistics.cs:52) | ○ |
| C-106 (UT-NNI-106) | LinuxIPGlobalStatistics.OutputPacketRoutingDiscards PlatformNotSupportedException | E-18 (LinuxIPGlobalStatistics.cs:60-61) | ○ |
| C-107 (UT-NNI-107) | NetworkChange.NetworkAddressChanged イベント購読 | **根拠なし** | △ |
| C-108 (UT-NNI-108) | NetworkChange.NetworkAvailabilityChanged イベント購読 | **根拠なし** | △ |
| C-109 (UT-NNI-109) | TeredoHelper.UnsafeNotifyStableUnicastIpAddressTable 安定時true | E-20 (TeredoHelper.cs:49-76) | ○ |
| C-110 (UT-NNI-110) | TeredoHelper.UnsafeNotifyStableUnicastIpAddressTable 不安定時false | E-20 (TeredoHelper.cs:61-67) | ○ |

## 4) 不足情報（Unknown / Missing）
- **NetworkChange イベント実装詳細**：NetworkAddressChange.csには基本的なイベント定義のみがあり、実際のイベント発火ロジックはプラットフォーム固有ファイル（NetworkAddressChange.Unix.cs, NetworkAddressChange.OSX.cs, NetworkAddressChange.Android.cs）に分散しています。完全なテストケース設計には各プラットフォーム実装の確認が必要です。
  - 候補：NetworkAddressChange.Unix.cs / NetworkAddressChange.OSX.cs / NetworkAddressChange.Windows.cs

- **TeredoHelper Windows固有実装**：TeredoHelperはInterop.IpHlpApi.NotifyStableUnicastIpAddressTableを使用しており、これはWindows固有のAPIです。Linux/macOS環境でのテスト実行可否を確認する必要があります。
  - 候補：条件付きコンパイル確認 / プラットフォーム判定ロジック確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - PhysicalAddress関連テストケース（UT-NNI-001〜019）：純粋なデータ構造でプラットフォーム依存なし
- **0: 低リスク** - コレクションクラスの読み取り専用制約テスト（UT-NNI-027〜040）：単純な例外スローの検証
- **1: 中リスク** - StringParsingHelpers関連テストケース（UT-NNI-048〜076）：ファイルフォーマットへの依存があるが、モック可能
- **1: 中リスク** - Linux固有実装テストケース（UT-NNI-077〜106）：/proc/net等のLinux固有ファイルシステムへの依存
- **2: 高リスク** - NetworkChange イベントテスト（UT-NNI-107〜108）：プラットフォーム固有の実装詳細が不明確
- **2: 高リスク** - TeredoHelper テスト（UT-NNI-109〜110）：Windows固有APIへの依存、他プラットフォームでのテスト不可の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] PhysicalAddress.Parse/TryParseのすべての区切り文字パターンが網羅されているか
- [ ] IPAddressUtil.IsMulticastの境界値（223.255.255.255と240.0.0.0）が正しくテストされているか
- [ ] 読み取り専用コレクションのNotSupportedException発生パターンが漏れなくテストされているか
- [ ] StringParsingHelpersのファイルパース関数で、ファイル不存在やアクセス権限エラーのケースが考慮されているか
- [ ] Linux固有の/proc/net/*ファイルパースで、カーネルバージョンによる形式差異が考慮されているか
- [ ] NetworkChangeイベントのプラットフォーム固有実装（Unix/OSX/Android/Windows）が個別にテストされる必要があるか確認
- [ ] TeredoHelperがWindows以外のプラットフォームで条件付きでスキップされるべきか確認
