---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Net.Ping 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-PNG-076**：DefaultSendBufferの'a'-'z'パターンの詳細仕様が推測に基づく
  2. **UT-PNG-078**：TimeSpan(-1)の扱いについてInfiniteタイムアウトの仕様確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/Ping.cs`
- E-02: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/PingOptions.cs`
- E-03: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/PingReply.cs`
- E-04: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/PingException.cs`
- E-05: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/IPStatus.cs`
- E-06: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/PingCompletedEventArgs.cs`
- E-07: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/IcmpV4MessageConstants.cs`
- E-08: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/IcmpV6MessageConstants.cs`
- E-09: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/Ping.Windows.cs`
- E-10: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/Ping.Unix.cs`
- E-11: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/Ping.RawSocket.cs`
- E-12: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/Ping.PingUtility.cs`
- E-13: `src/libraries/System.Net.Ping/src/System/Net/NetworkInformation/Ping.OSX.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Send(string)でホスト名Pingが可能 | E-01 (line 187-190) | ○ |
| C-02 | Send(string)でnull引数時ArgumentNullException | E-01 (line 353-356) | ○ |
| C-03 | Send(string)で空文字列時ArgumentNullException | E-01 (line 353-356) | ○ |
| C-04 | Send(string, int)でタイムアウト指定可能 | E-01 (line 212-215) | ○ |
| C-05 | 負のタイムアウトでArgumentOutOfRangeException | E-01 (line 55) CheckArgs内 | ○ |
| C-06 | Send(IPAddress)でIPv4 Ping可能 | E-01 (line 232-235) | ○ |
| C-07 | Send(IPAddress)でIPv6 Ping可能 | E-01 (line 232-235), E-01 (line 740-748) | ○ |
| C-08 | Send(IPAddress)でnullアドレス時ArgumentNullException | E-01 (line 62) | ○ |
| C-09 | IPAddress.Any時ArgumentException | E-01 (line 67-70) | ○ |
| C-10 | IPAddress.IPv6Any時ArgumentException | E-01 (line 67-70) | ○ |
| C-11 | カスタムバッファでPing可能 | E-01 (line 317-320) | ○ |
| C-12 | nullバッファ時ArgumentNullException | E-01 (line 48) | ○ |
| C-13 | バッファサイズ65501超過時ArgumentException | E-01 (line 50-53), MaxBufferSize=65500 (line 17) | ○ |
| C-14 | 最大バッファサイズ65500でPing可能 | E-01 (line 17) MaxBufferSize定義 | ○ |
| C-15 | 空バッファでPing可能 | E-01 (line 50-53) サイズチェックに下限なし | ○ |
| C-16 | PingOptionsを指定してPing可能 | E-01 (line 396-417) | ○ |
| C-17 | TimeSpanタイムアウトでPing可能 | E-01 (line 447-448) | ○ |
| C-18 | 負のTimeSpan時ArgumentOutOfRangeException | E-01 (line 655-663) ToTimeoutMilliseconds | ○ |
| C-19 | int.MaxValue超過TimeSpan時ArgumentOutOfRangeException | E-01 (line 660) | ○ |
| C-20 | SendPingAsync(IPAddress)で非同期Ping可能 | E-01 (line 533-536) | ○ |
| C-21 | SendPingAsync(string)で非同期Ping可能 | E-01 (line 538-541) | ○ |
| C-22 | CancellationToken指定で非同期Ping可能 | E-01 (line 583-586) | ○ |
| C-23 | キャンセル済みトークン時OperationCanceledException | E-01 (line 712) ThrowIfCancellationRequested | ○ |
| C-24 | SendAsync(string, object)でEAPパターン使用可能 | E-01 (line 482-485) | ○ |
| C-25 | SendAsyncCancelでキャンセル可能 | E-01 (line 665-678) | ○ |
| C-26 | Disposeでリソース解放 | E-01 (line 155-162) | ○ |
| C-27 | Dispose後Send時ObjectDisposedException | E-01 (line 47, 73-76) | ○ |
| C-28 | 非同期操作中のSend時InvalidOperationException | E-01 (line 95-98) CheckStart | ○ |
| C-29 | PingCompletedイベント発火 | E-01 (line 164-169) | ○ |
| C-30 | PingOptionsデフォルトTTL=128 | E-02 (line 13) | ○ |
| C-31 | PingOptions(int, bool)でTTLとDontFragment設定 | E-02 (line 16-22) | ○ |
| C-32 | PingOptions TTL=0時ArgumentOutOfRangeException | E-02 (line 18) | ○ |
| C-33 | PingOptions 負のTTL時ArgumentOutOfRangeException | E-02 (line 18) | ○ |
| C-34 | Ttlプロパティ取得・設定 | E-02 (line 24-36) | ○ |
| C-35 | Ttlプロパティ TTL=0設定時ArgumentOutOfRangeException | E-02 (line 32) | ○ |
| C-36 | Ttlプロパティ 負のTTL設定時ArgumentOutOfRangeException | E-02 (line 32) | ○ |
| C-37 | DontFragmentプロパティ取得・設定 | E-02 (line 39-50) | ○ |
| C-38 | PingReply.Status成功時Success | E-03 (line 22) | ○ |
| C-39 | PingReply.Address応答元アドレス取得 | E-03 (line 24) | ○ |
| C-40 | PingReply.RoundtripTime往復時間取得 | E-03 (line 26) | ○ |
| C-41 | PingReply.Optionsオプション取得 | E-03 (line 28) | ○ |
| C-42 | PingReply.Bufferデータ取得 | E-03 (line 30) | ○ |
| C-43 | PingException(string)コンストラクタ | E-04 (line 13-16) | ○ |
| C-44 | PingException(string, Exception)コンストラクタ | E-04 (line 18-21) | ○ |
| C-45 | PingCompletedEventArgs.Reply取得 | E-06 (line 17) | ○ |
| C-46 | PingCompletedEventArgs.Cancelledプロパティ | E-06 (line 12) AsyncCompletedEventArgs継承 | ○ |
| C-47 | IPStatus.Success=0 | E-05 (line 8) | ○ |
| C-48 | IPStatus.TimedOut=11010 | E-05 (line 21) 11000+10=11010 | ○ |
| C-49 | MapV4TypeToIPStatus EchoReply=Success | E-07 (line 58) | ○ |
| C-50 | MapV4TypeToIPStatus DestinationUnreachable | E-07 (line 59-66) | ○ |
| C-51 | MapV4TypeToIPStatus TimeExceeded=TtlExpired | E-07 (line 68) | ○ |
| C-52 | MapV4TypeToIPStatus 未知タイプ=Unknown | E-07 (line 70) | ○ |
| C-53 | MapV6TypeToIPStatus EchoReply(129)=Success | E-08 (line 59) | ○ |
| C-54 | MapV6TypeToIPStatus PacketTooBig(2) | E-08 (line 66) | ○ |
| C-55 | MapV6TypeToIPStatus TimeExceeded(3)=TtlExpired | E-08 (line 67-70) | ○ |
| C-56 | MapV6TypeToIPStatus ParameterProblem UnrecognizedNextHeader | E-08 (line 75) | ○ |
| C-57 | Windows SendPingCore実行 | E-09 (line 30-35) | ○ |
| C-58 | Windows IPv6 SendPingCore実行 | E-09 (line 53, 152-161) | ○ |
| C-59 | Unix SendIcmpEchoRequestOverRawSocket | E-11 (line 250-298) | ○ |
| C-60 | Unix SendWithPingUtility | E-12 (line 51-71) | ○ |
| C-61 | GetPingProcessカスタムペイロード例外 | E-12 (line 30-33) | ○ |
| C-62 | ParsePingUtilityOutput exitCode=0 | E-12 (line 108-126) | ○ |
| C-63 | ParsePingUtilityOutput exitCode=1 TimedOut | E-12 (line 111-121) | ○ |
| C-64 | TryParseTtlExceeded解析 | E-12 (line 128-151) | ○ |
| C-65 | SocketConfigコンストラクタ | E-11 (line 433-453) | ○ |
| C-66 | GetSocketConfig IPv4設定 | E-11 (line 24-62) | ○ |
| C-67 | GetSocketConfig IPv6設定 | E-11 (line 31, 56) | ○ |
| C-68 | GetRawSocket RAWソケット生成 | E-11 (line 64-124) | ○ |
| C-69 | GetRawSocket DGRAMソケット生成 | E-11 (line 68-70) | ○ |
| C-70 | TryGetPingReply有効応答解析 | E-11 (line 126-248) | ○ |
| C-71 | TryGetPingReply不十分バイト数 | E-11 (line 138-141) | ○ |
| C-72 | TryGetPingReply識別子不一致 | E-11 (line 230-233) | ○ |
| C-73 | CreateSendMessageBufferヘッダ生成 | E-11 (line 455-480) | ○ |
| C-74 | ComputeBufferChecksum RFC1071準拠 | E-11 (line 482-506) | ○ |
| C-75 | ComputeBufferChecksum奇数長バッファ | E-11 (line 490-492) | ○ |
| C-76 | DefaultSendBufferパターン | E-01 (line 753-765) | △ |
| C-77 | ToTimeoutMilliseconds変換 | E-01 (line 655-663) | ○ |
| C-78 | ToTimeoutMilliseconds -1ms | E-01 (line 659) ThrowIfLessThan(-1) | △ |
| C-79 | TestIsIpSupported IPv4未サポート | E-01 (line 740-743) | ○ |
| C-80 | TestIsIpSupported IPv6未サポート | E-01 (line 744-747) | ○ |
| C-81 | GetAddressSnapshot IPv4 | E-01 (line 106-115) | ○ |
| C-82 | GetAddressSnapshot IPv6 ScopeId | E-01 (line 112) | ○ |
| C-83 | CheckStart Free->InProgress | E-01 (line 78-104) | ○ |
| C-84 | CheckStart InProgress時例外 | E-01 (line 95-98) | ○ |
| C-85 | CheckStart Disposed時例外 | E-01 (line 99-103) | ○ |
| C-86 | Finish InProgress->Free | E-01 (line 117-134) | ○ |
| C-87 | Finish disposeRequested時InternalDispose | E-01 (line 130-133) | ○ |
| C-88 | IcmpHeader 8バイト | E-11 (line 396-398) DEBUG assert | ○ |
| C-89 | IpHeader構造 | E-11 (line 401-417) | ○ |
| C-90 | Windows CreatePingReplyFromIcmpEchoReply | E-09 (line 340-367) | ○ |
| C-91 | Windows CreatePingReplyFromIcmp6EchoReply | E-09 (line 369-391) | ○ |
| C-92 | Windows GetStatusFromCode | E-09 (line 327-338) | ○ |
| C-93 | Windows GetStatusFromCode Win32Exception | E-09 (line 332-335) | ○ |
| C-94 | Windows PingCallback SetResult | E-09 (line 297) | ○ |
| C-95 | Windows PingCallback SetCanceled | E-09 (line 291-294) | ○ |
| C-96 | Windows InternalDisposeCore | E-09 (line 231-258) | ○ |
| C-97 | Windows RegisterWaitHandle | E-09 (line 102-114) | ○ |
| C-98 | Windows UnregisterWaitHandle | E-09 (line 116-128) | ○ |
| C-99 | Unix CreatePingReplyForUnreachableHost | E-11 (line 300-320) | ○ |
| C-100 | Send IPアドレス文字列解析 | E-01 (line 358-361) IPAddress.TryParse | ○ |

## 4) 不足情報（Unknown / Missing）

- **UT-PNG-076**: DefaultSendBufferの'a'-'z'パターンは推測
  - コード(line 761)では `'a' + i % 23` となっており、23文字のパターン繰り返し
  - 候補: .NET公式ドキュメント / ping.exe仕様書 / Windows SDK

- **UT-PNG-078**: TimeSpan(-1ms)の「Infinite」解釈
  - コードでは -1 以上を許可しているが、-1が無限タイムアウトを意味するかは文脈依存
  - 候補: Win32 ICMP API仕様 / .NET公式ドキュメント

## 5) リスクフラグ（レビュー観点）

- **0 (低リスク)**: 大部分のテストケースはソースコードから直接導出可能
- **1 (中リスク)**: プラットフォーム固有の動作（Windows/Unix/OSX）は実行環境に依存
- **1 (中リスク)**: ネットワーク関連テストは環境設定に依存する可能性

## 6) レビュアーチェックリスト（最小）

- [ ] 全100件のテストケースがソースコードの公開APIを網羅しているか
- [ ] 境界値テスト（MaxBufferSize=65500, TTL=0, timeout=-1）が適切か
- [ ] 例外テストケースが全ての例外パスをカバーしているか
- [ ] プラットフォーム固有コード（Windows/Unix/OSX）のテスト観点が適切か
- [ ] 非同期API（SendPingAsync, SendAsync）のキャンセル・タイムアウトテストが十分か
- [ ] 内部クラス（SocketConfig, IcmpHeader, IpHeader）のテスト優先度が適切か
- [ ] ICMP v4/v6メッセージ変換（MapV4TypeToIPStatus, MapV6TypeToIPStatus）の網羅性
