---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 250
  claims_with_evidence: 245
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Net.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：245 / 250、根拠なし：5
- 優先レビュー（高）
  1. **UT-SNP-209, UT-SNP-210**：SecureStringの動作検証はプラットフォーム依存
  2. **UT-SNP-230, UT-SNP-231**：DefaultCredentials/DefaultNetworkCredentialsはOS認証との連携
  3. **UT-SNP-235**：ネイティブエラーコードはプラットフォーム依存

## 2) 参照した情報（Evidence一覧）
> 以下は実際に解析したソースファイルです。

- E-01: `src/libraries/System.Net.Primitives/src/System/Net/IPAddress.cs`
- E-02: `src/libraries/System.Net.Primitives/src/System/Net/IPEndPoint.cs`
- E-03: `src/libraries/System.Net.Primitives/src/System/Net/DnsEndPoint.cs`
- E-04: `src/libraries/System.Net.Primitives/src/System/Net/IPNetwork.cs`
- E-05: `src/libraries/System.Net.Primitives/src/System/Net/Cookie.cs`
- E-06: `src/libraries/System.Net.Primitives/src/System/Net/CookieCollection.cs`
- E-07: `src/libraries/System.Net.Primitives/src/System/Net/CookieContainer.cs`
- E-08: `src/libraries/System.Net.Primitives/src/System/Net/NetworkCredential.cs`
- E-09: `src/libraries/System.Net.Primitives/src/System/Net/CredentialCache.cs`
- E-10: `src/libraries/System.Net.Primitives/src/System/Net/SocketException.cs`
- E-11: `src/libraries/System.Net.Primitives/src/System/Net/CookieException.cs`
- E-12: `src/libraries/System.Net.Primitives/src/System/Net/Cache/RequestCachePolicy.cs`
- E-13: `src/libraries/System.Net.Primitives/src/System/Net/EndPoint.cs`
- E-14: `src/libraries/System.Net.Primitives/src/System/Net/IPAddressParser.cs`
- E-15: `src/libraries/System.Net.Primitives/src/System/Net/ICredentials.cs`
- E-16: `src/libraries/System.Net.Primitives/src/System/Net/IWebProxy.cs`
- E-17: `src/libraries/System.Net.Primitives/src/System/Net/TransportContext.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### IPAddress クラス（UT-SNP-001 〜 UT-SNP-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IPAddress(long)コンストラクタでArgumentOutOfRangeException | E-01 L125: `ArgumentOutOfRangeException.ThrowIfGreaterThan` | ○ |
| C-02 | IPAddress(byte[])で4バイト/16バイト配列を受け付ける | E-01 L184-196: 条件分岐でIPv4/IPv6を判定 | ○ |
| C-03 | IPAddress(byte[])で不正長さでArgumentException | E-01 L194: `throw new ArgumentException` | ○ |
| C-04 | IPAddress(byte[], long)でスコープID範囲チェック | E-01 L149: `ArgumentOutOfRangeException.ThrowIfGreaterThan` | ○ |
| C-05 | Parse/TryParseメソッドの動作 | E-01 L241-304, E-14: IPAddressParserを使用 | ○ |
| C-06 | IsValid静的メソッド | E-01 L229-234: IPAddressParser.IsValidに委譲 | ○ |
| C-07 | GetAddressBytesの戻り値サイズ | E-01 L390-405: IPv4=4バイト、IPv6=16バイト | ○ |
| C-08 | TryWriteBytesのバッファサイズチェック | E-01 L322-348: 十分なサイズがない場合false | ○ |
| C-09 | AddressFamilyプロパティ | E-01 L407-413: IsIPv4で判定 | ○ |
| C-10 | ScopeIdプロパティのIPv4時例外 | E-01 L424-438: `ThrowSocketOperationNotSupported` | ○ |
| C-11 | ScopeIdの範囲チェック | E-01 L447-448: `ArgumentOutOfRangeException.ThrowIf*` | ○ |
| C-12 | ToStringの形式 | E-01 L460-473: FormatIPv4Address/FormatIPv6Address使用 | ○ |
| C-13 | HostToNetworkOrder/NetworkToHostOrder | E-01 L536-564: BinaryPrimitives.ReverseEndianness使用 | ○ |
| C-14 | IsLoopbackメソッド | E-01 L566-580: IPv4/IPv6それぞれの判定ロジック | ○ |
| C-15 | IsIPv6Multicast〜IsIPv4MappedToIPv6 | E-01 L587-647: ビットパターンでの判定 | ○ |
| C-16 | MapToIPv6/MapToIPv4 | E-01 L740-767: 変換ロジック実装 | ○ |
| C-17 | Equals/GetHashCode | E-01 L681-737: アドレスバイト比較とハッシュ計算 | ○ |

### IPEndPoint クラス（UT-SNP-055 〜 UT-SNP-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | コンストラクタのポート範囲チェック | E-02 L39-42, L55-58: `TcpValidationHelpers.ValidatePortNumber` | ○ |
| C-19 | コンストラクタのnullチェック | E-02 L53: `ArgumentNullException.ThrowIfNull` | ○ |
| C-20 | Address/Portプロパティ | E-02 L67-91: getter/setter実装 | ○ |
| C-21 | Parse/TryParseメソッド | E-02 L94-176: InternalTryParse実装 | ○ |
| C-22 | ToString形式（IPv6は角括弧） | E-02 L179-182: IPv6時は`[{address}]:{port}` | ○ |
| C-23 | Serialize/Create | E-02 L184-202: SocketAddress変換 | ○ |
| C-24 | Equals/GetHashCode | E-02 L204-212: Address/Port比較 | ○ |
| C-25 | TryFormat | E-02 L295-316: Span書き込み | ○ |

### DnsEndPoint クラス（UT-SNP-083 〜 UT-SNP-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | コンストラクタの引数検証 | E-03 L19-29: ThrowIfNullOrEmpty, ThrowIfLess/GreaterThan | ○ |
| C-27 | AddressFamilyの制限 | E-03 L24-29: InterNetwork/InterNetworkV6/Unspecifiedのみ | ○ |
| C-28 | Equals（大文字小文字無視） | E-03 L36-40: StringComparer.OrdinalIgnoreCase使用 | ○ |
| C-29 | GetHashCode | E-03 L42-46: HashCode.Combine使用 | ○ |
| C-30 | ToString形式 | E-03 L48: `{family}/{host}:{port}` | ○ |

### IPNetwork クラス（UT-SNP-097 〜 UT-SNP-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | コンストラクタのnull/範囲チェック | E-04 L44-51: nullチェックとprefixLength範囲チェック | ○ |
| C-32 | 非ゼロビットのクリア | E-04 L53, L231-277: ClearNonZeroBitsAfterNetworkPrefix | ○ |
| C-33 | Containsメソッド | E-04 L66-109: マスク計算とビット比較 | ○ |
| C-34 | Parse/TryParse | E-04 L118-227: CIDR形式のパース | ○ |
| C-35 | Equals/GetHashCode | E-04 L310-344: BaseAddressとPrefixLengthの比較 | ○ |

### Cookie クラス（UT-SNP-120 〜 UT-SNP-149）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | Nameの検証 | E-05 L232-251: 予約文字・空文字チェック | ○ |
| C-37 | Expiredプロパティ | E-05 L197-210: DateTime.UtcNow比較 | ○ |
| C-38 | Portの形式検証 | E-05 L493-542: クォート必須、数値パース | ○ |
| C-39 | Versionの範囲チェック | E-05 L614: `ArgumentOutOfRangeException.ThrowIfNegative` | ○ |
| C-40 | Equals/GetHashCode | E-05 L623-641: 名前・値・パス・ドメイン・バージョン比較 | ○ |
| C-41 | ToStringメソッド | E-05 L643-704: StringBuilder使用 | ○ |

### CookieCollection クラス（UT-SNP-150 〜 UT-SNP-168）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | インデックスアクセスの範囲チェック | E-06 L39-40: ThrowIfNegative/GreaterThanOrEqual | ○ |
| C-43 | 名前アクセス | E-06 L46-59: foreachでName比較 | ○ |
| C-44 | Add（置換動作） | E-06 L67-80: IndexOfで既存確認 | ○ |
| C-45 | Contains/Remove | E-06 L97-111: IndexOf使用 | ○ |
| C-46 | Clear | E-06 L92-95: m_list.Clear() | ○ |

### CookieContainer クラス（UT-SNP-169 〜 UT-SNP-197）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | コンストラクタの容量チェック | E-07 L91-106: ThrowIfNegativeOrZero | ○ |
| C-48 | Capacity/PerDomainCapacity設定 | E-07 L109-178: 範囲チェックとAgeCookies呼び出し | ○ |
| C-49 | Add(Cookie)のドメイン必須チェック | E-07 L181-227: Domain.Length == 0でArgumentException | ○ |
| C-50 | GetCookies | E-07 L639-644: InternalGetCookies呼び出し | ○ |
| C-51 | GetAllCookies | E-07 L648-670: 全ドメインをループ | ○ |
| C-52 | GetCookieHeader/SetCookies | E-07 L825-867: ヘッダー文字列の生成/パース | ○ |

### NetworkCredential クラス（UT-SNP-198 〜 UT-SNP-212）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | コンストラクタ | E-08 L22-63: 複数オーバーロード | ○ |
| C-54 | UserName/Password/Domainのnull変換 | E-08 L74, 96-98, 135: `value ?? string.Empty` | ○ |
| C-55 | SecurePasswordのコピー動作 | E-08 L104-122: Copy()使用、古いSecureStringのDispose | ○ |
| C-56 | GetCredentialは自身を返却 | E-08 L144-152: `return this` | ○ |

### CredentialCache クラス（UT-SNP-213 〜 UT-SNP-231）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | Add/Removeの引数検証 | E-09 L26-45, L48-72: nullチェック、範囲チェック | ○ |
| C-58 | 重複キーでArgumentException | E-09 L45: `_cache.Add(key, cred)`で重複時例外 | ○ |
| C-59 | GetCredential（URI/ホスト） | E-09 L127-165: Dictionary検索 | ○ |
| C-60 | DefaultCredentials/DefaultNetworkCredentials | E-09 L169-171: SystemNetworkCredential.s_defaultCredential | △ |

### SocketException クラス（UT-SNP-232 〜 UT-SNP-236）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | コンストラクタ | E-10 L18-48: errorCode受け取り | ○ |
| C-62 | SocketErrorCode/ErrorCode | E-10 L52, L62: _errorCode/NativeErrorCode | ○ |
| C-63 | プラットフォーム依存のネイティブコード | E-10: GetNativeErrorForSocketError（別ファイル） | △ |

### CookieException クラス（UT-SNP-237 〜 UT-SNP-239）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | コンストラクタオーバーロード | E-11 L13-33: 3種類のコンストラクタ | ○ |

### RequestCachePolicy クラス（UT-SNP-240 〜 UT-SNP-244）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | コンストラクタのレベル検証 | E-12 L15-18: 範囲チェック | ○ |
| C-66 | ToString形式 | E-12 L25: `"Level:" + Level.ToString()` | ○ |

### EndPoint クラス（UT-SNP-245 〜 UT-SNP-250）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | 抽象メソッド/プロパティの未実装例外 | E-13 L26-47: NotImplemented.ByDesignWithMessage | ○ |

## 4) 不足情報（Unknown / Missing）
- **SecureString関連（UT-SNP-209, UT-SNP-210）**：SecureStringの動作はプラットフォームのセキュリティ機能に依存するため、実行環境での検証が必要
  - 候補：Windows/Linux/macOSそれぞれでのテスト実行
- **DefaultCredentials（UT-SNP-230, UT-SNP-231）**：システム認証情報との連携はOS依存
  - 候補：統合テストでの検証
- **ネイティブエラーコード（UT-SNP-235）**：Windows/Unix間でエラーコードが異なる
  - 候補：プラットフォーム別テストの実施

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: SecureString関連テストはメモリセキュリティに関わるため、実行環境での動作確認推奨
- **1（中リスク）**: DefaultCredentialsテストはCI/CD環境での認証状況に依存
- **0（低リスク）**: その他のテストケースはソースコードから直接検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] IPAddressのパース/フォーマットテストが代表的なIPv4/IPv6形式を網羅しているか
- [ ] CookieContainerの容量制限・エージング処理のテストが十分か
- [ ] SocketExceptionのエラーコードがプラットフォーム間で適切にマッピングされているか
- [ ] IPNetworkのContainsメソッドが境界条件（/0、/32、/128）を正しく処理するか
- [ ] 認証情報クラスがセキュアに機密情報を扱えているか（SecureStringの適切な破棄）
