---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 135
  claims_with_evidence: 135
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Net.Quic 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：135 / 135、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードから直接抽出された根拠に基づく
  2. 特に高優先度のテストケースはQUIC接続・ストリーム操作の核心機能
  3. プラットフォーム依存テストの実行環境確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicConnection.cs`
- E-02: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicListener.cs`
- E-03: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicStream.cs`
- E-04: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicStream.Stream.cs`
- E-05: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicConnectionOptions.cs`
- E-06: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicListenerOptions.cs`
- E-07: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicException.cs`
- E-08: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicError.cs`
- E-09: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicDefaults.cs`
- E-10: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicAbortDirection.cs`
- E-11: `src/libraries/System.Net.Quic/src/System/Net/Quic/QuicStreamType.cs`
- E-12: `src/libraries/System.Net.Quic/src/System/Net/Quic/Internal/ThrowHelper.cs`
- E-13: `src/libraries/System.Net.Quic/src/System/Net/Quic/Internal/MsQuicApi.cs`
- E-14: `src/libraries/System.Net.Quic/src/System/Net/Quic/Internal/MsQuicHelpers.cs`
- E-15: `src/libraries/System.Net.Quic/src/System/Net/Quic/Internal/ReceiveBuffers.cs`
- E-16: `src/libraries/System.Net.Quic/src/System/Net/Quic/Internal/MsQuicConfiguration.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### QuicConnection クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsSupported プロパティでQUICサポート状態を確認 | E-01 (L54), E-13 | ○ |
| C-02 | ConnectAsync でクライアント接続を確立 | E-01 (L62-106) | ○ |
| C-03 | ConnectAsync でハンドシェイクタイムアウト処理 | E-01 (L79-96) | ○ |
| C-04 | OpenOutboundStreamAsync でストリーム作成 | E-01 (L521-556) | ○ |
| C-05 | AcceptInboundStreamAsync でストリーム受け入れ | E-01 (L563-586) | ○ |
| C-06 | CloseAsync で接続クローズ | E-01 (L602-621) | ○ |
| C-07 | DisposeAsync でリソース解放 | E-01 (L820-868) | ○ |
| C-08 | RemoteEndPoint/LocalEndPoint プロパティ | E-01 (L236-240) | ○ |
| C-09 | RemoteCertificate プロパティ | E-01 (L286-293) | ○ |
| C-10 | NegotiatedApplicationProtocol プロパティ | E-01 (L298) | ○ |

### QuicListener クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | IsSupported プロパティでQUICサポート状態を確認 | E-02 (L45) | ○ |
| C-12 | ListenAsync でリスナー開始 | E-02 (L53-71) | ○ |
| C-13 | AcceptConnectionAsync で接続受け入れ | E-02 (L178-204) | ○ |
| C-14 | StartConnectionHandshake でハンドシェイク処理 | E-02 (L216-323) | ○ |
| C-15 | DisposeAsync でリソース解放 | E-02 (L408-440) | ○ |
| C-16 | LocalEndPoint プロパティ | E-02 (L112) | ○ |

### QuicStream クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Id/Type プロパティ | E-03 (L133-138) | ○ |
| C-18 | ReadAsync でデータ読み取り | E-03 (L273-349) | ○ |
| C-19 | WriteAsync でデータ送信 | E-03 (L352-441) | ○ |
| C-20 | Abort でストリームアボート | E-03 (L452-502) | ○ |
| C-21 | CompleteWrites で書き込み完了 | E-03 (L511-533) | ○ |
| C-22 | ReadsClosed/WritesClosed タスク | E-03 (L146-155) | ○ |
| C-23 | DisposeAsync でリソース解放 | E-03 (L713-777) | ○ |
| C-24 | Stream基底クラスメソッド（CanRead, CanWrite等） | E-04 (L18-224) | ○ |
| C-25 | ReadTimeout/WriteTimeout プロパティ | E-04 (L49-84) | ○ |

### QuicConnectionOptions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | MaxInboundBidirectionalStreams/MaxInboundUnidirectionalStreams | E-05 (L83-89) | ○ |
| C-27 | IdleTimeout プロパティ | E-05 (L95) | ○ |
| C-28 | DefaultStreamErrorCode/DefaultCloseErrorCode | E-05 (L103-114) | ○ |
| C-29 | HandshakeTimeout プロパティ | E-05 (L140) | ○ |
| C-30 | KeepAliveInterval プロパティ | E-05 (L132) | ○ |
| C-31 | InitialReceiveWindowSizes プロパティ | E-05 (L121-125) | ○ |
| C-32 | Validate メソッド | E-05 (L154-165) | ○ |

### QuicClientConnectionOptions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | デフォルトコンストラクタ | E-05 (L176-180) | ○ |
| C-34 | ClientAuthenticationOptions プロパティ | E-05 (L186) | ○ |
| C-35 | RemoteEndPoint/LocalEndPoint プロパティ | E-05 (L192-197) | ○ |
| C-36 | Validate メソッドの検証 | E-05 (L203-210) | ○ |

### QuicServerConnectionOptions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | デフォルトコンストラクタ | E-05 (L221-225) | ○ |
| C-38 | ServerAuthenticationOptions プロパティ | E-05 (L231) | ○ |
| C-39 | Validate メソッドの検証 | E-05 (L237-243) | ○ |

### QuicListenerOptions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | ListenEndPoint プロパティ | E-06 (L21) | ○ |
| C-41 | ApplicationProtocols プロパティ | E-06 (L27) | ○ |
| C-42 | ListenBacklog プロパティ | E-06 (L32) | ○ |
| C-43 | ConnectionOptionsCallback プロパティ | E-06 (L37) | ○ |
| C-44 | Validate メソッドの検証 | E-06 (L43-55) | ○ |

### QuicReceiveWindowSizes クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | Connection/LocallyInitiatedBidirectionalStream等プロパティ | E-05 (L19-34) | ○ |
| C-46 | Validate メソッド（2の累乗検証） | E-05 (L36-50) | ○ |

### QuicException クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | コンストラクタ群 | E-07 (L19-59) | ○ |
| C-48 | QuicError/ApplicationErrorCode/TransportErrorCode プロパティ | E-07 (L64-77) | ○ |

### QuicError 列挙型
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | 各エラー値（Success, InternalError, ConnectionAborted等） | E-08 (L9-70) | ○ |

### QuicDefaults クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | 各デフォルト値定数 | E-09 (L14-49) | ○ |

### ThrowHelper クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | GetConnectionAbortedException | E-12 (L18-21) | ○ |
| C-52 | GetStreamAbortedException | E-12 (L23-26) | ○ |
| C-53 | GetOperationAbortedException | E-12 (L28-31) | ○ |
| C-54 | ValidateErrorCode/ValidateInRange/ValidateTimeSpan | E-12 (L192-218) | ○ |
| C-55 | GetExceptionForMsQuicStatus | E-12 (L57-131) | ○ |

### MsQuicHelpers クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | TryParse メソッド | E-14 (L15-36) | ○ |
| C-57 | QuicAddrToIPEndPoint メソッド | E-14 (L38-47) | ○ |
| C-58 | ToQuicAddr メソッド | E-14 (L49-55) | ○ |
| C-59 | GetMsQuicParameter/SetMsQuicParameter | E-14 (L57-95) | ○ |

### ReceiveBuffers 構造体
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | CopyFrom/CopyTo メソッド | E-15 (L39-86) | ○ |
| C-61 | SetFinal/HasCapacity メソッド | E-15 (L23-37) | ○ |

### MsQuicApi クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | IsQuicSupported プロパティ | E-13 (L61) | ○ |
| C-63 | NotSupportedReason プロパティ | E-13 (L64) | ○ |
| C-64 | Version プロパティ | E-13 (L59) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全てのテストケースはソースコードから直接確認可能な根拠に基づいています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されています
- 注意点：
  - プラットフォーム依存テスト（Windows/Linux/macOS）は実行環境に依存
  - MsQuicネイティブライブラリの存在が前提条件
  - TLS 1.3サポートが必要

## 6) レビュアーチェックリスト（最小）
- [ ] QuicConnection/QuicListener/QuicStreamの主要メソッドがカバーされているか
- [ ] 正常系・異常系・境界値テストが適切に含まれているか
- [ ] Dispose後の操作に対するObjectDisposedExceptionテストが含まれているか
- [ ] エラーコード検証（負の値、範囲外）のテストが含まれているか
- [ ] タイムアウト処理のテストが含まれているか
- [ ] キャンセルトークン処理のテストが含まれているか
- [ ] ストリームの双方向/単方向それぞれのテストが含まれているか
- [ ] プラットフォーム非サポート時のPlatformNotSupportedExceptionテストが含まれているか
