---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 298
  claims_with_evidence: 298
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Net.Requests 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：298 / 298、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースはソースコードに基づいて作成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Requests/src/System/Net/WebRequest.cs`
- E-02: `src/libraries/System.Net.Requests/src/System/Net/HttpWebRequest.cs`
- E-03: `src/libraries/System.Net.Requests/src/System/Net/HttpWebResponse.cs`
- E-04: `src/libraries/System.Net.Requests/src/System/Net/WebResponse.cs`
- E-05: `src/libraries/System.Net.Requests/src/System/Net/FtpWebRequest.cs`
- E-06: `src/libraries/System.Net.Requests/src/System/Net/FtpWebResponse.cs`
- E-07: `src/libraries/System.Net.Requests/src/System/Net/FileWebRequest.cs`
- E-08: `src/libraries/System.Net.Requests/src/System/Net/FileWebResponse.cs`
- E-09: `src/libraries/System.Net.Requests/src/System/Net/WebException.cs`
- E-10: `src/libraries/System.Net.Requests/src/System/Net/Authorization.cs`
- E-11: `src/libraries/System.Net.Requests/src/System/Net/ServicePoint/ServicePointManager.cs`
- E-12: `src/libraries/System.Net.Requests/src/System/Net/ServicePoint/ServicePoint.cs`
- E-13: `src/libraries/System.Net.Requests/src/System/Net/Cache/HttpRequestCachePolicy.cs`
- E-14: `src/libraries/System.Net.Requests/src/System/Net/GlobalProxySelection.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### WebRequest クラス（UT-REQ-001 〜 UT-REQ-016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebRequest.Create(string)でHTTP URIからHttpWebRequestが生成される | E-01 (PrefixList初期化, Create実装) | ○ |
| C-02 | WebRequest.Create(string)でFTP URIからFtpWebRequestが生成される | E-01 (PrefixList初期化, FtpWebRequestCreator) | ○ |
| C-03 | WebRequest.Create(string)でFile URIからFileWebRequestが生成される | E-01 (PrefixList初期化, FileWebRequestCreator) | ○ |
| C-04 | 未サポートスキームでNotSupportedExceptionがスローされる | E-01 (Create メソッド Line:138) | ○ |
| C-05 | nullパラメータでArgumentNullExceptionがスローされる | E-01 (Create メソッド Line:154, 172) | ○ |
| C-06 | RegisterPrefixでカスタムプレフィックスが登録できる | E-01 (RegisterPrefix メソッド Line:233-312) | ○ |
| C-07 | CreateHttpでHTTP/HTTPS以外のスキームは拒否される | E-01 (CreateHttp メソッド Line:205-214) | ○ |
| C-08 | DefaultWebProxyでシステムプロキシの取得・設定が可能 | E-01 (DefaultWebProxy プロパティ Line:550-561) | ○ |

### HttpWebRequest クラス（UT-REQ-017 〜 UT-REQ-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | Accept, ContentType, UserAgentなどのヘッダープロパティが正しく動作する | E-02 (SetSpecialHeaders, Accept, ContentType など) | ○ |
| C-10 | ContentLengthに負の値を設定すると例外がスローされる | E-02 (ContentLength setter Line:338) | ○ |
| C-11 | リクエスト送信後のプロパティ変更で例外がスローされる | E-02 (RequestSubmitted チェック 複数箇所) | ○ |
| C-12 | Methodに空文字やnullを設定すると例外がスローされる | E-02 (Method setter Line:933-939) | ○ |
| C-13 | Timeoutに負の値(Infinite以外)で例外がスローされる | E-02 (Timeout setter Line:314-318) | ○ |
| C-14 | ContinueTimeoutの検証ロジック | E-02 (ContinueTimeout setter Line:287-305) | ○ |
| C-15 | MaximumAutomaticRedirectionsに0以下で例外 | E-02 (MaximumAutomaticRedirections setter Line:270) | ○ |
| C-16 | ReadWriteTimeoutの検証ロジック | E-02 (ReadWriteTimeout setter Line:841-861) | ○ |
| C-17 | Host設定時の検証（スラッシュ禁止、null禁止） | E-02 (Host setter Line:363-403) | ○ |
| C-18 | Connection に keep-alive/close を含む場合は例外 | E-02 (Connection setter Line:585-623) | ○ |
| C-19 | Expect に 100-continue を含む場合は例外 | E-02 (Expect setter Line:635-672) | ○ |
| C-20 | TransferEncoding に chunked を含む場合は例外 | E-02 (TransferEncoding setter Line:444-489) | ○ |
| C-21 | SendChunked がリクエスト送信後に変更不可 | E-02 (SendChunked setter Line:753-774) | ○ |
| C-22 | ProtocolVersionでHTTP/1.0, 1.1以外は例外 | E-02 (ProtocolVersion setter Line:816-839) | ○ |
| C-23 | AddRangeメソッドの範囲検証 | E-02 (AddRange メソッド群 Line:1470-1582) | ○ |
| C-24 | GetRequestStreamでGET/HEADメソッド時に例外 | E-02 (CheckRequestStream メソッド Line:1070-1088) | ○ |
| C-25 | BeginGetRequestStreamの二重呼び出しで例外 | E-02 (BeginGetRequestStream Line:1146-1163) | ○ |
| C-26 | EndGetRequestStreamの検証ロジック | E-02 (EndGetRequestStream Line:1165-1192) | ○ |
| C-27 | BeginGetResponseの二重呼び出しで例外 | E-02 (BeginGetResponse Line:1423-1436) | ○ |
| C-28 | EndGetResponseの検証ロジック | E-02 (EndGetResponse Line:1438-1463) | ○ |
| C-29 | Abortメソッドの動作 | E-02 (Abort メソッド Line:996-1030) | ○ |
| C-30 | CheckAbortでリクエスト中止時に例外 | E-02 (CheckAbort メソッド Line:1592-1598) | ○ |
| C-31 | ServicePointプロパティの遅延初期化 | E-02 (ServicePoint Line:789) | ○ |
| C-32 | ClientCertificatesの遅延初期化とnull設定禁止 | E-02 (ClientCertificates Line:799-807) | ○ |
| C-33 | DefaultMaximumResponseHeadersLengthの検証 | E-02 (DefaultMaximumResponseHeadersLength Line:682-706) | ○ |
| C-34 | HaveResponseの状態確認 | E-02 (HaveResponse Line:887-893) | ○ |

### HttpWebResponse クラス（UT-REQ-119 〜 UT-REQ-146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | StatusCode, StatusDescriptionの取得 | E-03 (StatusCode, StatusDescription Line:241-257) | ○ |
| C-36 | ContentLengthでContent-Lengthヘッダー値を返す | E-03 (ContentLength Line:81-88) | ○ |
| C-37 | ContentTypeでContent-Typeヘッダー値を返す | E-03 (ContentType Line:90-110) | ○ |
| C-38 | Headers でレスポンスヘッダーをWebHeaderCollectionで返す | E-03 (Headers Line:194-218) | ○ |
| C-39 | LastModifiedの日付パースと例外処理 | E-03 (LastModified Line:141-161) | ○ |
| C-40 | CharacterSetのパースロジック（text/*のデフォルト処理含む） | E-03 (CharacterSet Line:262-327) | ○ |
| C-41 | GetResponseStreamの実装（TruncatedReadStream含む） | E-03 (GetResponseStream Line:337-353, TruncatedReadStream Line:384-434) | ○ |
| C-42 | Dispose後のアクセスでObjectDisposedException | E-03 (CheckDisposed Line:377-380) | ○ |
| C-43 | Cookiesプロパティの動作 | E-03 (Cookies Line:126-139, コンストラクタ Line:58-72) | ○ |

### FtpWebRequest クラス（UT-REQ-147 〜 UT-REQ-180）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | Methodの設定とFtpMethodInfo検証 | E-05 (Method setter Line:257-280, FtpMethodInfo.GetMethodInfo Line:97-105) | ○ |
| C-45 | RenameToの検証ロジック | E-05 (RenameTo setter Line:288-306) | ○ |
| C-46 | Credentialsの検証（DefaultNetworkCredentials禁止） | E-05 (Credentials setter Line:311-331) | ○ |
| C-47 | Timeout, ReadWriteTimeoutの検証 | E-05 (Timeout setter Line:347-369, ReadWriteTimeout setter Line:385-403) | ○ |
| C-48 | ContentOffsetに負の値で例外 | E-05 (ContentOffset setter Line:408-423) | ○ |
| C-49 | UseBinary, UsePassive, EnableSslの状態検証 | E-05 (UseBinary Line:1495-1509, UsePassive Line:1511-1525, EnableSsl Line:1543-1557) | ○ |
| C-50 | GetRequestStreamでダウンロードメソッド時に例外 | E-05 (GetRequestStream Line:710-757) | ○ |
| C-51 | GetResponseでの二重呼び出し例外 | E-05 (GetResponse Line:520-598) | ○ |
| C-52 | ContentType, UseDefaultCredentials, PreAuthenticateはNotSupported | E-05 (Line:1566-1602) | ○ |
| C-53 | URI内の改行文字でFormatException | E-05 (FtpWebRequest コンストラクタ Line:490-491) | ○ |
| C-54 | Abortメソッドの実装 | E-05 (Abort Line:1423-1456) | ○ |

### FtpWebResponse クラス（UT-REQ-181 〜 UT-REQ-192）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | StatusCode, StatusDescriptionの取得 | E-06 (StatusCode Line:133-139, StatusDescription Line:144-150) | ○ |
| C-56 | LastModified, BannerMessage, WelcomeMessage, ExitMessageの取得 | E-06 (Line:155-194) | ○ |
| C-57 | GetResponseStreamでEmptyStreamのフォールバック | E-06 (GetResponseStream Line:48-61, EmptyStream Line:63-68) | ○ |

### FileWebRequest クラス（UT-REQ-193 〜 UT-REQ-206）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | Methodの空文字検証 | E-07 (Method setter Line:82-89) | ○ |
| C-59 | ContentLengthに負の値で例外 | E-07 (ContentLength setter Line:62-69) | ○ |
| C-60 | Timeoutの検証ロジック | E-07 (Timeout setter Line:96-107) | ○ |
| C-61 | GetRequestStreamでGET/HEADメソッド時に例外 | E-07 (CheckAndMarkAsyncGetRequestStreamPending Line:114-140) | ○ |
| C-62 | UseDefaultCredentialsはNotSupported | E-07 (UseDefaultCredentials Line:289-293) | ○ |
| C-63 | Abortメソッドの実装 | E-07 (Abort Line:295-302) | ○ |

### FileWebResponse クラス（UT-REQ-207 〜 UT-REQ-214）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | ContentLengthでファイルサイズを返す | E-08 (ContentLength Line:68-75) | ○ |
| C-65 | ContentTypeでapplication/octet-streamを返す | E-08 (ContentType Line:77-84, DefaultFileContentType Line:14) | ○ |
| C-66 | Close後のアクセスでObjectDisposedException | E-08 (CheckDisposed Line:106-109) | ○ |
| C-67 | SupportsHeadersがtrueを返す | E-08 (SupportsHeaders Line:95) | ○ |

### WebException クラス（UT-REQ-215 〜 UT-REQ-222）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | 各コンストラクタの動作 | E-09 (コンストラクタ群 Line:22-54) | ○ |
| C-69 | Status, Responseプロパティの取得 | E-09 (Status Line:63, Response Line:65) | ○ |
| C-70 | CreateCompatibleExceptionの変換ロジック | E-09 (CreateCompatibleException Line:80-101) | ○ |

### Authorization クラス（UT-REQ-223 〜 UT-REQ-231）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | 各コンストラクタの動作 | E-10 (コンストラクタ群 Line:11-26) | ○ |
| C-72 | 空トークンでMessageがnullになる | E-10 (コンストラクタ Line:22) | ○ |
| C-73 | ProtectionRealmで空配列がnullになる | E-10 (ProtectionRealm setter Line:36-37) | ○ |
| C-74 | MutuallyAuthenticatedはCompleteとの組み合わせ | E-10 (MutuallyAuthenticated getter Line:42) | ○ |

### ServicePointManager クラス（UT-REQ-232 〜 UT-REQ-254）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | SecurityProtocolの設定と検証 | E-11 (SecurityProtocol Line:27-35, ValidateSecurityProtocol Line:37-48) | ○ |
| C-76 | MaxServicePointsに負の値で例外 | E-11 (MaxServicePoints setter Line:56-58) | ○ |
| C-77 | DefaultConnectionLimitに0以下で例外 | E-11 (DefaultConnectionLimit setter Line:66-68) | ○ |
| C-78 | MaxServicePointIdleTimeの検証 | E-11 (MaxServicePointIdleTime setter Line:76-78) | ○ |
| C-79 | FindServicePointの実装 | E-11 (FindServicePoint Line:103-168) | ○ |
| C-80 | SetTcpKeepAliveの検証 | E-11 (SetTcpKeepAlive Line:206-222) | ○ |

### ServicePoint クラス（UT-REQ-255 〜 UT-REQ-274）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | ConnectionLimitに0以下で例外 | E-12 (ConnectionLimit setter Line:79-81) | ○ |
| C-82 | MaxIdleTimeの検証 | E-12 (MaxIdleTime setter Line:46-49) | ○ |
| C-83 | ConnectionLeaseTimeoutの検証 | E-12 (ConnectionLeaseTimeout setter Line:34-38) | ○ |
| C-84 | ReceiveBufferSizeの検証 | E-12 (ReceiveBufferSize setter Line:58-61) | ○ |
| C-85 | SetTcpKeepAliveの検証 | E-12 (SetTcpKeepAlive Line:93-109) | ○ |
| C-86 | CloseConnectionGroupが常にtrueを返す | E-12 (CloseConnectionGroup Line:73) | ○ |

### HttpRequestCachePolicy クラス（UT-REQ-275 〜 UT-REQ-285）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | 各コンストラクタの動作 | E-13 (コンストラクタ群 Line:15-78) | ○ |
| C-88 | 無効なHttpCacheAgeControlで例外 | E-13 (コンストラクタ Line:37-38, 63-64) | ○ |
| C-89 | ToStringの実装 | E-13 (ToString Line:93-100) | ○ |
| C-90 | MapLevelの変換ロジック | E-13 (MapLevel Line:102-120) | ○ |

### GlobalProxySelection クラス（UT-REQ-286 〜 UT-REQ-288）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | SelectプロパティがDefaultWebProxyをラップ | E-14 (Select Line:12-17) | ○ |
| C-92 | GetEmptyWebProxyでEmptyWebProxyを返す | E-14 (GetEmptyWebProxy Line:19, EmptyWebProxy Line:21-36) | ○ |

### WebResponse 基底クラス（UT-REQ-289 〜 UT-REQ-298）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | 抽象プロパティ/メソッドでNotImplementedExceptionをスロー | E-04 (各プロパティ/メソッド) | ○ |
| C-94 | Close, Disposeの基本実装 | E-04 (Close Line:46-48, Dispose Line:50-66) | ○ |
| C-95 | SupportsHeaders, IsFromCache, IsMutuallyAuthenticatedのデフォルト値 | E-04 (Line:103-105, 147-153) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本レポートは.NET Runtimeのレガシーネットワークリクエストライブラリのテストケースを網羅しています

注意事項：
- このモジュールは `[Obsolete]` 属性が付与されたレガシーAPIを多く含みます
- `HttpWebRequest`、`FtpWebRequest`、`FileWebRequest` は現在非推奨であり、新規開発では `HttpClient` の使用が推奨されています
- 一部のプロパティやメソッドは `PlatformNotSupportedException` をスローする可能性があります（シリアライゼーション関連）

## 6) レビュアーチェックリスト（最小）
- [ ] 正常系テストケースが主要な公開APIを網羅しているか
- [ ] 異常系テストケースが例外スロー条件を網羅しているか
- [ ] 境界値テストケースが適切に設計されているか
- [ ] Obsolete APIに対するテストケースが適切に分類されているか
- [ ] セキュリティ関連（認証、証明書検証）のテストケースが十分か
- [ ] タイムアウト処理のテストケースが網羅されているか
- [ ] リソース解放（Dispose/Close）のテストケースが含まれているか
