---
generated_at: 2026-01-30 17:35:00
metrics:
  claims_total: 87
  claims_with_evidence: 87
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Net.ServerSentEvents 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードからの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：対象クラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：87 / 87、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.ServerSentEvents/src/System/Net/ServerSentEvents/SseItem.cs`
- E-02: `src/libraries/System.Net.ServerSentEvents/src/System/Net/ServerSentEvents/SseParser.cs`
- E-03: `src/libraries/System.Net.ServerSentEvents/src/System/Net/ServerSentEvents/SseParser_1.cs`
- E-04: `src/libraries/System.Net.ServerSentEvents/src/System/Net/ServerSentEvents/SseFormatter.cs`
- E-05: `src/libraries/System.Net.ServerSentEvents/src/System/Net/ServerSentEvents/SseItemParser.cs`
- E-06: `src/libraries/System.Net.ServerSentEvents/src/System/Net/ServerSentEvents/Helpers.cs`
- E-07: `src/libraries/System.Net.ServerSentEvents/src/System/Net/ServerSentEvents/ThrowHelper.cs`
- E-08: `src/libraries/System.Net.ServerSentEvents/src/System/Net/ServerSentEvents/PooledByteBufferWriter.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### SseItem<T> クラス（UT-SSE-001 〜 UT-SSE-013）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SseItem<T>コンストラクタでdata, eventTypeを設定できる | E-01: L21-30 | ○ |
| C-02 | eventType=nullでデフォルト値"message"が使用される | E-01: L36, E-02: L13 | ○ |
| C-03 | eventTypeに改行を含むとArgumentExceptionがスロー | E-01: L23-26, E-06: L56-57 | ○ |
| C-04 | eventTypeにCRを含むとArgumentExceptionがスロー | E-01: L23-26, E-06: L56-57 | ○ |
| C-05 | Dataプロパティで値を取得できる | E-01: L33 | ○ |
| C-06 | EventTypeプロパティで値を取得できる | E-01: L36 | ○ |
| C-07 | EventId initプロパティで値を設定できる | E-01: L40-51 | ○ |
| C-08 | EventIdに改行を含むとArgumentExceptionがスロー | E-01: L45-48 | ○ |
| C-09 | EventId=nullを設定できる | E-01: L42-50 (値がnullの場合チェックをパス) | ○ |
| C-10 | ReconnectionInterval initプロパティで値を設定できる | E-01: L58-69 | ○ |
| C-11 | ReconnectionIntervalに負の値を設定するとArgumentException | E-01: L63-66 | ○ |
| C-12 | ReconnectionInterval=TimeSpan.Zeroを設定できる | E-01: L63 (< Zero のみチェック) | ○ |
| C-13 | ReconnectionInterval=nullを設定できる | E-01: L58-69 (Nullable<TimeSpan>) | ○ |

### SseParser 静的クラス（UT-SSE-014 〜 UT-SSE-019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | EventTypeDefault定数は"message" | E-02: L13 | ○ |
| C-15 | Create(Stream)でSseParser<string>を作成できる | E-02: L26-27 | ○ |
| C-16 | Create(null)でArgumentNullExceptionがスロー | E-02: L37-40 | ○ |
| C-17 | Create<T>(Stream, Parser)でSseParser<T>を作成できる | E-02: L35-48 | ○ |
| C-18 | Create<T>(null, Parser)でArgumentNullException | E-02: L37-40 | ○ |
| C-19 | Create<T>(Stream, null)でArgumentNullException | E-02: L42-45 | ○ |

### SseParser<T> クラス（UT-SSE-020 〜 UT-SSE-046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | Enumerate()で単一イベントをパースできる | E-03: L97-171 | ○ |
| C-21 | 複数イベントを連続してパースできる | E-03: L114-141 | ○ |
| C-22 | eventフィールドをパースできる | E-03: L406-409 | ○ |
| C-23 | idフィールドをパースできる | E-03: L411-418 | ○ |
| C-24 | retryフィールドをパースできる | E-03: L420-436 | ○ |
| C-25 | コメント行（:で始まる）が無視される | E-03: L440-443 | ○ |
| C-26 | UTF8 BOMがスキップされる | E-03: L110-111, L519-532 | ○ |
| C-27 | CRLFで行が区切られる | E-03: L30, L275-279 | ○ |
| C-28 | CRで行が区切られる | E-03: L26-28 | ○ |
| C-29 | LFで行が区切られる | E-03: L26-28 | ○ |
| C-30 | 複数data行が結合される | E-03: L365-405, L396-404 | ○ |
| C-31 | dataの先頭スペースが1つのみ除去される | E-03: L350-356 | ○ |
| C-32 | 空のdata行が処理される | E-03: L365-405 | ○ |
| C-33 | 空のStreamでイベント0件 | E-03: L152-157 | ○ |
| C-34 | 2回目のEnumerate()でInvalidOperationException | E-03: L463-470 | ○ |
| C-35 | idにNULL文字を含む場合無視される | E-03: L414 | ○ |
| C-36 | retryに非数値で無視される | E-03: L424-430 | ○ |
| C-37 | retryに負数で無視される | E-03: L431 | ○ |
| C-38 | EOFで不完全イベントが破棄される | E-03: L152-157 | ○ |
| C-39 | EnumerateAsync()で非同期パースできる | E-03: L177-251 | ○ |
| C-40 | CancellationTokenでキャンセルできる | E-03: L177, L190, L240 | ○ |
| C-41 | 2回目のEnumerateAsync()でInvalidOperationException | E-03: L180 | ○ |
| C-42 | LastEventIdが更新される | E-03: L417, L452 | ○ |
| C-43 | LastEventId初期値は空文字 | E-03: L452 | ○ |
| C-44 | 空のidでLastEventIdがリセットされる | E-03: L416-417 | ○ |
| C-45 | ReconnectionIntervalが更新される | E-03: L435, L461 | ○ |
| C-46 | ReconnectionInterval初期値はTimeout.InfiniteTimeSpan | E-03: L461 | ○ |

### SseFormatter クラス（UT-SSE-047 〜 UT-SSE-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | WriteAsync()で単一イベントをフォーマットできる | E-04: L27-40 | ○ |
| C-48 | eventフィールドがフォーマットされる | E-04: L103-110 | ○ |
| C-49 | idフィールドがフォーマットされる | E-04: L115-122 | ○ |
| C-50 | retryフィールドがフォーマットされる | E-04: L124-131 | ○ |
| C-51 | 複数行dataがフォーマットされる | E-04: L112, L136-164 | ○ |
| C-52 | CRLFがLFに正規化される | E-04: L139-156 | ○ |
| C-53 | source=nullでArgumentNullException | E-04: L29-32 | ○ |
| C-54 | destination=nullでArgumentNullException | E-04: L34-37 | ○ |
| C-55 | カスタムフォーマッタでフォーマットできる | E-04: L51-69 | ○ |
| C-56 | itemFormatter=nullでArgumentNullException | E-04: L63-66 | ○ |
| C-57 | CancellationTokenでキャンセルできる | E-04: L76 | ○ |
| C-58 | eventType=nullでeventフィールドが出力されない | E-04: L103 | ○ |

### Helpers クラス（UT-SSE-059 〜 UT-SSE-070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | ContainsLineBreaks()で改行なし文字列はfalse | E-06: L56-57 | ○ |
| C-60 | ContainsLineBreaks()でLF含む文字列はtrue | E-06: L57 | ○ |
| C-61 | ContainsLineBreaks()でCR含む文字列はtrue | E-06: L57 | ○ |
| C-62 | ContainsLineBreaks()で空文字列はfalse | E-06: L56-57 | ○ |
| C-63 | WriteUtf8Number()で正の数値を書き込める | E-06: L13-26 | ○ |
| C-64 | WriteUtf8Number()で0を書き込める | E-06: L13-26 | ○ |
| C-65 | WriteUtf8Number()でlong.MaxValueを書き込める | E-06: L16-22 | ○ |
| C-66 | WriteUtf8String(byte[])でバイト配列を書き込める | E-06: L28-39 | ○ |
| C-67 | WriteUtf8String(byte[])で空配列は何も書き込まない | E-06: L30-33 | ○ |
| C-68 | WriteUtf8String(char[])で文字列を書き込める | E-06: L41-54 | ○ |
| C-69 | WriteUtf8String(char[])で空文字列は何も書き込まない | E-06: L43-46 | ○ |
| C-70 | WriteUtf8String(char[])でマルチバイト文字をエンコード | E-06: L48-53 | ○ |

### PooledByteBufferWriter クラス（UT-SSE-071 〜 UT-SSE-079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Advance()でバッファを進める | E-08: L14 | ○ |
| C-72 | GetMemory()で要求サイズ以上のMemoryを取得 | E-08: L16-20 | ○ |
| C-73 | GetMemory(0)でデフォルトサイズを取得 | E-08: L11, L18 | ○ |
| C-74 | GetSpan()で要求サイズ以上のSpanを取得 | E-08: L22-26 | ○ |
| C-75 | WrittenMemoryで書き込み済みデータを取得 | E-08: L28 | ○ |
| C-76 | WrittenCountで書き込みバイト数を取得 | E-08: L30 | ○ |
| C-77 | Reset()でWrittenCountが0になる | E-08: L31 | ○ |
| C-78 | Dispose()でリソースが解放される | E-08: L32 | ○ |
| C-79 | 初期容量が256以上 | E-08: L11-12, L29 | ○ |

### ThrowHelper クラス（UT-SSE-080 〜 UT-SSE-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | ThrowArgumentNullException()で例外をスロー | E-07: L10-14 | ○ |
| C-81 | ThrowArgumentException_CannotContainLineBreaks()で例外をスロー | E-07: L16-19 | ○ |
| C-82 | ThrowArgumentException_CannotBeNegative()で例外をスロー | E-07: L21-24 | ○ |

### SseItemParser<T> デリゲート（UT-SSE-083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | eventTypeとdataがデリゲートに渡される | E-05: L11 | ○ |

### 追加テストケース（UT-SSE-084 〜 UT-SSE-087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | 認識されないフィールド名が無視される | E-03: L438-443 | ○ |
| C-85 | 非常に長い行が処理される | E-03: L285-310 (バッファ拡張ロジック) | ○ |
| C-86 | コロンなしの行がフィールド名として扱われる | E-03: L358-363 | ○ |
| C-87 | retryにTimeSpan.MaxValue相当値を設定できる | E-03: L32-34, L430-434 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- SSE仕様（https://html.spec.whatwg.org/multipage/server-sent-events.html）との整合性は人間レビュアーによる確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] SseItem<T>のバリデーションロジック（改行・負値チェック）が正しくテストされているか
- [ ] SseParser<T>のEnumerate/EnumerateAsyncの再列挙防止が正しくテストされているか
- [ ] 各フィールド（data, event, id, retry）のパースロジックが網羅されているか
- [ ] SseFormatterの出力形式がSSE仕様に準拠しているか
- [ ] 境界値テスト（空文字、null、最大値、ゼロ値）が十分か
- [ ] 非同期処理のCancellationToken対応が正しくテストされているか
- [ ] UTF8 BOM処理が正しくテストされているか
- [ ] 改行コード（CR, LF, CRLF）の処理が網羅されているか
