---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 336
  claims_with_evidence: 336
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: libraries-System.Net.Sockets 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：336 / 336、根拠なし：0
- 優先レビュー（高）
  1. **Socket クラスの非同期メソッド群**: Socket.Tasks.cs は大規模で全メソッドを網羅するには追加分析が必要
  2. **プラットフォーム固有実装**: Unix/Windows固有のSocketPal実装の差異
  3. **エラー処理パス**: SocketException発生条件の網羅性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/Socket.cs`
- E-02: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/TcpClient.cs`
- E-03: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/TcpListener.cs`
- E-04: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/UdpClient.cs`
- E-05: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/NetworkStream.cs`
- E-06: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/SocketAsyncEventArgs.cs`
- E-07: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/SafeSocketHandle.cs`
- E-08: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/LingerOption.cs`
- E-09: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/MulticastOption.cs`
- E-10: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/IPPacketInformation.cs`
- E-11: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/SendPacketsElement.cs`
- E-12: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/UdpReceiveResult.cs`
- E-13: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/UnixDomainSocketEndPoint.cs`
- E-14: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/SocketsTelemetry.cs`
- E-15: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/Socket.Tasks.cs`
- E-16: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/Socket.Unix.cs`
- E-17: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/Socket.Windows.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Socket クラス（UT-SKT-001 〜 UT-SKT-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Socket(SocketType, ProtocolType)でデュアルモードソケット作成 | E-01 (line 72-79) | ○ |
| C-02 | Socket(AddressFamily, SocketType, ProtocolType)でソケット作成 | E-01 (line 82-101) | ○ |
| C-03 | Socket(SafeSocketHandle)でハンドルからソケット作成 | E-01 (line 114-117, 119-235) | ○ |
| C-04 | Availableプロパティでバイト数取得 | E-01 (line 270-291) | ○ |
| C-05 | LocalEndPointプロパティでエンドポイント取得 | E-01 (line 294-339) | ○ |
| C-06 | RemoteEndPointプロパティでリモート取得 | E-01 (line 342-388) | ○ |
| C-07 | Blockingプロパティでモード設定 | E-01 (line 405-430) | ○ |
| C-08 | Connectedプロパティで接続状態確認 | E-01 (line 449-458) | ○ |
| C-09 | AddressFamily/SocketType/ProtocolTypeプロパティ | E-01 (line 462-486) | ○ |
| C-10 | IsBoundプロパティでバインド状態確認 | E-01 (line 488-494) | ○ |
| C-11 | ExclusiveAddressUseプロパティ | E-01 (line 496-509) | ○ |
| C-12 | ReceiveBufferSize/SendBufferSizeプロパティ | E-01 (line 512-538) | ○ |
| C-13 | ReceiveTimeout/SendTimeoutプロパティ | E-01 (line 541-580) | ○ |
| C-14 | LingerStateプロパティ | E-01 (line 582-597) | ○ |
| C-15 | NoDelayプロパティ | E-01 (line 599-608) | ○ |
| C-16 | Ttlプロパティと境界値検証 | E-01 (line 611-648) | ○ |
| C-17 | DontFragmentプロパティ | E-01 (line 651-680) | ○ |
| C-18 | MulticastLoopbackプロパティ | E-01 (line 682-721) | ○ |
| C-19 | EnableBroadcastプロパティ | E-01 (line 723-738) | ○ |
| C-20 | DualModeプロパティ | E-01 (line 744-769) | ○ |
| C-21 | Bind(EndPoint)メソッド | E-01 (line 789-827) | ○ |
| C-22 | Connect(EndPoint)メソッドと状態検証 | E-01 (line 830-872) | ○ |
| C-23 | Connect(IPAddress, int)メソッド | E-01 (line 874-897) | ○ |
| C-24 | Connect(string, int)メソッド | E-01 (line 899-928) | ○ |
| C-25 | Connect(IPAddress[], int)メソッド | E-01 (line 930-979) | ○ |
| C-26 | Close()メソッドとタイムアウト付きClose | E-01 (line 981-996) | ○ |

### TcpClient クラス（UT-SKT-078 〜 UT-SKT-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | TcpClient()コンストラクタ | E-02 (line 26-27) | ○ |
| C-28 | TcpClient(AddressFamily)コンストラクタと検証 | E-02 (line 31-42) | ○ |
| C-29 | TcpClient(IPEndPoint)コンストラクタ | E-02 (line 45-53) | ○ |
| C-30 | TcpClient(string, int)コンストラクタ | E-02 (line 57-76) | ○ |
| C-31 | Available/Client/Connectedプロパティ | E-02 (line 92-109) | ○ |
| C-32 | Connectメソッド群 | E-02 (line 121-179) | ○ |
| C-33 | ConnectAsyncメソッド群 | E-02 (line 181-226) | ○ |
| C-34 | GetStream()メソッド | E-02 (line 247-257) | ○ |
| C-35 | ReceiveBufferSize/SendBufferSizeプロパティ | E-02 (line 303-314) | ○ |
| C-36 | ReceiveTimeout/SendTimeoutプロパティ | E-02 (line 317-344) | ○ |
| C-37 | LingerState/NoDelayプロパティ | E-02 (line 347-366) | ○ |
| C-38 | Dispose実装 | E-02 (line 262-298) | ○ |

### TcpListener クラス（UT-SKT-109 〜 UT-SKT-131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | TcpListener(IPEndPoint)コンストラクタ | E-03 (line 23-30) | ○ |
| C-40 | TcpListener(IPAddress, int)コンストラクタ | E-03 (line 34-46) | ○ |
| C-41 | Server/LocalEndpointプロパティ | E-03 (line 62-88) | ○ |
| C-42 | ExclusiveAddressUseプロパティと状態制限 | E-03 (line 90-106) | ○ |
| C-43 | Start()/Start(int)メソッド | E-03 (line 127-157) | ○ |
| C-44 | Stop()メソッド | E-03 (line 160-165) | ○ |
| C-45 | Pending()メソッド | E-03 (line 173-181) | ○ |
| C-46 | AcceptSocket()/AcceptTcpClient()メソッド | E-03 (line 184-207) | ○ |
| C-47 | AcceptSocketAsync()/AcceptTcpClientAsync()メソッド | E-03 (line 221-241) | ○ |
| C-48 | Create(int)静的ファクトリ | E-03 (line 244-265) | ○ |

### UdpClient クラス（UT-SKT-132 〜 UT-SKT-175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | UdpClient()コンストラクタ群 | E-04 (line 24-94) | ○ |
| C-50 | Available/Client/Ttl等プロパティ | E-04 (line 109-187) | ○ |
| C-51 | Connectメソッド群 | E-04 (line 686-829) | ○ |
| C-52 | Send/SendAsyncメソッド群 | E-04 (line 524-613, 854-973) | ○ |
| C-53 | Receive/ReceiveAsyncメソッド | E-04 (line 615-656, 831-850) | ○ |
| C-54 | JoinMulticastGroup/DropMulticastGroupメソッド | E-04 (line 394-522) | ○ |
| C-55 | Dispose実装 | E-04 (line 213-247) | ○ |

### NetworkStream クラス（UT-SKT-176 〜 UT-SKT-222）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | NetworkStreamコンストラクタ群と検証 | E-05 (line 30-83) | ○ |
| C-57 | CanRead/CanWrite/CanSeek/CanTimeoutプロパティ | E-05 (line 103-113) | ○ |
| C-58 | ReadTimeout/WriteTimeoutプロパティと検証 | E-05 (line 117-167) | ○ |
| C-59 | DataAvailableプロパティ | E-05 (line 171-181) | ○ |
| C-60 | Length/Positionプロパティ（NotSupportedException） | E-05 (line 184-204) | ○ |
| C-61 | Read/Write系メソッド | E-05 (line 227-347) | ○ |
| C-62 | ReadAsync/WriteAsyncメソッド | E-05 (line 563-666) | ○ |
| C-63 | Flush/FlushAsyncメソッド | E-05 (line 669-676) | ○ |
| C-64 | Seek/SetLengthメソッド（NotSupportedException） | E-05 (line 208-211, 679-682) | ○ |
| C-65 | Close(int)/Close(TimeSpan)メソッド | E-05 (line 360-386) | ○ |
| C-66 | Dispose実装とSocket所有権 | E-05 (line 388-415) | ○ |

### SocketAsyncEventArgs クラス（UT-SKT-223 〜 UT-SKT-254）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | コンストラクタとExecutionContextフロー制御 | E-06 (line 91-104) | ○ |
| C-68 | AcceptSocket/ConnectSocket/Bufferプロパティ | E-06 (line 106-136) | ○ |
| C-69 | BufferListプロパティと排他制御 | E-06 (line 147-197) | ○ |
| C-70 | BytesTransferred/LastOperationプロパティ | E-06 (line 199-251) | ○ |
| C-71 | RemoteEndPoint/SocketError/SocketFlagsプロパティ | E-06 (line 258-302) | ○ |
| C-72 | SetBufferメソッド群と検証 | E-06 (line 330-427) | ○ |
| C-73 | Completedイベント | E-06 (line 204-239) | ○ |
| C-74 | Dispose実装 | E-06 (line 497-500) | ○ |

### ヘルパークラス群（UT-SKT-255 〜 UT-SKT-336）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | LingerOptionクラス | E-08 (line 8-51) | ○ |
| C-76 | MulticastOption/IPv6MulticastOptionクラス | E-09 (line 7-133) | ○ |
| C-77 | IPPacketInformation構造体 | E-10 (line 8-41) | ○ |
| C-78 | SendPacketsElementクラス | E-11 (line 9-117) | ○ |
| C-79 | UdpReceiveResult構造体 | E-12 (line 11-100) | ○ |
| C-80 | UnixDomainSocketEndPointクラス | E-13 (line 12-169) | ○ |
| C-81 | SafeSocketHandleクラス | E-07 (line 23-187) | ○ |
| C-82 | SocketsTelemetryクラス | E-14 (line 10-295) | ○ |

## 4) 不足情報（Unknown / Missing）
- Socket.Tasks.cs の全非同期メソッド: 70604バイトの大規模ファイルで、全メソッドの詳細確認には追加分析が必要
  - 候補：ConnectAsync / SendAsync / ReceiveAsync の各オーバーロード
- SocketPal.Unix.cs / SocketPal.Windows.cs: プラットフォーム固有のエラー条件
  - 候補：プラットフォーム間の挙動差異テスト
- SocketAsyncEngine: 非同期エンジンの内部動作テスト
  - 候補：Unix/Wasi固有の非同期処理

## 5) リスクフラグ（レビュー観点）
- 0: **低リスク** - LingerOption, MulticastOption, IPPacketInformation等の単純なデータクラス
- 1: **中リスク** - TcpClient, TcpListener, UdpClient等の高レベルAPI（内部でSocket操作を委譲）
- 2: **高リスク** - Socketクラスの接続管理、非同期操作、リソース解放（データ整合性・リソースリークに直結）

## 6) レビュアーチェックリスト（最小）
- [ ] Socketクラスのコンストラクタが正しいパラメータ検証をカバーしているか
- [ ] Connect/Bindの状態遷移が正しく検証されているか
- [ ] 非同期メソッド（ConnectAsync, SendAsync, ReceiveAsync）が網羅されているか
- [ ] Dispose後の操作に対するObjectDisposedExceptionテストが含まれているか
- [ ] タイムアウト境界値（-1, 0, 正の値）が検証されているか
- [ ] マルチキャスト操作のAddressFamily整合性チェックが含まれているか
- [ ] UnixDomainSocketEndPointのプラットフォームサポート検証が含まれているか
- [ ] SocketAsyncEventArgsのBuffer/BufferList排他制御が検証されているか
