---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Net.WebClient 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-WCL-133, UT-WCL-134, UT-WCL-135（PostProgressChanged）**：内部メソッドのため直接テスト困難、統合テストで検証推奨
  2. **UT-WCL-149, UT-WCL-150（StartAsyncOperation）**：内部メソッドのため直接テスト困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Net.WebClient/src/System/Net/WebClient.cs` - WebClientクラス実装（約2100行）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Net.WebClient/ref/System.Net.WebClient.cs` - 公開API定義（約220行）
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Net.WebClient/tests/WebClientTest.cs` - 既存テストコード（約750行）
- E-04: .NET公式ドキュメント - System.Net.WebClient Class（参照：https://learn.microsoft.com/en-us/dotnet/api/system.net.webclient）

## 3) Claims と根拠の対応（レビューの主戦場）

### プロパティ関連（UT-WCL-001〜018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでデフォルトプロパティが正しく初期化される | E-01 (line 56-64), E-03 (line 24-37) | ○ |
| C-02 | Encoding設定が正常に動作する | E-01 (line 142-150), E-03 (line 317-323) | ○ |
| C-03 | Encoding nullでArgumentNullException | E-01 (line 147), E-03 (line 45) | ○ |
| C-04 | BaseAddress設定が正常に動作する | E-01 (line 152-174), E-03 (line 260-267) | ○ |
| C-05 | BaseAddress null/空で空文字列が返る | E-01 (line 158-162), E-03 (line 265-266) | ○ |
| C-06 | BaseAddress不正URIでArgumentException | E-01 (line 168-171), E-03 (line 44) | ○ |
| C-07 | Credentials設定・取得が正常に動作する | E-01 (line 176-180), E-03 (line 279-287) | ○ |
| C-08 | UseDefaultCredentials trueでDefaultCredentials | E-01 (line 182-186), E-03 (line 358-367) | ○ |
| C-09 | UseDefaultCredentials falseでnull | E-01 (line 185), E-03 (line 365-366) | ○ |
| C-10 | Headers遅延初期化 | E-01 (line 191), E-03 (line 326-339) | ○ |
| C-11 | Headers設定が正常に動作する | E-01 (line 188-193), E-03 (line 336-338) | ○ |
| C-12 | QueryString遅延初期化 | E-01 (line 198), E-03 (line 342-355) | ○ |
| C-13 | Proxy未設定でDefaultWebProxy | E-01 (line 206), E-03 (line 295-298) | ○ |
| C-14 | Proxy設定が正常に動作する | E-01 (line 204-212), E-03 (line 300-306) | ○ |
| C-15 | IsBusy操作中でない場合false | E-01 (line 216) | ○ |
| C-16 | IsBusy操作中の場合true | E-01 (line 216), E-03 (line 33, 442-471) | ○ |
| C-17 | ResponseHeaders取得 | E-01 (line 202), E-03 (line 371-386) | ○ |
| C-18 | ResponseHeaders受信前はnull | E-01 (line 202), E-03 (line 374, 379) | ○ |

### ダウンロード系メソッド（UT-WCL-019〜033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | DownloadData(string)正常系 | E-01 (line 279-280), E-03 (line 532-549) | ○ |
| C-20 | DownloadData(Uri)正常系 | E-01 (line 282-296), E-03 (line 532-549) | ○ |
| C-21 | DownloadData(string) null検証 | E-01 (line 280, 778-780), E-03 (line 53) | ○ |
| C-22 | DownloadData(Uri) null検証 | E-01 (line 284), E-03 (line 54) | ○ |
| C-23 | DownloadFile(string, string)正常系 | E-01 (line 319-320), E-03 (line 581-599) | ○ |
| C-24 | DownloadFile(Uri, string)正常系 | E-01 (line 322-356), E-03 (line 581-599) | ○ |
| C-25 | DownloadFile address null検証 | E-01 (line 324), E-03 (line 68-69) | ○ |
| C-26 | DownloadFile fileName null検証 | E-01 (line 325), E-03 (line 77-78) | ○ |
| C-27 | DownloadFile失敗時ファイル削除 | E-01 (line 349-352) | ○ |
| C-28 | DownloadString(string)正常系 | E-01 (line 685-686), E-03 (line 516-529) | ○ |
| C-29 | DownloadString(Uri)正常系 | E-01 (line 688-703), E-03 (line 516-529) | ○ |
| C-30 | DownloadString null検証 | E-01 (line 690), E-03 (line 92-93) | ○ |
| C-31 | OpenRead(string)正常系 | E-01 (line 358-359), E-03 (line 603-616) | ○ |
| C-32 | OpenRead(Uri)正常系 | E-01 (line 361-383), E-03 (line 603-616) | ○ |
| C-33 | OpenRead null検証 | E-01 (line 363), E-03 (line 255-256) | ○ |

### OpenWrite・アップロード系メソッド（UT-WCL-034〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | OpenWrite(string)正常系 | E-01 (line 385-386), E-03 (line 621-629) | ○ |
| C-35 | OpenWrite(Uri)正常系 | E-01 (line 388-389), E-03 (line 621-629) | ○ |
| C-36 | OpenWrite メソッド指定 | E-01 (line 394-421) | ○ |
| C-37 | OpenWrite null検証 | E-01 (line 396), E-03 (line 244-247) | ○ |
| C-38 | UploadData(string, byte[])正常系 | E-01 (line 423-424), E-03 (line 634-648) | ○ |
| C-39 | UploadData(Uri, byte[])正常系 | E-01 (line 426-427), E-03 (line 634-648) | ○ |
| C-40 | UploadData メソッド指定 | E-01 (line 432-449) | ○ |
| C-41 | UploadData address null検証 | E-01 (line 434), E-03 (line 107-110) | ○ |
| C-42 | UploadData data null検証 | E-01 (line 435), E-03 (line 121-124) | ○ |
| C-43 | UploadFile(string, string)正常系 | E-01 (line 547-548), E-03 (line 669-683) | ○ |
| C-44 | UploadFile(Uri, string)正常系 | E-01 (line 550-551), E-03 (line 669-683) | ○ |
| C-45 | UploadFile メソッド指定 | E-01 (line 556-588) | ○ |
| C-46 | UploadFile address null検証 | E-01 (line 558), E-03 (line 141-145) | ○ |
| C-47 | UploadFile fileName null検証 | E-01 (line 559), E-03 (line 156-159) | ○ |
| C-48 | UploadFile multipart Content-Type WebException | E-01 (line 487-490) | ○ |
| C-49 | UploadString(string, string)正常系 | E-01 (line 655-656), E-03 (line 688-695) | ○ |
| C-50 | UploadString(Uri, string)正常系 | E-01 (line 658-659), E-03 (line 688-695) | ○ |
| C-51 | UploadString メソッド指定 | E-01 (line 664-683) | ○ |
| C-52 | UploadString address null検証 | E-01 (line 666), E-03 (line 176-179) | ○ |
| C-53 | UploadString data null検証 | E-01 (line 667), E-03 (line 190-193) | ○ |
| C-54 | UploadValues(string, NVC)正常系 | E-01 (line 618-619), E-03 (line 700-705) | ○ |
| C-55 | UploadValues(Uri, NVC)正常系 | E-01 (line 621-622), E-03 (line 700-705) | ○ |
| C-56 | UploadValues メソッド指定 | E-01 (line 627-653) | ○ |
| C-57 | UploadValues address null検証 | E-01 (line 629), E-03 (line 210-213) | ○ |
| C-58 | UploadValues data null検証 | E-01 (line 630), E-03 (line 224-227) | ○ |
| C-59 | UploadValues 不正Content-Type WebException | E-01 (line 594-598) | ○ |

### 保護されたメソッド（UT-WCL-060〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | GetWebRequest正常系 | E-01 (line 218-252) | ○ |
| C-61 | GetWebResponse(WebRequest)正常系 | E-01 (line 254-259) | ○ |
| C-62 | GetWebResponse(WebRequest, IAsyncResult)正常系 | E-01 (line 261-266) | ○ |
| C-63 | CancelAsync正常系 | E-01 (line 1529-1534) | ○ |
| C-64 | StartOperation正常系 | E-01 (line 90-105) | ○ |
| C-65 | StartOperation同時操作NotSupportedException | E-01 (line 92-96), E-03 (line 442-471) | ○ |
| C-66 | EndOperation正常系 | E-01 (line 140) | ○ |

### ヘルパーメソッド（UT-WCL-067〜078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | GetUri(string)正常系 | E-01 (line 778-796) | ○ |
| C-68 | GetUri(string)相対URI解決 | E-01 (line 783-789) | ○ |
| C-69 | GetUri(string) null検証 | E-01 (line 780) | ○ |
| C-70 | GetUri(Uri)クエリ追加 | E-01 (line 809-821) | ○ |
| C-71 | GetUri(Uri)既存クエリ保持 | E-01 (line 809) | ○ |
| C-72 | MapToDefaultMethod HTTP→POST | E-01 (line 1165-1173) | ○ |
| C-73 | MapToDefaultMethod FTP→STOR | E-01 (line 1171-1172) | ○ |
| C-74 | GetStringUsingEncoding Content-Type検出 | E-01 (line 1088-1131) | ○ |
| C-75 | GetStringUsingEncoding BOM検出 | E-01 (line 1133-1148) | ○ |
| C-76 | GetStringUsingEncoding デフォルトEncoding | E-01 (line 1151) | ○ |
| C-77 | CopyHeadersTo特殊ヘッダー処理 | E-01 (line 711-776), E-03 (line 423-439) | ○ |
| C-78 | CopyHeadersTo非HTTPリクエスト | E-01 (line 718-722) | ○ |

### 非同期メソッド（UT-WCL-079〜098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | DownloadDataAsync正常系 | E-01 (line 1313-1330), E-03 (line 56-57) | ○ |
| C-80 | DownloadDataAsync userToken | E-01 (line 1316-1330) | ○ |
| C-81 | DownloadStringAsync正常系 | E-01 (line 1287-1304), E-03 (line 95-96) | ○ |
| C-82 | DownloadFileAsync正常系 | E-01 (line 1339-1360), E-03 (line 71-72) | ○ |
| C-83 | OpenReadAsync正常系 | E-01 (line 1190-1223), E-03 (line 148-149) | ○ |
| C-84 | OpenWriteAsync正常系 | E-01 (line 1225-1264), E-03 (line 156-158) | ○ |
| C-85 | UploadDataAsync正常系 | E-01 (line 1411-1448), E-03 (line 112-114) | ○ |
| C-86 | UploadStringAsync正常系 | E-01 (line 1362-1409), E-03 (line 181-183) | ○ |
| C-87 | UploadFileAsync正常系 | E-01 (line 1450-1485), E-03 (line 147-149) | ○ |
| C-88 | UploadValuesAsync正常系 | E-01 (line 1487-1524), E-03 (line 215-217) | ○ |
| C-89 | DownloadDataTaskAsync(string)正常系 | E-01 (line 1647-1648), E-03 (line 740) | ○ |
| C-90 | DownloadDataTaskAsync(Uri)正常系 | E-01 (line 1650-1670), E-03 (line 740) | ○ |
| C-91 | DownloadStringTaskAsync正常系 | E-01 (line 1536-1558), E-03 (line 742) | ○ |
| C-92 | DownloadFileTaskAsync正常系 | E-01 (line 1672-1695), E-03 (line 741) | ○ |
| C-93 | OpenReadTaskAsync正常系 | E-01 (line 1560-1583), E-03 (line 749) | ○ |
| C-94 | OpenWriteTaskAsync正常系 | E-01 (line 1585-1614), E-03 (line 750) | ○ |
| C-95 | UploadDataTaskAsync正常系 | E-01 (line 1697-1726), E-03 (line 744) | ○ |
| C-96 | UploadStringTaskAsync正常系 | E-01 (line 1616-1645), E-03 (line 746) | ○ |
| C-97 | UploadFileTaskAsync正常系 | E-01 (line 1728-1757), E-03 (line 745) | ○ |
| C-98 | UploadValuesTaskAsync正常系 | E-01 (line 1759-1788), E-03 (line 747) | ○ |

### イベント関連（UT-WCL-099〜122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | DownloadProgressChangedイベント | E-01 (line 75, 81, 1819-1824), E-03 (line 539) | ○ |
| C-100 | UploadProgressChangedイベント | E-01 (line 76, 86, 1810-1818), E-03 (line 639) | ○ |
| C-101〜C-111 | OnXxxCompletedイベント発火 | E-01 (line 78-88) | ○ |
| C-112〜C-122 | EventArgs Result取得 | E-01 (line 1910-2092) | ○ |

### 内部処理（UT-WCL-123〜150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | DownloadBits正常系 | E-01 (line 826-865) | ○ |
| C-124 | DownloadBitsサイズ制限 | E-01 (line 837-840) | ○ |
| C-125 | UploadBits FileStream | E-01 (line 943-1002) | ○ |
| C-126 | UploadBits buffer | E-01 (line 974-985) | ○ |
| C-127 | UploadBits file://スキーム | E-01 (line 949-952, 1016-1018) | ○ |
| C-128 | GetValuesToUpload正常系 | E-01 (line 590-616) | ○ |
| C-129 | GetValuesToUpload不正Content-Type | E-01 (line 594-598) | ○ |
| C-130 | OpenFileInternal POST multipart | E-01 (line 497-529) | ○ |
| C-131 | OpenFileInternal非POST | E-01 (line 530-542) | ○ |
| C-132 | 同時操作NotSupportedException | E-01 (line 92-96), E-03 (line 442-471) | ○ |
| C-133 | PostProgressChangedアップロード | E-01 (line 1805-1818) | △ |
| C-134 | PostProgressChangedダウンロード | E-01 (line 1820-1824) | △ |
| C-135 | PostProgressChangedゼロスキップ | E-01 (line 1807) | ○ |
| C-136 | ProgressData.Reset | E-01 (line 1837-1844) | ○ |
| C-137 | WebClientWriteStream.Dispose | E-01 (line 1858-1871) | ○ |
| C-138 | HandleCompletion結果設定 | E-01 (line 1790-1803) | ○ |
| C-139 | HandleCompletion例外設定 | E-01 (line 1798) | ○ |
| C-140 | HandleCompletionキャンセル | E-01 (line 1799) | ○ |
| C-141 | InvokeOperationCompleted正常 | E-01 (line 1181-1188) | ○ |
| C-142 | InvokeOperationCompleted不一致 | E-01 (line 1183) | ○ |
| C-143 | AbortRequest正常 | E-01 (line 705-709) | ○ |
| C-144 | AbortRequest null | E-01 (line 707) | ○ |
| C-145 | AbortRequest例外抑制 | E-01 (line 708) | ○ |
| C-146〜C-148 | GetExceptionToPropagate | E-01 (line 1526-1527) | ○ |
| C-149 | StartAsyncOperation初期化 | E-01 (line 107-130) | ○ |
| C-150 | StartAsyncOperation開始 | E-01 (line 132-138) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-133, C-134（PostProgressChanged）**：privateメソッドであり、直接的な単体テストが困難。統合テストまたはリフレクションを使用したテストが必要。
  - 候補：統合テストで進捗イベントの発火を検証 / リフレクションでprivateメソッドをテスト / モックを使用したテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全体的に根拠が明確で、既存テストコードとの整合性が高い
- **1（中リスク）**：
  - privateメソッドのテスト（PostProgressChanged, StartAsyncOperation等）は直接テストが困難
  - 非同期操作のタイミングに依存するテストは不安定になる可能性あり
- **リスク軽減策**：
  - 統合テストで非同期操作の動作を包括的に検証
  - モックサーバーを使用して安定したテスト環境を構築

## 6) レビュアーチェックリスト（最小）
- [ ] 全150件のテストケースが適切な観点（正常系/異常系/境界値）をカバーしているか確認
- [ ] テストIDの命名規則（UT-WCL-XXX）が一貫しているか確認
- [ ] 優先度（高/中/低）の設定が適切か確認
- [ ] 入力値と期待結果の記述が具体的で再現可能か確認
- [ ] 既存テストコード（E-03）との重複・不足がないか確認
- [ ] privateメソッド関連のテスト方針が妥当か確認
- [ ] 非同期メソッドのテストでタイムアウト・キャンセル処理が考慮されているか確認
