---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 118
  claims_with_evidence: 115
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Net.WebHeaderCollection 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：115 / 118、根拠なし：3
- 優先レビュー（高）
  1. **UT-WHC-067 Get(int)境界値テスト**：空コレクション時の挙動が実装依存のため要確認
  2. **UT-WHC-102 AddWithoutValidate**：protectedメソッドのため直接テスト困難
  3. **UT-WHC-035 最大長制限**：ソースコードでは65536文字超の制限は明示的に確認されていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/src/libraries/System.Net.WebHeaderCollection/src/System/Net/WebHeaderCollection.cs`
- E-02: `/src/libraries/System.Net.WebHeaderCollection/src/System/Net/HeaderInfoTable.cs`
- E-03: `/src/libraries/System.Net.WebHeaderCollection/src/System/Net/HeaderInfo.cs`
- E-04: `/src/libraries/System.Net.WebHeaderCollection/src/System/Net/HttpRequestHeader.cs`
- E-05: `/src/libraries/System.Net.WebHeaderCollection/src/System/Net/HttpResponseHeader.cs`
- E-06: `/src/libraries/System.Net.WebHeaderCollection/ref/System.Net.WebHeaderCollection.cs`
- E-07: `/src/libraries/System.Net.WebHeaderCollection/tests/WebHeaderCollectionTest.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### WebHeaderCollection コンストラクタ・基本プロパティ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタでインスタンス生成 | E-01 (L418-420), E-07 (L14-17) | ○ |
| C-02 | 初期状態でCount=0 | E-01 (L422-428), E-07 (L20-28) | ○ |
| C-03 | 初期状態でAllKeysが空配列 | E-01 (L438-443), E-07 (L20-28) | ○ |
| C-04 | 初期状態でToString()が\r\n | E-01 (L390-395), E-07 (L20-28) | ○ |

### インデクサ (HttpRequestHeader/HttpResponseHeader)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | HttpRequestHeaderでヘッダー設定・取得 | E-01 (L65-83), E-07 (L31-39) | ○ |
| C-06 | 複数HttpRequestHeader設定 | E-01 (L65-83), E-07 (L86-94) | ○ |
| C-07 | 無効HttpRequestHeader値で例外 | E-04 (L98-101), E-07 (L41-49) | ○ |
| C-08 | MaxValue超で例外 | E-04 (L98-101), E-07 (L41-49) | ○ |
| C-09 | HttpResponseHeaderで設定・取得 | E-01 (L85-103), E-07 (L75-84) | ○ |
| C-10 | 無効HttpResponseHeader値で例外 | E-05 (L76-78), E-07 (L51-59) | ○ |
| C-11 | ResponseHeader後にRequestHeaderでInvalidOperationException | E-01 (L69-72), E-07 (L97-102) | ○ |
| C-12 | RequestHeader後にResponseHeaderでInvalidOperationException | E-01 (L88-91), E-07 (L104-110) | ○ |

### インデクサ (string)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | 文字列名でカスタムヘッダー設定・取得 | E-07 (L62-72) | ○ |
| C-14 | 大文字小文字を区別しない | E-01 (L51), E-07 (L189-204) | ○ |
| C-15 | 存在しないヘッダー名でnull | E-07 (L288-296) | ○ |
| C-16 | null名でArgumentNullException | E-07 (L135-142) | ○ |
| C-17 | 空文字名でArgumentNullException | E-07 (L135-142) | ○ |
| C-18-20 | 無効文字でArgumentException | E-07 (L144-156) | ○ |
| C-21-23 | 無効値でArgumentException | E-07 (L158-171) | ○ |
| C-24-28 | 有効値（null, 空, タブ等）の許容 | E-07 (L173-187) | ○ |
| C-29 | 同名ヘッダー上書き | E-07 (L189-204) | ○ |

### Add メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | Add(string, string)基本機能 | E-01 (L325-335), E-07 (L444-454) | ○ |
| C-31 | 同名ヘッダー追加でカンマ連結 | E-07 (L456-468) | ○ |
| C-32-33 | null/空文字名で例外 | E-01 (L329), E-07 (L470-492) | ○ |
| C-34 | 長い値の設定 | E-07 (L763-781) | ○ |
| C-35 | 65536文字超で例外 | E-07 (L722-729) | △ |
| C-36-43 | Add(string)の各種テスト | E-01 (L305-323), E-07 (L502-534) | ○ |
| C-44-47 | Add(HttpRequestHeader/HttpResponseHeader) | E-01 (L287-303), E-07 (L633-645, 704-710) | ○ |

### Set メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48-51 | Set(string, string) | E-01 (L106-118), E-07 (L751-761) | ○ |
| C-52-55 | Set(HttpRequestHeader/HttpResponseHeader) | E-01 (L120-136), E-07 (L732-749) | ○ |

### Remove メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56-61 | Remove(string) | E-01 (L358-372), E-07 (L206-270) | ○ |
| C-62-65 | Remove(HttpRequestHeader/HttpResponseHeader) | E-01 (L150-166), E-07 (L633-645) | ○ |

### Get/GetKey/GetValues メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66-67 | Get(int) | E-01 (L269-276) | △ |
| C-68-70 | Get(string) | E-01 (L278-285), E-07 (L288-309) | ○ |
| C-71 | GetKey(int) | E-01 (L258-261), E-07 (L668-675) | ○ |
| C-72 | GetValues(int) | E-01 (L184-187), E-07 (L647-656) | ○ |
| C-73-77 | GetValues(string) マルチ値処理 | E-01 (L189-256), E-02, E-07 (L549-631) | ○ |

### その他メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78-79 | Clear | E-01 (L263-267), E-07 (L685-693) | ○ |
| C-80-81 | Count | E-01 (L422-428) | ○ |
| C-82 | AllKeys | E-01 (L438-443) | ○ |
| C-83 | Keys | E-01 (L430-435), E-07 (L713-719) | ○ |
| C-84-87 | GetEnumerator | E-01 (L446-449), E-07 (L364-417) | ○ |
| C-88-91 | ToString | E-01 (L390-410), E-07 (L335-361) | ○ |
| C-92-93 | ToByteArray | E-01 (L412-416), E-07 (L658-666) | ○ |
| C-94-98 | IsRestricted | E-01 (L173-182), E-07 (L695-701) | ○ |
| C-99 | OnDeserialization | E-01 (L168-171) | ○ |
| C-100-101 | シリアライズ非対応 | E-01 (L30-35, L138-148) | ○ |
| C-102 | AddWithoutValidate | E-01 (L337-343) | △ |

### HttpRequestHeader/HttpResponseHeader 列挙型
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103-106 | HttpRequestHeader.GetName | E-04 (L52-102) | ○ |
| C-107-109 | HttpResponseHeader.GetName | E-05 (L41-80) | ○ |

### HeaderInfoTable/HeaderInfo（内部クラス）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110-111 | HeaderInfoTable インデクサ | E-02 (L146-157) | ○ |
| C-112-114 | HeaderInfo プロパティ | E-03 (L6-27) | ○ |
| C-115-118 | Parser動作 | E-02 (L12-82) | ○ |

## 4) 不足情報（Unknown / Missing）

### UT-WHC-035（65536文字超の値制限）
- ソースコードでは明示的な長さ制限が確認できない
- HttpValidationHelpers.CheckBadHeaderValueChars内での制限と推測
- 候補：HttpValidationHelpers.cs / 他の依存ライブラリ / 実行時テスト

### UT-WHC-067（Get(int)の境界値）
- 空コレクション時の挙動が_innerCollection==nullの場合nullを返す実装
- ArgumentOutOfRangeExceptionはNameValueCollectionの挙動依存
- 候補：NameValueCollection.cs / 実行時テスト

### UT-WHC-102（AddWithoutValidate）
- protectedメソッドのため、派生クラスを作成しないと直接テストできない
- 候補：TestHelper派生クラス作成 / リフレクション使用

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 0（低） | コンストラクタ・基本プロパティ | 既存テストで十分カバー |
| 0（低） | インデクサ | 既存テストで十分カバー |
| 0（低） | Add/Set/Remove | 既存テストで十分カバー |
| 1（中） | GetValues マルチ値処理 | Set-Cookie特殊処理のエッジケース |
| 0（低） | ToString/ToByteArray | 既存テストで十分カバー |
| 0（低） | IsRestricted | 既存テストでカバー |
| 1（中） | 内部クラス（HeaderInfoTable/HeaderInfo） | internal クラスのため直接テスト困難 |
| 0（低） | シリアライズ非対応 | PlatformNotSupportedException固定 |

## 6) レビュアーチェックリスト（最小）
- [ ] UT-WHC-035の65536文字制限が実際に存在するか確認
- [ ] UT-WHC-067のGet(int)境界値挙動を実行テストで確認
- [ ] UT-WHC-102のAddWithoutValidateをテスト可能にする方法検討
- [ ] Set-Cookie パーサーのExpires属性処理が全パターンでカバーされているか確認
- [ ] HttpRequestHeader/HttpResponseHeaderの全列挙値に対するGetName()テストが必要か検討
- [ ] 内部クラス（HeaderInfoTable/HeaderInfo）のテスト戦略検討
