---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 161
  claims_with_evidence: 158
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Net.WebSockets.Client 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：158 / 161、根拠なし：3
- 優先レビュー（高）
  1. **UT-WSC-149**: ConvertResponseメソッドのテストケース - 内部メソッドのため直接テスト可能性要確認
  2. **UT-WSC-151〜161**: BrowserInteropのJSImportメソッド - Browserプラットフォーム固有のため実行環境依存
  3. **UT-WSC-094〜096**: deflateネゴシエーション - サーバー側の応答に依存するため統合テスト推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/ClientWebSocket.cs`
- E-02: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/ClientWebSocketOptions.cs`
- E-03: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/WebSocketHandle.Managed.cs`
- E-04: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/WebSocketHandle.Browser.cs`
- E-05: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/HttpResponseHeadersReadOnlyCollection.cs`
- E-06: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/ClientWebSocketDeflateConstants.cs`
- E-07: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/BrowserWebSockets/BrowserWebSocket.cs`
- E-08: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/BrowserWebSockets/BrowserInterop.cs`
- E-09: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/BrowserWebSockets/ClientWebSocketOptions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ClientWebSocket クラス (UT-WSC-001〜039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-WSC-001) | コンストラクタで_state=Createdに初期化 | E-01 (L19-21) | ○ |
| C-02 (UT-WSC-002) | OptionsプロパティがWebSocketHandle.CreateDefaultOptions()で初期化 | E-01 (L21) | ○ |
| C-03 (UT-WSC-003〜004) | ConnectAsyncでws/wssスキーム接続 | E-01 (L79-119) | ○ |
| C-04 (UT-WSC-005) | uri=nullでArgumentNullException | E-01 (L93) | ○ |
| C-05 (UT-WSC-006) | 相対URIでArgumentException (net_uri_NotAbsolute) | E-01 (L95-98) | ○ |
| C-06 (UT-WSC-007〜008) | http/httpsスキームでArgumentException (net_WebSockets_Scheme) | E-01 (L99-102) | ○ |
| C-07 (UT-WSC-009) | 既接続でInvalidOperationException (net_WebSockets_AlreadyStarted) | E-01 (L105-115) | ○ |
| C-08 (UT-WSC-010) | Dispose後にObjectDisposedException | E-01 (L107-108) | ○ |
| C-09 (UT-WSC-011) | CancellationTokenキャンセルでOperationCanceledException | E-01 (L127, 131) | ○ |
| C-10 (UT-WSC-012〜015) | Stateプロパティの状態遷移 | E-01 (L32-53) | ○ |
| C-11 (UT-WSC-016〜021) | SendAsyncメソッド群 | E-01 (L142-149) | ○ |
| C-12 (UT-WSC-022〜025) | ReceiveAsyncメソッド群 | E-01 (L151-155) | ○ |
| C-13 (UT-WSC-026〜028) | CloseAsync/CloseOutputAsyncメソッド | E-01 (L157-161) | ○ |
| C-14 (UT-WSC-029〜030) | Abortメソッド | E-01 (L181-188) | ○ |
| C-15 (UT-WSC-031〜032) | Disposeメソッド | E-01 (L190-196) | ○ |
| C-16 (UT-WSC-033〜036) | CloseStatus/CloseStatusDescription/SubProtocol | E-01 (L26-30) | ○ |
| C-17 (UT-WSC-037〜039) | HttpStatusCode/HttpResponseHeaders | E-01 (L58-71) | ○ |

### ClientWebSocketOptions クラス (UT-WSC-040〜085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 (UT-WSC-040) | internalコンストラクタ | E-02 (L42) | ○ |
| C-19 (UT-WSC-041〜044) | HttpVersionプロパティ | E-02 (L48-58) | ○ |
| C-20 (UT-WSC-045〜046) | HttpVersionPolicyプロパティ | E-02 (L62-71) | ○ |
| C-21 (UT-WSC-047〜048) | SetRequestHeaderメソッド | E-02 (L75-81) | ○ |
| C-22 (UT-WSC-049〜054) | AddSubProtocolメソッド | E-02 (L158-173) | ○ |
| C-23 (UT-WSC-055〜062) | KeepAliveInterval/KeepAliveTimeoutプロパティ | E-02 (L182-218) | ○ |
| C-24 (UT-WSC-063〜064) | UseDefaultCredentialsプロパティ | E-02 (L88-96) | ○ |
| C-25 (UT-WSC-065〜066) | Credentialsプロパティ | E-02 (L99-107) | ○ |
| C-26 (UT-WSC-067〜069) | Proxyプロパティ | E-02 (L110-118) | ○ |
| C-27 (UT-WSC-070〜072) | ClientCertificatesプロパティ | E-02 (L121-130) | ○ |
| C-28 (UT-WSC-073) | RemoteCertificateValidationCallbackプロパティ | E-02 (L133-141) | ○ |
| C-29 (UT-WSC-074) | Cookiesプロパティ | E-02 (L144-152) | ○ |
| C-30 (UT-WSC-075〜079) | SetBufferメソッド | E-02 (L236-260) | ○ |
| C-31 (UT-WSC-080〜081) | CollectHttpResponseDetailsプロパティ | E-02 (L266-274) | ○ |
| C-32 (UT-WSC-082〜083) | DangerousDeflateOptionsプロパティ | E-02 (L229-230) | ○ |
| C-33 (UT-WSC-084〜085) | AreCompatibleWithCustomInvokerメソッド | E-02 (L34-40) | ○ |

### WebSocketHandle クラス - Managed (UT-WSC-086〜100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 (UT-WSC-086) | CreateDefaultOptionsファクトリメソッド | E-03 (L35) | ○ |
| C-35 (UT-WSC-087〜088) | ConnectAsync HTTP/1.1およびHTTP/2接続 | E-03 (L49-246) | ○ |
| C-36 (UT-WSC-089) | HTTP/2でinvoker必須 | E-03 (L54-57) | ○ |
| C-37 (UT-WSC-090) | カスタムInvoker非互換検証 | E-03 (L61-65) | ○ |
| C-38 (UT-WSC-091〜092) | レスポンスステータス検証 | E-03 (L447-477) | ○ |
| C-39 (UT-WSC-093) | サブプロトコル検証 | E-03 (L149-175) | ○ |
| C-40 (UT-WSC-094〜096) | deflateオプションネゴシエーション | E-03 (L178-190, 310-375) | ○ |
| C-41 (UT-WSC-097〜098) | Abortメソッド | E-03 (L43-47) | ○ |
| C-42 (UT-WSC-099〜100) | Disposeメソッド | E-03 (L37-41) | ○ |

### HttpResponseHeadersReadOnlyCollection クラス (UT-WSC-101〜111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 (UT-WSC-101) | コンストラクタ | E-05 (L15) | ○ |
| C-44 (UT-WSC-102〜103) | インデクサー | E-05 (L17) | ○ |
| C-45 (UT-WSC-104) | Keysプロパティ | E-05 (L19-27) | ○ |
| C-46 (UT-WSC-105) | Valuesプロパティ | E-05 (L30-38) | ○ |
| C-47 (UT-WSC-106) | Countプロパティ | E-05 (L41) | ○ |
| C-48 (UT-WSC-107〜108) | ContainsKeyメソッド | E-05 (L43) | ○ |
| C-49 (UT-WSC-109〜110) | TryGetValueメソッド | E-05 (L53-63) | ○ |
| C-50 (UT-WSC-111) | GetEnumeratorメソッド | E-05 (L45-51) | ○ |

### ClientWebSocketDeflateConstants クラス (UT-WSC-112〜117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 (UT-WSC-112〜117) | 定数値 | E-06 (L8-21) | ○ |

### DefaultWebProxy クラス (UT-WSC-118〜122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 (UT-WSC-118) | シングルトンInstance | E-03 (L536) | ○ |
| C-53 (UT-WSC-119〜122) | NotSupportedExceptionスロー | E-03 (L537-539) | ○ |

### BrowserWebSocket クラス (UT-WSC-123〜150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 (UT-WSC-123) | コンストラクタ初期状態 | E-07 (L22) | ○ |
| C-55 (UT-WSC-124〜125) | ConnectAsyncメソッド | E-07 (L136-152) | ○ |
| C-56 (UT-WSC-126〜130) | SendAsyncメソッド | E-07 (L154-172) | ○ |
| C-57 (UT-WSC-131〜133) | ReceiveAsyncメソッド | E-07 (L174-181) | ○ |
| C-58 (UT-WSC-134〜137) | CloseAsync/CloseOutputAsyncメソッド | E-07 (L183-201) | ○ |
| C-59 (UT-WSC-138〜140) | Abortメソッド | E-07 (L203-224) | ○ |
| C-60 (UT-WSC-141〜142) | Disposeメソッド | E-07 (L226-276) | ○ |
| C-61 (UT-WSC-143〜145) | CloseStatus/CloseStatusDescriptionプロパティ | E-07 (L83-119) | ○ |
| C-62 (UT-WSC-146〜147) | SubProtocolプロパティ | E-07 (L121-132) | ○ |
| C-63 (UT-WSC-148) | Stateプロパティ | E-07 (L34-63) | ○ |
| C-64 (UT-WSC-149) | ConvertResponseメソッド | E-07 (L465-507) | △ |
| C-65 (UT-WSC-150) | CloseStatus別例外処理 | E-07 (L486-504) | ○ |

### BrowserInterop クラス (UT-WSC-151〜161)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 (UT-WSC-151〜153) | GetProtocolメソッド | E-08 (L12-21) | ○ |
| C-67 (UT-WSC-154〜155) | GetCloseStatusメソッド | E-08 (L23-36) | ○ |
| C-68 (UT-WSC-156) | GetCloseStatusDescriptionメソッド | E-08 (L38-47) | ○ |
| C-69 (UT-WSC-157〜161) | GetReadyStateメソッド | E-08 (L49-57), E-07 (L641-652) | △ |

## 4) 不足情報（Unknown / Missing）
- **ConvertResponseメソッド（UT-WSC-149）**: privateメソッドのため直接テストは困難。ReceiveAsyncの戻り値を介した間接テストが必要
- **BrowserInterop JSImportメソッド群（UT-WSC-151〜161）**: JavaScript側の実装（web-socket.ts）が参照されていないため、完全な動作検証にはブラウザ環境でのテストが必要
- **deflateネゴシエーション（UT-WSC-094〜096）**: サーバー側の応答に依存するため、モックサーバーまたは統合テスト環境が必要

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 定数クラス（UT-WSC-112〜117）、DefaultWebProxyセンチネル（UT-WSC-118〜122）
- **1（中リスク）**: プロパティのget/set検証、状態遷移の単純なケース
- **2（高リスク）**:
  - ConnectAsyncの異常系（UT-WSC-005〜011）: ネットワーク関連の例外処理
  - SendAsync/ReceiveAsyncの状態検証（UT-WSC-018〜019, UT-WSC-024）: 不正状態での操作
  - Abort/Disposeの冪等性（UT-WSC-030〜032）: リソースリーク防止
  - deflateネゴシエーション（UT-WSC-094〜096）: セキュリティ関連（CRIME/BREACH攻撃）

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-WSC-001〜011, 016〜019, 022〜032, 049〜054, 086〜100）が網羅的であること
- [ ] 異常系テストケースで適切な例外型・メッセージが検証されていること
- [ ] Browser固有のテストケース（UT-WSC-123〜161）がBrowser以外のプラットフォームで除外されることを確認
- [ ] 状態遷移に関するテストケースが全ての有効な遷移パスをカバーしていること
- [ ] セキュリティ関連（deflate圧縮、証明書検証）のテストケースが適切に設計されていること
- [ ] CancellationTokenの伝播が全ての非同期メソッドで検証されていること
