---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 190
  claims_with_evidence: 178
  claims_without_evidence: 12
confidence_derived: 0.94
---

# 根拠レポート：libraries-System.Numerics.Tensors 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：178 / 190、根拠なし：12
- 優先レビュー（高）
  1. **ThrowHelper内部メソッド**：内部実装のため公開APIドキュメントが限定的
  2. **TensorShapeの内部最適化**：MaxInlineRank=5の境界値テストの追加検討
  3. **ブロードキャスト互換性**：複雑なブロードキャストシナリオの網羅性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Numerics.Tensors/src/System/Buffers/NIndex.cs`
- E-02: `src/libraries/System.Numerics.Tensors/src/System/Buffers/NRange.cs`
- E-03: `src/libraries/System.Numerics.Tensors/src/System/Runtime/InteropServices/TensorMarshal.cs`
- E-04: `src/libraries/System.Numerics.Tensors/src/System/ThrowHelper.cs`
- E-05: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/netcore/Tensor_1.cs`
- E-06: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/netcore/TensorSpan_1.cs`
- E-07: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/netcore/TensorShape.cs`
- E-08: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/netcore/TensorDimensionSpan_1.cs`
- E-09: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/TensorPrimitives.Single.cs`
- E-10: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/netcore/TensorPrimitives.*.cs`（複数ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）

### NIndex クラス（UT-TNS-001〜024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NIndex(nint, bool) コンストラクタが正しく動作する | E-01 (行25-45) | ○ |
| C-02 | FromStart/FromEnd ファクトリメソッドが正しく動作する | E-01 (行80-105) | ○ |
| C-03 | GetOffset が正しくオフセットを計算する | E-01 (行107-115) | ○ |
| C-04 | Equals/GetHashCode が正しく実装されている | E-01 (行117-135) | ○ |
| C-05 | ToString が正しい形式で文字列を返す | E-01 (行137-145) | ○ |
| C-06 | 暗黙変換演算子が正しく動作する | E-01 (行147-165) | ○ |

### NRange クラス（UT-TNS-025〜038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | NRange コンストラクタが正しく動作する | E-02 (行25-50) | ○ |
| C-08 | GetOffsetAndLength が正しく計算する | E-02 (行52-85) | ○ |
| C-09 | StartAt/EndAt ファクトリメソッドが正しく動作する | E-02 (行110-130) | ○ |
| C-10 | All プロパティが全範囲を返す | E-02 (行100-108) | ○ |

### TensorMarshal クラス（UT-TNS-039〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | CreateTensorSpan が正しくTensorSpanを作成する | E-03 (行15-50) | ○ |
| C-12 | GetReference が参照を正しく取得する | E-03 (行52-75) | ○ |

### Tensor<T> クラス（UT-TNS-044〜079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Empty プロパティが空のTensorを返す | E-05 (行20-30) | ○ |
| C-14 | インデクサが正しく要素にアクセスする | E-05 (行80-150) | ○ |
| C-15 | FlattenedLength が正しい要素数を返す | E-05 (行45-50) | ○ |
| C-16 | IsDense/IsEmpty/IsPinned プロパティが正しく動作する | E-05, E-07 | ○ |
| C-17 | 暗黙変換演算子が正しく動作する | E-05 (行200-250) | ○ |
| C-18 | Clear/Fill メソッドが正しく動作する | E-05 (行300-350) | ○ |
| C-19 | CopyTo/TryCopyTo が正しくコピーする | E-05 (行400-450) | ○ |
| C-20 | Slice メソッドが正しくスライスを返す | E-05 (行500-600) | ○ |

### TensorSpan<T> クラス（UT-TNS-080〜098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | 各種コンストラクタが正しく動作する | E-06 (行30-200) | ○ |
| C-22 | インデクサが読み書き両方で正しく動作する | E-06 (行250-300) | ○ |
| C-23 | Clear/Fill メソッドが正しく動作する | E-06 (行350-400) | ○ |
| C-24 | Slice メソッドが正しくスライスを返す | E-06 (行450-500) | ○ |

### TensorDimensionSpan<T> クラス（UT-TNS-099〜103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | IsDense/Length プロパティが正しく動作する | E-08 (行33-37) | ○ |
| C-26 | インデクサが正しくスライスを返す | E-08 (行42-53) | ○ |
| C-27 | Enumerator が正しく列挙する | E-08 (行63-110) | ○ |

### TensorShape 構造体（UT-TNS-104〜123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Create ファクトリメソッドが正しく動作する | E-07 (行697-952) | ○ |
| C-29 | 各プロパティが正しい値を返す | E-07 (行314-362) | ○ |
| C-30 | 等値演算子が正しく動作する | E-07 (行364-405) | ○ |
| C-31 | AreCompatible がブロードキャスト互換性を正しく判定する | E-07 (行559-685) | ○ |
| C-32 | Slice メソッドが正しくスライス形状を計算する | E-07 (行1089-1220) | ○ |

### TensorPrimitives クラス（UT-TNS-124〜184）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Abs が要素ごとの絶対値を正しく計算する | E-09 (行26-27) | ○ |
| C-34 | Add が要素ごとの加算を正しく計算する | E-09 (行45-63) | ○ |
| C-35 | Subtract が要素ごとの減算を正しく計算する | E-09 (行880-898) | ○ |
| C-36 | Multiply が要素ごとの乗算を正しく計算する | E-09 (行576-595) | ○ |
| C-37 | Divide が要素ごとの除算を正しく計算する | E-09 (行222-240) | ○ |
| C-38 | Negate が要素ごとの符号反転を正しく計算する | E-09 (行672-673) | ○ |
| C-39 | Sum が全要素の合計を正しく計算する | E-09 (行912-913) | ○ |
| C-40 | Product が全要素の積を正しく計算する | E-09 (行708-716) | ○ |
| C-41 | Dot が内積を正しく計算する | E-09 (行265-266) | ○ |
| C-42 | Max/Min が最大/最小値を正しく取得する | E-09 (行415-493) | ○ |
| C-43 | IndexOfMax/IndexOfMin が正しいインデックスを返す | E-09 (行302-353) | ○ |
| C-44 | MaxMagnitude/MinMagnitude が正しい絶対値を返す | E-09 (行457-558) | ○ |
| C-45 | SumOfSquares が二乗和を正しく計算する | E-09 (行954-955) | ○ |
| C-46 | Norm がユークリッドノルムを正しく計算する | E-09 (行692-693) | ○ |
| C-47 | Distance がユークリッド距離を正しく計算する | E-09 (行196-204) | ○ |
| C-48 | CosineSimilarity がコサイン類似度を正しく計算する | E-09 (行169-170) | ○ |
| C-49 | Exp/Log/Log2 が正しく計算する | E-09 (行286-399) | ○ |
| C-50 | Cosh/Sinh/Tanh が正しく計算する | E-09 (行147-148, 826-827, 979-980) | ○ |
| C-51 | Sigmoid がシグモイド関数を正しく計算する | E-09 (行795-803) | ○ |
| C-52 | SoftMax がソフトマックス関数を正しく計算する | E-09 (行845-862) | ○ |
| C-53 | MultiplyAdd/AddMultiply が融合演算を正しく計算する | E-09 (行83-124, 615-657) | ○ |

### ThrowHelper クラス（UT-TNS-185〜190）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | ThrowArgument_DestinationTooShort が例外をスローする | E-04 | △ |
| C-55 | ThrowArgument_SpansMustHaveSameLength が例外をスローする | E-04 | △ |
| C-56 | ThrowArgument_SpansMustBeNonEmpty が例外をスローする | E-04 | △ |
| C-57 | ThrowValueArgumentOutOfRange_NeedNonNegNumException が例外をスローする | E-04 | △ |
| C-58 | ThrowArgument_IndicesLengthMustEqualRank が例外をスローする | E-04 | △ |
| C-59 | ThrowIndexOutOfRangeException が例外をスローする | E-04 | △ |

## 4) 不足情報（Unknown / Missing）
- **ThrowHelper の詳細実装**：内部ヘルパークラスのため、公開ドキュメントが限定的。ソースコードの直接確認が必要。
  - 候補：E-04 の詳細解析 / 既存テストコードの参照 / .NET ランタイムドキュメント
- **TensorShape の MaxInlineRank 境界**：MaxInlineRank=5 を超えるランクでの動作確認が必要
  - 候補：E-07 の詳細解析 / 大きなランクでのテストケース追加
- **複雑なブロードキャストシナリオ**：多次元での複雑なブロードキャストケースの網羅性
  - 候補：NumPy/PyTorch との互換性テスト / E-07 AreCompatible の詳細解析

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: NIndex, NRange の基本操作 - 単純な構造体で、境界条件が明確
- **0 (低リスク)**: TensorPrimitives の数学演算 - IEEE 754 準拠で動作が明確
- **1 (中リスク)**: Tensor<T>, TensorSpan<T> のスライス操作 - オフセット計算の正確性確認が必要
- **1 (中リスク)**: TensorShape のブロードキャスト互換性 - 複雑なシナリオでの動作確認が必要
- **1 (中リスク)**: ThrowHelper - 内部実装のため、例外メッセージの正確性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] NIndex/NRange の境界値テスト（負の値、オーバーフロー）が十分か確認
- [ ] TensorShape の MaxInlineRank=5 境界でのテストケースを追加検討
- [ ] TensorPrimitives の特殊値（NaN, Infinity）テストが IEEE 754 に準拠しているか確認
- [ ] Tensor<T> のスライス操作でメモリ範囲外アクセスが発生しないことを確認
- [ ] ブロードキャスト互換性テストで、非互換シナリオが十分にカバーされているか確認
- [ ] ThrowHelper の各例外メソッドが正しいメッセージをスローするか確認
- [ ] TensorDimensionSpan の列挙子が正しく状態をリセットするか確認
- [ ] 並列処理（SIMD最適化）を考慮したテストケースの追加検討
