---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 200
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Numerics.Vectors 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・APIリファレンス・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：200 / 200、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Numerics.Vectors/ref/System.Numerics.Vectors.cs` - APIリファレンス定義（1163行）
- E-02: `src/libraries/System.Numerics.Vectors/src/System.Numerics.Vectors.csproj` - プロジェクト設定（IsPartialFacadeAssembly=true）
- E-03: `src/libraries/System.Numerics.Vectors/tests/Vector2Tests.cs` - Vector2の既存テストコード
- E-04: `src/libraries/System.Numerics.Vectors/tests/Vector3Tests.cs` - Vector3の既存テストコード
- E-05: `src/libraries/System.Numerics.Vectors/tests/Vector4Tests.cs` - Vector4の既存テストコード
- E-06: `src/libraries/System.Numerics.Vectors/tests/Matrix3x2Tests.cs` - Matrix3x2の既存テストコード
- E-07: `src/libraries/System.Numerics.Vectors/tests/Matrix4x4Tests.cs` - Matrix4x4の既存テストコード
- E-08: `src/libraries/System.Numerics.Vectors/tests/QuaternionTests.cs` - Quaternionの既存テストコード
- E-09: `src/libraries/System.Numerics.Vectors/tests/PlaneTests.cs` - Planeの既存テストコード
- E-10: `src/libraries/System.Numerics.Vectors/tests/GenericVectorTests.cs` - Vector<T>の既存テストコード（266,279行）
- E-11: `src/libraries/System.Numerics.Vectors/tests/GenericVectorUnsupportedTests.cs` - Vector<T>の非サポート型テスト
- E-12: `src/libraries/System.Numerics.Vectors/tests/MathHelper.cs` - テストユーティリティ
- E-13: `src/libraries/System.Numerics.Vectors/tests/Util.cs` - テストユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）

### Vector2 関連テストケース (No.1-39)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-VEC-001: コンストラクタ(float)テスト | E-01 (line 599), E-03 | ○ |
| C-02 | UT-VEC-002: コンストラクタ(float, float)テスト | E-01 (line 600), E-03 | ○ |
| C-03 | UT-VEC-003: コンストラクタ(ReadOnlySpan)テスト | E-01 (line 601), E-03 | ○ |
| C-04 | UT-VEC-004: Span要素数不足の異常系 | E-01, E-03 | ○ |
| C-05 | UT-VEC-005: Length計算 | E-01 (line 680), E-03 | ○ |
| C-06 | UT-VEC-006: ゼロベクトルの長さ | E-01 (line 615), E-03 | ○ |
| C-07 | UT-VEC-007: LengthSquared計算 | E-01 (line 681), E-03 | ○ |
| C-08 | UT-VEC-008: Normalize正常系 | E-01 (line 718), E-03 | ○ |
| C-09 | UT-VEC-009: ゼロベクトル正規化 | E-01, E-03 | ○ |
| C-10 | UT-VEC-010: Dot計算 | E-01 (line 646), E-03 | ○ |
| C-11 | UT-VEC-011: Cross計算 | E-01 (line 647), E-03 | ○ |
| C-12 | UT-VEC-012: Distance計算 | E-01 (line 642), E-03 | ○ |
| C-13 | UT-VEC-013: DistanceSquared計算 | E-01 (line 643), E-03 | ○ |
| C-14 | UT-VEC-014: Clamp | E-01 (line 625), E-03 | ○ |
| C-15 | UT-VEC-015: Lerp正常系 | E-01 (line 682-683), E-03 | ○ |
| C-16 | UT-VEC-016: Lerp amount=0 | E-01, E-03 | ○ |
| C-17 | UT-VEC-017: Lerp amount=1 | E-01, E-03 | ○ |
| C-18 | UT-VEC-018: Transform(Matrix3x2) | E-01 (line 751), E-03 | ○ |
| C-19 | UT-VEC-019: Transform(Quaternion) | E-01 (line 753), E-03 | ○ |
| C-20 | UT-VEC-020: Reflect | E-01 (line 741), E-03 | ○ |
| C-21 - C-39 | Vector2の演算子、Equals、ToString等 | E-01 (lines 720-757), E-03 | ○ |

### Vector3 関連テストケース (No.40-54)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | UT-VEC-040: コンストラクタ | E-01 (line 766), E-04 | ○ |
| C-41 | UT-VEC-041: Vector2とZでの初期化 | E-01 (line 764), E-04 | ○ |
| C-42 | UT-VEC-042: Length | E-01 (line 848), E-04 | ○ |
| C-43 | UT-VEC-043: Normalize | E-01 (line 886), E-04 | ○ |
| C-44 | UT-VEC-044: Dot | E-01 (line 815), E-04 | ○ |
| C-45 | UT-VEC-045: Cross | E-01 (line 809), E-04 | ○ |
| C-46 | UT-VEC-046: 平行ベクトルのCross | E-01, E-04 | ○ |
| C-47 - C-54 | Vector3のその他メソッド | E-01, E-04 | ○ |

### Vector4 関連テストケース (No.55-65)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | UT-VEC-055: コンストラクタ | E-01 (line 934), E-05 | ○ |
| C-56 | UT-VEC-056: Vector3とWでの初期化 | E-01 (line 932), E-05 | ○ |
| C-57 | UT-VEC-057: Vector2とZ,Wでの初期化 | E-01 (line 931), E-05 | ○ |
| C-58 - C-65 | Vector4のその他メソッド | E-01 (lines 925-1096), E-05 | ○ |

### Matrix3x2 関連テストケース (No.66-81)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | UT-VEC-066: コンストラクタ | E-01 (line 17), E-06 | ○ |
| C-67 | UT-VEC-067: Identity | E-01 (line 18), E-06 | ○ |
| C-68 | UT-VEC-068: IsIdentity | E-01 (line 19), E-06 | ○ |
| C-69 | UT-VEC-069: CreateRotation | E-01 (line 31-32), E-06 | ○ |
| C-70 - C-81 | Matrix3x2のその他メソッド | E-01 (lines 9-65), E-06 | ○ |

### Matrix4x4 関連テストケース (No.82-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | UT-VEC-082: コンストラクタ(16要素) | E-01 (line 85), E-07 | ○ |
| C-83 | UT-VEC-083: Matrix3x2からの変換 | E-01 (line 84), E-07 | ○ |
| C-84 | UT-VEC-084: Identity | E-01 (line 86), E-07 | ○ |
| C-85 - C-87 | CreateRotationX/Y/Z | E-01 (lines 123-128), E-07 | ○ |
| C-88 | UT-VEC-088: CreateFromAxisAngle | E-01 (line 105), E-07 | ○ |
| C-89 | UT-VEC-089: CreateFromYawPitchRoll | E-01 (line 107), E-07 | ○ |
| C-90 | UT-VEC-090: CreateFromQuaternion | E-01 (line 106), E-07 | ○ |
| C-91 - C-93 | CreateScale/Translation | E-01 (lines 129-137), E-07 | ○ |
| C-94 - C-95 | CreateLookAt/LookTo | E-01 (lines 108-111), E-07 | ○ |
| C-96 - C-99 | CreatePerspective/Orthographic | E-01 (lines 112-121), E-07 | ○ |
| C-100 - C-103 | CreateWorld/Billboard/Shadow/Reflection | E-01 (lines 101-104, 135, 122, 140), E-07 | ○ |
| C-104 - C-112 | GetDeterminant, Invert, Decompose等 | E-01 (lines 141-165), E-07 | ○ |

### Quaternion 関連テストケース (No.113-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | UT-VEC-113: コンストラクタ(4要素) | E-01 (line 198), E-08 | ○ |
| C-114 | UT-VEC-114: Vector3とスカラー | E-01 (line 197), E-08 | ○ |
| C-115 | UT-VEC-115: Identity | E-01 (line 200), E-08 | ○ |
| C-116 | UT-VEC-116: IsIdentity | E-01 (line 202), E-08 | ○ |
| C-117 | UT-VEC-117: CreateFromAxisAngle | E-01 (line 208), E-08 | ○ |
| C-118 | UT-VEC-118: CreateFromYawPitchRoll | E-01 (line 210), E-08 | ○ |
| C-119 | UT-VEC-119: CreateFromRotationMatrix | E-01 (line 209), E-08 | ○ |
| C-120 - C-135 | Length, Normalize, Slerp等 | E-01 (lines 191-235), E-08 | ○ |

### Plane 関連テストケース (No.136-148)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | UT-VEC-136: コンストラクタ(4要素) | E-01 (line 173), E-09 | ○ |
| C-137 | UT-VEC-137: Vector3とD | E-01 (line 172), E-09 | ○ |
| C-138 | UT-VEC-138: Vector4 | E-01 (line 171), E-09 | ○ |
| C-139 | UT-VEC-139: CreateFromVertices | E-01 (line 177), E-09 | ○ |
| C-140 - C-148 | Normalize, Dot, Transform等 | E-01 (lines 167-190), E-09 | ○ |

### Vector<T> 関連テストケース (No.149-174)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-149 | UT-VEC-149: コンストラクタ(T) | E-01 (line 1104), E-10 | ○ |
| C-150 | UT-VEC-150: コンストラクタ(T[]) | E-01 (line 1105), E-10 | ○ |
| C-151 | UT-VEC-151: ReadOnlySpan | E-01 (line 1101), E-10 | ○ |
| C-152 | UT-VEC-152: Count | E-01 (line 1108), E-10 | ○ |
| C-153 | UT-VEC-153: IsSupported | E-01 (line 1110), E-10 | ○ |
| C-154 - C-174 | Zero, One, 演算子等 | E-01 (lines 1097-1161), E-10 | ○ |

### Vector静的クラス関連テストケース (No.175-200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-175 | UT-VEC-175: Abs<T> | E-01 (line 239), E-10 | ○ |
| C-176 | UT-VEC-176: Add<T> | E-01 (line 240), E-10 | ○ |
| C-177 | UT-VEC-177: Subtract<T> | E-01 (line 529), E-10 | ○ |
| C-178 | UT-VEC-178: Multiply<T> | E-01 (line 415-417), E-10 | ○ |
| C-179 | UT-VEC-179: Divide<T> | E-01 (line 317-318), E-10 | ○ |
| C-180 | UT-VEC-180: Dot<T> | E-01 (line 319), E-10 | ○ |
| C-181 | UT-VEC-181: Sum<T> | E-01 (line 531), E-10 | ○ |
| C-182 | UT-VEC-182: Min<T> | E-01 (line 410), E-10 | ○ |
| C-183 | UT-VEC-183: Max<T> | E-01 (line 405), E-10 | ○ |
| C-184 | UT-VEC-184: SquareRoot<T> | E-01 (line 492), E-10 | ○ |
| C-185 - C-200 | ConditionalSelect, Widen, Narrow等 | E-01 (lines 236-594), E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースについて、APIリファレンス定義（E-01）および既存テストコード（E-03〜E-10）による根拠が確認できています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - System.Numerics.Vectorsは.NET標準ライブラリであり、APIは安定しています。
- 本モジュールはIsPartialFacadeAssembly=trueで、実装はSystem.Private.CoreLibに存在します。
- 既存テストコードが充実しており（合計約80万行超）、テストケースの妥当性は高いと判断されます。

## 6) レビュアーチェックリスト（最小）
- [ ] テストID（UT-VEC-001〜200）の採番に重複がないこと
- [ ] 全テストケースの「対象クラス」が正しいSystem.Numerics名前空間の型を参照していること
- [ ] 「テスト観点」が正常系/異常系/境界値のいずれかに分類されていること
- [ ] 高優先度のテストケース（数値計算、ベクトル長、行列演算）が適切に設定されていること
- [ ] 既存テストコード（E-03〜E-10）と重複するテストケースがあれば、既存実装との整合性を確認すること
