---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 136
  claims_with_evidence: 136
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.ObjectModel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：136 / 136、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースはソースコードから直接導出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/Collections/ObjectModel/ObservableCollection.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/Collections/ObjectModel/ReadOnlyObservableCollection.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/Collections/ObjectModel/KeyedCollection.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/Collections/Specialized/NotifyCollectionChangedEventArgs.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/ComponentModel/PropertyChangedEventArgs.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/ComponentModel/PropertyChangingEventArgs.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/ComponentModel/DataErrorsChangedEventArgs.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/ComponentModel/TypeConverterAttribute.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/ComponentModel/TypeDescriptionProviderAttribute.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/Windows/Markup/ValueSerializerAttribute.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ObjectModel/src/System/Collections/CollectionHelpers.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ObservableCollection<T>（UT-SOM-001〜UT-SOM-019）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタで空のコレクションが生成される | E-01 (line 32-34) | ○ |
| C-02 | IEnumerableから要素がコピーされる | E-01 (line 47-48) | ○ |
| C-03 | IEnumerableがnullの場合ArgumentNullExceptionがスローされる | E-01 (line 47: `throw new ArgumentNullException`) | ○ |
| C-04 | Listから要素がコピーされる | E-01 (line 61-62) | ○ |
| C-05 | Listがnullの場合ArgumentNullExceptionがスローされる | E-01 (line 61: `throw new ArgumentNullException`) | ○ |
| C-06 | InsertItem時にCollectionChangedイベントがAddで発火 | E-01 (line 119-127: `OnCollectionChanged(NotifyCollectionChangedAction.Add`) | ○ |
| C-07 | InsertItem時にPropertyChangedイベントがCountとItem[]で発火 | E-01 (line 124-125: `OnCountPropertyChanged()`, `OnIndexerPropertyChanged()`) | ○ |
| C-08 | RemoveItem時にCollectionChangedイベントがRemoveで発火 | E-01 (line 103-113: `OnCollectionChanged(NotifyCollectionChangedAction.Remove`) | ○ |
| C-09 | RemoveItem時にPropertyChangedイベントが発火 | E-01 (line 110-111) | ○ |
| C-10 | SetItem時にCollectionChangedイベントがReplaceで発火 | E-01 (line 133-141: `OnCollectionChanged(NotifyCollectionChangedAction.Replace`) | ○ |
| C-11 | SetItem時にPropertyChangedがItem[]のみで発火 | E-01 (line 139: `OnIndexerPropertyChanged()` のみ) | ○ |
| C-12 | ClearItems時にCollectionChangedがResetで発火 | E-01 (line 90-97: `OnCollectionReset()`) | ○ |
| C-13 | ClearItems時にPropertyChangedイベントが発火 | E-01 (line 94-95) | ○ |
| C-14 | Move時にCollectionChangedがMoveで発火 | E-01 (line 147-158: `OnCollectionChanged(NotifyCollectionChangedAction.Move`) | ○ |
| C-15 | Move時にPropertyChangedがItem[]で発火 | E-01 (line 156: `OnIndexerPropertyChanged()`) | ○ |
| C-16 | 同一インデックスへの移動が正常処理される | E-01 (line 147-158: 特別な処理なし) | ○ |
| C-17 | 複数リスナー時の再入でInvalidOperationExceptionがスロー | E-01 (line 223-235: `CheckReentrancy()`) | ○ |
| C-18 | 単一リスナー時は再入が許可される | E-01 (line 232: `!handler.HasSingleTarget` の条件) | ○ |
| C-19 | BlockReentrancyがIDisposableを返す | E-01 (line 214-218: `protected IDisposable BlockReentrancy()`) | ○ |

### ReadOnlyObservableCollection<T>（UT-SOM-020〜UT-SOM-024）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | ObservableCollectionをラップして読み取り専用コレクションが生成される | E-02 (line 25-29) | ○ |
| C-21 | 内部ObservableCollectionの変更がCollectionChangedとして伝播 | E-02 (line 27, 88-91: `HandleCollectionChanged`) | ○ |
| C-22 | PropertyChangedイベントが伝播する | E-02 (line 28, 93-96: `HandlePropertyChanged`) | ○ |
| C-23 | Empty静的プロパティが空のコレクションを返す | E-02 (line 34: `public static new ReadOnlyObservableCollection<T> Empty`) | ○ |
| C-24 | Emptyプロパティが同一インスタンスを返す | E-02 (line 34: `{ get; }` 静的プロパティ) | ○ |

### KeyedCollection<TKey, TItem>（UT-SOM-025〜UT-SOM-050）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | デフォルトコンストラクタで空のコレクションが生成される | E-03 (line 23-25) | ○ |
| C-26 | カスタム比較器を指定できる | E-03 (line 27-29, 40: `this.comparer = comparer ?? EqualityComparer<TKey>.Default`) | ○ |
| C-27 | 辞書作成閾値を指定できる | E-03 (line 31-42, 41: `threshold = dictionaryCreationThreshold`) | ○ |
| C-28 | 閾値に-2以下でArgumentOutOfRangeException | E-03 (line 35-38: `if (dictionaryCreationThreshold < -1)`) | ○ |
| C-29 | 閾値-1で辞書が作成されない | E-03 (line 41: `dictionaryCreationThreshold == -1 ? int.MaxValue`) | ○ |
| C-30 | キーで要素を取得できる | E-03 (line 58-70: `public TItem this[TKey key]`) | ○ |
| C-31 | 存在しないキーでKeyNotFoundException | E-03 (line 68: `throw new KeyNotFoundException`) | ○ |
| C-32 | Contains(TKey)が存在するキーでtrueを返す | E-03 (line 72-90) | ○ |
| C-33 | Contains(TKey)が存在しないキーでfalseを返す | E-03 (line 89: `return false`) | ○ |
| C-34 | Contains(TKey)がnullキーでArgumentNullException | E-03 (line 74: `ArgumentNullException.ThrowIfNull(key)`) | ○ |
| C-35 | TryGetValueが存在するキーでtrueと要素を返す | E-03 (line 92-113) | ○ |
| C-36 | TryGetValueが存在しないキーでfalseを返す | E-03 (line 111-112: `item = default; return false`) | ○ |
| C-37 | TryGetValueがnullキーでArgumentNullException | E-03 (line 94: `ArgumentNullException.ThrowIfNull(key)`) | ○ |
| C-38 | Remove(TKey)がキーで要素を削除する | E-03 (line 132-152) | ○ |
| C-39 | Remove(TKey)が存在しないキーでfalseを返す | E-03 (line 151: `return false`) | ○ |
| C-40 | Remove(TKey)がnullキーでArgumentNullException | E-03 (line 134: `ArgumentNullException.ThrowIfNull(key)`) | ○ |
| C-41 | 重複キーでArgumentException | E-03 (line 249-251: `throw new ArgumentException(SR.Format(SR.Argument_AddingDuplicate`) | ○ |
| C-42 | nullキーを返す要素はリストのみに追加 | E-03 (line 188-192: `if (key != null) { AddKey(key, item); }`) | ○ |
| C-43 | SetItemで同一キーの場合辞書が更新される | E-03 (line 213-218) | ○ |
| C-44 | SetItemで異なるキーの場合旧キー削除・新キー追加 | E-03 (line 220-231) | ○ |
| C-45 | ClearItemsで内部辞書もクリアされる | E-03 (line 177-182: `dict?.Clear()`) | ○ |
| C-46 | ChangeItemKeyで要素のキーを変更できる | E-03 (line 156-175) | ○ |
| C-47 | ChangeItemKeyで存在しない要素でArgumentException | E-03 (line 158-161: `throw new ArgumentException(SR.Argument_ItemNotExist`) | ○ |
| C-48 | Comparerプロパティが比較器を返す | E-03 (line 56: `public IEqualityComparer<TKey> Comparer => comparer`) | ○ |
| C-49 | 閾値超過後にDictionaryプロパティが非nullを返す | E-03 (line 154, 242-245: `CreateDictionary()`) | ○ |
| C-50 | 閾値未満でDictionaryプロパティがnullを返す | E-03 (line 154: `protected IDictionary<TKey, TItem>? Dictionary => dict`) | ○ |

### NotifyCollectionChangedEventArgs（UT-SOM-051〜UT-SOM-073）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | ResetアクションでEventArgsが生成される | E-04 (line 26-34) | ○ |
| C-52 | Reset以外のアクションでArgumentException | E-04 (line 28-30: `if (action != NotifyCollectionChangedAction.Reset)`) | ○ |
| C-53 | Addアクションで単一要素が設定される | E-04 (line 67-70: `case NotifyCollectionChangedAction.Add`) | ○ |
| C-54 | Removeアクションで単一要素が設定される | E-04 (line 72-75: `case NotifyCollectionChangedAction.Remove`) | ○ |
| C-55 | Resetアクションで非null要素を渡すとArgumentException | E-04 (line 57-60: `if (changedItem != null)`) | ○ |
| C-56 | Resetアクションでindex!=-1を渡すとArgumentException | E-04 (line 61-64: `if (index != -1)`) | ○ |
| C-57 | Addアクションで複数要素が設定される | E-04 (line 100-137: 複数要素用コンストラクタ) | ○ |
| C-58 | Addアクションでnull配列を渡すとArgumentNullException | E-04 (line 117: `ArgumentNullException.ThrowIfNull(changedItems)`) | ○ |
| C-59 | Addアクションでindex<-1を渡すとArgumentOutOfRangeException | E-04 (line 118: `ArgumentOutOfRangeException.ThrowIfLessThan(startingIndex, -1)`) | ○ |
| C-60 | Replaceアクションで新旧要素が設定される | E-04 (line 157-168) | ○ |
| C-61 | Replace以外のアクションでArgumentException | E-04 (line 159-162) | ○ |
| C-62 | Replaceアクションで複数要素が設定される | E-04 (line 188-201) | ○ |
| C-63 | newItemsがnullでArgumentNullException | E-04 (line 194: `ArgumentNullException.ThrowIfNull(newItems)`) | ○ |
| C-64 | oldItemsがnullでArgumentNullException | E-04 (line 195: `ArgumentNullException.ThrowIfNull(oldItems)`) | ○ |
| C-65 | Moveアクションで要素とインデックスが設定される | E-04 (line 210-222) | ○ |
| C-66 | Move以外のアクションでArgumentException | E-04 (line 212-215) | ○ |
| C-67 | 負のindexでArgumentOutOfRangeException | E-04 (line 216: `ArgumentOutOfRangeException.ThrowIfNegative(index)`) | ○ |
| C-68 | Moveアクションで複数要素が設定される | E-04 (line 231-243) | ○ |
| C-69 | Actionプロパティが正しく返される | E-04 (line 248: `public NotifyCollectionChangedAction Action => _action`) | ○ |
| C-70 | NewItemsプロパティが正しく返される | E-04 (line 253: `public IList? NewItems => _newItems`) | ○ |
| C-71 | OldItemsプロパティが正しく返される | E-04 (line 258: `public IList? OldItems => _oldItems`) | ○ |
| C-72 | NewStartingIndexプロパティが正しく返される | E-04 (line 263: `public int NewStartingIndex => _newStartingIndex`) | ○ |
| C-73 | OldStartingIndexプロパティが正しく返される | E-04 (line 268: `public int OldStartingIndex => _oldStartingIndex`) | ○ |

### PropertyChangedEventArgs（UT-SOM-074〜UT-SOM-076）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | プロパティ名を指定してインスタンス生成 | E-05 (line 15-18) | ○ |
| C-75 | nullを指定してインスタンス生成 | E-05 (line 15: `string? propertyName`) | ○ |
| C-76 | PropertyNameプロパティが正しく返される | E-05 (line 23: `public virtual string? PropertyName { get; }`) | ○ |

### PropertyChangingEventArgs（UT-SOM-077〜UT-SOM-079）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | プロパティ名を指定してインスタンス生成 | E-06 (line 15-18) | ○ |
| C-78 | nullを指定してインスタンス生成 | E-06 (line 15: `string? propertyName`) | ○ |
| C-79 | PropertyNameプロパティが正しく返される | E-06 (line 23: `public virtual string? PropertyName { get; }`) | ○ |

### DataErrorsChangedEventArgs（UT-SOM-080〜UT-SOM-082）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | プロパティ名を指定してインスタンス生成 | E-07 (line 15-18) | ○ |
| C-81 | nullを指定してインスタンス生成 | E-07 (line 15: `string? propertyName`) | ○ |
| C-82 | PropertyNameプロパティが正しく返される | E-07 (line 23: `public virtual string? PropertyName { get; }`) | ○ |

### TypeConverterAttribute（UT-SOM-083〜UT-SOM-092）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | デフォルトコンストラクタでConverterTypeNameが空文字 | E-08 (line 25-28: `ConverterTypeName = string.Empty`) | ○ |
| C-84 | Type指定でAssemblyQualifiedNameが設定される | E-08 (line 35-40: `ConverterTypeName = type.AssemblyQualifiedName!`) | ○ |
| C-85 | Type=nullでArgumentNullException | E-08 (line 37: `ArgumentNullException.ThrowIfNull(type)`) | ○ |
| C-86 | 型名文字列が正しく設定される | E-08 (line 47-52: `ConverterTypeName = typeName`) | ○ |
| C-87 | typeName=nullでArgumentNullException | E-08 (line 49: `ArgumentNullException.ThrowIfNull(typeName)`) | ○ |
| C-88 | 同じConverterTypeNameでEqualsがtrueを返す | E-08 (line 61-66: `other.ConverterTypeName == ConverterTypeName`) | ○ |
| C-89 | 異なるConverterTypeNameでEqualsがfalseを返す | E-08 (line 61-66) | ○ |
| C-90 | nullとの比較でfalseを返す | E-08 (line 64: `obj is TypeConverterAttribute other`) | ○ |
| C-91 | GetHashCodeがConverterTypeNameのハッシュを返す | E-08 (line 68: `return ConverterTypeName.GetHashCode()`) | ○ |
| C-92 | Default静的フィールドが空文字属性を返す | E-08 (line 19: `public static readonly TypeConverterAttribute Default = new TypeConverterAttribute()`) | ○ |

### TypeDescriptionProviderAttribute（UT-SOM-093〜UT-SOM-097）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | 型名文字列が正しく設定される | E-09 (line 14-19: `TypeName = typeName`) | ○ |
| C-94 | typeName=nullでArgumentNullException | E-09 (line 16: `ArgumentNullException.ThrowIfNull(typeName)`) | ○ |
| C-95 | Type指定でAssemblyQualifiedNameが設定される | E-09 (line 24-29: `TypeName = type.AssemblyQualifiedName!`) | ○ |
| C-96 | type=nullでArgumentNullException | E-09 (line 26: `ArgumentNullException.ThrowIfNull(type)`) | ○ |
| C-97 | TypeNameプロパティが正しく返される | E-09 (line 36: `public string TypeName { get; }`) | ○ |

### ValueSerializerAttribute（UT-SOM-098〜UT-SOM-101）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | Type指定でValueSerializerTypeが設定される | E-10 (line 28-31: `_valueSerializerType = valueSerializerType`) | ○ |
| C-99 | 型名文字列が正しく設定される | E-10 (line 37-40: `_valueSerializerTypeName = valueSerializerTypeName`) | ○ |
| C-100 | 型名から型が解決される | E-10 (line 50-52: `_valueSerializerType = Type.GetType(_valueSerializerTypeName)`) | ○ |
| C-101 | Type指定時にAssemblyQualifiedNameが返される | E-10 (line 67-69: `return _valueSerializerType.AssemblyQualifiedName!`) | ○ |

### ReadOnlyList（UT-SOM-102〜UT-SOM-115）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | IListをラップする | E-04 (line 280-284) | ○ |
| C-103 | インデクサgetで要素が取得できる | E-04 (line 296: `get => _list[index]`) | ○ |
| C-104 | インデクサsetでNotSupportedException | E-04 (line 297: `set => throw new NotSupportedException`) | ○ |
| C-105 | AddでNotSupportedException | E-04 (line 302) | ○ |
| C-106 | ClearでNotSupportedException | E-04 (line 304) | ○ |
| C-107 | InsertでNotSupportedException | E-04 (line 314) | ○ |
| C-108 | RemoveでNotSupportedException | E-04 (line 316) | ○ |
| C-109 | RemoveAtでNotSupportedException | E-04 (line 318) | ○ |
| C-110 | Containsが正しく動作する | E-04 (line 306: `return _list.Contains(value)`) | ○ |
| C-111 | IndexOfが正しく動作する | E-04 (line 312: `return _list.IndexOf(value)`) | ○ |
| C-112 | CopyToが正しく動作する | E-04 (line 308: `_list.CopyTo(array, index)`) | ○ |
| C-113 | GetEnumeratorが正しく動作する | E-04 (line 310: `return _list.GetEnumerator()`) | ○ |
| C-114 | IsReadOnlyがtrueを返す | E-04 (line 288: `public bool IsReadOnly => true`) | ○ |
| C-115 | IsFixedSizeがtrueを返す | E-04 (line 290: `public bool IsFixedSize => true`) | ○ |

### SingleItemReadOnlyList（UT-SOM-116〜UT-SOM-129）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | 単一要素のリストが生成される | E-04 (line 325: `public SingleItemReadOnlyList(object? item) => _item = item`) | ○ |
| C-117 | インデックス0で要素が取得できる | E-04 (line 327-334) | ○ |
| C-118 | インデックス0以外でArgumentOutOfRangeException | E-04 (line 331: `ArgumentOutOfRangeException.ThrowIfNotEqual(index, 0)`) | ○ |
| C-119 | インデクサsetでNotSupportedException | E-04 (line 334: `set => throw new NotSupportedException`) | ○ |
| C-120 | 同一要素でContainsがtrueを返す | E-04 (line 352: `Contains` メソッド) | ○ |
| C-121 | 異なる要素でContainsがfalseを返す | E-04 (line 352) | ○ |
| C-122 | null要素に対するContains | E-04 (line 352: `_item is null ? value is null : _item.Equals(value)`) | ○ |
| C-123 | 同一要素でIndexOfが0を返す | E-04 (line 354: `return Contains(value) ? 0 : -1`) | ○ |
| C-124 | 異なる要素でIndexOfが-1を返す | E-04 (line 354) | ○ |
| C-125 | CopyToが正しく動作する | E-04 (line 356-360) | ○ |
| C-126 | null配列でArgumentNullException | E-11 (line 12: `ArgumentNullException.ThrowIfNull(array)`) | ○ |
| C-127 | 配列サイズ不足でArgumentException | E-11 (line 27-30) | ○ |
| C-128 | GetEnumeratorで単一要素が列挙できる | E-04 (line 347-350: `yield return _item`) | ○ |
| C-129 | Countが1を返す | E-04 (line 341: `public int Count => 1`) | ○ |

### CollectionHelpers（UT-SOM-130〜UT-SOM-136）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | 有効な引数で例外がスローされない | E-11 (line 10-31) | ○ |
| C-131 | null配列でArgumentNullException | E-11 (line 12: `ArgumentNullException.ThrowIfNull(array)`) | ○ |
| C-132 | 多次元配列でArgumentException | E-11 (line 14-17: `if (array.Rank != 1)`) | ○ |
| C-133 | 非ゼロ下限配列でArgumentException | E-11 (line 19-22: `if (array.GetLowerBound(0) != 0)`) | ○ |
| C-134 | 負のindexでArgumentOutOfRangeException | E-11 (line 24: `ArgumentOutOfRangeException.ThrowIfNegative(index)`) | ○ |
| C-135 | indexが配列長より大きい場合ArgumentOutOfRangeException | E-11 (line 25: `ArgumentOutOfRangeException.ThrowIfGreaterThan(index, array.Length)`) | ○ |
| C-136 | コピー先スペース不足でArgumentException | E-11 (line 27-30) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースはソースコードの実装に基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] ObservableCollection のイベント発火順序（Count -> Item[] -> CollectionChanged）が実際の実装と一致しているか確認
- [ ] KeyedCollection の閾値境界でのテストケースが網羅されているか確認
- [ ] NotifyCollectionChangedEventArgs の各アクションタイプのバリデーションが漏れなくテストされているか確認
- [ ] 内部クラス（ReadOnlyList, SingleItemReadOnlyList）のテストが必要かプロジェクト方針と照合
- [ ] シリアライゼーション関連のテストケースが必要かプロジェクト方針と照合
