---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Private.CoreLib.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **Task.Delay引数検証**：-1以外の負の値の挙動がコードで確認困難
  2. **WeakReference GC後の挙動**：GCタイミング依存のため実行時検証が必要
  3. **Environment.GetEnvironmentVariable**：プラットフォーム依存の挙動

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.CoreLib/src/System/String.cs` - String クラスのコンストラクタ実装
- E-02: `src/libraries/System.Private.CoreLib/src/System/Array.cs` - Array クラスの CreateInstance, Resize 実装
- E-03: `src/libraries/System.Private.CoreLib/src/System/Collections/Generic/List.cs` - List<T> 実装
- E-04: `src/libraries/System.Private.CoreLib/src/System/Collections/Generic/Dictionary.cs` - Dictionary<TKey,TValue> 実装
- E-05: `src/libraries/System.Private.CoreLib/src/System/Memory.cs` - Memory<T> 実装
- E-06: `src/libraries/System.Private.CoreLib/src/System/Span.cs` - Span<T> 実装
- E-07: `src/libraries/System.Private.CoreLib/src/System/Guid.cs` - Guid 構造体実装
- E-08: `src/libraries/System.Private.CoreLib/src/System/DateTime.cs` - DateTime 構造体実装
- E-09: `src/libraries/System.Private.CoreLib/src/System/Threading/Tasks/Task.cs` - Task クラス実装
- E-10: `src/libraries/System.Private.CoreLib/src/System/IO/Stream.cs` - Stream 抽象クラス実装
- E-11: `src/libraries/System.Private.CoreLib/src/System/Text/StringBuilder.cs` - StringBuilder 実装
- E-12: `src/libraries/System.Private.CoreLib/src/System/Exception.cs` - Exception 基底クラス実装
- E-13: `src/libraries/System.Private.CoreLib/src/System/Convert.cs` - Convert クラス実装
- E-14: `src/libraries/System.Private.CoreLib/src/System/Math.cs` - Math クラス実装
- E-15: `src/libraries/System.Private.CoreLib/src/System/Environment.cs` - Environment クラス実装
- E-16: `src/libraries/System.Private.CoreLib/src/System/BitConverter.cs` - BitConverter クラス実装
- E-17: `src/libraries/System.Private.CoreLib/src/System/Lazy.cs` - Lazy<T> 実装
- E-18: `src/libraries/System.Private.CoreLib/src/System/WeakReference.T.cs` - WeakReference<T> 実装
- E-19: `src/libraries/System.Private.CoreLib/src/System/Tuple.cs` - Tuple 実装
- E-20: `src/libraries/System.Private.CoreLib/src/System/ValueTuple.cs` - ValueTuple 実装
- E-21: `src/libraries/System.Private.CoreLib/src/System/Index.cs` - Index 構造体実装
- E-22: `src/libraries/System.Private.CoreLib/src/System/Range.cs` - Range 構造体実装
- E-23: `src/libraries/System.Private.CoreLib/src/System/Version.cs` - Version クラス実装

## 3) Claims と根拠の対応（レビューの主戦場）

### String クラス（UT-SCL-001 ~ UT-SCL-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | String.Ctor(char[])でchar配列から文字列生成 | E-01 L76-89 | ○ |
| C-02 | String.Ctor(char[])でnull配列からEmpty返却 | E-01 L78-79 | ○ |
| C-03 | String.Ctor(char[])で空配列からEmpty返却 | E-01 L78-79 | ○ |
| C-04 | String.Ctor(char[], int, int)で部分配列から生成 | E-01 L97-115 | ○ |
| C-05 | String.Ctor(char[], int, int)でnull引数検証 | E-01 L99 | ○ |
| C-06 | String.Ctor(char[], int, int)で負のstartIndex検証 | E-01 L100 | ○ |
| C-07 | String.Ctor(char[], int, int)で負のlength検証 | E-01 L101 | ○ |
| C-08 | String.Ctor(char[], int, int)で範囲外検証 | E-01 L102 | ○ |
| C-09 | String.Lengthで文字列長取得 | E-01 L54 | ○ |
| C-10 | String.Lengthで空文字列は0 | E-01 L54 | ○ |

### Array クラス（UT-SCL-011 ~ UT-SCL-019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Array.CreateInstance(Type, int)で配列生成 | E-02 L74-84 | ○ |
| C-12 | Array.CreateInstance(Type, int)でnull型検証 | E-02 L76 | ○ |
| C-13 | Array.CreateInstance(Type, int)で負の長さ検証 | E-02 L77 | ○ |
| C-14 | Array.Resize<T>でサイズ拡大 | E-02 L42-71 | ○ |
| C-15 | Array.Resize<T>でサイズ縮小 | E-02 L62-67 | ○ |
| C-16 | Array.Resize<T>でnull配列から新規生成 | E-02 L48-51 | ○ |
| C-17 | Array.Resize<T>で負のサイズ検証 | E-02 L44-45 | ○ |
| C-18 | Array.AsReadOnly<T>でReadOnlyCollection返却 | E-02 L30-39 | ○ |
| C-19 | Array.AsReadOnly<T>でnull配列検証 | E-02 L32-35 | ○ |

### List<T> クラス（UT-SCL-020 ~ UT-SCL-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | List<T>.Ctor()で空リスト生成 | E-03 L37-40 | ○ |
| C-21 | List<T>.Ctor(int)で容量指定生成 | E-03 L46-55 | ○ |
| C-22 | List<T>.Ctor(int)で負の容量検証 | E-03 L48-49 | ○ |
| C-23 | List<T>.Ctor(IEnumerable<T>)でコレクションコピー | E-03 L61-91 | ○ |
| C-24 | List<T>.Ctor(IEnumerable<T>)でnullコレクション検証 | E-03 L63-64 | ○ |
| C-25 | List<T>.Add(T)で要素追加 | E-03 L196-200 | ○ |
| C-26 | List<T>.this[int]でインデックスアクセス | E-03 L143-153 | ○ |
| C-27 | List<T>.this[int]で範囲外検証 | E-03 L148-151 | ○ |
| C-28 | List<T>.this[int]で負インデックス検証 | E-03 L148-151 | ○ |
| C-29 | List<T>.Capacityで容量管理 | E-03 L97-124 | ○ |
| C-30 | List<T>.CapacityでCount未満設定検証 | E-03 L102-105 | ○ |

### Dictionary<TKey, TValue> クラス（UT-SCL-031 ~ UT-SCL-039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Dictionary.Ctor()で空辞書生成 | E-04 L40 | ○ |
| C-32 | Dictionary.Ctor(int)で容量指定生成 | E-04 L46-83 | ○ |
| C-33 | Dictionary.Ctor(int)で負の容量検証 | E-04 L48-51 | ○ |
| C-34 | Dictionary.Add(TKey, TValue)で要素追加 | E-04（Addメソッド） | ○ |
| C-35 | Dictionary.Add(TKey, TValue)で重複キー検証 | E-04（Addメソッド） | ○ |
| C-36 | Dictionary.this[TKey]でキーアクセス | E-04（インデクサ） | ○ |
| C-37 | Dictionary.this[TKey]で存在しないキー検証 | E-04（インデクサ） | ○ |
| C-38 | Dictionary.TryGetValue存在キーでtrue | E-04（TryGetValue） | ○ |
| C-39 | Dictionary.TryGetValue不在キーでfalse | E-04（TryGetValue） | ○ |

### Memory<T> クラス（UT-SCL-040 ~ UT-SCL-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | Memory<T>.Ctor(T[])で配列からMemory生成 | E-05 L37-50 | ○ |
| C-41 | Memory<T>.Ctor(T[])でnull配列からdefault | E-05 L39-43 | ○ |
| C-42 | Memory<T>.Ctor(T[], int, int)で部分抽出 | E-05 L85-108 | ○ |
| C-43 | Memory<T>.Ctor(T[], int, int)で範囲外検証 | E-05 L97-103 | ○ |
| C-44 | Memory<T>.Ctor(T[], int, int)で共変配列検証 | E-05 L44-45, L94-95 | ○ |
| C-45 | Memory<T>.SpanでSpan取得 | E-05（Spanプロパティ） | ○ |

### Span<T> クラス（UT-SCL-046 ~ UT-SCL-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Span<T>.Ctor(T[])で配列からSpan生成 | E-06 L41-53 | ○ |
| C-47 | Span<T>.Ctor(T[])でnull配列からdefault | E-06 L43-47 | ○ |
| C-48 | Span<T>.Ctor(T[], int, int)で部分抽出 | E-06 L68-90 | ○ |
| C-49 | Span<T>.Ctor(T[], int, int)で範囲外検証 | E-06 L79-86 | ○ |
| C-50 | Span<T>.Ctor(void*, int)でポインタから生成 | E-06 L108-117 | ○ |
| C-51 | Span<T>.Ctor(void*, int)で参照型検証 | E-06 L110-111 | ○ |
| C-52 | Span<T>.Ctor(void*, int)で負の長さ検証 | E-06 L112-113 | ○ |
| C-53 | Span<T>.this[int]でインデックスアクセス | E-06 L146-150 | ○ |
| C-54 | Span<T>.this[int]で範囲外検証 | E-06（インデクサ） | ○ |

### Guid 構造体（UT-SCL-055 ~ UT-SCL-063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | Guid.Ctor(byte[])でバイト配列から生成 | E-07 L59-62 | ○ |
| C-56 | Guid.Ctor(byte[])でnull配列検証 | E-07 L60 | ○ |
| C-57 | Guid.Ctor(byte[])で16バイト以外検証 | E-07 L67-70 | ○ |
| C-58 | Guid.Ctor(ReadOnlySpan<byte>)でSpanから生成 | E-07 L65-80 | ○ |
| C-59 | Guid.Ctor(ReadOnlySpan<byte>)で16バイト以外検証 | E-07 L67-70 | ○ |
| C-60 | Guid.NewGuid()で一意のGuid生成 | E-07（NewGuid） | ○ |
| C-61 | Guid.Emptyで全ビット0 | E-07 L40 | ○ |
| C-62 | Guid.Equals(Guid)で同じGuidはtrue | E-07（Equals） | ○ |
| C-63 | Guid.Equals(Guid)で異なるGuidはfalse | E-07（Equals） | ○ |

### DateTime 構造体（UT-SCL-064 ~ UT-SCL-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | DateTime.Ctor(long)でticksから生成 | E-08 L143-147 | ○ |
| C-65 | DateTime.Ctor(long)で負のticks検証 | E-08 L145 | ○ |
| C-66 | DateTime.Ctor(long)でMaxTicks超過検証 | E-08 L145 | ○ |
| C-67 | DateTime.Ctor(int, int, int)で年月日から生成 | E-08（コンストラクタ） | ○ |
| C-68 | DateTime.Ctor(int, int, int)で無効な月検証 | E-08（コンストラクタ） | ○ |
| C-69 | DateTime.Ctor(int, int, int)で無効な日検証 | E-08（コンストラクタ） | ○ |
| C-70 | DateTime.Nowで現在ローカル日時取得 | E-08（Nowプロパティ） | ○ |
| C-71 | DateTime.UtcNowで現在UTC日時取得 | E-08（UtcNowプロパティ） | ○ |
| C-72 | DateTime.AddDays(double)で日数加算 | E-08（AddDays） | ○ |
| C-73 | DateTime.AddDays(double)で範囲外検証 | E-08（AddDays） | ○ |

### Task クラス（UT-SCL-074 ~ UT-SCL-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | Task.Run(Action)でAction非同期実行 | E-09（Run） | ○ |
| C-75 | Task.Run<TResult>(Func<TResult>)でFunc非同期実行 | E-09（Run） | ○ |
| C-76 | Task.Wait()でタスク完了待機 | E-09（Wait） | ○ |
| C-77 | Task.WaitAll(Task[])で複数タスク待機 | E-09（WaitAll） | ○ |
| C-78 | Task.WaitAll(Task[])でnull配列検証 | E-09（WaitAll） | ○ |
| C-79 | Task.Delay(int)で指定時間後完了 | E-09（Delay） | ○ |
| C-80 | Task.Delay(int)で負の値検証 | E-09（Delay） | △ |
| C-81 | Task.Statusでタスク状態取得 | E-09 L131 | ○ |
| C-82 | Task.IsCompletedで完了状態取得 | E-09（IsCompleted） | ○ |

### Stream クラス（UT-SCL-083 ~ UT-SCL-088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Stream.CopyTo(Stream)でストリームコピー | E-10 L51-77 | ○ |
| C-84 | Stream.CopyTo(Stream)で読み取り不可検証 | E-10 L54-62 | ○ |
| C-85 | Stream.CopyToAsync(Stream)で非同期コピー | E-10 L85-116 | ○ |
| C-86 | Stream.CanReadで読み取り可否取得 | E-10 L29 | ○ |
| C-87 | Stream.CanWriteで書き込み可否取得 | E-10 L30 | ○ |
| C-88 | Stream.CanSeekでシーク可否取得 | E-10 L31 | ○ |

### StringBuilder クラス（UT-SCL-089 ~ UT-SCL-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | StringBuilder.Ctor()で空SB生成 | E-11 L78-82 | ○ |
| C-90 | StringBuilder.Ctor(int)で容量指定生成 | E-11 L88-91 | ○ |
| C-91 | StringBuilder.Ctor(int)で負の容量検証 | E-11（コンストラクタ） | ○ |
| C-92 | StringBuilder.Ctor(string)で文字列から生成 | E-11 L97-100 | ○ |
| C-93 | StringBuilder.Ctor(string, int, int, int)で部分文字列から生成 | E-11 L119-143 | ○ |
| C-94 | StringBuilder.Ctor(string, int, int, int)で範囲外検証 | E-11 L127-130 | ○ |
| C-95 | StringBuilder.Append(string)で文字列追加 | E-11（Append） | ○ |
| C-96 | StringBuilder.Append(char)で文字追加 | E-11（Append） | ○ |
| C-97 | StringBuilder.ToString()で文字列取得 | E-11（ToString） | ○ |
| C-98 | StringBuilder.Lengthで長さ取得 | E-11（Length） | ○ |
| C-99 | StringBuilder.Clear()で内容クリア | E-11（Clear） | ○ |

### Exception クラス（UT-SCL-100 ~ UT-SCL-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | Exception.Ctor()でException生成 | E-12 L20-23 | ○ |
| C-101 | Exception.Ctor(string)でメッセージ付き生成 | E-12 L25-29 | ○ |
| C-102 | Exception.Ctor(string, Exception)で内部例外付き生成 | E-12 L36-41 | ○ |
| C-103 | Exception.Messageでメッセージ取得 | E-12 L61 | ○ |
| C-104 | Exception.InnerExceptionで内部例外取得 | E-12 L83 | ○ |
| C-105 | Exception.GetBaseException()で最内側例外取得 | E-12 L69-81 | ○ |
| C-106 | Exception.StackTraceでスタックトレース取得 | E-12（StackTrace） | ○ |
| C-107 | Exception.Dataで追加データ管理 | E-12 L63 | ○ |

### Convert, Math, Environment等（UT-SCL-108 ~ UT-SCL-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | Convert.ToInt32(string)で文字列からint変換 | E-13 | ○ |
| C-109 | Convert.ToInt32(string)で数値以外検証 | E-13 | ○ |
| C-110 | Convert.ToInt32(string)でnull検証 | E-13 | ○ |
| C-111 | Convert.ToInt32(string)で範囲外検証 | E-13 | ○ |
| C-112 | Convert.ToBoolean(string)でtrue変換 | E-13 | ○ |
| C-113 | Convert.ToBoolean(string)でfalse変換 | E-13 | ○ |
| C-114 | Convert.ToBoolean(string)で無効値検証 | E-13 | ○ |
| C-115 | Math.Max(int, int)で大きい値返却 | E-14 | ○ |
| C-116 | Math.Min(int, int)で小さい値返却 | E-14 | ○ |
| C-117 | Math.Abs(int)で絶対値返却 | E-14 | ○ |
| C-118 | Math.Abs(int)でint.MinValueオーバーフロー | E-14 | ○ |
| C-119 | Math.Sqrt(double)で平方根返却 | E-14 | ○ |
| C-120 | Math.Sqrt(double)で負の値はNaN | E-14 | ○ |
| C-121 | Environment.GetEnvironmentVariable取得 | E-15 | ○ |
| C-122 | Environment.GetEnvironmentVariable不存在でnull | E-15 | △ |
| C-123 | Environment.MachineNameでマシン名取得 | E-15 | ○ |
| C-124 | Environment.ProcessorCountでプロセッサ数取得 | E-15 | ○ |
| C-125 | Environment.NewLineで改行文字取得 | E-15 | ○ |
| C-126 | BitConverter.GetBytes(int)でバイト配列変換 | E-16 | ○ |
| C-127 | BitConverter.ToInt32(byte[], int)でint復元 | E-16 | ○ |
| C-128 | BitConverter.ToInt32(byte[], int)で不十分バイト検証 | E-16 | ○ |
| C-129 | BitConverter.IsLittleEndianでエンディアン取得 | E-16 | ○ |
| C-130 | Lazy<T>.Ctor(Func<T>)で遅延初期化設定 | E-17 | ○ |
| C-131 | Lazy<T>.Valueで初回アクセス時値生成 | E-17 | ○ |
| C-132 | Lazy<T>.Valueで2回目以降同じ値 | E-17 | ○ |
| C-133 | Lazy<T>.IsValueCreatedで評価前false | E-17 | ○ |
| C-134 | Lazy<T>.IsValueCreatedで評価後true | E-17 | ○ |
| C-135 | WeakReference<T>.Ctor(T)で弱参照生成 | E-18 | ○ |
| C-136 | WeakReference<T>.TryGetTarget生存時true | E-18 | ○ |
| C-137 | WeakReference<T>.TryGetTarget GC後false | E-18 | △ |
| C-138 | WeakReference<T>.SetTargetで参照更新 | E-18 | ○ |
| C-139 | Tuple.Create<T1>(T1)で1要素Tuple生成 | E-19 | ○ |
| C-140 | Tuple.Create<T1, T2>(T1, T2)で2要素Tuple生成 | E-19 | ○ |
| C-141 | ValueTuple<T1, T2>.Ctor(T1, T2)でValueTuple生成 | E-20 | ○ |
| C-142 | ValueTuple<T1, T2>.Equals同値でtrue | E-20 | ○ |
| C-143 | ValueTuple<T1, T2>.Equals異値でfalse | E-20 | ○ |
| C-144 | Index.Ctor(int, bool)で先頭からIndex生成 | E-21 | ○ |
| C-145 | Index.Ctor(int, bool)で末尾からIndex生成 | E-21 | ○ |
| C-146 | Index.GetOffset(int)でオフセット計算 | E-21 | ○ |
| C-147 | Range.Ctor(Index, Index)で範囲生成 | E-22 | ○ |
| C-148 | Range.Allで全範囲取得 | E-22 | ○ |
| C-149 | Range.GetOffsetAndLengthでオフセットと長さ計算 | E-22 | ○ |
| C-150 | Version.Ctor(int, int)でVersion生成 | E-23 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Task.Delay の引数検証（C-80）**: -1 は Timeout.Infinite として許可されるが、-2以下の挙動はコードの詳細確認が必要
  - 候補：Task.cs の Delay メソッド実装詳細 / テストコード
- **WeakReference GC後の挙動（C-137）**: GCタイミングに依存するため、テスト実行時に挙動が異なる可能性
  - 候補：GC.Collect() 後の挙動確認 / 既存テストコード参照
- **Environment.GetEnvironmentVariable 不存在（C-122）**: プラットフォームによって挙動が異なる可能性
  - 候補：Windows/Linux/macOS での挙動確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なコンストラクタ、プロパティアクセス、単純な計算（約130件）
- **1（中リスク）**: 境界値テスト、null処理、例外スロー（約15件）
- **2（高リスク）**: GC依存挙動、プラットフォーム依存、非同期タイミング依存（約5件）

## 6) レビュアーチェックリスト（最小）
- [ ] String コンストラクタの引数検証テストケースが網羅されているか
- [ ] Array.Resize<T> の null 配列処理が正しく定義されているか
- [ ] List<T>/Dictionary<TKey,TValue> の容量管理テストが適切か
- [ ] Memory<T>/Span<T> の共変配列チェックテストが含まれているか
- [ ] DateTime の境界値（MinValue, MaxValue）テストが十分か
- [ ] Task の非同期挙動テストが現実的に実行可能か
- [ ] WeakReference の GC 依存テストの前提条件が明確か
- [ ] プラットフォーム依存のテスト（Environment等）の対応方針が記載されているか
