---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 115
  claims_with_evidence: 112
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Private.DataContractSerialization 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：112 / 115、根拠なし：3
- 優先レビュー（高）
  1. **UT-DCS-094**：空要素処理の詳細な挙動について追加確認が必要
  2. **UT-DCS-109**：IsNonAttributedTypeValidForSerializationの網羅的な条件確認
  3. **UT-DCS-115**：GetEnumeratorForCollectionの内部実装詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/DataContractSerializer.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/XmlObjectSerializer.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/Json/DataContractJsonSerializer.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/Json/JsonReaderWriterFactory.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Xml/XmlDictionaryReader.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Xml/XmlDictionaryWriter.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Xml/XmlDictionaryReaderQuotas.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/XmlReaderDelegator.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/DataContractSerializerSettings.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/ClassDataContract.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/CollectionDataContract.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DataContractSerializer関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DataContractSerializer(Type)コンストラクタでnullを渡すとArgumentNullExceptionがスローされる | E-01 (line 124) | ○ |
| C-02 | Initialize内でArgumentNullException.ThrowIfNull(type)が呼ばれる | E-01 (line 124) | ○ |
| C-03 | MaxItemsInObjectGraph=0でシリアライズ時に例外発生 | E-01 (line 369-370) | ○ |
| C-04 | WriteObject(Stream)でnullストリームはArgumentNullExceptionを発生 | E-02 (line 35) | ○ |
| C-05 | ReadObject時にverifyObjectName=trueで不一致ならSerializationException | E-01 (line 466-483) | ○ |
| C-06 | KnownTypesプロパティはReadOnlyCollectionを返却 | E-01 (line 162-171) | ○ |
| C-07 | PreserveObjectReferencesプロパティはフィールド値を返却 | E-01 (line 202-205) | ○ |
| C-08 | IgnoreExtensionDataObjectプロパティはフィールド値を返却 | E-01 (line 207-210) | ○ |
| C-09 | DataContractResolverプロパティはフィールド値を返却 | E-01 (line 212-215) | ○ |
| C-10 | SerializeReadOnlyTypesプロパティはフィールド値を返却 | E-01 (line 217-220) | ○ |

### DataContractJsonSerializer関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | DataContractJsonSerializer(Type)でnullを渡すとArgumentNullExceptionがスローされる | E-03 (line 594) | ○ |
| C-12 | WriteObject(Stream)でnullストリームはArgumentNullExceptionを発生 | E-03 (line 301) | ○ |
| C-13 | MaxItemsInObjectGraph=0でシリアライズ時に例外発生 | E-03 (line 500-503) | ○ |
| C-14 | CheckIfTypeIsReferenceでIsReference=trueならSerializationException | E-03 (line 638-647) | ○ |
| C-15 | DateTimeFormatプロパティは設定値を返却 | E-03 (line 150-156) | ○ |
| C-16 | EmitTypeInformationプロパティは設定値を返却 | E-03 (line 158-164) | ○ |
| C-17 | UseSimpleDictionaryFormatプロパティは設定値を返却 | E-03 (line 175-181) | ○ |

### JsonReaderWriterFactory関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | CreateJsonReader(byte[])でnullバッファはArgumentNullExceptionを発生 | E-04 (line 24) | ○ |
| C-19 | CreateJsonWriter(Stream)はUTF8エンコーディングを使用 | E-04 (line 50) | ○ |
| C-20 | CreateJsonWriter(Stream, Encoding, bool, bool, string)でインデント設定可能 | E-04 (line 68-73) | ○ |

### XmlDictionaryReader関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | CreateDictionaryReader(XmlReader)でnullはArgumentNullExceptionを発生 | E-05 (line 24) | ○ |
| C-22 | CreateBinaryReader(byte[])でnullはArgumentNullExceptionを発生 | E-05 (line 31) | ○ |
| C-23 | CreateTextReader(byte[])でnullはArgumentNullExceptionを発生 | E-05 (line 90) | ○ |
| C-24 | CreateMtomReaderはPlatformNotSupportedExceptionをスロー | E-05 (line 144) | ○ |
| C-25 | MoveToStartElement()で開始要素がない場合XmlExceptionをスロー | E-05 (line 198-199) | ○ |
| C-26 | ReadContentAsString()はQuotas.MaxStringContentLengthを使用 | E-05 (line 383) | ○ |
| C-27 | MaxStringContentLength超過時XmlExceptionをスロー | E-05 (line 412, 443-444) | ○ |

### XmlDictionaryWriter関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | CreateDictionaryWriter(XmlWriter)でnullはArgumentNullExceptionを発生 | E-06 (line 72) | ○ |
| C-29 | CreateTextWriter(Stream)はUTF8NoBomエンコーディングを使用 | E-06 (line 44) | ○ |
| C-30 | WriteArray()でnull配列はArgumentNullExceptionを発生 | E-06 (line 438) | ○ |
| C-31 | WriteArray()でoffsetが負の場合ArgumentOutOfRangeExceptionを発生 | E-06 (line 440) | ○ |
| C-32 | WriteValue(UniqueId)でnullはArgumentNullExceptionを発生 | E-06 (line 176) | ○ |

### XmlDictionaryReaderQuotas関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | デフォルトMaxDepth=32 | E-07 (line 29, 39) | ○ |
| C-34 | デフォルトMaxStringContentLength=8192 | E-07 (line 30, 40) | ○ |
| C-35 | デフォルトMaxArrayLength=16384 | E-07 (line 31, 41) | ○ |
| C-36 | デフォルトMaxBytesPerRead=4096 | E-07 (line 32, 42) | ○ |
| C-37 | デフォルトMaxNameTableCharCount=16384 | E-07 (line 33, 43) | ○ |
| C-38 | CopyTo(null)はArgumentNullExceptionを発生 | E-07 (line 67) | ○ |
| C-39 | CopyTo(readOnlyQuotas)はInvalidOperationExceptionを発生 | E-07 (line 69-70) | ○ |
| C-40 | MaxStringContentLength設定時0以下でArgumentOutOfRangeExceptionを発生 | E-07 (line 96) | ○ |
| C-41 | MaxArrayLength設定時0以下でArgumentOutOfRangeExceptionを発生 | E-07 (line 113) | ○ |
| C-42 | MaxDepth設定時0以下でArgumentOutOfRangeExceptionを発生 | E-07 (line 148) | ○ |
| C-43 | 読み取り専用時プロパティ設定でInvalidOperationExceptionを発生 | E-07 (line 94-95, 111-112, 128-129, 146-147, 163-164) | ○ |

### XmlReaderDelegator関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | XmlReaderDelegator(null)はArgumentNullExceptionを発生 | E-08 (line 21) | ○ |
| C-45 | ReadContentAsBoolean()で空要素時XmlExceptionを発生 | E-08 (line 389-390) | ○ |
| C-46 | ReadContentAsChar()で範囲外の値はXmlExceptionを発生 | E-08 (line 357-363) | ○ |
| C-47 | ReadContentAsBase64()で空要素はArray.Empty<byte>()を返却 | E-08 (line 460-461) | ○ |
| C-48 | Read()で空要素の処理が正しく行われる | E-08 (line 172-186) | ○ |
| C-49 | IsStartElement()でisEndOfEmptyElement時falseを返却 | E-08 (line 117-119) | ○ |

### ClassDataContract関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | BaseClassContractプロパティでhelperの値を返却 | E-10 (line 64-68) | ○ |
| C-51 | Membersプロパティでhelperの値を返却 | E-10 (line 70-74) | ○ |
| C-52 | IsNonAttributedTypeValidForSerializationで配列型はfalse | E-10 (line 304-305) | ○ |
| C-53 | IsNonAttributedTypeValidForSerializationでEnum型はfalse | E-10 (line 307-308) | ○ |
| C-54 | IsNonAttributedTypeValidForSerializationでIXmlSerializableはfalse | E-10 (line 313-314) | ○ |

### CollectionDataContract関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | Kindプロパティでhelperの値を返却 | E-11 (line 152) | ○ |
| C-56 | ItemTypeプロパティでhelperの値を返却 | E-11 (line 154) | ○ |
| C-57 | IsDictionaryプロパティでKeyName != nullを判定 | E-11 (line 206) | ○ |
| C-58 | IsDictionaryLike()で辞書情報を返却 | E-11 (line 191-197) | ○ |

### 根拠不足項目

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | Read()での空要素終了後の詳細なフロー | **根拠不足** | △ |
| C-109 | IsNonAttributedTypeValidForSerializationの全条件分岐 | **一部根拠不足** | △ |
| C-115 | GetEnumeratorForCollectionの内部実装詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

1. **Read()メソッドの空要素処理フロー**
   - isEndOfEmptyElementフラグの状態遷移について、より詳細なテストケースが必要な可能性がある
   - 候補：追加のソースコード解析 / 既存テストコードの確認

2. **IsNonAttributedTypeValidForSerializationの網羅性**
   - 多数の条件分岐があり、すべての条件をカバーするテストケースが必要
   - 候補：追加のエッジケース分析

3. **GetEnumeratorForCollectionの実装詳細**
   - helperクラス内部の実装を確認していないため、具体的な挙動の検証が不十分
   - 候補：CollectionDataContractCriticalHelperクラスの解析

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2: 高リスク | MaxItemsInObjectGraph境界値テスト | オブジェクトグラフの制限に関わるセキュリティ上重要なテスト |
| 2: 高リスク | XmlDictionaryReaderQuotasの境界値テスト | DoS攻撃対策に関わる重要なテスト |
| 1: 中リスク | IsReference型のJSON処理 | サポート対象外の型を正しく検出するテスト |
| 1: 中リスク | Base64デコード処理 | 大きなデータや不正データの処理 |
| 0: 低リスク | プロパティアクセサテスト | 単純なゲッター/セッターの確認 |

## 6) レビュアーチェックリスト（最小）

- [ ] 高優先度（高リスク）のテストケースが適切に定義されているか
- [ ] null入力に対するArgumentNullExceptionのテストが網羅されているか
- [ ] 境界値（0, 負値, 最大値）のテストが適切に定義されているか
- [ ] シリアライズ/デシリアライズの往復テストが考慮されているか
- [ ] クォータ制限のテストが適切に定義されているか
- [ ] JSON/XML両形式でのテストが網羅されているか
- [ ] 例外メッセージの検証が必要なテストケースを特定したか
- [ ] 継承関係（BaseClassContract）のテストが考慮されているか
- [ ] コレクション型（Dictionary, List等）の各種別がカバーされているか
