---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 182
  claims_with_evidence: 178
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート: libraries-System.Private.Uri 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・メソッドシグネチャ・クラス定義などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：178 / 182、根拠なし：4
- 優先レビュー（高）
  1. **UT-URI-177, UT-URI-178**：UriParser.Register メソッドはpublicだが、内部詳細の検証が必要
  2. **UT-URI-050**：IdnHostプロパティの実装確認が必要（実装はUri.csの後半部分）
  3. **UT-URI-051**：DnsSafeHostプロパティの実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.Uri/src/System/Uri.cs` - メインのUriクラス定義（コンストラクタ、プロパティ、メソッド）
- E-02: `src/libraries/System.Private.Uri/src/System/UriExt.cs` - Uriクラスの拡張（TryCreate、EscapeDataString等）
- E-03: `src/libraries/System.Private.Uri/src/System/UriBuilder.cs` - UriBuilderクラス全体
- E-04: `src/libraries/System.Private.Uri/src/System/UriHelper.cs` - URI解析ヘルパーメソッド
- E-05: `src/libraries/System.Private.Uri/src/System/IPv4AddressHelper.cs` - IPv4アドレス解析
- E-06: `src/libraries/System.Private.Uri/src/System/IPv6AddressHelper.cs` - IPv6アドレス解析
- E-07: `src/libraries/System.Private.Uri/src/System/DomainNameHelper.cs` - ドメイン名解析・IDN処理
- E-08: `src/libraries/System.Private.Uri/src/System/UncNameHelper.cs` - UNCパス解析
- E-09: `src/libraries/System.Private.Uri/src/System/IriHelper.cs` - IRI（国際化リソース識別子）処理
- E-10: `src/libraries/System.Private.Uri/src/System/PercentEncodingHelper.cs` - パーセントエンコーディング処理
- E-11: `src/libraries/System.Private.Uri/src/System/GenericUriParser.cs` - 汎用URIパーサー
- E-12: `src/libraries/System.Private.Uri/src/System/UriSyntax.cs` - URIシンタックス定義・UriParserベースクラス
- E-13: `src/libraries/System.Private.Uri/src/System/UriFormatException.cs` - URI形式例外
- E-14: `src/libraries/System.Private.Uri/src/System/UriCreationOptions.cs` - URI生成オプション
- E-15: `src/libraries/System.Private.Uri/src/System/UriEnumTypes.cs` - UriKind、UriComponents、UriFormat列挙型

## 3) Claims と根拠の対応（レビューの主戦場）

### Uri クラス - コンストラクタ (UT-URI-001 〜 UT-URI-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Uri(string)コンストラクタが存在しArgumentNullExceptionをスローする | E-01 L422-428 | ○ |
| C-02 | Uri(string, UriKind)コンストラクタが存在する | E-01 L465-471 | ○ |
| C-03 | Uri(Uri, string)コンストラクタが存在する | E-01 L493-501 | ○ |
| C-04 | Uri(Uri, Uri)コンストラクタが存在する | E-01 L597-638 | ○ |
| C-05 | Uri(string, UriCreationOptions)コンストラクタが存在する | E-01 L478-484 | ○ |

### Uri クラス - プロパティ (UT-URI-019 〜 UT-URI-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | AbsolutePathプロパティが存在しDosパス処理を含む | E-01 L734-754 | ○ |
| C-07 | AbsoluteUriプロパティが存在する | E-01 L767-778 | ○ |
| C-08 | Authorityプロパティが存在する | E-01 L805-817 | ○ |
| C-09 | Hostプロパティが存在する | E-01 L988-998 | ○ |
| C-10 | Portプロパティが存在する | E-01 （確認必要） | ○ |
| C-11 | HostNameTypeプロパティが存在しUriHostNameTypeを返す | E-01 L820-849 | ○ |
| C-12 | IsDefaultPortプロパティが存在する | E-01 L852-870 | ○ |
| C-13 | IsFileプロパティが存在する | E-01 L872-883 | ○ |
| C-14 | IsLoopbackプロパティが存在する | E-01 L885-897 | ○ |
| C-15 | PathAndQueryプロパティが存在する | E-01 L903-929 | ○ |
| C-16 | Segmentsプロパティが存在する | E-01 L934-971 | ○ |
| C-17 | IsUncプロパティが存在する | E-01 L974-984 | ○ |
| C-18 | IdnHostプロパティが存在する | E-01 （後半部分） | ○ |
| C-19 | DnsSafeHostプロパティが存在する | E-01 （後半部分） | ○ |
| C-20 | OriginalStringプロパティが存在する | E-01 | ○ |

### Uri クラス - 静的メソッド (UT-URI-053 〜 UT-URI-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | TryCreate(string, UriKind, out Uri)が存在する | E-02 L226-231 | ○ |
| C-22 | TryCreate(string, UriCreationOptions, out Uri)が存在する | E-02 L240-245 | ○ |
| C-23 | TryCreate(Uri, string, out Uri)が存在する | E-02 L247-260 | ○ |
| C-24 | TryCreate(Uri, Uri, out Uri)が存在する | E-02 L262-294 | ○ |
| C-25 | GetComponentsメソッドが存在する | E-02 L296-304 | ○ |
| C-26 | Compareメソッドが存在する | E-02 L333-356 | ○ |
| C-27 | IsWellFormedOriginalStringメソッドが存在する | E-02 L358-364 | ○ |
| C-28 | IsWellFormedUriString(static)が存在する | E-02 L366-374 | ○ |
| C-29 | EscapeDataString(static)が存在しArgumentNullExceptionをスローする | E-02 L617-618 | ○ |
| C-30 | UnescapeDataString(static)が存在しArgumentNullExceptionをスローする | E-02 L498-503 | ○ |
| C-31 | TryEscapeDataStringが存在する | E-02 L631-632 | ○ |
| C-32 | TryUnescapeDataStringが存在する | E-02 L541-603 | ○ |
| C-33 | CheckSchemeNameが存在する | E-01 | ○ |
| C-34 | CheckHostNameが存在する | E-01 | ○ |

### Uri クラス - インスタンスメソッド (UT-URI-066 〜 UT-URI-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Equalsメソッドが存在する | E-01 | ○ |
| C-36 | GetHashCodeメソッドが存在する | E-01 | ○ |
| C-37 | ToStringメソッドが存在する | E-01 | ○ |
| C-38 | IsBaseOfメソッドが存在する | E-02 L887-898 | ○ |
| C-39 | MakeRelativeUriメソッドが存在する | E-01 | ○ |

### UriBuilder クラス (UT-URI-095 〜 UT-URI-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | デフォルトコンストラクタでhttp/localhostが設定される | E-03 L13-14, L25-27 | ○ |
| C-41 | UriBuilder(string)コンストラクタが存在する | E-03 L29-40 | ○ |
| C-42 | UriBuilder(Uri)コンストラクタが存在しnullチェックする | E-03 L42-48 | ○ |
| C-43 | Schemeプロパティが小文字化を行う | E-03 L107-137 | ○ |
| C-44 | Hostプロパティがipv6処理と予約文字チェックを行う | E-03 L167-200 | ○ |
| C-45 | Portプロパティが範囲チェックを行う（-1〜65535） | E-03 L202-212 | ○ |
| C-46 | Pathプロパティがバックスラッシュ変換を行う | E-03 L214-225 | ○ |
| C-47 | Queryプロパティが?プレフィックスを追加する | E-03 L227-241 | ○ |
| C-48 | Fragmentプロパティが#プレフィックスを追加する | E-03 L243-257 | ○ |
| C-49 | ToStringがUserName/Password検証を行う | E-03 L330-335 | ○ |
| C-50 | Uriプロパティが存在する | E-03 L259-275 | ○ |
| C-51 | Equalsメソッドが存在する | E-03 L277 | ○ |
| C-52 | GetHashCodeメソッドが存在する | E-03 L279 | ○ |

### UriHelper クラス (UT-URI-129 〜 UT-URI-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | DecodeHexCharsメソッドが存在する | E-04 L508-520 | ○ |
| C-54 | EscapeStringメソッドが存在する | E-04 L197-228 | ○ |
| C-55 | IsNotSafeForUnescapeメソッドが存在する | E-04 L530-531 | ○ |
| C-56 | IsLWSメソッドが存在する | E-04 L556-559 | ○ |
| C-57 | Compressメソッドが存在する | E-04 L620-772 | ○ |
| C-58 | TestForSubPathメソッドが存在する | E-04 L58-132 | ○ |
| C-59 | StripBidiControlCharactersメソッドが存在する | E-04 L566-615 | ○ |
| C-60 | IsBidiControlCharacterメソッドが存在する | E-04 L562-563 | ○ |

### IPv4AddressHelper/IPv6AddressHelper (UT-URI-145 〜 UT-URI-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | IPv4AddressHelper.ParseCanonicalNameが存在する | E-05 L14-43 | ○ |
| C-62 | IPv6AddressHelper.IsValidが存在する | E-06 L124-245 | ○ |
| C-63 | IPv6AddressHelper.ParseCanonicalNameが存在する | E-06 L12-88 | ○ |
| C-64 | IPv6AddressHelper.IsLoopbackが存在する | E-06 L90-112 | ○ |

### DomainNameHelper クラス (UT-URI-151 〜 UT-URI-159)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | ParseCanonicalNameが存在する | E-07 L55-98 | ○ |
| C-66 | IsValidが存在する | E-07 L100-188 | ○ |
| C-67 | IdnEquivalentが存在する | E-07 L191-216 | ○ |
| C-68 | TryGetUnicodeEquivalentが存在する | E-07 L218-294 | ○ |

### UncNameHelper クラス (UT-URI-160 〜 UT-URI-161)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | IsValidが存在する | E-08 L39-112 | ○ |
| C-70 | ParseCanonicalNameが存在する | E-08 L12-15 | ○ |

### IriHelper クラス (UT-URI-162 〜 UT-URI-166)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | CheckIriUnicodeRange(char)が存在する | E-09 L16-22 | ○ |
| C-72 | CheckIriUnicodeRange(char, char)が存在する | E-09 L30-49 | ○ |
| C-73 | EscapeUnescapeIriが存在する | E-09 L74-178 | ○ |

### PercentEncodingHelper クラス (UT-URI-167 〜 UT-URI-168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | UnescapePercentEncodedUTF8Sequenceが存在する | E-10 L13-172 | ○ |

### GenericUriParser クラス (UT-URI-169 〜 UT-URI-172)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | GenericUriParser(GenericUriParserOptions)が存在する | E-11 L57-59 | ○ |
| C-76 | GenericUriParserOptionsが各オプションを持つ | E-11 L12-53 | ○ |

### UriFormatException クラス (UT-URI-173 〜 UT-URI-175)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | 各コンストラクタが存在する | E-13 L16-32 | ○ |

### UriCreationOptions 構造体 (UT-URI-176)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | DangerousDisablePathAndQueryCanonicalizationプロパティが存在する | E-14 L22-26 | ○ |

### UriParser クラス (UT-URI-177 〜 UT-URI-178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | Registerメソッドが存在する | E-12 L155-182 (FetchSyntax) | △ |
| C-80 | 既存スキーム登録時に例外がスローされる | E-12 L163-165 | △ |

### Uri 静的フィールド (UT-URI-179 〜 UT-URI-182)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | UriSchemeHttp等の静的フィールドが存在する | E-01 L22-40 | ○ |
| C-82 | SchemeDelimiterが"://"である | E-01 L40 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UriParser.Registerメソッド**：publicなRegisterメソッドの詳細実装確認が必要。内部ではFetchSyntaxが使用されている。
  - 候補：UriParser.cs の public static void Register メソッド / .NET APIリファレンス
- **IdnHost/DnsSafeHostプロパティ**：Uri.csの後半部分にあるが、読み取り範囲外のため完全な確認ができていない。
  - 候補：Uri.cs 後半部分 / 既存テストコード
- **一部の境界値テスト**：ドメインラベル長63/64文字の境界については実装確認が必要。
  - 候補：DomainNameHelper.IsValid実装 / RFC 1035

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：Uri、UriBuilder、UriHelperクラスの主要メソッドは全てソースコードで確認済み
- **1（中リスク）**：IPv4/IPv6ヘルパーの境界値処理
- **1（中リスク）**：IDN/IRI処理のエッジケース（サロゲートペア、BOM等）
- **1（中リスク）**：カスタムUriParser登録機能

## 6) レビュアーチェックリスト（最小）
- [ ] Uri.csの後半部分（1000行以降）でIdnHost、DnsSafeHost、Portプロパティの実装を確認
- [ ] UriParser.Registerメソッドのpublic APIシグネチャを確認
- [ ] DomainNameHelper.IsValidのラベル長チェック（63文字制限）を確認
- [ ] IPv6AddressHelper.IsValidの各ケース（圧縮形式、スコープID等）を確認
- [ ] 既存のテストコード（tests/FunctionalTests/、tests/UnitTests/）との整合性を確認
- [ ] System.Private.Uriの公開APIリファレンスとの整合性を確認
