---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Private.Xml.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **UT-XML-146 GetElementById**: ID属性の定義方法（DTD/XSD）によって動作が異なる可能性
  2. **UT-XML-121 WriteRaw**: セキュリティリスクの観点から追加テストが必要
  3. **UT-XML-078 DtdProcessing**: セキュリティ設定のデフォルト値確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.Xml/src/System/Xml/NameTable.cs`
- E-02: `src/libraries/System.Private.Xml/src/System/Xml/XmlNamespacemanager.cs`
- E-03: `src/libraries/System.Private.Xml/src/System/Xml/XmlConvert.cs`
- E-04: `src/libraries/System.Private.Xml/src/System/Xml/XmlQualifiedName.cs`
- E-05: `src/libraries/System.Private.Xml/src/System/Xml/XmlException.cs`
- E-06: `src/libraries/System.Private.Xml/src/System/Xml/Core/XmlReaderSettings.cs`
- E-07: `src/libraries/System.Private.Xml/src/System/Xml/Core/XmlReader.cs`
- E-08: `src/libraries/System.Private.Xml/src/System/Xml/Core/XmlWriter.cs`
- E-09: `src/libraries/System.Private.Xml/src/System/Xml/Dom/XmlDocument.cs`
- E-10: `src/libraries/System.Private.Xml/src/System/Xml/Dom/XmlNode.cs`
- E-11: `src/libraries/System.Private.Xml/src/System/Xml/Dom/XmlElement.cs`
- E-12: `src/libraries/System.Private.Xml/src/System/Xml/Dom/XmlAttribute.cs`
- E-13: `src/libraries/System.Private.Xml/src/System/Xml/Dom/XmlAttributeCollection.cs`
- E-14: `src/libraries/System.Private.Xml/src/System/Xml/ValidateNames.cs`
- E-15: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathNavigator.cs`
- E-16: `src/libraries/System.Private.Xml/src/System/Xml/Schema/XmlSchemaSet.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### NameTable クラス (UT-XML-001 - UT-XML-012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NameTable.Add(string)はnullでArgumentNullExceptionをスロー | E-01 L56: `ArgumentNullException.ThrowIfNull(key)` | ○ |
| C-02 | NameTable.Add(string)は空文字列でstring.Emptyを返す | E-01 L59-62: `if (len == 0) return string.Empty` | ○ |
| C-03 | NameTable.Add(char[], int, int)の境界チェック | E-01 L91-94: 範囲チェックでIndexOutOfRangeException | ○ |
| C-04 | NameTable.Add(char[], int, int)の負のlenチェック | E-01 L97: `ArgumentOutOfRangeException.ThrowIfNegative(len)` | ○ |
| C-05 | NameTable.Get(string)はnullでArgumentNullExceptionをスロー | E-01 L117: `ArgumentNullException.ThrowIfNull(value)` | ○ |
| C-06 | NameTable.Get(char[], int, int)の負のlenでnull返却 | E-01 L154-157: `if (len < 0) return null` | ○ |

### XmlNamespaceManager クラス (UT-XML-013 - UT-XML-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | AddNamespaceでnullのprefixはArgumentNullExceptionをスロー | E-02 L123: `ArgumentNullException.ThrowIfNull(prefix)` | ○ |
| C-08 | AddNamespaceでxmlプレフィックスに不正URIでArgumentException | E-02 L131-134: xml予約チェック | ○ |
| C-09 | AddNamespaceでxmlnsプレフィックスでArgumentException | E-02 L135-138: xmlns予約チェック | ○ |
| C-10 | PopScopeはルートスコープでfalseを返す | E-02 L97-100: `if (_scopeId == 1) return false` | ○ |
| C-11 | DefaultNamespaceはLookupNamespaceを使用 | E-02 L82-86: `LookupNamespace(string.Empty)` | ○ |

### XmlConvert クラス (UT-XML-028 - UT-XML-051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | EncodeNameはnull入力でnullを返す | E-03 L173-176: `if (string.IsNullOrEmpty(name)) return name` | ○ |
| C-13 | DecodeNameはnull入力でnullを返す | E-03 L78-81: `if (string.IsNullOrEmpty(name)) return name` | ○ |
| C-14 | ToBooleanの変換ロジック | E-03（XmlConvert内部）: ToBoolean実装確認 | ○ |

### XmlQualifiedName クラス (UT-XML-052 - UT-XML-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | コンストラクタでnull名前は空文字列に | E-04 L35-36: `Name = name ?? string.Empty` | ○ |
| C-16 | IsEmptyはName.LengthとNamespace.Lengthで判定 | E-04 L62: `Name.Length == 0 && Namespace.Length == 0` | ○ |
| C-17 | ToStringは名前空間の有無で形式が変わる | E-04 L66-68: 条件分岐で形式決定 | ○ |
| C-18 | Equalsは名前と名前空間の両方を比較 | E-04 L84: `Name == name && Namespace == ns` | ○ |

### XmlException クラス (UT-XML-062 - UT-XML-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | コンストラクタで行番号と列位置を保存 | E-05 L113-114: `_lineNumber = lineNumber; _linePosition = linePosition` | ○ |
| C-20 | Messageプロパティで行情報付きメッセージ生成 | E-05 L198-218: CreateMessage実装 | ○ |

### XmlReaderSettings クラス (UT-XML-068 - UT-XML-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | ConformanceLevelの範囲チェック | E-06 L122-127: 範囲外でArgumentOutOfRangeException | ○ |
| C-22 | MaxCharactersInDocumentの負値チェック | E-06 L145-150: 負値でArgumentOutOfRangeException | ○ |
| C-23 | MaxCharactersFromEntitiesの負値チェック | E-06 L157-165: 負値でArgumentOutOfRangeException | ○ |

### XmlReader クラス (UT-XML-081 - UT-XML-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | ReadContentAsBooleanの変換エラー | E-07 L161-168: FormatExceptionをXmlExceptionでラップ | ○ |
| C-25 | ReadContentAsDateTimeの変換 | E-07 L180-188: XmlConvert.ToDateTimeを使用 | ○ |
| C-26 | HasValueはノードタイプで判定 | E-07 L108: `HasValueInternal(NodeType)` | ○ |

### XmlWriter クラス (UT-XML-105 - UT-XML-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | WriteAttributeStringの実装 | E-08 L93-98: WriteStartAttribute/WriteString/WriteEndAttribute | ○ |
| C-28 | WriteBinHexの実装 | E-08 L185-188: BinHexEncoder.Encode使用 | ○ |

### XmlDocument クラス (UT-XML-125 - UT-XML-151)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | デフォルトコンストラクタでXmlImplementation作成 | E-09 L133-135: `new XmlImplementation()` | ○ |
| C-30 | NameTable指定コンストラクタ | E-09 L139-141: `new XmlImplementation(nt)` | ○ |
| C-31 | GetElementByIdの動作 | E-09: ID属性の定義が必要（DTD/XSD） | △ |

### XmlNode クラス (UT-XML-152 - UT-XML-176)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | SelectSingleNodeでXPathNavigator使用 | E-10 L49-61: navigator.Select使用 | ○ |
| C-33 | ParentNodeの取得ロジック | E-10 L124-155: ドキュメントノードの特別処理 | ○ |
| C-34 | ChildNodesでXmlChildNodes返却 | E-10 L160: `new XmlChildNodes(this)` | ○ |

### XmlElement クラス (UT-XML-177 - UT-XML-188)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | GetAttributeの動作 | E-11: 属性操作メソッド確認 | ○ |
| C-36 | GetElementsByTagNameの動作 | E-11: 子孫検索メソッド確認 | ○ |

### XmlAttribute クラス (UT-XML-189 - UT-XML-192)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | Valueプロパティ | E-12: 属性値の取得・設定 | ○ |
| C-38 | OwnerElementプロパティ | E-12: 所有要素の取得 | ○ |

### XmlAttributeCollection クラス (UT-XML-193 - UT-XML-200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Appendメソッド | E-13: 属性追加メソッド | ○ |
| C-40 | RemoveAllメソッド | E-13: 全削除メソッド | ○ |

## 4) 不足情報（Unknown / Missing）
- **GetElementById (UT-XML-146)**: ID属性がDTDまたはXSDで定義されていないと動作しない可能性がある。テストケースにはこの前提条件を明記すべき。
  - 候補：DTD定義確認 / XSD検証モード確認 / 属性スキーマ情報
- **WriteRaw (UT-XML-121)**: 生XMLを直接出力するため、整形式でないXMLを出力するリスクがある。セキュリティテストの追加を検討。
  - 候補：XXE攻撃テスト / 不正XML注入テスト
- **DtdProcessing設定 (UT-XML-078)**: デフォルト値がProhibitからParseに変更されている可能性。バージョン間の互換性確認が必要。
  - 候補：.NET Frameworkとの互換性確認 / セキュリティポリシー確認
- **非同期メソッド**: XmlReader/XmlWriterの非同期メソッド（ReadAsync、WriteAsync等）のテストケースが不足している可能性。
  - 候補：Async=true設定時の動作確認
- **エンコーディング**: 各種文字エンコーディング（UTF-8、UTF-16、Shift-JIS等）のテストケースが限定的。
  - 候補：エンコーディング自動検出 / BOM処理

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - GetElementById: ID属性の定義方法による動作差異
- **1: 中リスク** - WriteRaw: セキュリティ上の懸念
- **0: 低リスク** - 大部分のテストケースはソースコードから直接確認可能
- **1: 中リスク** - 非同期処理のテストカバレッジ不足の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] NameTableのハッシュ衝突に関するテストケースの追加を検討
- [ ] XmlNamespaceManagerのハッシュテーブル使用閾値（MinDeclsCountForHashtable=16）のテスト
- [ ] XmlConvertの各型変換メソッドの境界値テストの網羅性確認
- [ ] XmlReaderSettingsのReadOnly状態でのプロパティ変更テスト
- [ ] XmlDocumentのイベント（NodeInserting, NodeInserted等）のテストケース追加
- [ ] XmlNodeのNormalize()メソッドのテストケース追加
- [ ] XPathNavigatorを使用したクエリのテストケース追加
- [ ] スキーマ検証（XmlSchemaSet）との統合テストケースの検討
- [ ] エンティティ参照展開に関するセキュリティテストの追加
- [ ] 大規模XMLドキュメントのパフォーマンステストケースの検討
