---
generated_at: 2026-01-30 17:45:00
metrics:
  claims_total: 254
  claims_with_evidence: 254
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Reflection.Context.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：254 / 254、根拠なし：0
- 優先レビュー（高）
  1. **CustomReflectionContext関連テストケース（UT-SRC-001〜020）**：コアクラスのテスト
  2. **VirtualPropertyInfo/VirtualPropertyBase関連テストケース（UT-SRC-044〜077）**：仮想プロパティの主要機能
  3. **ReflectionContextProjector関連テストケース（UT-SRC-222〜254）**：プロジェクション機能

## 2) 参照した情報（Evidence一覧）
> 解析したソースコードファイル

- E-01: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/CustomReflectionContext.cs`
- E-02: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/CustomReflectionContext.Projector.cs`
- E-03: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/CollectionServices.cs`
- E-04: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Projection/Projector.cs`
- E-05: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Projection/ProjectingType.cs`
- E-06: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Projection/ProjectingAssembly.cs`
- E-07: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Projection/ProjectingModule.cs`
- E-08: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomType.cs`
- E-09: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomAssembly.cs`
- E-10: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomModule.cs`
- E-11: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomMethodInfo.cs`
- E-12: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomPropertyInfo.cs`
- E-13: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomConstructorInfo.cs`
- E-14: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomFieldInfo.cs`
- E-15: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomEventInfo.cs`
- E-16: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/CustomParameterInfo.cs`
- E-17: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Custom/AttributeUtils.cs`
- E-18: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualPropertyInfo.cs`
- E-19: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualPropertyBase.cs`
- E-20: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualPropertyInfo.PropertyGetter.cs`
- E-21: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualPropertyInfo.PropertySetter.cs`
- E-22: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualPropertyBase.PropertyGetterBase.cs`
- E-23: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualPropertyBase.PropertySetterBase.cs`
- E-24: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualPropertyBase.FuncPropertyAccessorBase.cs`
- E-25: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualMethodBase.cs`
- E-26: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualParameter.cs`
- E-27: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/VirtualReturnParameter.cs`
- E-28: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/InheritedPropertyInfo.cs`
- E-29: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Virtual/InheritedMethodInfo.cs`
- E-30: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Delegation/DelegatingType.cs`
- E-31: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Delegation/DelegatingMethodInfo.cs`
- E-32: `src/libraries/System.Reflection.Context/src/System/Reflection/Context/Delegation/DelegatingPropertyInfo.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CustomReflectionContext関連（UT-SRC-001〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-001 | デフォルトコンストラクタでIdentityReflectionContextがSourceContextとして設定される | E-01 (L21) | ○ |
| UT-SRC-002 | ReflectionContextを指定して初期化できること | E-01 (L23-29) | ○ |
| UT-SRC-003 | nullを渡すとArgumentNullExceptionがスローされること | E-01 (L25) | ○ |
| UT-SRC-004 | Assemblyがプロジェクションされること | E-01 (L31-36) | ○ |
| UT-SRC-005 | nullを渡すとArgumentNullExceptionがスローされること（MapAssembly） | E-01 (L33) | ○ |
| UT-SRC-006 | TypeInfoがプロジェクションされること | E-01 (L38-43) | ○ |
| UT-SRC-007 | nullを渡すとArgumentNullExceptionがスローされること（MapType） | E-01 (L40) | ○ |
| UT-SRC-008 | カスタム属性を取得できること（MemberInfo） | E-01 (L45-48) | ○ |
| UT-SRC-009 | パラメータのカスタム属性を取得できること | E-01 (L50-53) | ○ |
| UT-SRC-010 | デフォルトで空のコレクションが返却されること（AddProperties） | E-01 (L55-60) | ○ |
| UT-SRC-011 | VirtualPropertyInfoが作成できること（CreateProperty基本） | E-01 (L62-77) | ○ |
| UT-SRC-012 | getterとsetterの両方がnullの場合例外がスローされること | E-18 (L28-29) | ○ |
| UT-SRC-013 | カスタム属性付きVirtualPropertyInfoが作成できること | E-01 (L79-97) | ○ |
| UT-SRC-014 | 新しいプロパティが取得できること（GetNewPropertiesForType） | E-01 (L99-125) | ○ |
| UT-SRC-015 | インターフェースの場合は空が返却されること | E-01 (L102-103) | ○ |
| UT-SRC-016 | ジェネリックパラメータの場合は空が返却されること | E-01 (L102) | ○ |
| UT-SRC-017 | nullプロパティが追加された場合InvalidOperationExceptionがスローされること | E-01 (L111-112) | ○ |
| UT-SRC-018 | 別コンテキストのプロパティが追加された場合InvalidOperationExceptionがスローされること | E-01 (L114-116) | ○ |
| UT-SRC-019 | Assemblyがそのまま返却されること（IdentityReflectionContext） | E-01 (L13) | ○ |
| UT-SRC-020 | TypeInfoがそのまま返却されること（IdentityReflectionContext） | E-01 (L14) | ○ |

### Projector関連（UT-SRC-021〜031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-021 | リストが正しくプロジェクションされること | E-04 (L12-21) | ○ |
| UT-SRC-022 | 空のリストの場合そのまま返却されること | E-04 (L15-16) | ○ |
| UT-SRC-023 | nullの場合nullが返却されること（IList） | E-04 (L15) | ○ |
| UT-SRC-024 | 配列が正しくプロジェクションされること | E-04 (L23-30) | ○ |
| UT-SRC-025 | 空配列の場合そのまま返却されること | E-04 (L26-27) | ○ |
| UT-SRC-026 | ProjectingType配列がアンプロジェクションされること | E-04 (L82-94) | ○ |
| UT-SRC-027 | nullの場合nullが返却されること（Unproject配列） | E-04 (L84-85) | ○ |
| UT-SRC-028 | ProjectingTypeがアンプロジェクションされること（単一） | E-04 (L97-103) | ○ |
| UT-SRC-029 | 非ProjectingTypeの場合そのまま返却されること | E-04 (L101-102) | ○ |
| UT-SRC-030 | プロジェクションが必要な場合trueが返却されること | E-04 (L105-117) | ○ |
| UT-SRC-031 | 既にプロジェクション済みの場合falseが返却されること | E-04 (L112-113) | ○ |

### CustomType関連（UT-SRC-032〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-032 | カスタム属性が取得できること（GetCustomAttributes bool） | E-08 (L24-27) | ○ |
| UT-SRC-033 | 指定した型の属性のみが取得できること | E-08 (L29-32) | ○ |
| UT-SRC-034 | 属性が定義されている場合trueが返却されること（IsDefined） | E-08 (L34-37) | ○ |
| UT-SRC-035 | インスタンス型判定が正しく動作すること | E-08 (L39-43) | ○ |
| UT-SRC-036 | プロパティ一覧が取得できること | E-08 (L45-81) | ○ |
| UT-SRC-037 | DeclaredOnlyの場合は基底型の新規プロパティが含まれないこと | E-08 (L52, 64-78) | ○ |
| UT-SRC-038 | NonPublicまたはStaticの場合新規プロパティが含まれないこと | E-08 (L55-56) | ○ |
| UT-SRC-039 | 名前でプロパティが取得できること（GetPropertyImpl） | E-08 (L83-138) | ○ |
| UT-SRC-040 | IgnoreCaseで大文字小文字無視検索ができること | E-08 (L87, 111) | ○ |
| UT-SRC-041 | メソッド一覧が取得できること | E-08 (L140-180) | ○ |
| UT-SRC-042 | get_XXX形式でプロパティゲッターが取得できること | E-08 (L205) | ○ |
| UT-SRC-043 | set_XXX形式でプロパティセッターが取得できること | E-08 (L208) | ○ |

### VirtualPropertyInfo関連（UT-SRC-044〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-044 | VirtualPropertyInfoが正しく初期化されること | E-18 (L17-42) | ○ |
| UT-SRC-045 | getterとsetterの両方がnullの場合例外がスローされること | E-18 (L28-29) | ○ |
| UT-SRC-046 | propertyTypeが異なるコンテキストの場合例外がスローされること | E-18 (L31-33) | ○ |
| UT-SRC-047 | ゲッターが返却されること | E-18 (L44-49) | ○ |
| UT-SRC-048 | getterがnullの場合nullが返却されること | E-18 (L48) | ○ |
| UT-SRC-049 | セッターが返却されること | E-18 (L51-56) | ○ |
| UT-SRC-050 | setterがnullの場合nullが返却されること | E-18 (L55) | ○ |
| UT-SRC-051 | プロパティ属性が取得できること（GetCustomAttributes Type） | E-18 (L58-61) | ○ |
| UT-SRC-052 | 全属性が取得できること（GetCustomAttributes bool） | E-18 (L63-66) | ○ |
| UT-SRC-053 | 空のリストが返却されること（GetCustomAttributesData） | E-18 (L68-71) | ○ |
| UT-SRC-054 | 属性が定義されている場合trueが返却されること（IsDefined） | E-18 (L73-76) | ○ |
| UT-SRC-055 | プロパティ型と名前の文字列が返却されること（ToString） | E-18 (L78-82) | ○ |

### VirtualPropertyBase関連（UT-SRC-056〜077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-056 | PropertyAttributes.Noneが返却されること | E-19 (L37-39) | ○ |
| UT-SRC-057 | 宣言型が取得できること（DeclaringType） | E-19 (L41-45) | ○ |
| UT-SRC-058 | プロパティ名が取得できること（Name） | E-19 (L47-49) | ○ |
| UT-SRC-059 | プロパティ型が取得できること（PropertyType） | E-19 (L51-55) | ○ |
| UT-SRC-060 | ゲッターがある場合trueが返却されること（CanRead） | E-19 (L57-60) | ○ |
| UT-SRC-061 | セッターがある場合trueが返却されること（CanWrite） | E-19 (L62-65) | ○ |
| UT-SRC-062 | InvalidOperationExceptionがスローされること（MetadataToken） | E-19 (L67-69) | ○ |
| UT-SRC-063 | DeclaringType.Moduleが返却されること（Module） | E-19 (L71-75) | ○ |
| UT-SRC-064 | ゲッターとセッターの配列が返却されること（GetAccessors） | E-19 (L82-95) | ○ |
| UT-SRC-065 | 片方のみの場合は1要素の配列が返却されること | E-19 (L89-91) | ○ |
| UT-SRC-066 | インデックスパラメータが取得できること | E-19 (L97-100) | ○ |
| UT-SRC-067 | ゲッターが呼び出されて値が取得できること（GetValue） | E-19 (L102-109) | ○ |
| UT-SRC-068 | ゲッターがない場合ArgumentExceptionがスローされること | E-19 (L105-106) | ○ |
| UT-SRC-069 | セッターが呼び出されて値が設定できること（SetValue） | E-19 (L111-134) | ○ |
| UT-SRC-070 | セッターがない場合ArgumentExceptionがスローされること | E-19 (L114-115) | ○ |
| UT-SRC-071 | InvalidOperationExceptionがスローされること（GetConstantValue） | E-19 (L136-139) | ○ |
| UT-SRC-072 | InvalidOperationExceptionがスローされること（GetRawConstantValue） | E-19 (L141-144) | ○ |
| UT-SRC-073 | 空配列が返却されること（GetOptionalCustomModifiers） | E-19 (L146-149) | ○ |
| UT-SRC-074 | 空配列が返却されること（GetRequiredCustomModifiers） | E-19 (L151-154) | ○ |
| UT-SRC-075 | 同一プロパティの場合trueが返却されること（Equals） | E-19 (L176-185) | ○ |
| UT-SRC-076 | 異なるプロパティの場合falseが返却されること（Equals） | E-19 (L176-185) | ○ |
| UT-SRC-077 | ハッシュコードが計算されること（GetHashCode） | E-19 (L187-193) | ○ |

### InheritedPropertyInfo/InheritedMethodInfo関連（UT-SRC-078〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-078 | 継承プロパティが作成できること | E-28 (L15-26) | ○ |
| UT-SRC-079 | reflectedTypeが返却されること（ReflectedType） | E-28 (L28-34) | ○ |
| UT-SRC-080 | InheritedMethodInfoでラップされたゲッターが返却されること | E-28 (L36-43) | ○ |
| UT-SRC-081 | ゲッターがない場合nullが返却されること | E-28 (L38-39) | ○ |
| UT-SRC-082 | InheritedMethodInfoでラップされたセッターが返却されること | E-28 (L45-52) | ○ |
| UT-SRC-083 | 同一の場合trueが返却されること（Equals） | E-28 (L54-59) | ○ |
| UT-SRC-084 | ハッシュコードが計算されること（GetHashCode） | E-28 (L61-64) | ○ |
| UT-SRC-085 | 継承メソッドが作成できること | E-29 (L15-26) | ○ |
| UT-SRC-086 | reflectedTypeが返却されること（InheritedMethodInfo.ReflectedType） | E-29 (L28-34) | ○ |
| UT-SRC-087 | 同一の場合trueが返却されること（InheritedMethodInfo.Equals） | E-29 (L36-41) | ○ |
| UT-SRC-088 | ハッシュコードが計算されること（InheritedMethodInfo.GetHashCode） | E-29 (L43-46) | ○ |

### VirtualMethodBase関連（UT-SRC-089〜109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-089 | Public|HideBySigが返却されること（Attributes） | E-25 (L16-18) | ○ |
| UT-SRC-090 | HasThis|Standardが返却されること（CallingConvention） | E-25 (L20-23) | ○ |
| UT-SRC-091 | falseが返却されること（ContainsGenericParameters） | E-25 (L25-28) | ○ |
| UT-SRC-092 | falseが返却されること（IsGenericMethod） | E-25 (L30-33) | ○ |
| UT-SRC-093 | falseが返却されること（IsGenericMethodDefinition） | E-25 (L35-38) | ○ |
| UT-SRC-094 | NotSupportedExceptionがスローされること（MethodHandle） | E-25 (L40-43) | ○ |
| UT-SRC-095 | DeclaringType.Moduleが返却されること（Module） | E-25 (L45-48) | ○ |
| UT-SRC-096 | VirtualReturnParameterが返却されること（ReturnParameter） | E-25 (L56-59) | ○ |
| UT-SRC-097 | thisが返却されること（GetBaseDefinition） | E-25 (L66-69) | ○ |
| UT-SRC-098 | 空配列が返却されること（GetGenericArguments） | E-25 (L71-74) | ○ |
| UT-SRC-099 | InvalidOperationExceptionがスローされること（GetGenericMethodDefinition） | E-25 (L76-79) | ○ |
| UT-SRC-100 | MethodImplAttributes.ILが返却されること（GetMethodImplementationFlags） | E-25 (L81-84) | ○ |
| UT-SRC-101 | 空配列が返却されること（GetParameters） | E-25 (L86-89) | ○ |
| UT-SRC-102 | InvalidOperationExceptionがスローされること（MakeGenericMethod） | E-25 (L91-95) | ○ |
| UT-SRC-103 | 空配列が返却されること（GetCustomAttributes Type） | E-25 (L97-100) | ○ |
| UT-SRC-104 | 空配列が返却されること（GetCustomAttributes bool） | E-25 (L102-105) | ○ |
| UT-SRC-105 | 空リストが返却されること（GetCustomAttributesData） | E-25 (L107-110) | ○ |
| UT-SRC-106 | falseが返却されること（IsDefined） | E-25 (L112-115) | ○ |
| UT-SRC-107 | 同一メソッドの場合trueが返却されること（Equals） | E-25 (L117-125) | ○ |
| UT-SRC-108 | ハッシュコードが計算されること（GetHashCode） | E-25 (L127-132) | ○ |
| UT-SRC-109 | メソッドシグネチャ文字列が返却されること（ToString） | E-25 (L134-162) | ○ |

### VirtualParameter/VirtualReturnParameter関連（UT-SRC-110〜117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-110 | パラメータが正しく初期化されること | E-26 (L11-22) | ○ |
| UT-SRC-111 | memberがnullの場合ArgumentNullExceptionがスローされること | E-26 (L13) | ○ |
| UT-SRC-112 | parameterTypeがnullの場合ArgumentNullExceptionがスローされること | E-26 (L14) | ○ |
| UT-SRC-113 | パラメータ配列が複製されること（CloneParameters） | E-26 (L24-41) | ○ |
| UT-SRC-114 | skipLastParameterがtrueの場合最後のパラメータがスキップされること | E-26 (L27-30) | ○ |
| UT-SRC-115 | 同一パラメータの場合trueが返却されること（Equals） | E-26 (L43-50) | ○ |
| UT-SRC-116 | ハッシュコードが計算されること（GetHashCode） | E-26 (L52-57) | ○ |
| UT-SRC-117 | 戻りパラメータが作成されること（VirtualReturnParameter） | E-27 (L8-13) | ○ |

### PropertyGetter/PropertySetter関連（UT-SRC-118〜135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-118 | ゲッター関数が呼び出されて値が取得できること（PropertyGetter.Invoke） | E-20 (L27-38) | ○ |
| UT-SRC-119 | parametersが空でない場合TargetParameterCountExceptionがスローされること | E-20 (L31-32) | ○ |
| UT-SRC-120 | objが対象型のインスタンスでない場合ArgumentExceptionがスローされること | E-20 (L34-35) | ○ |
| UT-SRC-121 | 指定型の属性のみが返却されること（PropertyGetter.GetCustomAttributes Type） | E-20 (L40-43) | ○ |
| UT-SRC-122 | 全属性が返却されること（PropertyGetter.GetCustomAttributes bool） | E-20 (L45-48) | ○ |
| UT-SRC-123 | 空リストが返却されること（PropertyGetter.GetCustomAttributesData） | E-20 (L50-53) | ○ |
| UT-SRC-124 | 属性が定義されている場合trueが返却されること（PropertyGetter.IsDefined） | E-20 (L55-58) | ○ |
| UT-SRC-125 | valueパラメータを含む配列が返却されること（PropertySetter.GetParameters） | E-21 (L29-32) | ○ |
| UT-SRC-126 | セッター関数が呼び出されて値が設定できること（PropertySetter.Invoke） | E-21 (L34-55) | ○ |
| UT-SRC-127 | parametersが1要素でない場合TargetParameterCountExceptionがスローされること | E-21 (L38-39) | ○ |
| UT-SRC-128 | objがnullの場合TargetExceptionがスローされること | E-21 (L43-44) | ○ |
| UT-SRC-129 | objが対象型のインスタンスでない場合TargetExceptionがスローされること | E-21 (L46-47) | ○ |
| UT-SRC-130 | get_プレフィックス付きのプロパティ名が返却されること（PropertyGetterBase.Name） | E-22 (L15-17) | ○ |
| UT-SRC-131 | DeclaringProperty.PropertyTypeが返却されること（PropertyGetterBase.ReturnType） | E-22 (L19-22) | ○ |
| UT-SRC-132 | set_プレフィックス付きのプロパティ名が返却されること（PropertySetterBase.Name） | E-23 (L15-18) | ○ |
| UT-SRC-133 | voidが返却されること（PropertySetterBase.ReturnType） | E-23 (L20-23) | ○ |
| UT-SRC-134 | Public|HideBySig|SpecialNameが返却されること（FuncPropertyAccessorBase.Attributes） | E-24 (L24-27) | ○ |
| UT-SRC-135 | DeclaringProperty.DeclaringTypeが返却されること（FuncPropertyAccessorBase.DeclaringType） | E-24 (L29-32) | ○ |

### CollectionServices関連（UT-SRC-136〜143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-136 | 空配列が返却されること（Empty） | E-03 (L10-13) | ○ |
| UT-SRC-137 | 同一配列の場合trueが返却されること（CompareArrays） | E-03 (L15-27) | ○ |
| UT-SRC-138 | 異なる配列の場合falseが返却されること（CompareArrays） | E-03 (L22-23) | ○ |
| UT-SRC-139 | 長さが異なる場合falseが返却されること（CompareArrays） | E-03 (L17-18) | ○ |
| UT-SRC-140 | 配列要素のXORハッシュが返却されること（GetArrayHashCode） | E-03 (L29-36) | ○ |
| UT-SRC-141 | リストが型付き配列に変換されること（ConvertListToArray） | E-03 (L38-50) | ○ |
| UT-SRC-142 | arrayTypeがHasElementTypeの場合object[]が返却されること | E-03 (L41-42) | ○ |
| UT-SRC-143 | IEnumerableが型付き配列に変換されること（IEnumerableToArray） | E-03 (L52-57) | ○ |

### AttributeUtils関連（UT-SRC-144〜156）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-144 | 型のカスタム属性が取得できること | E-17 (L11-49) | ○ |
| UT-SRC-145 | inherit=trueの場合基底型の属性も含まれること | E-17 (L18-48) | ○ |
| UT-SRC-146 | メソッドのカスタム属性が取得できること | E-17 (L51-89) | ○ |
| UT-SRC-147 | inherit=trueの場合オーバーライド元の属性も含まれること | E-17 (L55-88) | ○ |
| UT-SRC-148 | コンストラクタのカスタム属性が取得できること | E-17 (L91-97) | ○ |
| UT-SRC-149 | プロパティのカスタム属性が取得できること | E-17 (L99-105) | ○ |
| UT-SRC-150 | イベントのカスタム属性が取得できること | E-17 (L107-113) | ○ |
| UT-SRC-151 | フィールドのカスタム属性が取得できること | E-17 (L115-121) | ○ |
| UT-SRC-152 | パラメータのカスタム属性が取得できること | E-17 (L123-129) | ○ |
| UT-SRC-153 | 属性が定義されている場合trueが返却されること（IsDefined） | E-17 (L131-135) | ○ |
| UT-SRC-154 | 属性が定義されていない場合falseが返却されること（IsDefined） | E-17 (L131-135) | ○ |
| UT-SRC-155 | 指定型の属性のみがフィルタされること（FilterCustomAttributes） | E-17 (L197-207) | ○ |
| UT-SRC-156 | null属性がある場合InvalidOperationExceptionがスローされること | E-17 (L201-202) | ○ |

### ProjectingType/ProjectingAssembly/ProjectingModule関連（UT-SRC-157〜202）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-157〜185 | ProjectingType各メソッドの動作 | E-05 | ○ |
| UT-SRC-186〜192 | ProjectingAssembly各メソッドの動作 | E-06 | ○ |
| UT-SRC-193〜202 | ProjectingModule各メソッドの動作 | E-07 | ○ |

### Customクラス/Delegatingクラス関連（UT-SRC-203〜221）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-203 | CustomAssemblyが正しく初期化されること | E-09 | ○ |
| UT-SRC-204 | CustomModuleが正しく初期化されること | E-10 | ○ |
| UT-SRC-205〜207 | CustomMethodInfoの動作 | E-11 | ○ |
| UT-SRC-208〜209 | CustomPropertyInfoの動作 | E-12 | ○ |
| UT-SRC-210 | CustomConstructorInfoの動作 | E-13 | ○ |
| UT-SRC-211 | CustomFieldInfoの動作 | E-14 | ○ |
| UT-SRC-212 | CustomEventInfoの動作 | E-15 | ○ |
| UT-SRC-213 | CustomParameterInfoの動作 | E-16 | ○ |
| UT-SRC-214〜217 | DelegatingTypeの動作 | E-30 | ○ |
| UT-SRC-218〜219 | DelegatingMethodInfoの動作 | E-31 | ○ |
| UT-SRC-220〜221 | DelegatingPropertyInfoの動作 | E-32 | ○ |

### ReflectionContextProjector関連（UT-SRC-222〜254）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-SRC-222〜254 | ReflectionContextProjectorの各プロジェクションメソッド | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

すべてのテストケースはソースコードに基づいて生成されており、根拠が存在します。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべてのテストケースがソースコードから直接導出されており、実装との整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースID（UT-SRC-XXX）が連番で重複がないことを確認
- [ ] 高優先度テストケース（CustomReflectionContext, VirtualPropertyInfo/Base, ReflectionContextProjector関連）の入力値と期待結果が妥当であることを確認
- [ ] 異常系テストケースで例外の種類が正しいことを確認
- [ ] 境界値テストケース（null、空配列、空リスト）が網羅されていることを確認
- [ ] モジュール内の主要クラス（55ファイル中のsrcファイル）がテストケースでカバーされていることを確認
