---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 74
  claims_with_evidence: 71
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：libraries-System.Reflection.DispatchProxy 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：71 / 74、根拠なし：3
- 優先レビュー（高）
  1. **UT-DPX-063〜066 (IL生成詳細)**: 内部IL生成ロジックの詳細動作は外部から検証困難
  2. **UT-DPX-073 (多数パラメータ)**: 具体的なパラメータ数上限の根拠なし
  3. **UT-DPX-074 (required modifier)**: modreqの保持に関する明示的テストなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Reflection.DispatchProxy/src/System/Reflection/DispatchProxy.cs` - DispatchProxyクラス本体
- E-02: `src/libraries/System.Reflection.DispatchProxy/src/System/Reflection/DispatchProxyGenerator.cs` - プロキシ生成ロジック
- E-03: `src/libraries/System.Reflection.DispatchProxy/tests/DispatchProxyTests.cs` - 既存単体テスト
- E-04: `src/libraries/System.Reflection.DispatchProxy/tests/TestTypes.cs` - テスト用型定義
- E-05: `src/libraries/System.Reflection.DispatchProxy/ref/System.Reflection.DispatchProxy.cs` - APIリファレンス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-DPX-001) | インターフェース型に対するプロキシが生成されること | E-01 (L40-44), E-03 (L21-27) | ○ |
| C-02 (UT-DPX-002) | 生成されたプロキシがTProxyを継承していること | E-02 (L199-200), E-03 (L26) | ○ |
| C-03 (UT-DPX-003) | 生成されたプロキシがインターフェースTを実装していること | E-02 (L206), E-03 (L32-41) | ○ |
| C-04 (UT-DPX-004) | 複数のインターフェースを継承するインターフェースでプロキシが生成されること | E-02 (L202-206), E-03 (L32-41) | ○ |
| C-05 (UT-DPX-005) | internalインターフェースに対するプロキシが生成されること | E-02 (L239-249), E-03 (L47-51) | ○ |
| C-06 (UT-DPX-006) | 同一のT/TProxyペアに対して同一の生成型が再利用されること | E-02 (L149-164), E-03 (L80-88) | ○ |
| C-07 (UT-DPX-007) | 同一のT/TProxyペアに対して異なるインスタンスが生成されること | E-02 (L76), E-03 (L93-102) | ○ |
| C-08 (UT-DPX-008) | 異なるTProxyに対して異なる生成型が使用されること | E-02 (L98-108), E-03 (L108-117) | ○ |
| C-09 (UT-DPX-009) | 異なるTに対して異なる生成型が使用されること | E-02 (L98-108), E-03 (L122-131) | ○ |
| C-10 (UT-DPX-010) | Tがクラス型の場合ArgumentExceptionがスローされること | E-02 (L176-179), E-03 (L136-139) | ○ |
| C-11 (UT-DPX-011) | TProxyがsealedクラスの場合ArgumentExceptionがスローされること | E-02 (L182-185), E-03 (L144-147) | ○ |
| C-12 (UT-DPX-012) | TProxyがabstractクラスの場合ArgumentExceptionがスローされること | E-02 (L188-191), E-03 (L152-155) | ○ |
| C-13 (UT-DPX-013) | TProxyにパラメータなしコンストラクタがない場合ArgumentExceptionがスローされること | E-02 (L194-197), E-03 (L174-177) | ○ |
| C-14 (UT-DPX-014) | 非ジェネリック版でプロキシが生成されること | E-01 (L57-69), E-03 (L866-874) | ○ |
| C-15 (UT-DPX-015) | interfaceTypeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L60), E-03 (L180-183) | ○ |
| C-16 (UT-DPX-016) | proxyTypeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L61), E-03 (L186-189) | ○ |
| C-17 (UT-DPX-017) | proxyTypeがDispatchProxyを継承していない場合ArgumentExceptionがスローされること | E-01 (L63-66), E-03 (L192-195) | ○ |
| C-18 (UT-DPX-018) | interfaceTypeがクラス型の場合ArgumentExceptionがスローされること | E-02 (L176-179), E-03 (L136-139) | ○ |
| C-19 (UT-DPX-019) | プロキシメソッド呼び出し時にInvokeが呼び出されること | E-02 (L513), E-03 (L266-312) | ○ |
| C-20 (UT-DPX-020) | Invokeに正しいMethodInfoが渡されること | E-02 (L478-504), E-03 (L314-332) | ○ |
| C-21 (UT-DPX-021) | Invokeに正しい引数配列が渡されること | E-02 (L459-476), E-03 (L337-360) | ○ |
| C-22 (UT-DPX-022) | Invokeの戻り値がプロキシメソッドの戻り値として返されること | E-02 (L535-540), E-03 (L365-376) | ○ |
| C-23 (UT-DPX-023) | 複数パラメータを持つメソッドで正しい引数が渡されること | E-03 (L381-405) | ○ |
| C-24 (UT-DPX-024) | paramsパラメータを持つメソッドで正しい引数が渡されること | E-03 (L410-441) | ○ |
| C-25 (UT-DPX-025) | void戻りのメソッドでnullを返してもエラーにならないこと | E-02 (L519-523), E-03 (L446-461) | ○ |
| C-26 (UT-DPX-026) | 同名メソッドを持つ複数インターフェースで正しいMethodInfoが渡されること | E-03 (L466-487) | ○ |
| C-27 (UT-DPX-027) | Invoke内でスローされた例外が呼び出し元に伝播すること | E-03 (L492-513) | ○ |
| C-28 (UT-DPX-028) | プロパティのgetterが正しく呼び出されること | E-02 (L373-388), E-03 (L518-547) | ○ |
| C-29 (UT-DPX-029) | プロパティのsetterが正しく呼び出されること | E-02 (L373-388), E-03 (L518-547) | ○ |
| C-30 (UT-DPX-030) | インデクサのgetterが正しく呼び出されること | E-02 (L373-388), E-03 (L673-701) | ○ |
| C-31 (UT-DPX-031) | インデクサのsetterが正しく呼び出されること | E-02 (L373-388), E-03 (L673-701) | ○ |
| C-32 (UT-DPX-032) | イベントのaddが正しく呼び出されること | E-02 (L390-408), E-03 (L594-658) | ○ |
| C-33 (UT-DPX-033) | イベントのremoveが正しく呼び出されること | E-02 (L390-408), E-03 (L594-658) | ○ |
| C-34 (UT-DPX-034) | ジェネリックメソッドが正しく呼び出されること | E-02 (L486-504), E-03 (L713-741) | ○ |
| C-35 (UT-DPX-035) | ジェネリックメソッドでIsGenericMethodがtrueであること | E-03 (L718) | ○ |
| C-36 (UT-DPX-036) | ジェネリックメソッドで型引数が正しく解決されること | E-03 (L721-722) | ○ |
| C-37 (UT-DPX-037) | refパラメータが正しく処理されること | E-02 (L525-533), E-03 (L746-757) | ○ |
| C-38 (UT-DPX-038) | outパラメータが正しく処理されること | E-02 (L468-475), E-03 (L753) | ○ |
| C-39 (UT-DPX-039) | inパラメータが正しく処理されること | E-03 (L756) | ○ |
| C-40 (UT-DPX-040) | static virtualメソッドがプロキシで宣言されること | E-02 (L447-457), E-03 (L574-580) | ○ |
| C-41 (UT-DPX-041) | static virtualメソッドの呼び出しでNotSupportedExceptionがスローされること | E-02 (L449-456), E-03 (L585-591) | ○ |
| C-42 (UT-DPX-042) | AssemblyLoadContextごとに異なるProxyAssemblyが生成されること | E-02 (L50, L74), E-03 (L810-845) | ○ |
| C-43 (UT-DPX-043) | Collectible ALCでプロキシが正しく生成されること | E-02 (L132-134) | ○ |
| C-44 (UT-DPX-044) | ALCのアンロード時にプロキシ型もアンロードされること | E-02 (L132-134), E-03 (L779-808) | ○ |
| C-45 (UT-DPX-045) | 同一のbaseType/interfaceTypeペアに対してキャッシュが機能すること | E-02 (L149-164) | ○ |
| C-46 (UT-DPX-046) | interfaceTypeがインターフェースでない場合ArgumentExceptionがスローされること | E-02 (L176-179) | ○ |
| C-47 (UT-DPX-047) | baseTypeがsealedの場合ArgumentExceptionがスローされること | E-02 (L182-185) | ○ |
| C-48 (UT-DPX-048) | baseTypeがabstractの場合ArgumentExceptionがスローされること | E-02 (L188-191) | ○ |
| C-49 (UT-DPX-049) | baseTypeにデフォルトコンストラクタがない場合ArgumentExceptionがスローされること | E-02 (L194-197) | ○ |
| C-50 (UT-DPX-050) | 非publicな型に対してIgnoresAccessChecksToAttributeが生成されること | E-02 (L223-249), E-03 (L56-75) | ○ |
| C-51 (UT-DPX-051) | インターフェースのメソッドがプロキシに実装されること | E-02 (L344-371) | ○ |
| C-52 (UT-DPX-052) | インターフェースのプロパティがプロキシに宣言されること | E-02 (L373-388), E-03 (L553-558) | ○ |
| C-53 (UT-DPX-053) | インターフェースのイベントがプロキシに宣言されること | E-02 (L390-408), E-03 (L663-668) | ○ |
| C-54 (UT-DPX-054) | 非virtualメソッドがスキップされること | E-02 (L348-349) | ○ |
| C-55 (UT-DPX-055) | 生成されたメソッドがpublic virtualであること | E-02 (L423-425) | ○ |
| C-56 (UT-DPX-056) | 生成されたメソッドが正しいシグネチャを持つこと | E-02 (L413-429) | ○ |
| C-57 (UT-DPX-057) | 生成されたメソッドがインターフェースメソッドをオーバーライドすること | E-02 (L544) | ○ |
| C-58 (UT-DPX-058) | 生成されたコンストラクタがMethodInfo[]を受け取ること | E-02 (L280-286) | ○ |
| C-59 (UT-DPX-059) | 生成されたコンストラクタが基底クラスのコンストラクタを呼び出すこと | E-02 (L289-294) | ○ |
| C-60 (UT-DPX-060) | 値型からobjectへのボックス化が正しく行われること | E-02 (L648-653) | ○ |
| C-61 (UT-DPX-061) | objectから値型へのアンボックス化が正しく行われること | E-02 (L630-644) | ○ |
| C-62 (UT-DPX-062) | 参照型間のキャストが正しく行われること | E-02 (L655-666) | ○ |
| C-63 (UT-DPX-063) | 指定されたサイズの配列が生成されること | E-02 (L728-736) | ○ |
| C-64 (UT-DPX-064) | 配列要素への設定が正しく行われること | E-02 (L750-760) | ○ |
| C-65 (UT-DPX-065) | 指定されたインデックスのパラメータが取得されること | E-02 (L705-708) | ○ |
| C-66 (UT-DPX-066) | ByRef型パラメータへの値設定が正しく行われること | E-02 (L715-721) | ○ |
| C-67 (UT-DPX-067) | privateなTProxyでプロキシが生成されること | E-03 (L198-207) | ○ |
| C-68 (UT-DPX-068) | 外部アセンブリのnon-publicインターフェースでプロキシが生成されること | E-03 (L226-229) | ○ |
| C-69 (UT-DPX-069) | GeneratedTypeとMethodInfosが正しく設定されること | E-02 (L79-92) | ○ |
| C-70 (UT-DPX-070) | getter/setterのMethodInfoが保持されること | E-02 (L763-775) | ○ |
| C-71 (UT-DPX-071) | add/remove/raiseのMethodInfoが保持されること | E-02 (L777-792) | ○ |
| C-72 (UT-DPX-072) | 引数なしのメソッドでargs配列が空であること | E-02 (L463), E-03 (L446-461) | ○ |
| C-73 (UT-DPX-073) | 多数のパラメータを持つメソッドで全引数が渡されること | **根拠なし** | △ |
| C-74 (UT-DPX-074) | required custom modifiersが保持されること | E-02 (L420) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-DPX-073**: 多数パラメータの境界値テストは既存テストに含まれていない。実装上の制限はCLRの制限に依存する。
  - 候補: CLRドキュメント / 実際のパフォーマンステスト
- **UT-DPX-074**: required custom modifiersの保持についてはコード上で処理されているが（L420）、明示的なテストケースが既存テストに存在しない。
  - 候補: Reflection.Emitのテスト / カスタム修飾子を持つインターフェースのテスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースは既存テストおよびソースコードで十分に裏付けられている
- **1 (中リスク)**: IL生成詳細（UT-DPX-060〜066）は内部実装の詳細であり、外部からの検証が難しい
- **0 (低リスク)**: API公開部分のテストケースは既存テストで網羅されている

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-DPX-XXX）が一貫しているか確認
- [ ] 正常系/異常系/境界値のバランスを確認
- [ ] 高優先度のテストケースが重要な機能をカバーしているか確認
- [ ] 根拠なし（△）のテストケースが本当に必要かレビュー
- [ ] 既存テスト（E-03）との重複・差異を確認
- [ ] static virtualメソッド関連のテスト（.NET 7+機能）が適切か確認
