---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 108
  claims_with_evidence: 108
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Reflection.Emit.ILGeneration 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコード・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：108 / 108、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースは既存のテストコードおよびAPIリファレンスに基づいて作成されています
  2. 特に優先的にレビューが必要な項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

### APIリファレンス
- E-01: `src/libraries/System.Reflection.Emit.ILGeneration/ref/System.Reflection.Emit.ILGeneration.cs` - 公開API定義
- E-02: `System.Reflection.Emit.CustomAttributeBuilder` クラス定義
- E-03: `System.Reflection.Emit.ILGenerator` クラス定義
- E-04: `System.Reflection.Emit.Label` 構造体定義
- E-05: `System.Reflection.Emit.LocalBuilder` クラス定義
- E-06: `System.Reflection.Emit.ParameterBuilder` クラス定義
- E-07: `System.Reflection.Emit.SignatureHelper` クラス定義

### 既存テストコード
- E-10: `tests/CustomAttributeBuilderTests.cs` - CustomAttributeBuilderのテスト
- E-11: `tests/ILGenerator/Emit1Tests.cs` - ILGenerator Emit(MethodInfo)のテスト
- E-12: `tests/ILGenerator/Emit2Tests.cs` - ILGenerator Emit(LocalBuilder)のテスト
- E-13: `tests/ILGenerator/Emit3Tests.cs` - ILGenerator Emit複合テスト
- E-14: `tests/ILGenerator/Emit4Tests.cs` - ILGenerator EmitCalliのテスト
- E-15: `tests/ILGenerator/Emit5Tests.cs` - ILGenerator MaxStackテスト
- E-16: `tests/ILGenerator/DeclareLocalTests.cs` - DeclareLocalのテスト
- E-17: `tests/ILGenerator/DefineLabelTests.cs` - DefineLabelのテスト
- E-18: `tests/ILGenerator/ExceptionEmitTests.cs` - 例外ブロックのテスト
- E-19: `tests/ILGenerator/ILOffsetTests.cs` - ILOffsetのテスト
- E-20: `tests/ILGenerator/EmitWriteLineTests.cs` - EmitWriteLineのテスト
- E-21: `tests/ILGenerator/EmitMethodInfo.cs` - Emit(MethodInfo)のテスト
- E-22: `tests/ILGenerator/EmitWithModsTests.cs` - 修飾子付きEmitのテスト
- E-23: `tests/Label/LabelEquals.cs` - Label Equalsのテスト
- E-24: `tests/Label/LabelGetHashCode.cs` - Label GetHashCodeのテスト
- E-25: `tests/Label/LabelId.cs` - Label Idのテスト
- E-26: `tests/LocalBuilder/LocalBuilderLocalType.cs` - LocalBuilder LocalTypeのテスト
- E-27: `tests/LocalBuilder/LocalBuilderLocalIndex.cs` - LocalBuilder LocalIndexのテスト
- E-28: `tests/LocalBuilder/LocalBuilderIsPinned.cs` - LocalBuilder IsPinnedのテスト
- E-29: `tests/ParameterBuilder/PropertyTests.cs` - ParameterBuilderプロパティのテスト
- E-30: `tests/ParameterBuilder/SetConstant.cs` - SetConstantのテスト
- E-31: `tests/ParameterBuilder/SetCustomAttributeTests.cs` - SetCustomAttributeのテスト
- E-32: `tests/SignatureHelper/SignatureHelperGetMethodSigHelper.cs` - GetMethodSigHelperのテスト
- E-33: `tests/SignatureHelper/SignatureHelperAddArgument.cs` - AddArgumentのテスト
- E-34: `tests/SignatureHelper/SignatureHelperAddArguments.cs` - AddArgumentsのテスト
- E-35: `tests/SignatureHelper/SignatureHelperEquals.cs` - SignatureHelper Equalsのテスト
- E-36: `tests/SignatureHelper/SignatureHelperGetFieldSigHelper.cs` - GetFieldSigHelperのテスト
- E-37: `tests/SignatureHelper/SignatureHelperGetLocalVarSigHelper.cs` - GetLocalVarSigHelperのテスト
- E-38: `tests/SignatureHelper/SignatureHelperGetPropertySigHelper.cs` - GetPropertySigHelperのテスト
- E-39: `tests/SignatureHelper/SignatureHelperGetSignature.cs` - GetSignatureのテスト
- E-40: `tests/SignatureHelper/SignatureHelperToString.cs` - ToStringのテスト
- E-41: `tests/Utilities.cs` - テストユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）

### CustomAttributeBuilder (UT-ILG-001 - UT-ILG-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-ILG-001: コンストラクタ引数のみでCustomAttributeBuilderが作成できる | E-01, E-10 | ○ |
| C-02 | UT-ILG-002: フィールド指定でCustomAttributeBuilderが作成できる | E-01, E-10 | ○ |
| C-03 | UT-ILG-003: プロパティ指定でCustomAttributeBuilderが作成できる | E-01, E-10 | ○ |
| C-04 | UT-ILG-004: 全パラメータ指定でCustomAttributeBuilderが作成できる | E-01, E-10 | ○ |
| C-05 | UT-ILG-005: nullコンストラクタでArgumentNullException | E-10 (NullConstructor_ThrowsArgumentNullException) | ○ |
| C-06 | UT-ILG-006: 静的コンストラクタでArgumentException | E-10 (StaticConstructor_ThrowsArgumentException) | ○ |
| C-07 | UT-ILG-007: プライベートコンストラクタでArgumentException | E-10 (PrivateConstructor_ThrowsArgumentException) | ○ |
| C-08 | UT-ILG-008: nullコンストラクタ引数でArgumentNullException | E-10 (NullConstructorArgs_ThrowsArgumentNullException) | ○ |
| C-09 | UT-ILG-009: コンストラクタと引数の不一致でArgumentException | E-10 (ConstructorAndConstructorArgsDontMatch_ThrowsArgumentException) | ○ |
| C-10 | UT-ILG-010: サポートされないオブジェクト型でArgumentException | E-10 (NotSupportedObjectInConstructorArgs_ThrowsArgumentException) | ○ |
| C-11 | UT-ILG-011: nullフィールド配列でArgumentNullException | E-10 (NullNamedFields_ThrowsArgumentNullException) | ○ |
| C-12 | UT-ILG-012: nullプロパティ配列でArgumentNullException | E-10 (NullNamedProperties_ThrowsArgumentNullException) | ○ |
| C-13 | UT-ILG-013: 全プリミティブ型が正しく処理される | E-10 (Ctor_AllPrimitives) | ○ |
| C-14 | UT-ILG-014: 長い文字列値が正しく処理される | E-10 (Ctor_TestData - longString) | ○ |

### ILGenerator - 基本操作 (UT-ILG-015 - UT-ILG-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | UT-ILG-015: 何も出力されていない場合ILOffset=0 | E-19 (ILOffset_NothingEmitted_ReturnsZero) | ○ |
| C-16 | UT-ILG-016: IL命令出力後にILOffset>0 | E-19 (ILOffset_SomethingEmitted_ReturnsNonZero) | ○ |
| C-17 | UT-ILG-017: ローカル変数が正しく宣言できる | E-16 (Basic) | ○ |
| C-18 | UT-ILG-018: 複数型でローカル変数が宣言できる | E-16 (TestData) | ○ |
| C-19 | UT-ILG-019: ピン留めローカル変数が宣言できる | E-16 (DeclareLocal_Pinned) | ○ |
| C-20 | UT-ILG-020: null型でArgumentNullException | E-16 (DeclareLocal_NullLocalType_ThrowsArgumentNullException) | ○ |
| C-21 | UT-ILG-021: 型作成後にInvalidOperationException | E-16 (DeclareLocal_TypeCreated_ThrowsInvalidOperationException) | ○ |
| C-22 | UT-ILG-022: ラベルが定義できる | E-17 (DefineLabel_DoesNotThrow) | ○ |
| C-23 | UT-ILG-023: 複数ラベルが連続して定義できる | E-17 (DefineLabel_DoesNotThrow - 17回呼び出し) | ○ |
| C-24 | UT-ILG-024: ラベルがマークできる | E-13 (PosTest1 - MarkLabel呼び出し) | ○ |
| C-25 | UT-ILG-025: 単純なOpCodeが出力できる | E-11, E-12, E-13 (複数のEmitテスト) | ○ |

### ILGenerator - Emit各種 (UT-ILG-026 - UT-ILG-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | UT-ILG-026: 整数引数付きOpCodeが出力できる | E-13 (PosTest1 - Ldc_I4) | ○ |
| C-27 | UT-ILG-027: long引数付きOpCodeが出力できる | E-11 (PosTest4 - Ldc_I8) | ○ |
| C-28 | UT-ILG-028: double引数付きOpCodeが出力できる | E-13 (PosTest1 - Ldc_R8) | ○ |
| C-29 | UT-ILG-029: 文字列引数付きOpCodeが出力できる | E-03 (Emit(OpCode, string)定義) | ○ |
| C-30 | UT-ILG-030: メソッド情報付きOpCodeが出力できる | E-11 (PosTest1-5) | ○ |
| C-31 | UT-ILG-031: nullメソッドでArgumentNullException | E-11 (Emit_OpCodes_MethodInfo_NullMethod_ThrowsArgumentNullException) | ○ |
| C-32 | UT-ILG-032: ローカル変数付きOpCodeが出力できる | E-12, E-13 (複数のLocalBuilderテスト) | ○ |
| C-33 | UT-ILG-033: nullローカルでArgumentNullException | E-12 (Emit_OpCodes_LocalBuilder_NullLocal_ThrowsArgumentNullException) | ○ |
| C-34 | UT-ILG-034: 別メソッドのローカルでArgumentException | E-12 (Emit_OpCodes_LocalBuilder_LocalFromDifferentMethod_ThrowsArgumentException) | ○ |
| C-35 | UT-ILG-035: ローカル数超過でInvalidOperationException | E-12 (Emit_OpCodes_LocalBuilder_TooManyLocals_ThrowsInvalidOperationException) | ○ |
| C-36 | UT-ILG-036: ラベル付きOpCodeが出力できる | E-13 (PosTest1 - Brtrue_S, Br_S) | ○ |
| C-37 | UT-ILG-037: ラベル配列付きOpCodeが出力できる | E-03 (Emit(OpCode, Label[])定義) | ○ |
| C-38 | UT-ILG-038: 型情報付きOpCodeが出力できる | E-11 (Newobj呼び出し) | ○ |
| C-39 | UT-ILG-039: コンストラクタ情報付きOpCodeが出力できる | E-11 (Newobj with GetConstructor) | ○ |
| C-40 | UT-ILG-040: フィールド情報付きOpCodeが出力できる | E-20 (EmitWriteLineTests - createdField) | ○ |
| C-41 | UT-ILG-041: EmitCallが出力できる | E-22 (EmitWithModsTests) | ○ |
| C-42 | UT-ILG-042: アンマネージドcalliが出力できる | E-14 (TestEmitCalliBlittable) | ○ |
| C-43 | UT-ILG-043: マネージドcalliが出力できる | E-14 (TestEmitCalliManagedBlittable) | ○ |
| C-44 | UT-ILG-044: 例外ブロックが開始できる | E-18 (TestExceptionEmitCalls) | ○ |
| C-45 | UT-ILG-045: catchブロックが開始できる | E-18 (TestExceptionEmitCalls) | ○ |
| C-46 | UT-ILG-046: finallyブロックが開始できる | E-12 (PosTest5 - BeginFinallyBlock) | ○ |
| C-47 | UT-ILG-047: faultブロックが開始できる | E-12 (PosTest6 - BeginFaultBlock) | ○ |
| C-48 | UT-ILG-048: 例外フィルタブロックが開始できる | E-03 (BeginExceptFilterBlock定義) | ○ |
| C-49 | UT-ILG-049: 例外ブロックが終了できる | E-18 (TestExceptionEmitCalls) | ○ |
| C-50 | UT-ILG-050: スコープが開始できる | E-12 (PosTest2 - BeginScope) | ○ |
| C-51 | UT-ILG-051: スコープが終了できる | E-03 (EndScope定義) | ○ |
| C-52 | UT-ILG-052: 例外スローコードが出力できる | E-18 (TestExceptionEmitCalls - ThrowException) | ○ |
| C-53 | UT-ILG-053: 文字列EmitWriteLineが出力できる | E-20 (EmitWriteLineTests) | ○ |
| C-54 | UT-ILG-054: ローカルEmitWriteLineが出力できる | E-20 (EmitWriteLineTests) | ○ |
| C-55 | UT-ILG-055: フィールドEmitWriteLineが出力できる | E-20 (EmitWriteLineTests) | ○ |
| C-56 | UT-ILG-056: UsingNamespaceが指定できる | E-03 (UsingNamespace定義) | ○ |

### Label (UT-ILG-057 - UT-ILG-065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | UT-ILG-057: 同一ラベルでEquals=true | E-23 (Equals_SameInstance_ReturnsTrue) | ○ |
| C-58 | UT-ILG-058: 異なるラベルでEquals=false | E-23 (Equals_DifferentLabel_ReturnsFalse) | ○ |
| C-59 | UT-ILG-059: 非Labelオブジェクトでfalse | E-23 (Equals_ObjectNotLabel_ReturnsFalse) | ○ |
| C-60 | UT-ILG-060: 等価演算子が正しく動作 | E-23 (Equals_EqualityOperators) | ○ |
| C-61 | UT-ILG-061: 非等価演算子が正しく動作 | E-23 (Equals_EqualityOperators) | ○ |
| C-62 | UT-ILG-062: 新規インスタンスでGetHashCode=0 | E-24 (GetHashCode_NewInstance_ReturnsZero) | ○ |
| C-63 | UT-ILG-063: ILGenerator作成ラベルでGetHashCode=インデックス | E-24 (GetHashCode_CreatedByILGenerator_ReturnsIndex) | ○ |
| C-64 | UT-ILG-064: デフォルトコンストラクタでId=0 | E-25 (LabelId_DefaultConstuctor_ReturnsZero) | ○ |
| C-65 | UT-ILG-065: ILGenerator作成ラベルでId=連番 | E-25 (LabelId_CreatedByILGenerator_ReturnsId) | ○ |

### LocalBuilder (UT-ILG-066 - UT-ILG-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | UT-ILG-066: LocalTypeが宣言した型を返却 | E-26 (LocalType) | ○ |
| C-67 | UT-ILG-067: 最初のLocalIndexが0 | E-27 (LocalIndex_FirstLocal_ReturnsZero) | ○ |
| C-68 | UT-ILG-068: 複数ローカルでインデックスが正しい | E-27 (LocalIndex_MultipleLocals_ReturnsIndex) | ○ |
| C-69 | UT-ILG-069: IsPinnedがtrueを返却 | E-28 (IsPinned - true) | ○ |
| C-70 | UT-ILG-070: IsPinnedがfalseを返却 | E-28 (IsPinned - false) | ○ |

### ParameterBuilder (UT-ILG-071 - UT-ILG-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | UT-ILG-071: Attributesが設定値を返却 | E-29 (Properties) | ○ |
| C-72 | UT-ILG-072: IsInがtrueを返却 | E-29 (Properties) | ○ |
| C-73 | UT-ILG-073: IsOutがtrueを返却 | E-06 (IsOut定義) | ○ |
| C-74 | UT-ILG-074: IsOptionalがtrueを返却 | E-06 (IsOptional定義) | ○ |
| C-75 | UT-ILG-075: Nameが設定値を返却 | E-29 (Properties) | ○ |
| C-76 | UT-ILG-076: Positionが設定値を返却 | E-29 (Properties) | ○ |
| C-77 | UT-ILG-077: SetConstantが動作する | E-30 (NullableValueType_DoesNotThrow) | ○ |
| C-78 | UT-ILG-078: SetCustomAttribute(builder)が動作する | E-31 (SetCustomAttribute_CustomAttributeBuilder) | ○ |
| C-79 | UT-ILG-079: SetCustomAttribute(bytes)が動作する | E-31 (SetCustomAttribute_ConstructorInfo_ByteArray) | ○ |
| C-80 | UT-ILG-080: SetCustomAttributeのnull検証 | E-31 (SetCustomAttribute_NullArgument_ThrowsArgumentNullException) | ○ |

### SignatureHelper (UT-ILG-081 - UT-ILG-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | UT-ILG-081: GetFieldSigHelperが取得できる | E-36 (GetFieldSigHelper_Length_ReturnsOne) | ○ |
| C-82 | UT-ILG-082: GetLocalVarSigHelper()が取得できる | E-37 (GetLocalVarSigHelper_Length_ReturnsTwo) | ○ |
| C-83 | UT-ILG-083: GetLocalVarSigHelper(Module)が取得できる | E-37 (GetLocalVarSigHelper_Module_Length_ReturnsTwo) | ○ |
| C-84 | UT-ILG-084: GetMethodSigHelper基本が取得できる | E-32 (GetMethodSigHelper_CallingConventions_Type_Length_ReturnsThree) | ○ |
| C-85 | UT-ILG-085: GetMethodSigHelper(Module)が取得できる | E-32 (GetMethodSigHelper_Module_CallingConventions_Type_Length_ReturnsThree) | ○ |
| C-86 | UT-ILG-086: GetMethodSigHelper(params)が取得できる | E-32 (GetMethodSigHelper_Module_Type_TypeArray) | ○ |
| C-87 | UT-ILG-087: GetMethodSigHelperのnullパラメータ検証 | E-32 (GetMethodSigHelper_Module_Type_TypeArray_NullObjectInParameterType_ThrowsArgumentNullException) | ○ |
| C-88 | UT-ILG-088: GetPropertySigHelper基本が取得できる | E-38 (GetPropertySigHelper_Module_Type_TypeArray) | ○ |
| C-89 | UT-ILG-089: GetPropertySigHelperのnullパラメータ検証 | E-38 (GetPropertySigHelper_Module_Type_TypeArray_NullObjectInParameterTypes_ThrowsArgumentNullException) | ○ |
| C-90 | UT-ILG-090: AddArgument基本が動作する | E-33 (AddArgument_Type) | ○ |
| C-91 | UT-ILG-091: AddArgument pinnedが動作する | E-33 (AddArgument_Type_Bool) | ○ |
| C-92 | UT-ILG-092: AddArgument with modsが動作する | E-33 (AddArgument_Type_TypeArray_TypeArray) | ○ |
| C-93 | UT-ILG-093: AddArgumentのnull検証 | E-33 (AddArgument_NullType_ThrowsArgumentNullException) | ○ |
| C-94 | UT-ILG-094: AddArgument完了後のArgumentException | E-33 (AddArgument_SignatureFinished_ThrowsArgumentException) | ○ |
| C-95 | UT-ILG-095: AddArguments基本が動作する | E-34 (AddArguments) | ○ |
| C-96 | UT-ILG-096: AddArgumentsのnull type検証 | E-34 (AddArguments_NullObjectInTypeArguments_ThrowsArgumentNullException) | ○ |
| C-97 | UT-ILG-097: AddArguments完了後のArgumentException | E-34 (AddArguments_SignatureFinished_ThrowsArgumentException) | ○ |
| C-98 | UT-ILG-098: AddSentinelが動作する | E-07 (AddSentinel定義) | ○ |
| C-99 | UT-ILG-099: GetSignatureが動作する | E-39 (GetSignature_Length_ReturnsOne) | ○ |
| C-100 | UT-ILG-100: Equals同一シグネチャでtrue | E-35 (Equals_TestData) | ○ |
| C-101 | UT-ILG-101: Equals異なるシグネチャでfalse | E-35 (Equals_TestData) | ○ |
| C-102 | UT-ILG-102: GetHashCodeが同一値 | E-35 (EqualsTest) | ○ |
| C-103 | UT-ILG-103: ToStringが文字列を返却 | E-40 (ToString_EqualSignatureHelpers_ReturnsEqualStrings) | ○ |
| C-104 | UT-ILG-104: MaxStackが正しく計算される | E-15 (MaxStackOverflowTest) | ○ |
| C-105 | UT-ILG-105: MaxStackオーバーフローしない | E-15 (MaxStackOverflowTest - num=16384) | ○ |
| C-106 | UT-ILG-106: 前方分岐スタック深度が正しい | E-15 (MaxStackNonEmptyForward) | ○ |
| C-107 | UT-ILG-107: 後方分岐スタック深度が正しい | E-15 (MaxStackNonEmptyBackward) | ○ |
| C-108 | UT-ILG-108: 到達不能コードが正しく処理される | E-15 (UnreachableDepth) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし
- 全テストケースは既存テストコードおよびAPIリファレンスに基づいて作成

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに根拠あり
- 注意点: 一部のテスト（EmitCalli関連）はプラットフォーム依存（Browser非対応、Mono一部非対応）
- 注意点: ActiveIssue属性で無効化されているテストが既存コードに存在

## 6) レビュアーチェックリスト（最小）
- [ ] CustomAttributeBuilder: コンストラクタの4種類のオーバーロードがカバーされているか確認
- [ ] ILGenerator: Emit系メソッドの主要なオーバーロードがカバーされているか確認
- [ ] ILGenerator: 例外ブロック関連（BeginExceptionBlock, BeginCatchBlock等）の組み合わせが適切か確認
- [ ] Label/LocalBuilder: 基本プロパティのテストが網羅されているか確認
- [ ] ParameterBuilder: 属性設定とカスタム属性設定がカバーされているか確認
- [ ] SignatureHelper: 各Get*SigHelperメソッドとAddArgument系がカバーされているか確認
- [ ] プラットフォーム依存テスト（EmitCalli等）の取り扱いが適切か確認
