---
generated_at: 2026-01-30 18:15:00
metrics:
  claims_total: 89
  claims_with_evidence: 89
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Reflection.Emit.Lightweight.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストファイル・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：89 / 89、根拠なし：0
- 優先レビュー（高）
  1. なし：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/ref/System.Reflection.Emit.Lightweight.cs` - API参照定義
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/DynamicMethodCtor.cs` - コンストラクタテスト
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/DynamicILInfoTests.cs` - DynamicILInfoテスト
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/DynamicMethodCreateDelegate.cs` - CreateDelegateテスト
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/DynamicMethodDefineParameter.cs` - DefineParameterテスト
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/DynamicMethodGetBaseDefinition.cs` - GetBaseDefinitionテスト
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/DynamicMethodGetILGenerator.cs` - GetILGeneratorテスト
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/DynamicMethodInitLocals.cs` - InitLocalsテスト
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/DynamicMethodToString.cs` - ToStringテスト
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit.Lightweight/tests/Utilities.cs` - テストユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）

### DynamicMethod コンストラクタ関連（UT-REL-001 〜 UT-REL-022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-REL-001) | Moduleを指定してDynamicMethodが作成できること | E-01, E-02 (String_Type_TypeArray_Module) | ○ |
| C-02 (UT-REL-002) | skipVisibility=trueでDynamicMethodが作成できること | E-01, E-02 (String_Type_TypeArray_Module) | ○ |
| C-03 (UT-REL-003) | Typeオーナーを指定してDynamicMethodが作成できること | E-01, E-02 (String_Type_TypeArray_Type) | ○ |
| C-04 (UT-REL-004) | TypeオーナーとskipVisibilityでDynamicMethodが作成できること | E-01, E-02 (String_Type_TypeArray_Type) | ○ |
| C-05 (UT-REL-005) | フル引数コンストラクタでDynamicMethodが作成できること | E-01, E-02 (String_Type_TypeArray_Module) | ○ |
| C-06 (UT-REL-006) | Typeオーナーでフル引数コンストラクタが動作すること | E-01, E-02 (String_Type_TypeArray_Type) | ○ |
| C-07 (UT-REL-007) | 空のメソッド名でもDynamicMethodが作成できること | E-02 ([InlineData("")]) | ○ |
| C-08 (UT-REL-008) | Nullable型を戻り値に指定できること | E-02 ([InlineData(typeof(char?))]) | ○ |
| C-09 (UT-REL-009) | ジェネリック型を戻り値に指定できること | E-02 ([InlineData(typeof(GenericClass<>))]) | ○ |
| C-10 (UT-REL-010) | インターフェース型を戻り値に指定できること | E-02 ([InlineData(typeof(TestInterface))]) | ○ |
| C-11 (UT-REL-011) | null戻り値型を指定できること | E-02 ([InlineData(null)]) | ○ |
| C-12 (UT-REL-012) | ByRef戻り値型を指定できること | E-02 (ByRefReturnType_DoesNotThrow) | ○ |
| C-13 (UT-REL-013) | ジェネリック型パラメータを指定できること | E-02 ([InlineData(typeof(GenericClass2<,>))]) | ○ |
| C-14 (UT-REL-014) | nullのメソッド名でArgumentNullExceptionがスローされること | E-02 (NullName_ThrowsArgumentNullException) | ○ |
| C-15 (UT-REL-015) | nullのModuleでArgumentNullExceptionがスローされること | E-02 (NullModule_ThrowsArgumentNullException) | ○ |
| C-16 (UT-REL-016) | nullのTypeオーナーでArgumentNullExceptionがスローされること | E-02 (NullOwner_ThrowsArgumentNullException) | ○ |
| C-17 (UT-REL-017) | パラメータ型配列にnullが含まれる場合ArgumentExceptionがスローされること | E-02 (NullObjectInParameterTypes_ThrowsArgumentException) | ○ |
| C-18 (UT-REL-018) | 配列型をオーナーに指定した場合ArgumentExceptionがスローされること | E-02 (InvalidOwner_ThrowsArgumentException) | ○ |
| C-19 (UT-REL-019) | インターフェース型をオーナーに指定した場合ArgumentExceptionがスローされること | E-02 (InvalidOwner_ThrowsArgumentException) | ○ |
| C-20 (UT-REL-020) | オープンジェネリック型をオーナーに指定した場合ArgumentExceptionがスローされること | E-02 (InvalidOwner_ThrowsArgumentException) | ○ |
| C-21 (UT-REL-021) | ポインタ型をオーナーに指定した場合ArgumentExceptionがスローされること | E-02 (InvalidOwner_ThrowsArgumentException) | ○ |
| C-22 (UT-REL-022) | 動的コードがサポートされていない環境でPlatformNotSupportedExceptionがスローされること | E-02 (ThrowsWhenDynamicCodeNotSupported) | ○ |

### DynamicMethod プロパティ関連（UT-REL-023 〜 UT-REL-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 (UT-REL-023) | Public|Static属性が返却されること | E-01, E-10 (VerifyMethod) | ○ |
| C-24 (UT-REL-024) | Standard呼び出し規約が返却されること | E-01, E-10 (VerifyMethod) | ○ |
| C-25 (UT-REL-025) | nullが返却されること（DeclaringType） | E-01, E-10 (VerifyMethod) | ○ |
| C-26 (UT-REL-026) | 指定した名前が返却されること | E-01, E-10 (VerifyMethod) | ○ |
| C-27 (UT-REL-027) | 指定した戻り値型が返却されること | E-01, E-10 (VerifyMethod) | ○ |
| C-28 (UT-REL-028) | 戻り値パラメータ情報が取得できること | E-01, E-10 (VerifyMethod) | ○ |
| C-29 (UT-REL-029) | 指定したModuleが返却されること | E-01, E-10 (VerifyMethod) | ○ |
| C-30 (UT-REL-030) | デフォルトでtrueが返却されること（InitLocals） | E-01, E-08, E-10 (VerifyMethod) | ○ |
| C-31 (UT-REL-031) | trueを設定した場合trueが返却されること | E-01, E-08 (InitLocals_Set_ReturnsNewValue) | ○ |
| C-32 (UT-REL-032) | falseを設定した場合falseが返却されること | E-01, E-08 (InitLocals_Set_ReturnsNewValue) | ○ |

### DynamicMethod メソッド関連（UT-REL-033 〜 UT-REL-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 (UT-REL-033) | パラメータ型情報が正しく取得できること | E-01, E-10 (VerifyMethod) | ○ |
| C-34 (UT-REL-034) | パラメータなしの場合空配列が返却されること | E-01, E-10 (VerifyMethod) | ○ |
| C-35 (UT-REL-035) | ILGeneratorが取得できること | E-01, E-07 (GetILGenerator_Owner) | ○ |
| C-36 (UT-REL-036) | サイズ指定でILGeneratorが取得できること | E-01, E-07 (GetILGenerator_Int_Owner) | ○ |
| C-37 (UT-REL-037) | 取得したILGeneratorでILを生成し実行できること | E-07 (VerifyILGenerator) | ○ |
| C-38 (UT-REL-038) | DynamicILInfoが取得できること | E-01, E-03 (GetDynamicILInfo_NotSameNotNull) | ○ |
| C-39 (UT-REL-039) | 同一インスタンスから複数回呼び出しても同じDynamicILInfoが返却されること | E-03 (GetDynamicILInfo_NotSameNotNull) | ○ |
| C-40 (UT-REL-040) | 自身が返却されること（GetBaseDefinition、Typeオーナー） | E-01, E-06 (CreateDynMethod_TypeOwner) | ○ |
| C-41 (UT-REL-041) | Moduleオーナーでも自身が返却されること | E-01, E-06 (CreateDynMethod_Module) | ○ |
| C-42 (UT-REL-042) | デリゲートが作成できること | E-01, E-04 (CreateDelegate_Type) | ○ |
| C-43 (UT-REL-043) | ターゲット指定でデリゲートが作成できること | E-01, E-04 (CreateDelegate_Target_Type) | ○ |
| C-44 (UT-REL-044) | ジェネリックメソッドでデリゲートが作成できること | E-01, E-04 (CreateDelegate_CanBeConvertedToAnotherDelegateType) | ○ |
| C-45 (UT-REL-045) | ILが未設定の場合InvalidOperationExceptionがスローされること | E-04 (CreateDelegate_NoMethodBody_ThrowsInvalidOperationException) | ○ |
| C-46 (UT-REL-046) | 不正なターゲットでArgumentExceptionがスローされること | E-04 (CreateDelegate_InvalidTarget_ThrowsArgumentException) | ○ |
| C-47 (UT-REL-047) | 戻り値型が不一致の場合ArgumentExceptionがスローされること | E-04 (CreateDelegate_DelegateTypeInvalid_ThrowsArgumentException, InvalidRetType) | ○ |
| C-48 (UT-REL-048) | パラメータ数が不一致の場合ArgumentExceptionがスローされること | E-04 (CreateDelegate_DelegateTypeInvalid_ThrowsArgumentException, WrongParamNumber) | ○ |
| C-49 (UT-REL-049) | パラメータ型が不一致の場合ArgumentExceptionがスローされること | E-04 (CreateDelegate_DelegateTypeInvalid_ThrowsArgumentException, InvalidParamType) | ○ |
| C-50 (UT-REL-050) | 作成したデリゲートを別のデリゲート型に変換できること | E-04 (CreateDelegate_CanBeConvertedToAnotherDelegateType) | ○ |
| C-51 (UT-REL-051) | パラメータを定義できること | E-01, E-05 (DefineParameter_SetsParameterCorrectly) | ○ |
| C-52 (UT-REL-052) | 複数パラメータを定義できること | E-05 (DefineParameter_SetsParameterCorrectly) | ○ |
| C-53 (UT-REL-053) | 定義後GetParametersで取得できること | E-05 (DefineParameter_SetsParameterCorrectly) | ○ |
| C-54 (UT-REL-054) | メソッドを実行できること | E-05 (powerOf.Invoke) | ○ |
| C-55 (UT-REL-055) | メソッドシグネチャが文字列で返却されること | E-01, E-09 (ToStringTest) | ○ |
| C-56 (UT-REL-056) | パラメータなしの場合"Void MethodName()"が返却されること | E-09 (ToStringTest, [InlineData(null, null, "Void MethodName()")]) | ○ |
| C-57 (UT-REL-057) | ジェネリック型パラメータが正しく表示されること | E-09 (ToStringTest, GenericClass`1[T]) | ○ |

### DynamicILInfo 関連（UT-REL-058 〜 UT-REL-089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 (UT-REL-058) | 関連するDynamicMethodが取得できること | E-01, E-03 (GetDynamicILInfo_NotSameNotNull) | ○ |
| C-59 (UT-REL-059) | 文字列リテラルのトークンが取得できること | E-01, E-03 (GetTokenFor_String_Success) | ○ |
| C-60 (UT-REL-060) | DynamicMethodのトークンが取得できること | E-01, E-03 (GetTokenFor_DynamicMethod_Success) | ○ |
| C-61 (UT-REL-061) | RuntimeMethodHandleのトークンが取得できること | E-01, E-03 (GetTokenFor_String_Success, token1) | ○ |
| C-62 (UT-REL-062) | ジェネリック型コンテキストでRuntimeMethodHandleのトークンが取得できること | E-01, E-03 (GetTokenFor_IntGenerics_Success) | ○ |
| C-63 (UT-REL-063) | RuntimeFieldHandleのトークンが取得できること | E-01, E-03 (GetTokenFor_CtorMethodAndField_Success, token3) | ○ |
| C-64 (UT-REL-064) | ジェネリック型コンテキストでRuntimeFieldHandleのトークンが取得できること | E-01, E-03 (GetTokenFor_StringGenerics_Success, token4) | ○ |
| C-65 (UT-REL-065) | RuntimeTypeHandleのトークンが取得できること | E-01, E-03 (GetTokenFor_Exception_Success, token3-5) | ○ |
| C-66 (UT-REL-066) | シグネチャバイト配列のトークンが取得できること | E-01 | ○ |
| C-67 (UT-REL-067) | ILコードをバイト配列で設定できること | E-01, E-03 (SetCode in multiple tests) | ○ |
| C-68 (UT-REL-068) | ILコードをポインタで設定できること | E-01 | ○ |
| C-69 (UT-REL-069) | nullポインタでArgumentNullExceptionがスローされること（SetCode） | E-03 (SetX_NullInput_ThrowsArgumentNullException) | ○ |
| C-70 (UT-REL-070) | 負のサイズでArgumentOutOfRangeExceptionがスローされること（SetCode） | E-03 (SetX_NegativeInputSize_ThrowsArgumentOutOfRangeException) | ○ |
| C-71 (UT-REL-071) | 例外ハンドラ情報をバイト配列で設定できること | E-01, E-03 (SetExceptions in multiple tests) | ○ |
| C-72 (UT-REL-072) | 例外ハンドラ情報をポインタで設定できること | E-01 | ○ |
| C-73 (UT-REL-073) | nullポインタでArgumentNullExceptionがスローされること（SetExceptions） | E-03 (SetX_NullInput_ThrowsArgumentNullException) | ○ |
| C-74 (UT-REL-074) | 負のサイズでArgumentOutOfRangeExceptionがスローされること（SetExceptions） | E-03 (SetX_NegativeInputSize_ThrowsArgumentOutOfRangeException) | ○ |
| C-75 (UT-REL-075) | ローカル変数シグネチャをバイト配列で設定できること | E-01, E-03 (SetLocalSignature in multiple tests) | ○ |
| C-76 (UT-REL-076) | ローカル変数シグネチャをポインタで設定できること | E-01 | ○ |
| C-77 (UT-REL-077) | nullポインタでArgumentNullExceptionがスローされること（SetLocalSignature） | E-03 (SetX_NullInput_ThrowsArgumentNullException) | ○ |
| C-78 (UT-REL-078) | 負のサイズでArgumentOutOfRangeExceptionがスローされること（SetLocalSignature） | E-03 (SetX_NegativeInputSize_ThrowsArgumentOutOfRangeException) | ○ |
| C-79 (UT-REL-079) | 文字列操作メソッドを動的に生成・実行できること | E-03 (GetTokenFor_String_Success) | ○ |
| C-80 (UT-REL-080) | 再帰呼び出しを含むメソッドを動的に生成・実行できること | E-03 (GetTokenFor_DynamicMethod_Success, Fib) | ○ |
| C-81 (UT-REL-081) | コンストラクタ・メソッド・フィールドアクセスを含むメソッドを動的に生成・実行できること | E-03 (GetTokenFor_CtorMethodAndField_Success, Mock/Person) | ○ |
| C-82 (UT-REL-082) | 整数ジェネリックコレクションを操作するメソッドを動的に生成・実行できること | E-03 (GetTokenFor_IntGenerics_Success, SumInteger) | ○ |
| C-83 (UT-REL-083) | 文字列ジェネリックコレクションを操作するメソッドを動的に生成・実行できること | E-03 (GetTokenFor_StringGenerics_Success, ContactString) | ○ |
| C-84 (UT-REL-084) | 例外処理を含むメソッドを動的に生成・実行できること | E-03 (GetTokenFor_Exception_Success, ExceptionTest) | ○ |
| C-85 (UT-REL-085) | ジェネリックメソッドを含むメソッドを動的に生成・実行できること | E-03 (Test_GenericMethod, Finder.Find) | ○ |
| C-86 (UT-REL-086) | 多次元配列を操作するメソッドを動的に生成・実行できること | E-03 (Test_TwoDimTest, TwoDimTest) | ○ |
| C-87 (UT-REL-087) | ジェネリック型内のジェネリックメソッドを呼び出すメソッドを動的に生成・実行できること | E-03 (Test_CallGM, G<T>.M<K>) | ○ |
| C-88 (UT-REL-088) | インスタンスベースの関数ポインタを使用できること（ExplicitThis） | E-03 (InstanceBasedFunctionPointer, useExplicitThis=true) | ○ |
| C-89 (UT-REL-089) | インスタンスベースの関数ポインタを使用できること（HasThis） | E-03 (InstanceBasedFunctionPointer, useExplicitThis=false) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースに対応する根拠（既存テストコードまたはAPI定義）が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースが既存テストコードまたはAPI定義に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] UT-REL-001〜UT-REL-022: DynamicMethodコンストラクタの正常系・異常系テストケースが網羅されているか
- [ ] UT-REL-023〜UT-REL-032: DynamicMethodプロパティのテストケースが網羅されているか
- [ ] UT-REL-033〜UT-REL-057: DynamicMethodメソッドのテストケースが網羅されているか
- [ ] UT-REL-058〜UT-REL-089: DynamicILInfoのテストケースが網羅されているか
- [ ] 既存テストとの重複がないか確認
- [ ] 境界値テストが適切に設定されているか確認
- [ ] Mono固有のActiveIssue（runtime#31857, mono#15321等）に関連するテストケースの扱いを確認
