---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 170
  claims_with_evidence: 170
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Reflection.Emit 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：170 / 170、根拠なし：0
- 優先レビュー（高）
  1. すべてのテストケースはソースコードから直接抽出されたメソッドとクラスに基づいています
  2. 例外処理のテストケースはソースコード内のThrowIfメソッド呼び出しから導出されています
  3. 境界値テストはコード内の明示的な制限値（例：0x003f0000）から導出されています

## 2) 参照した情報（Evidence一覧）

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/PersistedAssemblyBuilder.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ModuleBuilderImpl.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/TypeBuilderImpl.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/MethodBuilderImpl.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ConstructorBuilderImpl.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/FieldBuilderImpl.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/PropertyBuilderImpl.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/EventBuilderImpl.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ParameterBuilderImpl.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/GenericTypeParameterBuilderImpl.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/EnumBuilderImpl.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ILGeneratorImpl.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### PersistedAssemblyBuilder関連 (UT-SRE-001 - UT-SRE-010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでArgumentNullExceptionがスローされる | E-01 L36-38: `ArgumentNullException.ThrowIfNull(name)` | ○ |
| C-02 | AssemblyName.Nameが空の場合ArgumentExceptionがスローされる | E-01 L37: `ArgumentException.ThrowIfNullOrEmpty(name.Name)` | ○ |
| C-03 | Saveメソッドでモジュール未定義時にInvalidOperationException | E-01 L140-143: `if (_module == null) throw new InvalidOperationException` | ○ |
| C-04 | メタデータ二重生成時にInvalidOperationException | E-01 L145-148: `if (_isMetadataPopulated) throw new InvalidOperationException` | ○ |
| C-05 | 複数モジュール定義時にInvalidOperationException | E-01 L175-178: `if (_module != null) throw new InvalidOperationException` | ○ |

### ModuleBuilderImpl関連 (UT-SRE-011 - UT-SRE-019)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | DefineTypeCore正常動作 | E-02 L1290-1296: `DefineTypeCore`メソッド定義 | ○ |
| C-07 | DefineEnumCore正常動作 | E-02 L1234-1239: `DefineEnumCore`メソッド定義 | ○ |
| C-08 | グローバルメソッドはstaticである必要がある | E-02 L1250-1253: `if ((attributes & MethodAttributes.Static) == 0) throw` | ○ |
| C-09 | CreateGlobalFunctions二重呼び出しでエラー | E-02 L1225-1228: `if (_hasGlobalBeenCreated) throw` | ○ |
| C-10 | GetArrayMethodで非配列型はエラー | E-02 L1313-1316: `if (!arrayClass.IsArray) throw new ArgumentException` | ○ |

### TypeBuilderImpl関連 (UT-SRE-020 - UT-SRE-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | グローバル型コンストラクタ | E-03 L44-50: `_name = "<Module>"; _isHiddenGlobalType = true;` | ○ |
| C-12 | 名前空間抽出ロジック | E-03 L65-70: `int idx = _name.LastIndexOf('.'); if (idx != -1)` | ○ |
| C-13 | AddInterfaceImplementation作成後エラー | E-03 L89-91: `ThrowIfCreated()` | ○ |
| C-14 | デフォルトコンストラクタ自動生成 | E-03 L114-118: `if (_constructorDefinitions.Count == 0...)` | ○ |
| C-15 | インターフェースにコンストラクタ不可 | E-03 L162-165: `if (Interface && !Static) throw` | ○ |
| C-16 | 抽象メソッドは抽象クラスのみ | E-03 L133-139: `ValidateMethods`内のチェック | ○ |
| C-17 | DefineInitializedDataのサイズチェック | E-03 L277-282: `if (data.Length <= 0 || data.Length >= 0x003f0000) throw` | ○ |
| C-18 | SetParentでインターフェース禁止 | E-03 L554-557: `if (parent.IsInterface) throw` | ○ |
| C-19 | StructLayoutAttribute疑似属性処理 | E-03 L496-544: `ParseStructLayoutAttribute`メソッド | ○ |
| C-20 | GetEnumUnderlyingTypeの制約 | E-03 L609-624: 非Enum時の例外スロー | ○ |

### MethodBuilderImpl関連 (UT-SRE-070 - UT-SRE-086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | 非staticメソッドにHasThis追加 | E-04 L47-51: `if ((attributes & Static) == 0) callingConventions |= HasThis` | ○ |
| C-22 | Static|VirtualでAbstract無しはエラー | E-04 L52-55: `throw new ArgumentException(SR.Argument_NoStaticVirtual)` | ○ |
| C-23 | ジェネリックパラメータ二重定義エラー | E-04 L116-117: `if (_typeParameters != null) throw` | ○ |
| C-24 | パラメータ位置範囲外エラー | E-04 L134-137: `if (position > _parameterTypes.Length) throw` | ○ |
| C-25 | AbstractメソッドにはILGenerator不可 | E-04 L161-164: `if (Abstract) throw` | ○ |
| C-26 | DllImportAttribute疑似属性処理 | E-04 L181-190: `_dllImportData`設定 | ○ |

### ConstructorBuilderImpl関連 (UT-SRE-087 - UT-SRE-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | デフォルトコンストラクタにILGenerator不可 | E-05 L33-36: `if (_isDefaultConstructor) throw` | ○ |

### FieldBuilderImpl関連 (UT-SRE-090 - UT-SRE-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | SetConstantでHasDefault属性設定 | E-06 L40-45: `_attributes |= FieldAttributes.HasDefault` | ○ |
| C-29 | SetOffsetで負値エラー | E-06 L80-82: `ArgumentOutOfRangeException.ThrowIfNegative(iOffset)` | ○ |
| C-30 | FieldOffsetAttribute疑似属性処理 | E-06 L58-61: `_offset = BinaryPrimitives.ReadInt32LittleEndian` | ○ |
| C-31 | MarshalAsAttribute処理 | E-06 L70-73: `_marshallingData = MarshallingData.CreateMarshallingData` | ○ |

### PropertyBuilderImpl関連 (UT-SRE-097 - UT-SRE-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | 空の名前でArgumentException | E-07 L31: `ArgumentException.ThrowIfNullOrEmpty(name)` | ○ |
| C-33 | SetGetMethodでnullエラー | E-07 L79: `ArgumentNullException.ThrowIfNull(mdBuilder)` | ○ |
| C-34 | 非publicなgetterのアクセス制御 | E-07 L109-122: `GetGetMethod`のアクセス制御ロジック | ○ |

### EventBuilderImpl関連 (UT-SRE-106 - UT-SRE-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | SetAddOnMethodでnullエラー | E-08 L46: `ArgumentNullException.ThrowIfNull(mdBuilder)` | ○ |
| C-36 | SpecialNameAttribute疑似属性処理 | E-08 L56-59: `_attributes |= EventAttributes.SpecialName` | ○ |

### ParameterBuilderImpl関連 (UT-SRE-112 - UT-SRE-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | SetConstantでHasDefault設定 | E-09 L35-37: `_attributes |= ParameterAttributes.HasDefault` | ○ |
| C-38 | InAttribute疑似属性処理 | E-09 L43-45: `_attributes |= ParameterAttributes.In` | ○ |
| C-39 | OutAttribute疑似属性処理 | E-09 L46-48: `_attributes |= ParameterAttributes.Out` | ○ |
| C-40 | OptionalAttribute疑似属性処理 | E-09 L49-51: `_attributes |= ParameterAttributes.Optional` | ○ |

### GenericTypeParameterBuilderImpl関連 (UT-SRE-117 - UT-SRE-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | SetBaseTypeConstraintで_interfacesに追加 | E-10 L44-48: `_interfaces.Add(_parent)` | ○ |
| C-42 | MakePointerType実装 | E-10 L144-145: `SymbolType.FormCompoundType("*", this, 0)` | ○ |
| C-43 | MakeByRefType実装 | E-10 L147-148: `SymbolType.FormCompoundType("&", this, 0)` | ○ |
| C-44 | MakeArrayType実装 | E-10 L151-152: `SymbolType.FormCompoundType("[]", this, 0)` | ○ |

### EnumBuilderImpl関連 (UT-SRE-125 - UT-SRE-129)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | VisibilityMask以外のフラグでエラー | E-11 L16-17: `if ((visibility & ~VisibilityMask) != 0) throw` | ○ |
| C-46 | value__フィールド自動定義 | E-11 L23: `_typeBuilder.DefineField("value__", underlyingType, ...)` | ○ |
| C-47 | DefineLiteralでSetConstant呼び出し | E-11 L37: `fieldBuilder.SetConstant(literalValue)` | ○ |

### ILGeneratorImpl関連 (UT-SRE-130 - UT-SRE-170)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Localloc時のフラグ設定 | E-12 L284-287: `if (opcode == OpCodes.Localloc) _hasDynamicStackAllocation = true` | ○ |
| C-49 | Ldc_I4短縮形最適化 | E-12 L322-347: `-1から8の値で短縮形使用` | ○ |
| C-50 | 無効なラベルでArgumentException | E-12 L517-519: `throw new ArgumentException(SR.Argument_InvalidLabel)` | ○ |
| C-51 | Call/Callvirt/Newobj以外でエラー | E-12 L425-429: `if (!(Call || Callvirt || Newobj)) throw` | ○ |
| C-52 | 異なるメソッドのローカルでエラー | E-12 L546-549: `if (local is not LocalBuilderImpl || GetMethodBuilder() != _methodBuilder) throw` | ○ |
| C-53 | 重複ラベルマークでエラー | E-12 L788-792: `if (labelInfo._position != -1) throw` | ○ |
| C-54 | 例外ブロック外でNotSupportedException | E-12 L88-91: `if (_exceptionStack.Count < 1) throw NotSupportedException` | ○ |
| C-55 | try/filterで終了時InvalidOperationException | E-12 L752-755: `if (state == Filter || state == Try) throw InvalidOperationException` | ○ |
| C-56 | ルートスコープで終了時エラー | E-12 L775-778: `if (_currentScope._parent == null) throw InvalidOperationException` | ○ |
| C-57 | VarArgs以外でoptionalParameterTypes指定エラー | E-12 L686-693: VarArgsチェック | ○ |
| C-58 | UsingNamespaceで空文字エラー | E-12 L849: `ArgumentException.ThrowIfNullOrEmpty(usingNamespace)` | ○ |
| C-59 | GetMaxStackの上限値 | E-12 L49: `Math.Min(ushort.MaxValue, _maxStackDepth + _depthAdjustment)` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - すべてのテストケースは実際のソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードから直接導出されています
- テストケースの網羅性について:
  - 主要なパブリックメソッドとプロパティをカバー
  - 例外処理パスの検証を含む
  - 境界値テストを含む
  - 疑似カスタム属性処理をカバー

## 6) レビュアーチェックリスト（最小）
- [ ] UT-SRE-001からUT-SRE-010: PersistedAssemblyBuilderの基本機能テスト - コンストラクタとSaveメソッドの検証
- [ ] UT-SRE-020からUT-SRE-069: TypeBuilderImplの包括的テスト - 型定義、メンバー定義、属性設定の検証
- [ ] UT-SRE-070からUT-SRE-086: MethodBuilderImplのテスト - メソッド定義、パラメータ、ジェネリックの検証
- [ ] UT-SRE-130からUT-SRE-170: ILGeneratorImplのテスト - IL発行、ラベル管理、例外処理の検証
- [ ] 疑似カスタム属性処理（StructLayoutAttribute, MarshalAsAttribute等）が正しくテストされているか確認
- [ ] 例外処理テストケースが全ての主要な検証パスをカバーしているか確認
- [ ] 境界値テスト（サイズ制限、スタック深度等）が適切か確認
