---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 103
  claims_with_evidence: 103
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Reflection.Extensions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：103 / 103、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Reflection.Extensions/README.md` - ライブラリの概要説明
- E-02: `src/libraries/shims/System.Reflection.Extensions/src/System.Reflection.Extensions.cs` - 型転送定義
- E-03: `src/libraries/System.Reflection.Extensions/tests/RuntimeReflectionExtensionTests.cs` - RuntimeReflectionExtensionsのテスト
- E-04: `src/libraries/System.Reflection.Extensions/tests/RuntimeReflectionExtensionTestsWithQuirks.cs` - RuntimeReflectionExtensionsの追加テスト
- E-05: `src/libraries/System.Reflection.Extensions/tests/GetCustomAttributes_MemberInfo.cs` - MemberInfo用CustomAttributeExtensionsテスト
- E-06: `src/libraries/System.Reflection.Extensions/tests/GetCustomAttributes_ParameterInfo.cs` - ParameterInfo用CustomAttributeExtensionsテスト
- E-07: `src/libraries/System.Reflection.Extensions/tests/GetCustomAttributes_Assembly.cs` - Assembly用CustomAttributeExtensionsテスト
- E-08: `src/libraries/System.Reflection.Extensions/tests/GetCustomAttributes_Compat.cs` - 互換性テスト
- E-09: `src/libraries/System.Reflection.Extensions/tests/Definitions/PropertyDefinitions.cs` - プロパティテスト定義
- E-10: `src/libraries/System.Reflection.Extensions/tests/Definitions/MethodDefinitions.cs` - メソッドテスト定義
- E-11: `src/libraries/System.Reflection.Extensions/tests/Definitions/EventDefinitions.cs` - イベントテスト定義
- E-12: `src/libraries/System.Reflection.Extensions/tests/Definitions/FieldDefinitions.cs` - フィールドテスト定義

## 3) Claims と根拠の対応（レビューの主戦場）

### RuntimeReflectionExtensions テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetRuntimeEvents正常系 | E-03 (L16-23) | ○ |
| C-02 | GetRuntimeEvents null検証 | E-03 (L18) | ○ |
| C-03 | GetRuntimeMethods正常系 | E-03 (L25-61) | ○ |
| C-04 | GetRuntimeMethods Object継承 | E-03 (L49-56) | ○ |
| C-05 | GetRuntimeMethods null検証 | E-03 (L30-33) | ○ |
| C-06 | GetRuntimeFields正常系 | E-03 (L63-89) | ○ |
| C-07 | GetRuntimeFields null検証 | E-03 (L68-71) | ○ |
| C-08 | GetRuntimeProperties正常系 | E-03 (L91-107) | ○ |
| C-09 | GetRuntimeProperties継承 | E-03 (L105-107) | ○ |
| C-10 | GetRuntimeProperties null検証 | E-03 (L94) | ○ |
| C-11 | GetRuntimeProperty正常系 | E-03 (L109-157) | ○ |
| C-12 | GetRuntimeProperty互換性 | E-03 (L156) | ○ |
| C-13 | GetRuntimeProperty空文字 | E-03 (L124) | ○ |
| C-14 | GetRuntimeProperty null type | E-03 (L114-117) | ○ |
| C-15 | GetRuntimeProperty null name | E-03 (L119-122) | ○ |
| C-16 | GetRuntimeProperty曖昧一致 | E-03 (L140-147) | ○ |
| C-17 | GetRuntimeEvent正常系 | E-03 (L159-197) | ○ |
| C-18 | GetRuntimeEvent互換性 | E-03 (L196) | ○ |
| C-19 | GetRuntimeEvent空文字 | E-03 (L175) | ○ |
| C-20 | GetRuntimeEvent null type | E-03 (L164-167) | ○ |
| C-21 | GetRuntimeEvent null name | E-03 (L170-173) | ○ |
| C-22 | GetRuntimeMethod正常系 | E-03 (L199-242) | ○ |
| C-23 | GetRuntimeMethod互換性 | E-03 (L241) | ○ |
| C-24 | GetRuntimeMethod空文字 | E-03 (L221) | ○ |
| C-25 | GetRuntimeMethod null type | E-03 (L204-207) | ○ |
| C-26 | GetRuntimeMethod null name | E-03 (L210-213) | ○ |
| C-27 | GetRuntimeMethod null types | E-03 (L216-219) | ○ |
| C-28 | GetRuntimeField正常系 | E-03 (L244-279) | ○ |
| C-29 | GetRuntimeField互換性 | E-03 (L278) | ○ |
| C-30 | GetRuntimeField空文字 | E-03 (L260) | ○ |
| C-31 | GetRuntimeField null type | E-03 (L249-252) | ○ |
| C-32 | GetRuntimeField null name | E-03 (L255-258) | ○ |
| C-33 | GetMethodInfo正常系 | E-03 (L281-286) | ○ |
| C-34 | GetMethodInfo null検証 | E-03 (L284) | ○ |
| C-35 | GetRuntimeBaseDefinition正常系 | E-03 (L288-297) | ○ |
| C-36 | GetRuntimeBaseDefinition null検証 | E-03 (L291) | ○ |
| C-37 | GetRuntimeInterfaceMap正常系 | E-03 (L299-320) | ○ |
| C-38 | GetRuntimeInterfaceMapメソッド詳細 | E-03 (L310-318) | ○ |
| C-39 | GetRuntimeInterfaceMap null typeInfo | E-03 (L302) | ○ |
| C-40 | GetRuntimeInterfaceMap null interfaceType | E-03 (L303) | ○ |
| C-41 | GetRuntimeInterfaceMap未実装インターフェース | E-03 (L304) | ○ |
| C-42 | GetRuntimeInterfaceMap非インターフェース | E-03 (L305) | ○ |

### CustomAttributeExtensions MemberInfo テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | IsDefined正常系 | E-05 (L22-36) | ○ |
| C-44 | IsDefined inherit=false | E-05 (L17-20) | ○ |
| C-45 | IsDefined null attributeType | E-05 (L32-35) | ○ |
| C-46 | IsDefined非Attribute型 | E-05 (L27-30) | ○ |
| C-47 | GetCustomAttribute<T>正常系 | E-05 (L45-55) | ○ |
| C-48 | GetCustomAttribute<T> inherit=false | E-05 (L39-43) | ○ |
| C-49 | GetCustomAttribute<T>曖昧一致 | E-05 (L51-54) | ○ |
| C-50 | GetCustomAttribute型指定正常系 | E-05 (L84-104) | ○ |
| C-51 | GetCustomAttribute型指定曖昧一致 | E-05 (L90-93) | ○ |
| C-52 | GetCustomAttribute型指定非Attribute | E-05 (L95-98) | ○ |
| C-53 | GetCustomAttribute型指定null | E-05 (L100-103) | ○ |
| C-54 | GetCustomAttributes<T>正常系 | E-05 (L64-72) | ○ |
| C-55 | GetCustomAttributes<T>存在しない | E-05 (L70-71) | ○ |
| C-56 | GetCustomAttributes<T> inherit=false | E-05 (L57-62) | ○ |
| C-57 | GetCustomAttributes型指定正常系 | E-05 (L106-124) | ○ |
| C-58 | GetCustomAttributes型指定存在しない | E-05 (L112-113) | ○ |
| C-59 | GetCustomAttributes型指定非Attribute | E-05 (L115-118) | ○ |
| C-60 | GetCustomAttributes型指定null | E-05 (L120-123) | ○ |
| C-61 | GetCustomAttributes全属性inherit=false | E-05 (L126-135) | ○ |
| C-62 | GetCustomAttributes全属性inherit=true | E-05 (L137-162) | ○ |
| C-63 | GetCustomAttributes属性なし | E-05 (L140-141) | ○ |

### CustomAttributeExtensions ParameterInfo テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | IsDefined正常系 | E-06 (L26-43) | ○ |
| C-65 | IsDefined inherit=false | E-06 (L14-23) | ○ |
| C-66 | IsDefined null attributeType | E-06 (L39-42) | ○ |
| C-67 | IsDefined非Attribute型 | E-06 (L34-37) | ○ |
| C-68 | GetCustomAttribute<T>正常系 | E-06 (L57-70) | ○ |
| C-69 | GetCustomAttribute<T> inherit=false | E-06 (L45-54) | ○ |
| C-70 | GetCustomAttribute<T>曖昧一致 | E-06 (L66-69) | ○ |
| C-71 | GetCustomAttribute型指定正常系 | E-06 (L114-138) | ○ |
| C-72 | GetCustomAttribute型指定inherit=false | E-06 (L103-112) | ○ |
| C-73 | GetCustomAttribute型指定曖昧一致 | E-06 (L124-127) | ○ |
| C-74 | GetCustomAttribute型指定非Attribute | E-06 (L129-132) | ○ |
| C-75 | GetCustomAttribute型指定null | E-06 (L134-137) | ○ |
| C-76 | GetCustomAttributes<T>複数 | E-06 (L74-84) | ○ |
| C-77 | GetCustomAttributes<T>単一 | E-06 (L86-101) | ○ |
| C-78 | GetCustomAttributes<T>存在しない | E-06 (L99-100) | ○ |
| C-79 | GetCustomAttributes型指定複数 | E-06 (L153-178) | ○ |
| C-80 | GetCustomAttributes型指定inherit=false | E-06 (L140-151) | ○ |
| C-81 | GetCustomAttributes型指定存在しない | E-06 (L166-167) | ○ |
| C-82 | GetCustomAttributes型指定非Attribute | E-06 (L169-172) | ○ |
| C-83 | GetCustomAttributes型指定null | E-06 (L174-177) | ○ |
| C-84 | GetCustomAttributes全属性inherit=false | E-06 (L180-203) | ○ |
| C-85 | GetCustomAttributes全属性inherit=true | E-06 (L205-237) | ○ |
| C-86 | GetCustomAttributes属性なし | E-06 (L193-194, L216-217) | ○ |
| C-87 | GetCustomAttribute戻り値属性継承 | E-06 (L239-247) | ○ |

### CustomAttributeExtensions Assembly テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | GetCustomAttributes全属性 | E-07 (L15-25) | ○ |
| C-89 | GetCustomAttribute型指定正常系 | E-07 (L39-52) | ○ |
| C-90 | GetCustomAttribute型指定存在しない | E-07 (L42-43) | ○ |
| C-91 | GetCustomAttribute型指定曖昧一致 | E-07 (L48-51) | ○ |
| C-92 | GetCustomAttributes型指定複数 | E-07 (L54-66) | ○ |
| C-93 | GetCustomAttributes型指定存在しない | E-07 (L64-65) | ○ |
| C-94 | GetCustomAttributes非Attribute型 | E-07 (L77-80) | ○ |
| C-95 | GetCustomAttribute<T>正常系 | E-07 (L69-89) | ○ |
| C-96 | GetCustomAttribute<T>存在しない | E-07 (L74-75) | ○ |
| C-97 | GetCustomAttribute<T>曖昧一致 | E-07 (L85-88) | ○ |
| C-98 | GetCustomAttributes<T>複数 | E-07 (L91-104) | ○ |
| C-99 | GetCustomAttributes<T>存在しない | E-07 (L102-103) | ○ |
| C-100 | IsDefined定義あり | E-07 (L106-113) | ○ |
| C-101 | IsDefined定義なし | E-07 (L112) | ○ |

### 互換性テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | 戻り値配列型 | E-08 (L11-45) | ○ |
| C-103 | モジュール属性取得 | E-08 (L21) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースに既存テストコードによる根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースが既存のテストコードに基づいており、実装の挙動が確認済み

### 特記事項
- このライブラリはshimライブラリであり、実際の実装は `System.Private.CoreLib` に存在
- 型転送: `CustomAttributeExtensions`, `InterfaceMapping`, `RuntimeReflectionExtensions`
- 既存テストが充実しており、正常系・異常系・境界値が網羅されている

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-SRE-XXX）が一貫しているか
- [ ] 各メソッドに対して正常系・異常系・境界値が網羅されているか
- [ ] null入力に対するArgumentNullExceptionのテストが全メソッドにあるか
- [ ] AmbiguousMatchExceptionのテストが該当メソッドにあるか
- [ ] 継承（inherit）パラメータの動作テストがあるか
- [ ] 優先度の割り当てが適切か（null検証=高、正常系=中）
