---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Reflection.MetadataLoadContext 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコード・APIドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの期待結果が実装コードの動作と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 138 / 140 = 0.99

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で主要なテストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-MLC-041, UT-MLC-042**：PathAssemblyResolverのバージョン選択・PKTマッチングロジックは実装コードから推測した部分あり
  2. **DefaultBinderのテストケース**：内部クラスのため直接テスト可能かの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/MetadataLoadContext.Apis.cs` - MetadataLoadContextの主要API実装
- E-02: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/MetadataLoadContext.Resolving.cs` - アセンブリ解決ロジック
- E-03: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/PathAssemblyResolver.cs` - PathAssemblyResolver実装
- E-04: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/MetadataAssemblyResolver.cs` - 抽象リゾルバークラス
- E-05: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/TypeLoading/Types/RoType.cs` - RoType基底クラス実装
- E-06: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/TypeLoading/Assemblies/RoAssembly.cs` - RoAssembly基底クラス実装
- E-07: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/TypeLoading/Modules/RoModule.cs` - RoModule基底クラス実装
- E-08: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/TypeLoading/Methods/RoMethod.cs` - RoMethod基底クラス実装
- E-09: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/TypeLoading/Constructors/RoConstructor.cs` - RoConstructor基底クラス実装
- E-10: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/TypeLoading/Fields/RoField.cs` - RoField基底クラス実装
- E-11: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/DefaultBinder.cs` - DefaultBinder実装
- E-12: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/TypeLoading/General/CoreTypes.cs` - CoreTypes実装
- E-13: `src/libraries/System.Reflection.MetadataLoadContext/src/System/Reflection/TypeLoading/Assemblies/Ecma/EcmaAssembly.cs` - EcmaAssembly実装
- E-14: `src/libraries/System.Reflection.MetadataLoadContext/tests/src/Tests/MetadataLoadContext/LoadApi.cs` - 既存のロードAPIテスト
- E-15: `src/libraries/System.Reflection.MetadataLoadContext/tests/src/Tests/MetadataLoadContext/Dispose.cs` - 既存のDisposeテスト

## 3) Claims と根拠の対応（レビューの主戦場）

### MetadataLoadContext クラス (UT-MLC-001 〜 UT-MLC-035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MetadataLoadContextコンストラクタがresolverとcoreAssemblyNameを受け取る | E-01 (行106-120) | ○ |
| C-02 | resolverがnullの場合ArgumentNullExceptionをスロー | E-01 (行108) | ○ |
| C-03 | LoadFromAssemblyPathがファイルからアセンブリをロード | E-01 (行127-134) | ○ |
| C-04 | LoadFromAssemblyPathでnullはArgumentNullException | E-01 (行129) | ○ |
| C-05 | Dispose後のAPIアクセスでObjectDisposedException | E-01 (行131-132, 145-146, 162-163, 179-180, 197-198, 247-248, 259-260), E-15 | ○ |
| C-06 | LoadFromByteArrayがバイト配列からアセンブリをロード | E-01 (行141-148) | ○ |
| C-07 | LoadFromStreamがストリームからアセンブリをロード | E-01 (行158-166) | ○ |
| C-08 | LoadFromStreamがストリーム位置を0にリセット | E-01 (行164), E-14 (行92-111) | ○ |
| C-09 | LoadFromAssemblyName(string)が名前解決を行う | E-01 (行175-184), E-02 | ○ |
| C-10 | LoadFromAssemblyName(AssemblyName)が名前解決を行う | E-01 (行193-201), E-02 | ○ |
| C-11 | GetAssembliesがロード済みアセンブリを返却 | E-01 (行257-263) | ○ |
| C-12 | CoreAssemblyがコアアセンブリを返却 | E-01 (行243-252) | ○ |
| C-13 | Disposeが複数回呼び出し可能 | E-15 (行33-40) | ○ |
| C-14 | Disposeがファイルロックを解放 | E-15 (行12-30) | ○ |
| C-15 | 同一Mvidのアセンブリは同一インスタンスを返却 | E-14 (行132-154) | ○ |
| C-16 | 異なるMvidのアセンブリでFileLoadException | E-14 (行156-180) | ○ |

### PathAssemblyResolver クラス (UT-MLC-036 〜 UT-MLC-043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | PathAssemblyResolverがパスコレクションを受け取る | E-03 (行32-52) | ○ |
| C-18 | null/空パスでArgumentException | E-03 (行34, 38-43) | ○ |
| C-19 | Resolveがアセンブリ名に基づいて解決 | E-03 (行54-96) | ○ |
| C-20 | 同名アセンブリで最新バージョンを返却 | E-03 (行74-78, 86-88) | ○ |
| C-21 | PublicKeyTokenが一致するアセンブリを優先 | E-03 (行61-91) | △ |

### RoAssembly クラス (UT-MLC-044 〜 UT-MLC-057)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | GetNameがAssemblyNameを返却 | E-06 (行36-37) | ○ |
| C-23 | FullNameが完全修飾名を返却 | E-06 (行41) | ○ |
| C-24 | ManifestModuleがモジュールを返却 | E-06 (行29-30) | ○ |
| C-25 | GetTypesが型配列を返却 | E-06 (行63) | ○ |
| C-26 | GetTypeが名前から型を検索 | E-06 (行99-109) | ○ |
| C-27 | GetReferencedAssembliesが参照アセンブリを返却 | E-06 (行139-150) | ○ |
| C-28 | ReflectionOnlyが常にtrue | E-06 (行157) | ○ |
| C-29 | IsDefinedでInvalidOperationException | E-06 (行210) | ○ |
| C-30 | GetCustomAttributesでInvalidOperationException | E-06 (行208-209) | ○ |
| C-31 | CreateInstanceでArgumentException | E-06 (行212) | ○ |
| C-32 | GetSatelliteAssemblyでNotSupportedException | E-06 (行204-205) | ○ |
| C-33 | CodeBaseでNotSupportedException | E-06 (行51, 56) | ○ |

### RoModule クラス (UT-MLC-058 〜 UT-MLC-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | Assemblyが親アセンブリを返却 | E-07 (行32) | ○ |
| C-35 | FullyQualifiedNameがパスを返却 | E-07 (行40) | ○ |
| C-36 | バイト配列ロードで<Unknown>を返却 | E-07 (行20) | ○ |
| C-37 | ModuleVersionIdがGuidを返却 | E-07 (行43) | ○ |
| C-38 | GetTypesが型配列を返却 | E-07 (行82) | ○ |
| C-39 | ignoreCase=trueでNotSupportedException | E-07 (行120-121) | ○ |
| C-40 | ResolveFieldでNotSupportedException | E-07 (行86) | ○ |
| C-41 | ResolveMethodでNotSupportedException | E-07 (行88) | ○ |
| C-42 | ResolveTypeでNotSupportedException | E-07 (行91) | ○ |

### RoType クラス (UT-MLC-069 〜 UT-MLC-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | Nameが型名を返却 | E-05 (行108) | ○ |
| C-44 | Namespaceが名前空間を返却 | E-05 (行112) | ○ |
| C-45 | FullNameが完全修飾名を返却 | E-05 (行116-117) | ○ |
| C-46 | オープンジェネリック型のFullNameがnull | E-05 (行117, 123) | ○ |
| C-47 | Assemblyが所属アセンブリを返却 | E-05 (行130) | ○ |
| C-48 | Moduleが所属モジュールを返却 | E-05 (行131) | ○ |
| C-49 | BaseTypeが基底型を返却 | E-05 (行155-169) | ○ |
| C-50 | GetInterfacesがインターフェース配列を返却 | E-05 (行191) | ○ |
| C-51 | IsAssignableFromが代入可能性を判定 | E-05 (行247-261) | ○ |
| C-52 | MakeArrayTypeが配列型を作成 | E-05 (行310-317) | ○ |
| C-53 | MakeArrayType(rank<=0)でIndexOutOfRangeException | E-05 (行313-314) | ○ |
| C-54 | MakeByRefTypeが参照型を作成 | E-05 (行319) | ○ |
| C-55 | MakePointerTypeがポインタ型を作成 | E-05 (行320) | ○ |
| C-56 | GetCustomAttributesでInvalidOperationException | E-05 (行369-370) | ○ |
| C-57 | InvokeMemberでInvalidOperationException | E-05 (行372) | ○ |
| C-58 | TypeHandleでInvalidOperationException | E-05 (行368) | ○ |
| C-59 | GetInterfaceMapでNotSupportedException | E-05 (行244) | ○ |

### RoMethod クラス (UT-MLC-104 〜 UT-MLC-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Nameがメソッド名を返却 | E-08 (行32) | ○ |
| C-61 | DeclaringTypeが宣言型を返却 | E-08 (行27-28) | ○ |
| C-62 | ReturnTypeが戻り値型を返却 | E-08 (行96) | ○ |
| C-63 | GetParametersがパラメータ配列を返却 | E-08 (行88) | ○ |
| C-64 | InvokeでInvalidOperationException | E-08 (行122) | ○ |
| C-65 | MethodHandleでInvalidOperationException | E-08 (行125) | ○ |

### RoConstructor クラス (UT-MLC-115 〜 UT-MLC-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | Nameがコンストラクタ名を返却 | E-09 (行24) | ○ |
| C-67 | DeclaringTypeが宣言型を返却 | E-09 (行19-20) | ○ |
| C-68 | GetParametersがパラメータ配列を返却 | E-09 (行64) | ○ |
| C-69 | InvokeでInvalidOperationException | E-09 (行79-80) | ○ |

### RoField クラス (UT-MLC-119 〜 UT-MLC-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | Nameがフィールド名を返却 | E-10 (行37) | ○ |
| C-71 | FieldTypeがフィールド型を返却 | E-10 (行84-91) | ○ |
| C-72 | GetRawConstantValueが定数値を返却 | E-10 (行129) | ○ |
| C-73 | 非定数フィールドでInvalidOperationException | E-10 (行129) | ○ |
| C-74 | GetValueでInvalidOperationException | E-10 (行145) | ○ |
| C-75 | SetValueでInvalidOperationException | E-10 (行147) | ○ |

### DefaultBinder クラス (UT-MLC-126 〜 UT-MLC-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | SelectMethodがメソッドを選択 | E-11 (行47-144) | ○ |
| C-77 | 空のmatch配列でArgumentException | E-11 (行62-63) | ○ |
| C-78 | SelectPropertyがプロパティを選択 | E-11 (行147-264) | ○ |
| C-79 | BindToMethodでInvalidOperationException | E-11 (行39) | ○ |
| C-80 | BindToFieldでInvalidOperationException | E-11 (行43) | ○ |
| C-81 | ChangeTypeでInvalidOperationException | E-11 (行268) | ○ |

### CoreTypes クラス (UT-MLC-133 〜 UT-MLC-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | インデクサがコア型を返却 | E-12 (行45) | ○ |
| C-83 | 存在しないコア型でnull | E-12 (行45, 32-35) | ○ |
| C-84 | GetExceptionが例外を返却 | E-12 (行46) | ○ |

### EcmaAssembly クラス (UT-MLC-136 〜 UT-MLC-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | ImageRuntimeVersionがバージョンを返却 | E-13 (行38) | ○ |
| C-86 | IsDynamicが常にfalse | E-13 (行39) | ○ |
| C-87 | EntryPointがエントリポイントを返却 | E-13 (行36) | ○ |
| C-88 | CustomAttributesが属性を返却 | E-13 (行42) | ○ |

## 4) 不足情報（Unknown / Missing）
- **PathAssemblyResolverのPKTマッチングロジック詳細**
  - 候補：PathAssemblyResolverの内部実装の詳細なテスト / 既存テストコードの調査
  - 現状：実装コードから推測しているが、エッジケースの動作確認が必要

- **DefaultBinderの直接テスト可能性**
  - 候補：internalクラスのためInternalsVisibleToの確認 / 間接的なテスト方法の検討
  - 現状：テスト可能であることを前提としているが、テストプロジェクトの構成確認が必要

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - MetadataLoadContext、RoAssembly、RoModule、RoType、RoMethod、RoConstructor、RoField、CoreTypes、EcmaAssemblyのテストケース
  - 実装コードと既存テストコードから明確に根拠が確認できる

- **1: 中リスク** - PathAssemblyResolverのバージョン選択・PKTマッチングテストケース（UT-MLC-041, UT-MLC-042）
  - 実装コードは確認できるが、複雑なロジックのため動作確認が推奨される

- **1: 中リスク** - DefaultBinderのテストケース（UT-MLC-126 〜 UT-MLC-132）
  - internalクラスのため、テスト実装時にアクセス方法の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] MetadataLoadContextの主要API（Load系メソッド、Dispose）のテストケースが網羅されているか
- [ ] 異常系（null引数、Dispose後アクセス、不正データ）のテストケースが適切か
- [ ] 禁止操作（Invoke、GetValue、SetValue等）のテストケースが網羅されているか
- [ ] PathAssemblyResolverのバージョン選択ロジックのテストケースが実装可能か確認
- [ ] DefaultBinderが直接テスト可能かの確認（InternalsVisibleTo等）
- [ ] 既存テストコード（E-14, E-15）との重複・整合性の確認
