---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 75
  claims_with_evidence: 73
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Reflection.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・API定義などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：対象クラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：73 / 75、根拠なし：2
- 優先レビュー（高）
  1. **UT-SRP-075（EndsUncondJmpBlk）**：内部メソッドのため直接テスト不可能な可能性
  2. **一部OpCode静的フィールドの網羅性**：全225命令中、代表的なものを抽出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Reflection.Primitives/ref/System.Reflection.Primitives.cs` - API定義（ref assembly）
- E-02: `src/libraries/System.Reflection.Primitives/ref/System.Reflection.Primitives.Forwards.cs` - 型転送定義
- E-03: `src/libraries/System.Private.CoreLib/src/System/Reflection/Emit/Opcode.cs` - OpCode構造体実装
- E-04: `src/libraries/System.Private.CoreLib/src/System/Reflection/Emit/OpCodes.cs` - OpCodes静的クラス・OpCodeValues列挙体
- E-05: `src/libraries/System.Private.CoreLib/src/System/Reflection/Emit/FlowControl.cs` - FlowControl列挙体
- E-06: `src/libraries/System.Private.CoreLib/src/System/Reflection/Emit/OpCodeType.cs` - OpCodeType列挙体
- E-07: `src/libraries/System.Private.CoreLib/src/System/Reflection/Emit/OperandType.cs` - OperandType列挙体
- E-08: `src/libraries/System.Private.CoreLib/src/System/Reflection/Emit/PackingSize.cs` - PackingSize列挙体
- E-09: `src/libraries/System.Private.CoreLib/src/System/Reflection/Emit/StackBehaviour.cs` - StackBehaviour列挙体
- E-10: `src/libraries/System.Reflection.Primitives/README.md` - モジュール説明

## 3) Claims と根拠の対応（レビューの主戦場）

### OpCode 構造体のプロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EvaluationStackDeltaがm_flagsから正しくシフト演算で取得される | E-03 (line 59-60) | ○ |
| C-02 | OperandTypeがm_flagsのマスクで取得される | E-03 (line 62) | ○ |
| C-03 | FlowControlがシフトとマスクで取得される | E-03 (line 64) | ○ |
| C-04 | OpCodeTypeがシフトとマスクで取得される | E-03 (line 66) | ○ |
| C-05 | StackBehaviourPopがシフトとマスクで取得される | E-03 (line 68) | ○ |
| C-06 | StackBehaviourPushがシフトとマスクで取得される | E-03 (line 70) | ○ |
| C-07 | Sizeがシフトとマスクで取得される | E-03 (line 72) | ○ |
| C-08 | Valueがm_valueのキャストで取得される | E-03 (line 74) | ○ |
| C-09 | NameがSize==0の場合nullを返す | E-03 (line 82-83) | ○ |
| C-10 | Nameが遅延初期化キャッシュを使用する | E-03 (line 87-92) | ○ |
| C-11 | NameがEnum.GetNameを使用してilasm形式に変換 | E-03 (line 117) | ○ |

### OpCode 構造体のメソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | Equals(object)がOpCode型チェックを行う | E-03 (line 123-124) | ○ |
| C-13 | Equals(OpCode)がValueで比較する | E-03 (line 126) | ○ |
| C-14 | operator==がEqualsを使用 | E-03 (line 128) | ○ |
| C-15 | operator!=が==の否定 | E-03 (line 130) | ○ |
| C-16 | GetHashCodeがValueを返す | E-03 (line 132) | ○ |
| C-17 | ToStringがNameを返す | E-03 (line 134) | ○ |

### OpCodes クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | TakesSingleByteArgumentがShortInlineBrTarget/ShortInlineI/ShortInlineVarでtrue | E-04 (line 2529-2533) | ○ |
| C-19 | Nop命令が正しく定義されている | E-04 (line 258-266) | ○ |
| C-20 | 各OpCodeの静的フィールドが正しいフラグで初期化されている | E-04 | ○ |

### FlowControl 列挙体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | Branch=0, Break=1, ..., Throw=8 | E-05 (line 9-20) | ○ |
| C-22 | PhiにObsolete属性がある | E-05 (line 17) | ○ |

### OpCodeType 列挙体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | Macro=1, Nternal=2, ..., Primitive=5 | E-06 (line 9-18) | ○ |
| C-24 | AnnotationにObsolete属性がある | E-06 (line 11) | ○ |

### OperandType 列挙体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | InlineBrTarget=0, ..., ShortInlineVar=18 | E-07 (line 9-30) | ○ |
| C-26 | InlinePhiにObsolete属性がある | E-07 (line 17) | ○ |
| C-27 | 値8が欠番（InlineSig=9） | E-07 (line 19) | ○ |

### PackingSize 列挙体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Unspecified=0, Size1=1, ..., Size128=128 | E-08 (line 6-17) | ○ |
| C-29 | 値が2の累乗で定義されている | E-08 | ○ |

### StackBehaviour 列挙体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | Pop0=0, ..., Popref_popi_pop1=28 | E-09 (line 9-40) | ○ |
| C-31 | 全29の列挙値が定義されている | E-09 | ○ |

### 内部メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | EndsUncondJmpBlkがフラグをチェック | E-03 (line 45-46) | △ |

## 4) 不足情報（Unknown / Missing）

- **EndsUncondJmpBlk内部メソッド**: `internal`アクセス修飾子のため、パブリックAPIとしてはテスト不可能。リフレクションまたはInternalsVisibleTo経由でのテストが必要。
  - 候補：InternalsVisibleToを使用したテストプロジェクト / リフレクションベースのテスト / 統合テストでの間接検証

- **全OpCodeフィールドの網羅性**: OpCodesクラスには約225個のオペコードが定義されているが、テストケースでは代表的なものを抽出。
  - 候補：リフレクションで全フィールドを列挙するデータ駆動テスト / 各FlowControl/OpCodeTypeカテゴリからの代表サンプル

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|------------|------|------|
| 0 | OpCodeプロパティテスト | 実装コードとの1:1対応が明確 |
| 0 | 列挙体値テスト | 定義値がソースコードで直接確認可能 |
| 1 | TakesSingleByteArgument | 条件分岐の網羅性確認が必要 |
| 1 | Name生成ロジック | キャッシュと変換ロジックの組み合わせ |
| 2 | EndsUncondJmpBlk | 内部メソッドのため直接テスト困難 |

## 6) レビュアーチェックリスト（最小）

- [ ] OpCode構造体の各プロパティがビットフィールドから正しく抽出されることを確認
- [ ] TakesSingleByteArgumentの3つのOperandTypeが正しくtrueを返すことを確認
- [ ] 各列挙体（FlowControl, OpCodeType, OperandType, PackingSize, StackBehaviour）の値が仕様と一致することを確認
- [ ] Obsolete属性付きの列挙値（Phi, Annotation, InlinePhi）が適切にマークされていることを確認
- [ ] Name生成において、アンダースコアがドットに変換されることを確認
- [ ] default(OpCode)の場合にSize=0, Name=nullとなることを確認
- [ ] Equals/GetHashCode/ToString の基本動作を確認
