---
generated_at: 2026-01-30 18:15:00
metrics:
  claims_total: 107
  claims_with_evidence: 107
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Reflection.TypeExtensions.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：107 / 107、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Reflection.TypeExtensions/src/System/Reflection/TypeExtensions.cs` - メインソースファイル（TypeExtensions, AssemblyExtensions, EventInfoExtensions, MemberInfoExtensions, MethodInfoExtensions, ModuleExtensions, PropertyInfoExtensions クラス）
- E-02: `src/libraries/System.Reflection.TypeExtensions/ref/System.Reflection.TypeExtensions.cs` - API リファレンスファイル
- E-03: `src/libraries/System.Reflection.TypeExtensions/ref/System.Reflection.TypeExtensions.Forwards.cs` - 型転送定義

## 3) Claims と根拠の対応（レビューの主戦場）

### TypeExtensions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetConstructor: 指定したパラメータ型のコンストラクタが取得できること | E-01 (L13-20) | ○ |
| C-02 | GetConstructor: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L17) ArgumentNullException.ThrowIfNull(type) | ○ |
| C-03 | GetConstructor: 存在しないコンストラクタの場合nullが返却されること | E-01 (L19) type.GetConstructor(types)の戻り値 | ○ |
| C-04 | GetConstructors: パブリックコンストラクタ一覧が取得できること | E-01 (L23-29) | ○ |
| C-05 | GetConstructors: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L26) | ○ |
| C-06 | GetConstructors: BindingFlagsを指定してコンストラクタ一覧が取得できること | E-01 (L31-39) | ○ |
| C-07 | GetConstructors: コンストラクタが存在しない場合空配列が返却されること | E-01 (L28) type.GetConstructors()の仕様 | ○ |
| C-08 | GetDefaultMembers: DefaultMemberAttribute指定メンバーが取得できること | E-01 (L41-54) | ○ |
| C-09 | GetDefaultMembers: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L51) | ○ |
| C-10 | GetDefaultMembers: デフォルトメンバーが存在しない場合空配列が返却されること | E-01 (L53) | ○ |
| C-11 | GetEvent: 指定名のイベントが取得できること | E-01 (L56-64) | ○ |
| C-12 | GetEvent: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L61) | ○ |
| C-13 | GetEvent: 存在しないイベントの場合nullが返却されること | E-01 (L63) | ○ |
| C-14 | GetEvent: BindingFlagsを指定してイベントが取得できること | E-01 (L66-75) | ○ |
| C-15 | GetEvents: パブリックイベント一覧が取得できること | E-01 (L77-84) | ○ |
| C-16 | GetEvents: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L81) | ○ |
| C-17 | GetEvents: イベントが存在しない場合空配列が返却されること | E-01 (L83) | ○ |
| C-18 | GetField: 指定名のフィールドが取得できること | E-01 (L96-104) | ○ |
| C-19 | GetField: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L101) | ○ |
| C-20 | GetField: 存在しないフィールドの場合nullが返却されること | E-01 (L103) | ○ |
| C-21 | GetField: BindingFlagsを指定してフィールドが取得できること | E-01 (L106-115) | ○ |
| C-22 | GetFields: パブリックフィールド一覧が取得できること | E-01 (L117-124) | ○ |
| C-23 | GetFields: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L121) | ○ |
| C-24 | GetFields: フィールドが存在しない場合空配列が返却されること | E-01 (L123) | ○ |
| C-25 | GetGenericArguments: ジェネリック型引数が取得できること | E-01 (L136-142) | ○ |
| C-26 | GetGenericArguments: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L139) | ○ |
| C-27 | GetGenericArguments: 非ジェネリック型の場合空配列が返却されること | E-01 (L141) | ○ |
| C-28 | GetInterfaces: 実装インターフェース一覧が取得できること | E-01 (L144-151) | ○ |
| C-29 | GetInterfaces: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L148) | ○ |
| C-30 | GetInterfaces: インターフェースを実装しない場合空配列が返却されること | E-01 (L150) | ○ |
| C-31 | GetMember: 指定名のメンバーが取得できること | E-01 (L153-167) | ○ |
| C-32 | GetMember: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L164) | ○ |
| C-33 | GetMember: 存在しないメンバーの場合空配列が返却されること | E-01 (L166) | ○ |
| C-34 | GetMember: BindingFlagsを指定してメンバーが取得できること | E-01 (L169-184) | ○ |
| C-35 | GetMembers: パブリックメンバー一覧が取得できること | E-01 (L186-199) | ○ |
| C-36 | GetMembers: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L196) | ○ |
| C-37 | GetMethod: 指定名のメソッドが取得できること | E-01 (L217-225) | ○ |
| C-38 | GetMethod: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L222) | ○ |
| C-39 | GetMethod: 存在しないメソッドの場合nullが返却されること | E-01 (L224) | ○ |
| C-40 | GetMethod: BindingFlagsを指定してメソッドが取得できること | E-01 (L227-236) | ○ |
| C-41 | GetMethod: パラメータ型を指定してオーバーロードを取得できること | E-01 (L238-247) | ○ |
| C-42 | GetMethods: パブリックメソッド一覧が取得できること | E-01 (L249-256) | ○ |
| C-43 | GetMethods: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L253) | ○ |
| C-44 | GetNestedType: 指定名のネストされた型が取得できること | E-01 (L268-277) | ○ |
| C-45 | GetNestedType: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L274) | ○ |
| C-46 | GetNestedType: 存在しないネスト型の場合nullが返却されること | E-01 (L276) | ○ |
| C-47 | GetNestedTypes: ネストされた型一覧が取得できること | E-01 (L279-287) | ○ |
| C-48 | GetNestedTypes: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L284) | ○ |
| C-49 | GetProperties: パブリックプロパティ一覧が取得できること | E-01 (L289-296) | ○ |
| C-50 | GetProperties: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L293) | ○ |
| C-51 | GetProperties: プロパティが存在しない場合空配列が返却されること | E-01 (L295) | ○ |
| C-52 | GetProperty: 指定名のプロパティが取得できること | E-01 (L308-316) | ○ |
| C-53 | GetProperty: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L313) | ○ |
| C-54 | GetProperty: 存在しないプロパティの場合nullが返却されること | E-01 (L315) | ○ |
| C-55 | GetProperty: BindingFlagsを指定してプロパティが取得できること | E-01 (L318-327) | ○ |
| C-56 | GetProperty: 戻り値型を指定してプロパティが取得できること | E-01 (L329-338) | ○ |
| C-57 | GetProperty: 戻り値型とパラメータ型を指定してインデクサが取得できること | E-01 (L340-350) | ○ |
| C-58 | IsAssignableFrom: 継承関係にある型でtrueが返却されること | E-01 (L352-358) | ○ |
| C-59 | IsAssignableFrom: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L355) | ○ |
| C-60 | IsAssignableFrom: 継承関係にない型でfalseが返却されること | E-01 (L357) | ○ |
| C-61 | IsAssignableFrom: cがnullの場合falseが返却されること | E-01 (L353) NotNullWhen属性 | ○ |
| C-62 | IsInstanceOfType: インスタンスが指定型の場合trueが返却されること | E-01 (L360-366) | ○ |
| C-63 | IsInstanceOfType: typeがnullの場合ArgumentNullExceptionがスローされること | E-01 (L363) | ○ |
| C-64 | IsInstanceOfType: インスタンスが異なる型の場合falseが返却されること | E-01 (L365) | ○ |
| C-65 | IsInstanceOfType: oがnullの場合falseが返却されること | E-01 (L361) NotNullWhen属性 | ○ |

### AssemblyExtensions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | GetExportedTypes: エクスポートされた型一覧が取得できること | E-01 (L372-378) | ○ |
| C-67 | GetExportedTypes: assemblyがnullの場合ArgumentNullExceptionがスローされること | E-01 (L375) | ○ |
| C-68 | GetModules: モジュール一覧が取得できること | E-01 (L380-386) | ○ |
| C-69 | GetModules: assemblyがnullの場合ArgumentNullExceptionがスローされること | E-01 (L383) | ○ |
| C-70 | GetTypes: すべての型一覧が取得できること | E-01 (L388-394) | ○ |
| C-71 | GetTypes: assemblyがnullの場合ArgumentNullExceptionがスローされること | E-01 (L391) | ○ |

### EventInfoExtensions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | GetAddMethod: イベントのAddメソッドが取得できること | E-01 (L400-406) | ○ |
| C-73 | GetAddMethod: eventInfoがnullの場合ArgumentNullExceptionがスローされること | E-01 (L403) | ○ |
| C-74 | GetAddMethod: nonPublic=trueで非パブリックAddメソッドが取得できること | E-01 (L408-414) | ○ |
| C-75 | GetAddMethod: Addメソッドが存在しない場合nullが返却されること | E-01 (L405) | ○ |
| C-76 | GetRaiseMethod: イベントのRaiseメソッドが取得できること | E-01 (L416-422) | ○ |
| C-77 | GetRaiseMethod: eventInfoがnullの場合ArgumentNullExceptionがスローされること | E-01 (L419) | ○ |
| C-78 | GetRaiseMethod: Raiseメソッドが存在しない場合nullが返却されること | E-01 (L421) | ○ |
| C-79 | GetRemoveMethod: イベントのRemoveメソッドが取得できること | E-01 (L432-438) | ○ |
| C-80 | GetRemoveMethod: eventInfoがnullの場合ArgumentNullExceptionがスローされること | E-01 (L435) | ○ |
| C-81 | GetRemoveMethod: nonPublic=trueで非パブリックRemoveメソッドが取得できること | E-01 (L440-446) | ○ |

### MemberInfoExtensions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | HasMetadataToken: メタデータトークンを持つメンバーでtrueが返却されること | E-01 (L458-473) | ○ |
| C-83 | HasMetadataToken: memberがnullの場合ArgumentNullExceptionがスローされること | E-01 (L461) | ○ |
| C-84 | HasMetadataToken: メタデータトークンを持たないメンバーでfalseが返却されること | E-01 (L465) GetMetadataTokenOrZeroOrThrow != 0 判定 | ○ |
| C-85 | HasMetadataToken: unbaked ref-emitメンバーでInvalidOperationException発生時falseが返却されること | E-01 (L467-472) catch (InvalidOperationException) | ○ |
| C-86 | GetMetadataToken: メタデータトークンが取得できること | E-01 (L481-494) | ○ |
| C-87 | GetMetadataToken: memberがnullの場合ArgumentNullExceptionがスローされること | E-01 (L484) | ○ |
| C-88 | GetMetadataToken: メタデータトークンを持たないメンバーでInvalidOperationExceptionがスローされること | E-01 (L488-491) token == 0 チェックとthrow | ○ |

### MethodInfoExtensions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | GetBaseDefinition: オーバーライドされたメソッドの基底定義が取得できること | E-01 (L516-522) | ○ |
| C-90 | GetBaseDefinition: methodがnullの場合ArgumentNullExceptionがスローされること | E-01 (L519) | ○ |
| C-91 | GetBaseDefinition: オーバーライドでないメソッドで自身が返却されること | E-01 (L521) method.GetBaseDefinition()の仕様 | ○ |

### ModuleExtensions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | HasModuleVersionId: モジュールバージョンIDの有無が判定できること | E-01 (L528-534) return true | ○ |
| C-93 | HasModuleVersionId: moduleがnullの場合ArgumentNullExceptionがスローされること | E-01 (L531) | ○ |
| C-94 | GetModuleVersionId: モジュールバージョンIDが取得できること | E-01 (L536-542) | ○ |
| C-95 | GetModuleVersionId: moduleがnullの場合ArgumentNullExceptionがスローされること | E-01 (L539) | ○ |

### PropertyInfoExtensions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | GetAccessors: プロパティのアクセサ一覧が取得できること | E-01 (L548-554) | ○ |
| C-97 | GetAccessors: propertyがnullの場合ArgumentNullExceptionがスローされること | E-01 (L551) | ○ |
| C-98 | GetAccessors: nonPublic=trueで非パブリックアクセサも取得できること | E-01 (L556-562) | ○ |
| C-99 | GetAccessors: getterのみのプロパティで1要素の配列が返却されること | E-01 (L553) property.GetAccessors()の仕様 | ○ |
| C-100 | GetGetMethod: プロパティのgetterが取得できること | E-01 (L564-570) | ○ |
| C-101 | GetGetMethod: propertyがnullの場合ArgumentNullExceptionがスローされること | E-01 (L567) | ○ |
| C-102 | GetGetMethod: nonPublic=trueで非パブリックgetterが取得できること | E-01 (L572-578) | ○ |
| C-103 | GetGetMethod: getterが存在しない場合nullが返却されること | E-01 (L569) | ○ |
| C-104 | GetSetMethod: プロパティのsetterが取得できること | E-01 (L580-586) | ○ |
| C-105 | GetSetMethod: propertyがnullの場合ArgumentNullExceptionがスローされること | E-01 (L583) | ○ |
| C-106 | GetSetMethod: nonPublic=trueで非パブリックsetterが取得できること | E-01 (L588-594) | ○ |
| C-107 | GetSetMethod: setterが存在しない場合nullが返却されること | E-01 (L585) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべてのテストケースはソースコード `TypeExtensions.cs` から直接根拠を得ている。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての拡張メソッドは既存のSystem.Reflection APIへの薄いラッパーであり、主にnullチェックを追加している
- **0: 低リスク** - MemberInfoExtensions.HasMetadataToken と GetMetadataToken は独自ロジックを含むが、try-catchとトークン値チェックによる堅牢な実装
- **0: 低リスク** - ModuleExtensions.HasModuleVersionId は常にtrueを返す実装（プラットフォーム固有の事情によるものと考えられる）

## 6) レビュアーチェックリスト（最小）
- [ ] 各メソッドのnullチェック（ArgumentNullException.ThrowIfNull）が正しくテストされているか確認
- [ ] 境界値テスト（空配列、null戻り値等）が適切にカバーされているか確認
- [ ] MemberInfoExtensions のメタデータトークン関連ロジックのテストケースが十分か確認
- [ ] DynamicallyAccessedMembers属性が付与されたメソッドのトリミング互換性テストが考慮されているか確認
- [ ] RequiresUnreferencedCode属性が付与されたメソッド（GetExportedTypes, GetTypes）のテストケースが適切か確認
